/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit;

import net.sourceforge.jwebunit.ExpectedCell;

public class ExpectedRow {
    private ExpectedCell[] expectedCells;

    public ExpectedRow(Object[] rowCells) {
        this.expectedCells = new ExpectedCell[rowCells.length];
        for (int i = 0; i < rowCells.length; ++i) {
            Object column = rowCells[i];
            this.expectedCells[i] = column instanceof ExpectedCell ? (ExpectedCell)column : new ExpectedCell(column.toString(), 1);
        }
    }

    String[] getExpandedColumns() {
        String[] expandedColumns = new String[this.getNumberOfColumns()];
        int targetColumn = 0;
        for (int i = 0; i < this.expectedCells.length; ++i) {
            targetColumn = this.expandIntoColumns(this.expectedCells[i], expandedColumns, targetColumn);
        }
        return expandedColumns;
    }

    private int getNumberOfColumns() {
        int numCols = 0;
        for (int i = 0; i < this.expectedCells.length; ++i) {
            ExpectedCell column = this.expectedCells[i];
            numCols += column.getColspan();
        }
        return numCols;
    }

    private int expandIntoColumns(ExpectedCell cell, String[] targetArray, int offset) {
        for (int columnsSpanned = 0; columnsSpanned < cell.getColspan(); ++columnsSpanned) {
            targetArray[offset] = cell.getExpectedValue();
            ++offset;
        }
        return offset;
    }
}

