/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard.jButtonBar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class ModifiedFlowLayout
extends FlowLayout {
    public ModifiedFlowLayout() {
    }

    public ModifiedFlowLayout(int align) {
        super(align);
    }

    public ModifiedFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension dim = this.computeSize(target, true);
        return new Dimension(0, dim.height);
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = this.computeSize(target, true);
        return new Dimension(0, dim.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension computeSize(Container target, boolean minimum) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets;
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            int w = target.getWidth();
            if (w == 0) {
                w = Integer.MAX_VALUE;
            }
            if ((insets = target.getInsets()) == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            int reqdWidth = 0;
            int maxwidth = w - (insets.left + insets.right + hgap * 2);
            int n = target.getComponentCount();
            int x = 0;
            int y = insets.top;
            int rowHeight = 0;
            for (int i = 0; i < n; ++i) {
                Dimension d;
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension dimension = d = minimum ? c.getMinimumSize() : c.getPreferredSize();
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += hgap;
                    }
                    x += d.width;
                    rowHeight = Math.max(rowHeight, d.height);
                } else {
                    x = d.width;
                    y += vgap + rowHeight;
                    rowHeight = d.height;
                }
                reqdWidth = Math.max(reqdWidth, x);
            }
            return new Dimension(reqdWidth + insets.left + insets.right, y += rowHeight);
        }
    }
}

