/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import org.wikiwizard.EditorDocument;
import org.wikiwizard.RETokenizer;
import org.wikiwizard.Token;
import org.wikiwizard.WikiTag;

public class SyntaxFilter {
    public EditorDocument doc;
    public ArrayList tagsCollection;

    public SyntaxFilter(EditorDocument doc) {
        this.doc = doc;
        this.tagsCollection = doc.tagsCollection;
    }

    public ArrayList receiveTextWithOutTags() {
        int i;
        Token token;
        String txt = this.doc.getText();
        String regEx = this.doc.manager.createCompleteRegExTerm(this.tagsCollection);
        RETokenizer tokenizer = new RETokenizer(regEx, this.tagsCollection.size());
        tokenizer.createTokenizer(txt);
        BlockList blocks = new BlockList();
        int previousEnd = 0;
        while ((token = tokenizer.nextToken()) != null) {
            previousEnd = this.checkTokens(0, token, previousEnd, blocks);
        }
        if (previousEnd != this.doc.getLength()) {
            ((ArrayList)blocks).add(new Block(0, previousEnd, this.doc.getLength()));
        }
        for (i = 0; i < blocks.size(); ++i) {
            String blockText = ((Block)blocks.get((int)i)).text.replace("\n", "");
            if (!blockText.equals("")) continue;
            blocks.remove(i);
        }
        for (i = 0; i < blocks.size(); ++i) {
            System.out.println(((Block)blocks.get((int)i)).text);
        }
        return blocks;
    }

    public int checkTokens(int add, Token token, int previousEnd, ArrayList blocks) {
        try {
            WikiTag item = (WikiTag)this.tagsCollection.get(token.getGroup());
            int start = 0;
            int end = 0;
            if (item.tagGroup == 1 || item.tagGroup == 2 || item.tagGroup == 3) {
                if (previousEnd > -1) {
                    start = token.getPos();
                    blocks.add(new Block(add, previousEnd, start));
                } else {
                    start = token.getPos();
                }
                int next = 0;
                if (!item.separator.equals("") && (next = token.getText().indexOf(item.separator)) > -1) {
                    next += token.getPos();
                    if (!item.isCode && !item.isCodeRight) {
                        blocks.add(new Block(add, start += item.startTagLength, next));
                        end = start - item.startTagLength + token.getText().length() - item.endTagLength;
                        blocks.add(new Block(add, next + item.separator.length(), end));
                        previousEnd = end + item.endTagLength;
                    } else if (item.isCode && item.isCodeRight) {
                        previousEnd = start + token.getText().length();
                    } else if (!item.isCode && item.isCodeRight) {
                        blocks.add(new Block(add, start += item.startTagLength, next));
                        previousEnd = start - item.startTagLength + token.getText().length();
                    } else if (item.isCode && !item.isCodeRight) {
                        end = start + token.getText().length() - item.endTagLength;
                        blocks.add(new Block(add, next + item.separator.length(), end));
                        previousEnd = start + token.getText().length();
                    }
                } else {
                    if (!item.isCode && token.getText().indexOf("http://") < 0) {
                        end = token.getPos() + token.getText().length() - item.endTagLength;
                        blocks.add(new Block(add, start + item.startTagLength, end));
                    } else {
                        end = token.getPos() + token.getText().length() - item.endTagLength;
                    }
                    previousEnd = end + item.endTagLength;
                }
            } else if (item.tagGroup == 4 || item.tagGroup == 5 || item.tagGroup == 6) {
                if (previousEnd > -1) {
                    start = token.getPos();
                    blocks.add(new Block(add, previousEnd, start));
                } else {
                    start = token.getPos();
                }
                previousEnd = start + token.getText().length();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return previousEnd;
    }

    public class BlockList
    extends ArrayList {
        public Token token;

        public boolean add(Object o) {
            Block block = (Block)o;
            String regEx = SyntaxFilter.this.doc.manager.createCompleteRegExTerm(SyntaxFilter.this.tagsCollection);
            RETokenizer tokenizer = new RETokenizer(regEx, SyntaxFilter.this.tagsCollection.size());
            tokenizer.createTokenizer(block.text);
            int previousEnd = 0;
            boolean work = false;
            while ((this.token = tokenizer.nextToken()) != null) {
                work = true;
                previousEnd = SyntaxFilter.this.checkTokens(block.start, this.token, previousEnd, this);
            }
            if (work && previousEnd != block.text.length()) {
                this.add(new Block(block.start, previousEnd, block.text.length()));
            }
            if (!work) {
                super.add(o);
            }
            return true;
        }
    }

    public class Block {
        public int start = 0;
        public int end = 0;
        public String text = "";

        public Block(int add, int start, int end) {
            this.start = start + add;
            this.end = end + add;
            try {
                this.text = SyntaxFilter.this.doc.getText(this.start, this.end - this.start);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

