/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.Timer;

public class StopwatchPanel
extends JPanel
implements ActionListener,
Runnable {
    AffineTransform t;
    double x = 100.0;
    double y = -100.0;
    double dx = 100.0;
    double dy = 0.0;
    Timer timer = null;
    long startTime = 0L;
    long time = 0L;
    long elapsedTime = 0L;
    long lastTimeStamp = 0L;
    int fps = 0;
    String text = "";
    DecimalFormat df;

    public StopwatchPanel(String displayText, int fps) {
        this.text = displayText;
        this.fps = fps;
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        System.out.println("StopwatchPanel v1.1");
        if (this.fps <= 0) {
            this.fps = 19;
        }
        this.setBackground(Color.white);
        this.t = new AffineTransform();
        int delay = this.fps > 0 ? 1000 / this.fps : 100;
        this.timer = new Timer(delay, this);
        this.timer.start();
        this.startTime = new Date().getTime();
        this.df = new DecimalFormat("0.###");
    }

    public void reset() {
        this.timer.stop();
        this.startTime = new Date().getTime();
        this.time = 0L;
        this.elapsedTime = 0L;
        this.lastTimeStamp = 0L;
        this.timer.start();
    }

    public void stopAnimation() {
        this.timer.stop();
    }

    public void startAnimation() {
        this.timer.start();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(null);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHints(hints);
        g2.scale(0.9, 0.9);
        g2.setStroke(new BasicStroke(0.5f));
        long timeStamp = new Date().getTime();
        this.time = timeStamp - this.startTime;
        this.elapsedTime = timeStamp - this.lastTimeStamp;
        this.lastTimeStamp = timeStamp;
        double Sekunden = (double)this.elapsedTime / 1000.0;
        double ex_center = this.getWidth() / 2;
        double ey_center = this.getHeight() / 2;
        double e_width = 100.0;
        double e_height = 100.0;
        double ex_luc = ex_center - e_width / 2.0;
        double ey_luc = ey_center - e_height / 2.0;
        Ellipse2D.Double ball = new Ellipse2D.Double(ex_luc, ey_luc, e_width, e_height);
        Point2D.Double p1 = new Point2D.Double(ex_center, ey_center);
        double stime = (double)this.time * 0.001;
        double factor1 = Math.cos(stime) * 55.0;
        double factor2 = Math.sin(stime) * 55.0;
        Point2D.Double p2 = new Point2D.Double(ex_center + factor1, ey_center + factor2);
        g2.setPaint(new GradientPaint(p1, Color.lightGray, p2, Color.white));
        g2.fill(ball);
        g2.setPaint(Color.black);
        g2.setPaint(Color.white);
        g2.setFont(new Font("Sans Serif", 1, 15));
        g2.setPaint(Color.lightGray);
        g2.drawString(this.text, this.getWidth() / 2 - 70, this.getHeight() / 2 + 70);
    }

    public void actionPerformed(ActionEvent e) {
        this.repaint();
    }
}

