/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.ConstantPoolParser;
import java.dyn.ConstantPoolVisitor;
import java.dyn.InvalidConstantPoolFormatException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPoolPatch {
    final ConstantPoolParser outer;
    final Object[] patchArray;
    private static final int CONSTANT_MemberRef_MASK = 11;
    private static final Map<Class<?>, Byte> CONSTANT_VALUE_CLASS_TAG;
    private static final Class[] CONSTANT_VALUE_CLASS;

    ConstantPoolPatch(ConstantPoolParser constantPoolParser) {
        this.outer = constantPoolParser;
        this.patchArray = new Object[constantPoolParser.getLength()];
    }

    public ConstantPoolPatch(byte[] byArray) throws InvalidConstantPoolFormatException {
        this(new ConstantPoolParser(byArray));
    }

    public ConstantPoolPatch(Class<?> clazz) throws IOException, InvalidConstantPoolFormatException {
        this(new ConstantPoolParser(clazz));
    }

    public ConstantPoolPatch(ConstantPoolPatch constantPoolPatch) {
        this.outer = constantPoolPatch.outer;
        this.patchArray = (Object[])constantPoolPatch.patchArray.clone();
    }

    public ConstantPoolParser getParser() {
        return this.outer;
    }

    public byte getTag(int n) {
        return this.outer.getTag(n);
    }

    public Object getPatch(int n) {
        String[] stringArray = this.patchArray[n];
        if (stringArray == null) {
            return null;
        }
        switch (this.getTag(n)) {
            case 9: 
            case 10: 
            case 11: {
                if (!(stringArray instanceof String)) break;
                stringArray = ConstantPoolPatch.stripSemis(2, (String)stringArray);
                break;
            }
            case 12: {
                if (!(stringArray instanceof String)) break;
                stringArray = ConstantPoolPatch.stripSemis(1, (String)stringArray);
            }
        }
        return stringArray;
    }

    public void clear() {
        Arrays.fill(this.patchArray, null);
    }

    public Object[] getPatches() {
        return (Object[])this.patchArray.clone();
    }

    public Object[] getOriginalCP() throws InvalidConstantPoolFormatException {
        return this.getOriginalCP(0, this.patchArray.length, -1);
    }

    public void putPatches(final Map<String, String> map, Map<Object, Object> map2, Map<Object, Object> map3, boolean bl) throws InvalidConstantPoolFormatException {
        if (map2 != null || map3 != null) {
            throw new UnsupportedOperationException("NYI: non-null classMap or constantMap");
        }
        final HashSet hashSet = !bl ? null : new HashSet();
        this.outer.parse(new ConstantPoolVisitor(){

            public void visitUTF8(int n, byte by, String string) {
                String string2;
                String string3 = string;
                Object object = ConstantPoolPatch.this.patchArray[n];
                if (object != null) {
                    string3 = (String)object;
                }
                if ((string2 = (String)map.get(string3)) != null) {
                    ConstantPoolPatch.this.putUTF8(n, string2);
                    if (hashSet != null) {
                        hashSet.add(string3);
                    }
                }
            }
        });
        if (hashSet != null) {
            map.keySet().removeAll(hashSet);
        }
    }

    Object[] getOriginalCP(final int n, final int n2, final int n3) throws InvalidConstantPoolFormatException {
        final Object[] objectArray = new Object[n2 - n];
        this.outer.parse(new ConstantPoolVisitor(){

            void show(int n4, byte by, Object object) {
                if (n4 < n || n4 >= n2) {
                    return;
                }
                if ((1 << by & n3) == 0) {
                    return;
                }
                objectArray[n4 - n] = object;
            }

            public void visitUTF8(int n4, byte by, String string) {
                this.show(n4, by, string);
            }

            public void visitConstantValue(int n4, byte by, Object object) {
                assert (by != 8);
                this.show(n4, by, object);
            }

            public void visitConstantString(int n4, byte by, String string, int n22) {
                this.show(n4, by, string);
            }

            public void visitMemberRef(int n4, byte by, String string, String string2, String string3, int n22, int n32) {
                this.show(n4, by, new String[]{string, string2, string3});
            }

            public void visitDescriptor(int n4, byte by, String string, String string2, int n22, int n32) {
                this.show(n4, by, new String[]{string, string2});
            }
        });
        return objectArray;
    }

    void writeHead(OutputStream outputStream) throws IOException {
        this.outer.writePatchedHead(outputStream, this.patchArray);
    }

    void writeTail(OutputStream outputStream) throws IOException {
        this.outer.writeTail(outputStream);
    }

    private void checkConstantTag(byte by, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("invalid null constant value");
        }
        if (ConstantPoolPatch.classForTag(by) != object.getClass()) {
            throw new IllegalArgumentException("invalid constant value" + (by == 0 ? "" : " for tag " + ConstantPoolVisitor.tagName(by)) + " of class " + object.getClass());
        }
    }

    private void checkTag(int n, byte by) {
        byte by2 = this.outer.tags[n];
        if (by2 != by) {
            throw new IllegalArgumentException("invalid put operation for " + ConstantPoolVisitor.tagName(by) + " at index " + n + " found " + ConstantPoolVisitor.tagName(by2));
        }
    }

    private void checkTagMask(int n, int n2) {
        int n3;
        byte by = this.outer.tags[n];
        int n4 = n3 = (by & 0x1F) == by ? 1 << by : 0;
        if ((n3 & n2) == 0) {
            throw new IllegalArgumentException("invalid put operation at index " + n + " found " + ConstantPoolVisitor.tagName(by));
        }
    }

    private static void checkMemberName(String string) {
        if (string.indexOf(59) >= 0) {
            throw new IllegalArgumentException("memberName " + string + " contains a ';'");
        }
    }

    public void putUTF8(int n, String string) {
        this.checkTag(n, (byte)1);
        this.patchArray[n] = string;
    }

    public void putConstantValue(int n, Object object) {
        byte by = ConstantPoolPatch.tagForConstant(object.getClass());
        this.checkConstantTag(by, object);
        this.checkTag(n, by);
        this.patchArray[n] = object;
    }

    public void putConstantValue(int n, byte by, Object object) {
        this.checkTag(n, by);
        if (by == 7 && object instanceof String) {
            ConstantPoolPatch.checkClassName((String)object);
        } else if (by != 8) {
            this.checkConstantTag(by, object);
        }
        this.checkTag(n, by);
        this.patchArray[n] = object;
    }

    public void putDescriptor(int n, String string, String string2) {
        this.checkTag(n, (byte)12);
        ConstantPoolPatch.checkMemberName(string);
        this.patchArray[n] = ConstantPoolPatch.addSemis(string, string2);
    }

    public void putMemberRef(int n, byte by, String string, String string2, String string3) {
        this.checkTagMask(by, 11);
        this.checkTag(n, by);
        ConstantPoolPatch.checkClassName(string);
        ConstantPoolPatch.checkMemberName(string2);
        if (string3.startsWith("(") == (by == 9)) {
            throw new IllegalArgumentException("bad signature: " + string3);
        }
        this.patchArray[n] = ConstantPoolPatch.addSemis(string, string2, string3);
    }

    static Class<?> classForTag(byte by) {
        if ((by & 0xFF) >= CONSTANT_VALUE_CLASS.length) {
            return null;
        }
        return CONSTANT_VALUE_CLASS[by];
    }

    static byte tagForConstant(Class<?> clazz) {
        Byte by = CONSTANT_VALUE_CLASS_TAG.get(clazz);
        return by == null ? (byte)0 : by;
    }

    private static void checkClassName(String string) {
        if (string.indexOf(47) >= 0 || string.indexOf(59) >= 0) {
            throw new IllegalArgumentException("invalid class name " + string);
        }
    }

    static String addSemis(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 5);
        stringBuilder.append(string);
        for (String string2 : stringArray) {
            stringBuilder.append(';').append(string2);
        }
        String string3 = stringBuilder.toString();
        assert (ConstantPoolPatch.stripSemis(stringArray.length, string3)[0].equals(string));
        assert (ConstantPoolPatch.stripSemis(stringArray.length, string3)[1].equals(stringArray[0]));
        assert (stringArray.length == 1 || ConstantPoolPatch.stripSemis(stringArray.length, string3)[2].equals(stringArray[1]));
        return string3;
    }

    static String[] stripSemis(int n, String string) {
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.indexOf(59, n2);
            if (n3 < 0) {
                n3 = string.length();
            }
            stringArray[i] = string.substring(n2, n3);
            n2 = n3;
        }
        stringArray[n] = string.substring(n2);
        return stringArray;
    }

    static {
        Object[][] objectArrayArray;
        CONSTANT_VALUE_CLASS_TAG = new IdentityHashMap();
        CONSTANT_VALUE_CLASS = new Class[16];
        for (Object[] objectArray : objectArrayArray = new Object[][]{{Integer.class, (byte)3}, {Long.class, (byte)5}, {Float.class, (byte)4}, {Double.class, (byte)6}, {String.class, (byte)8}, {Class.class, (byte)7}}) {
            Class clazz = (Class)objectArray[0];
            Byte by = (Byte)objectArray[1];
            CONSTANT_VALUE_CLASS_TAG.put(clazz, by);
            ConstantPoolPatch.CONSTANT_VALUE_CLASS[by.byteValue()] = clazz;
        }
    }
}

