#!/usr/bin/env python

import sys
import os
import glob
from optparse import OptionParser

newhome = os.path.join(os.path.abspath('.'),'testhome')
if os.path.exists(newhome):
    os.environ['HOME'] = newhome
else:
    print "Please execute from main jppy build directory."
    sys.exit(10)

sys.path.insert(0,"./")

import unittest
import basicTests
import dependencyTests
import bugTests
import todoTests
import printerTests
import contactTests
import eventTests
import pluginTests
import conduitTests

def tests():
    all_tests = unittest.TestSuite()
    all_tests.addTest(basicTests.suite())
    all_tests.addTest(dependencyTests.suite())
    all_tests.addTest(bugTests.suite())
    all_tests.addTest(contactTests.suite())
    all_tests.addTest(eventTests.suite())
    all_tests.addTest(todoTests.suite())
    all_tests.addTest(printerTests.suite())
    all_tests.addTest(pluginTests.suite())
    all_tests.addTest(conduitTests.suite())
    return all_tests

if __name__ == "__main__":
    parser = OptionParser()
    parser.add_option("-v", "--verbose", dest="verbosity", help="set verbosity")
    (options, args) = parser.parse_args()
    runner = unittest.TextTestRunner(verbosity=options.verbosity)
    runner.run(tests())
