import unittest
import baseclass

import jppy


class todoPluginsTest(baseclass.baseTest):
    def testListAvailablePlugins(self):
        assert len(list(self.env.taskList.record_field_filters)) > 0

    def testListFieldsByPlugins(self):
        for plugin in self.env.taskList.record_field_filters:
            additional_fields_by_plugin = plugin.fields()

    def testUrgencyByPlugins(self):
        todo = self.env.taskList.new()
        # implementation not finished yet
        todo['note'] = "12345"
        assert 'urgency' in todo.keys()
        todo['urgency'] = 'a'
        todo['note'] = "123"        
        assert todo['urgency'] == 'A'
        todo['urgency'] = 'B'
        assert todo['urgency'] == 'B'
        len(todo)
        todo.items()

def suite():
    suite = unittest.TestSuite((unittest.makeSuite(todoPluginsTest),))
    
    return suite

