import pisock
from jppy.conduit import Conduit
from jppy.core import Component, implements

class ExampleSync(Conduit):
    """
    To use this conduit, write into your ~/.jppyrc:

    [conduit]
    enabled = jppy.conduits.example.ExampleSync
    """    
    
    def pre_sync_pre_connect(self):
        self.log.info("Example conduit in pre-connect preparation.")
    
    def pre_sync(self):
        self.log.info("Example conduit could do pre-sync data collection now.")

    def sync(self,sd):
        pisock.dlp_AddSyncLogEntry(sd,"Hello Palm, From Python\n")
        self.log.info(pisock.dlp_ReadUserInfo(sd))
        self.log.info(pisock.dlp_ReadStorageInfo(sd,0))
        self.log.info(pisock.dlp_ReadSysInfo(sd))
        self.log.info(pisock.dlp_ReadNetSyncInfo(sd))

    def post_sync(self):
        self.log.info("The palm has gone. We can do any clean-up work now.")
