/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.text.JTextComponent;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JTextComponentDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.fixture.TextInputFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTextComponentFixture
extends JPopupMenuInvokerFixture<JTextComponent>
implements CommonComponentFixture,
TextInputFixture {
    private JTextComponentDriver driver;

    public JTextComponentFixture(Robot robot, JTextComponent target) {
        super(robot, target);
        this.createDriver();
    }

    public JTextComponentFixture(Robot robot, String textComponentName) {
        super(robot, textComponentName, JTextComponent.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new JTextComponentDriver(this.robot));
    }

    void updateDriver(JTextComponentDriver newDriver) {
        this.driver = newDriver;
    }

    @Override
    public String text() {
        return ((JTextComponent)this.target).getText();
    }

    @Override
    public JTextComponentFixture select(String text) {
        this.driver.selectText((JTextComponent)this.target, text);
        return this;
    }

    @Override
    public JTextComponentFixture selectText(int start, int end) {
        this.driver.selectText((JTextComponent)this.target, start, end);
        return this;
    }

    @Override
    public JTextComponentFixture selectAll() {
        this.driver.selectAll((JTextComponent)this.target);
        return this;
    }

    @Override
    public JTextComponentFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JTextComponentFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JTextComponentFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JTextComponentFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JTextComponentFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JTextComponentFixture deleteText() {
        this.driver.deleteText((JTextComponent)this.target);
        return this;
    }

    @Override
    public JTextComponentFixture enterText(String text) {
        this.driver.enterText((JTextComponent)this.target, text);
        return this;
    }

    public JTextComponentFixture setText(String text) {
        this.driver.setText((JTextComponent)this.target, text);
        return this;
    }

    @Override
    public JTextComponentFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JTextComponentFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JTextComponentFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JTextComponentFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JTextComponentFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JTextComponentFixture requireText(String expected) {
        this.driver.requireText((JTextComponent)this.target, expected);
        return this;
    }

    public JTextComponentFixture requireEmpty() {
        this.driver.requireEmpty((JTextComponent)this.target);
        return this;
    }

    @Override
    public JTextComponentFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JTextComponentFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JTextComponentFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JTextComponentFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JTextComponentFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JTextComponentFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JTextComponentFixture requireEditable() {
        this.driver.requireEditable((JTextComponent)this.target);
        return this;
    }

    @Override
    public JTextComponentFixture requireNotEditable() {
        this.driver.requireNotEditable((JTextComponent)this.target);
        return this;
    }
}

