/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractButtonDriver;
import org.fest.swing.fixture.TwoStateButtonFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCheckBoxFixture
extends TwoStateButtonFixture<JCheckBox> {
    private AbstractButtonDriver driver;

    public JCheckBoxFixture(Robot robot, JCheckBox target) {
        super(robot, target);
        this.createDriver();
    }

    public JCheckBoxFixture(Robot robot, String checkBoxName) {
        super(robot, checkBoxName, JCheckBox.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new AbstractButtonDriver(this.robot));
    }

    final void updateDriver(AbstractButtonDriver newDriver) {
        this.driver = newDriver;
    }

    @Override
    public String text() {
        return this.driver.textOf((AbstractButton)this.target);
    }

    public JCheckBoxFixture check() {
        this.driver.select((AbstractButton)this.target);
        return this;
    }

    public JCheckBoxFixture uncheck() {
        this.driver.unselect((AbstractButton)this.target);
        return this;
    }

    @Override
    public JCheckBoxFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JCheckBoxFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JCheckBoxFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JCheckBoxFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JCheckBoxFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JCheckBoxFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JCheckBoxFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JCheckBoxFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JCheckBoxFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JCheckBoxFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JCheckBoxFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JCheckBoxFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JCheckBoxFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JCheckBoxFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    public JCheckBoxFixture requireSelected() {
        this.driver.requireSelected((AbstractButton)this.target);
        return this;
    }

    public JCheckBoxFixture requireNotSelected() {
        this.driver.requireNotSelected((AbstractButton)this.target);
        return this;
    }

    @Override
    public JCheckBoxFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JCheckBoxFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JCheckBoxFixture requireText(String expected) {
        this.driver.requireText((AbstractButton)this.target, expected);
        return this;
    }
}

