/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTableHeaderLocation;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;

public class JTableHeaderDriver
extends JComponentDriver {
    private final JTableHeaderLocation location = new JTableHeaderLocation();

    public JTableHeaderDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void clickColumn(JTableHeader tableHeader, int columnIndex) {
        this.clickColumn(tableHeader, columnIndex, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(JTableHeader tableHeader, int columnIndex, MouseButton button, int times) {
        Point p = JTableHeaderDriver.pointAtIndex(tableHeader, columnIndex, this.location);
        this.robot.click(tableHeader, p, button, times);
    }

    @RunsInEDT
    public void clickColumn(JTableHeader tableHeader, String columnName) {
        this.clickColumn(tableHeader, columnName, MouseButton.LEFT_BUTTON, 1);
    }

    @RunsInEDT
    public void clickColumn(JTableHeader tableHeader, String columnName, MouseButton button, int times) {
        Point p = JTableHeaderDriver.pointAtName(tableHeader, columnName, this.location);
        this.robot.click(tableHeader, p, button, times);
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JTableHeader tableHeader, int columnIndex) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtIndex(tableHeader, columnIndex, this.location));
    }

    @RunsInEDT
    private static Point pointAtIndex(final JTableHeader tableHeader, final int columnIndex, final JTableHeaderLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tableHeader);
                return location.pointAt(tableHeader, columnIndex);
            }
        });
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(JTableHeader tableHeader, String columnName) {
        return this.robot.showPopupMenu(tableHeader, JTableHeaderDriver.pointAtName(tableHeader, columnName, this.location));
    }

    @RunsInEDT
    private static Point pointAtName(final JTableHeader tableHeader, final String columnName, final JTableHeaderLocation location) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tableHeader);
                return location.pointAt(tableHeader, columnName);
            }
        });
    }
}

