/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.Actions;
import org.fest.swing.driver.ContainerDriver;
import org.fest.swing.driver.KeyStrokes;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Strings;

public class JComponentDriver
extends ContainerDriver {
    public JComponentDriver(Robot robot) {
        super(robot);
    }

    @RunsInCurrentThread
    protected final void scrollToVisible(JComponent c, Rectangle r) {
        c.scrollRectToVisible(r);
    }

    @RunsInCurrentThread
    protected static boolean isVisible(JComponent c, Rectangle r) {
        return c.getVisibleRect().contains(r);
    }

    @RunsInCurrentThread
    protected final boolean isVisible(JComponent c, Point p) {
        return c.getVisibleRect().contains(p);
    }

    @RunsInEDT
    protected final void invokeAction(JComponent c, String name) {
        this.robot.focusAndWaitForFocusGain(c);
        for (KeyStroke keyStroke : JComponentDriver.keyStrokesForAction(c, name)) {
            try {
                this.type(keyStroke);
                this.robot.waitForIdle();
                return;
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to type any key for the action with key ", Strings.quote((String)name)}));
    }

    @RunsInCurrentThread
    static KeyStroke[] keyStrokesForAction(JComponent component, String actionName) {
        Object key = Actions.findActionKey(actionName, component.getActionMap());
        return KeyStrokes.findKeyStrokesForAction(actionName, key, component.getInputMap());
    }

    private void type(KeyStroke keyStroke) {
        if (keyStroke.getKeyCode() == 0) {
            this.robot.type(keyStroke.getKeyChar());
            return;
        }
        this.robot.pressAndReleaseKey(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }
}

