/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import org.fest.swing.awt.AWT;
import org.fest.swing.core.InputEventGenerator;
import org.fest.swing.core.Settings;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.Platform;
import org.fest.util.Strings;

class RobotEventGenerator
implements InputEventGenerator {
    private static final int KEY_INPUT_DELAY = 200;
    private final Robot robot;
    private final Settings settings;

    RobotEventGenerator(Settings settings) {
        this(RobotEventGenerator.createRobot(), settings);
    }

    private static Robot createRobot() {
        try {
            Robot robot = new Robot();
            if (Platform.isWindows() || Platform.isOSX()) {
                Pause.pause(500L);
            }
            return robot;
        }
        catch (AWTException e) {
            throw UnexpectedException.unexpected(e);
        }
    }

    RobotEventGenerator(Robot robot, Settings settings) {
        this.robot = robot;
        this.settings = settings;
        settings.attachTo(robot);
    }

    Robot robot() {
        return this.robot;
    }

    public void pressMouse(Component c, Point where, int buttons) {
        Point p = where;
        if (c != null && !this.isPointInScreenBoundaries(p = AWT.translate(c, where.x, where.y))) {
            throw ActionFailedException.actionFailure("The component to click is out of the boundaries of the screeen");
        }
        this.pressMouse(p, buttons);
    }

    private boolean isPointInScreenBoundaries(Point p) {
        Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return screen.contains(p);
    }

    public void pressMouse(Point where, int buttons) {
        this.moveMouse(where.x, where.y);
        this.pressMouse(buttons);
    }

    public void pressMouse(int buttons) {
        this.robot.mousePress(buttons);
    }

    public void releaseMouse(int buttons) {
        this.robot.mouseRelease(buttons);
    }

    public void rotateMouseWheel(int amount) {
        this.robot.mouseWheel(amount);
    }

    public void moveMouse(Component c, int x, int y) {
        Point p = AWT.translate(c, x, y);
        this.moveMouse(p.x, p.y);
    }

    public void moveMouse(int x, int y) {
        this.robot.mouseMove(x, y);
    }

    public void pressKey(int keyCode, char keyChar) {
        try {
            this.robot.keyPress(keyCode);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"Invalid key code '", String.valueOf(keyCode), "'"}));
        }
    }

    public void releaseKey(int keyCode) {
        this.robot.keyRelease(keyCode);
        if (!Platform.isOSX()) {
            return;
        }
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        if (200 > delayBetweenEvents) {
            Pause.pause(200 - delayBetweenEvents);
        }
    }
}

