/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.hostchooser;

import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.LoadSet;
import net.sf.jftp.config.SaveSet;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.framework.HButton;
import net.sf.jftp.gui.framework.HFrame;
import net.sf.jftp.gui.framework.HInsetPanel;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.framework.HPasswordField;
import net.sf.jftp.gui.framework.HTextField;
import net.sf.jftp.net.wrappers.Sftp2Connection;
import net.sf.jftp.net.wrappers.SftpConnection;
import net.sf.jftp.net.wrappers.SftpURLConnection;
import net.sf.jftp.net.wrappers.StartConnection;
import net.sf.jftp.system.logging.Log;
import net.sf.jftp.tools.SshShell;

public class SftpHostChooser
extends HFrame
implements ActionListener,
WindowListener,
ChangeListener {
    public HTextField host = new HTextField("Host:", "localhost");
    public HTextField user = new HTextField("Username:", "guest");
    public HTextField port = new HTextField("Port:", "22");
    public HPasswordField pass = new HPasswordField("Password/Phrase:", "nopasswd");
    public JComboBox enc = new JComboBox();
    public JComboBox cs = new JComboBox();
    public JComboBox keys = new JComboBox();
    public JLabel encL = new JLabel("Pref. Encryption");
    public JLabel csL = new JLabel("Pref. Message Auth.");
    public JLabel keysL = new JLabel("Pref. Public Key");
    public JLabel keyfileL = new JLabel("(No File)");
    private HPanel okP = new HPanel();
    private HPanel keyP = new HPanel();
    private HButton ok = new HButton("Connect");
    private HButton keyfile = new HButton("Choose Key File");
    private ComponentListener listener = null;
    private boolean useLocal = false;
    private boolean shell = false;
    private String keyfileName = null;
    private JCheckBox useJSch = new JCheckBox("Use JSch instead of j2ssh");

    public SftpHostChooser(ComponentListener l, boolean local) {
        this.listener = l;
        this.useLocal = local;
        this.init();
    }

    public SftpHostChooser(ComponentListener l) {
        this.listener = l;
        this.init();
    }

    public SftpHostChooser() {
        this.init();
    }

    public SftpHostChooser(boolean shell) {
        this.shell = shell;
        this.init();
    }

    public void init() {
        this.setLocation(100, 150);
        this.setTitle("Sftp Connection...");
        this.setBackground(this.okP.getBackground());
        try {
            File f = new File(Settings.appHomeDir);
            f.mkdir();
            File f1 = new File(Settings.login);
            f1.createNewFile();
            File f2 = new File(Settings.login_def_sftp);
            f2.createNewFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String[] login = LoadSet.loadSet(Settings.login_def_sftp);
        if (login[0] != null && login.length > 1) {
            this.host.setText(login[0]);
            this.user.setText(login[1]);
        }
        if (Settings.getStorePasswords()) {
            if (login != null && login.length > 2 && login[2] != null) {
                this.pass.setText(login[2]);
            }
        } else {
            this.pass.setText("");
        }
        this.enc.addItem("3des-cbc");
        this.enc.addItem("blowfish-cbc");
        this.cs.addItem("hmac-sha1");
        this.cs.addItem("hmac-sha1-96");
        this.cs.addItem("hmac-md5");
        this.cs.addItem("hmac-md5-96");
        this.keys.addItem("ssh-rsa");
        this.keys.addItem("ssh-dss");
        HInsetPanel root = new HInsetPanel();
        root.setLayout(new GridLayout(7, 2, 5, 3));
        root.add(this.host);
        root.add(this.port);
        root.add(this.user);
        root.add(this.pass);
        root.add(this.encL);
        root.add(this.enc);
        root.add(this.csL);
        root.add(this.cs);
        root.add(this.keysL);
        root.add(this.keys);
        root.add(this.keyP);
        root.add(new JLabel("Keyfiles are usually located ~/.ssh/ on UNIX"));
        root.add(this.useJSch);
        root.add(this.okP);
        this.keyP.add(this.keyfileL);
        this.keyP.add(this.keyfile);
        this.okP.add(new JLabel("        "));
        this.okP.add(this.ok);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.getContentPane().add("Center", root);
        this.ok.addActionListener(this);
        this.keyfile.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.pass.text.addActionListener(this);
        this.useJSch.addChangeListener(this);
        this.pack();
        this.setModal(false);
        this.setVisible(false);
        this.addWindowListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.useJSch.isSelected()) {
            this.enc.setEnabled(false);
            this.cs.setEnabled(false);
            this.keys.setEnabled(false);
        } else {
            this.keyfile.setEnabled(true);
            this.enc.setEnabled(true);
            this.cs.setEnabled(true);
            this.keys.setEnabled(true);
        }
    }

    public void update() {
        this.fixLocation();
        this.setVisible(true);
        this.toFront();
        this.host.requestFocus();
    }

    public void update(String url) {
        try {
            SftpURLConnection uc = new SftpURLConnection(new URL(url));
            SftpConnection con = uc.getSftpConnection();
            JFtp.statusP.jftp.addConnection(url, con);
            uc.connect();
            if (!uc.getLoginResponse()) {
                this.setTitle("Wrong password!");
                this.host.setText(uc.getHost());
                this.port.setText(Integer.toString(uc.getPort()));
                this.user.setText(uc.getUser());
                this.pass.setText(uc.getPass());
                this.setVisible(true);
                this.toFront();
                this.host.requestFocus();
            } else {
                this.dispose();
                if (this.listener != null) {
                    this.listener.componentResized(new ComponentEvent(this, 0));
                }
                JFtp.mainFrame.setVisible(true);
                JFtp.mainFrame.toFront();
            }
        }
        catch (IOException ex) {
            Log.debug("Error!");
            ex.printStackTrace();
        }
    }

    public void setShell(boolean shell) {
        this.shell = shell;
    }

    public boolean getShell() {
        return this.shell;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok || e.getSource() == this.pass.text) {
            block12: {
                this.setCursor(new Cursor(3));
                Object con = null;
                String htmp = this.host.getText().trim();
                String utmp = this.user.getText().trim();
                String ptmp = this.pass.getText();
                int potmp = 22;
                try {
                    potmp = Integer.parseInt(this.port.getText());
                }
                catch (Exception ex) {
                    Log.debug("Error: Not a number!");
                }
                String potmpString = new String("" + potmp);
                SshConnectionProperties properties = new SshConnectionProperties();
                properties.setHost(htmp);
                properties.setPort(potmp);
                properties.setPrefSCEncryption((String)this.enc.getSelectedItem());
                properties.setPrefCSMac((String)this.cs.getSelectedItem());
                properties.setPrefPublicKey((String)this.keys.getSelectedItem());
                if (this.shell) {
                    SshShell s = new SshShell(properties, utmp, ptmp, potmp);
                    this.setCursor(new Cursor(0));
                    this.dispose();
                    s.toFront();
                    return;
                }
                try {
                    SaveSet s = new SaveSet(Settings.login_def_sftp, htmp, utmp, ptmp, potmpString, "null", "null");
                    if (!this.useJSch.isSelected()) {
                        StartConnection.setSshProperties(properties);
                        StartConnection.setSshKeyfile(this.keyfileName);
                        boolean status = StartConnection.startCon("SFTP", htmp, utmp, ptmp, potmp, "", this.useLocal);
                        break block12;
                    }
                    Sftp2Connection con2 = new Sftp2Connection(htmp, "" + potmp, this.keyfileName);
                    if (con2.login(utmp, ptmp)) {
                        if (this.useLocal) {
                            JFtp.statusP.jftp.addLocalConnection(htmp, con2);
                        } else {
                            JFtp.statusP.jftp.addConnection(htmp, con2);
                        }
                        if (!con2.chdir(con2.getPWD()) && !con2.chdir("/")) {
                            // empty if block
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Log.debug("Could not create SftpConnection, does this distribution come with j2ssh?");
                }
            }
            this.setCursor(new Cursor(0));
            this.dispose();
            JFtp.mainFrame.setVisible(true);
            JFtp.mainFrame.toFront();
            if (this.listener == null) return;
            this.listener.componentResized(new ComponentEvent(this, 0));
            return;
        }
        if (e.getSource() != this.keyfile) return;
        JFileChooser chooser = new JFileChooser();
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.keyfileName = chooser.getSelectedFile().getPath();
            if (this.keyfileName == null) return;
            this.keyfileL.setText("(File present)");
            return;
        }
        this.keyfileName = null;
        if (this.keyfileName == null) return;
        this.keyfileL.setText("(No File)");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void pause(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

