/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

public class Xdr {
    private static int XDRUNIT = 4;
    private byte[] buf;
    private int size;
    private int off;
    private int wrap_offset;
    int xid;

    public Xdr(int n) {
        this.buf = new byte[n];
        this.size = n;
        this.off = 0;
    }

    public boolean xdr_bool() {
        return this.xdr_int() != 0;
    }

    public void xdr_bool(boolean bl) {
        this.xdr_int(bl ? 1 : 0);
    }

    public byte[] xdr_buf() {
        return this.buf;
    }

    public byte[] xdr_bytes() {
        return this.xdr_raw(this.xdr_int());
    }

    public void xdr_bytes(Xdr xdr) {
        this.xdr_bytes(xdr.xdr_buf(), xdr.xdr_offset());
    }

    public void xdr_bytes(byte[] byArray) {
        this.xdr_bytes(byArray, 0, byArray.length);
    }

    public void xdr_bytes(byte[] byArray, int n) {
        this.xdr_bytes(byArray, 0, n);
    }

    public void xdr_bytes(byte[] byArray, int n, int n2) {
        this.xdr_int(n2);
        System.arraycopy(byArray, n, this.buf, this.off, n2);
        this.xdr_skip(n2);
    }

    public float xdr_float() {
        return Float.intBitsToFloat(this.xdr_int());
    }

    public void xdr_float(float f) {
        this.xdr_int(Float.floatToIntBits(f));
    }

    public long xdr_hyper() {
        return (long)(this.buf[this.off++] & 0xFF) << 56 | (long)(this.buf[this.off++] & 0xFF) << 48 | (long)(this.buf[this.off++] & 0xFF) << 40 | (long)(this.buf[this.off++] & 0xFF) << 32 | (long)(this.buf[this.off++] & 0xFF) << 24 | (long)(this.buf[this.off++] & 0xFF) << 16 | (long)(this.buf[this.off++] & 0xFF) << 8 | (long)(this.buf[this.off++] & 0xFF);
    }

    public void xdr_hyper(long l) {
        this.buf[this.off++] = (byte)(l >>> 56);
        this.buf[this.off++] = (byte)(l >> 48 & 0xFFL);
        this.buf[this.off++] = (byte)(l >> 40 & 0xFFL);
        this.buf[this.off++] = (byte)(l >> 32 & 0xFFL);
        this.buf[this.off++] = (byte)(l >> 24 & 0xFFL);
        this.buf[this.off++] = (byte)(l >> 16 & 0xFFL);
        this.buf[this.off++] = (byte)(l >> 8 & 0xFFL);
        this.buf[this.off++] = (byte)(l & 0xFFL);
    }

    public int xdr_int() {
        return (this.buf[this.off++] & 0xFF) << 24 | (this.buf[this.off++] & 0xFF) << 16 | (this.buf[this.off++] & 0xFF) << 8 | this.buf[this.off++] & 0xFF;
    }

    public void xdr_int(int n) {
        this.buf[this.off++] = (byte)(n >>> 24);
        this.buf[this.off++] = (byte)(n >> 16);
        this.buf[this.off++] = (byte)(n >> 8);
        this.buf[this.off++] = (byte)n;
    }

    public int xdr_offset() {
        return this.off;
    }

    public void xdr_offset(int n) {
        this.off = n;
    }

    public byte[] xdr_raw(int n) {
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.off, byArray, 0, n);
        this.xdr_skip(n);
        return byArray;
    }

    public byte[] xdr_raw(int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, n, byArray, 0, n2);
        return byArray;
    }

    public void xdr_raw(byte[] byArray) {
        int n = byArray.length;
        System.arraycopy(byArray, 0, this.buf, this.off, n);
        this.xdr_skip(n);
    }

    public void xdr_raw(byte[] byArray, int n) {
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, this.buf, n, n2);
        this.xdr_skip(n2);
    }

    public void xdr_raw(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.buf, this.off, n2);
        this.xdr_skip(n2);
    }

    public int xdr_size() {
        return this.size;
    }

    public void xdr_size(int n) {
        this.size = n;
    }

    public void xdr_skip(int n) {
        int n2 = (this.off += n) % XDRUNIT;
        if (n2 > 0) {
            this.off += XDRUNIT - n2;
        }
    }

    public String xdr_string() {
        int n = this.xdr_int();
        String string = new String(this.buf, this.off, n);
        this.xdr_skip(n);
        return string;
    }

    public void xdr_string(String string) {
        this.xdr_bytes(string.getBytes());
    }

    public long xdr_u_int() {
        return (this.buf[this.off++] & 0xFF) << 24 | (this.buf[this.off++] & 0xFF) << 16 | (this.buf[this.off++] & 0xFF) << 8 | this.buf[this.off++] & 0xFF;
    }

    public void xdr_u_int(long l) {
        this.buf[this.off++] = (byte)(l >>> 24 & 0xFFL);
        this.buf[this.off++] = (byte)(l >> 16);
        this.buf[this.off++] = (byte)(l >> 8);
        this.buf[this.off++] = (byte)l;
    }

    public int xdr_wrap_offset() {
        return this.wrap_offset;
    }

    public void xdr_wrap_offset(int n) {
        this.wrap_offset = n;
    }
}

