/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AsyncService
extends Service
implements Runnable {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$Service == null ? (class$com$sshtools$j2ssh$transport$Service = AsyncService.class$("com.sshtools.j2ssh.transport.Service")) : class$com$sshtools$j2ssh$transport$Service);
    protected SshThread thread;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$Service;

    public AsyncService(String string) {
        super(string);
    }

    protected void onStart() throws IOException {
        this.thread = Thread.currentThread() instanceof SshThread ? ((SshThread)Thread.currentThread()).cloneThread(this, this.getServiceName()) : new SshThread(this, this.getServiceName(), true);
        log.info("Starting " + this.getServiceName() + " service thread");
        this.thread.start();
    }

    public final void run() {
        int[] nArray = this.getAsyncMessageFilter();
        this.state.setValue(2);
        SshMessage sshMessage = null;
        while (this.state.getValue() == 2 && this.transport.isConnected()) {
            try {
                sshMessage = this.messageStore.getMessage(nArray);
                if (this.state.getValue() == 3) break;
                if (log.isDebugEnabled()) {
                    log.debug("Routing " + sshMessage.getMessageName());
                }
                this.onMessageReceived(sshMessage);
                if (!log.isDebugEnabled()) continue;
                log.debug("Finished processing " + sshMessage.getMessageName());
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                this.stop();
            }
            catch (Exception exception) {
                if (this.state.getValue() == 3 || !this.transport.isConnected()) continue;
                log.fatal("Service message loop failed!", exception);
                this.stop();
            }
        }
        this.onStop();
        log.info(this.getServiceName() + " thread is exiting");
        this.thread = null;
    }

    protected abstract void onStop();

    protected abstract int[] getAsyncMessageFilter();

    protected abstract void onMessageReceived(SshMessage var1) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

