/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelData
extends SshMessage {
    public static final int SSH_MSG_CHANNEL_DATA = 94;
    private byte[] channelData;
    private long recipientChannel;

    public SshMsgChannelData(long l, byte[] byArray) {
        super(94);
        this.recipientChannel = l;
        this.channelData = byArray;
    }

    public SshMsgChannelData() {
        super(94);
    }

    public byte[] getChannelData() {
        return this.channelData;
    }

    public long getChannelDataLength() {
        return this.channelData.length;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_DATA";
    }

    public long getRecipientChannel() {
        return this.recipientChannel;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.writeInt(this.recipientChannel);
            if (this.channelData != null) {
                byteArrayWriter.writeBinaryString(this.channelData);
            } else {
                byteArrayWriter.writeInt(0);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.recipientChannel = byteArrayReader.readInt();
            if (byteArrayReader.available() > 0) {
                this.channelData = byteArrayReader.readBinaryString();
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

