/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Cache;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EncodingDetector;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.Logger;
import au.id.jericho.lib.html.LoggerDisabled;
import au.id.jericho.lib.html.LoggerFactory;
import au.id.jericho.lib.html.OutputDocument;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.RowColumnVector;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.SourceFormatter;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import au.id.jericho.lib.html.Util;
import au.id.jericho.lib.html.WriterLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Source
extends Segment {
    final String string;
    private String documentSpecifiedEncoding = "";
    private String encoding = "";
    private String encodingSpecificationInfo;
    private String preliminaryEncodingInfo = null;
    private String newLine = "";
    private ParseText parseText = null;
    private OutputDocument parseTextOutputDocument = null;
    Logger logger;
    private RowColumnVector[] rowColumnVectorCacheArray = null;
    final Cache cache = new Cache(this);
    boolean useAllTypesCache = true;
    boolean useSpecialTypesCache = true;
    Tag[] allTagsArray = null;
    List allTags = null;
    List allStartTags = null;
    private List allElements = null;
    private static String lastNewLine = null;
    private static final String UNINITIALISED = "";
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String CRLF = "\r\n";
    static final String PACKAGE_NAME = "net.htmlparser.jericho";

    public Source(CharSequence charSequence) {
        super(charSequence.length());
        this.string = ((Object)charSequence).toString();
        this.setLogger(Source.newLogger());
    }

    private Source(EncodingDetector encodingDetector) throws IOException {
        this(Source.getString(encodingDetector));
        this.encoding = encodingDetector.getEncoding();
        this.encodingSpecificationInfo = encodingDetector.getEncodingSpecificationInfo();
        this.preliminaryEncodingInfo = encodingDetector.getPreliminaryEncoding() + ": " + encodingDetector.getPreliminaryEncodingSpecificationInfo();
    }

    Source(Reader reader, String string) throws IOException {
        this(Util.getString(reader));
        if (string != null) {
            this.encoding = string;
            this.encodingSpecificationInfo = "InputStreamReader.getEncoding() of constructor argument";
        }
    }

    public Source(Reader reader) throws IOException {
        this(reader, reader instanceof InputStreamReader ? ((InputStreamReader)reader).getEncoding() : null);
    }

    public Source(InputStream inputStream) throws IOException {
        this(new EncodingDetector(inputStream));
    }

    public Source(URL uRL) throws IOException {
        this(new EncodingDetector(uRL));
    }

    private String setEncoding(String string, String string2) {
        if (this.encoding == UNINITIALISED) {
            this.encoding = string;
            this.encodingSpecificationInfo = string2;
        }
        return string;
    }

    public String getDocumentSpecifiedEncoding() {
        String string;
        StartTag startTag;
        if (this.documentSpecifiedEncoding != UNINITIALISED) {
            return this.documentSpecifiedEncoding;
        }
        Tag tag = this.getTagAt(0);
        if (tag != null && tag.getTagType() == StartTagType.XML_DECLARATION) {
            this.documentSpecifiedEncoding = ((StartTag)tag).getAttributeValue("encoding");
            if (this.documentSpecifiedEncoding != null) {
                return this.setEncoding(this.documentSpecifiedEncoding, tag.toString());
            }
        }
        if ((startTag = this.findNextStartTag(0, "http-equiv", "Content-Type", false)) != null && (string = startTag.getAttributeValue("content")) != null) {
            this.documentSpecifiedEncoding = Source.getCharsetParameterFromHttpHeaderValue(string);
            if (this.documentSpecifiedEncoding != null) {
                return this.setEncoding(this.documentSpecifiedEncoding, startTag.toString());
            }
        }
        return this.setEncoding(null, "No encoding specified in document");
    }

    public String getEncoding() {
        if (this.encoding == UNINITIALISED) {
            this.getDocumentSpecifiedEncoding();
        }
        return this.encoding;
    }

    public String getEncodingSpecificationInfo() {
        if (this.encoding == UNINITIALISED) {
            this.getDocumentSpecifiedEncoding();
        }
        return this.encodingSpecificationInfo;
    }

    public String getPreliminaryEncodingInfo() {
        return this.preliminaryEncodingInfo;
    }

    public boolean isXML() {
        Tag tag = this.getTagAt(0);
        if (tag != null && tag.getTagType() == StartTagType.XML_DECLARATION) {
            return true;
        }
        Tag tag2 = this.findNextTag(0, StartTagType.DOCTYPE_DECLARATION);
        return tag2 != null && this.getParseText().indexOf("xhtml", tag2.begin, tag2.end) != -1;
    }

    public String getNewLine() {
        if (this.newLine != UNINITIALISED) {
            return this.newLine;
        }
        for (int i = 0; i < this.end; ++i) {
            char c = this.string.charAt(i);
            if (c == '\n') {
                lastNewLine = LF;
                this.newLine = LF;
                return LF;
            }
            if (c != '\r') continue;
            lastNewLine = ++i < this.end && this.string.charAt(i) == '\n' ? CRLF : CR;
            this.newLine = lastNewLine;
            return lastNewLine;
        }
        this.newLine = null;
        return null;
    }

    String getBestGuessNewLine() {
        String string = this.getNewLine();
        if (string != null) {
            return string;
        }
        if (lastNewLine != null) {
            return lastNewLine;
        }
        return Config.NewLine;
    }

    public int getRow(int n) {
        return this.getRowColumnVector(n).getRow();
    }

    public int getColumn(int n) {
        return this.getRowColumnVector(n).getColumn();
    }

    public RowColumnVector getRowColumnVector(int n) {
        if (n > this.end) {
            throw new IndexOutOfBoundsException();
        }
        if (this.rowColumnVectorCacheArray == null) {
            this.rowColumnVectorCacheArray = RowColumnVector.getCacheArray(this);
        }
        return RowColumnVector.get(this.rowColumnVectorCacheArray, n);
    }

    public String toString() {
        return this.string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag[] fullSequentialParse() {
        if (this.allTagsArray != null) {
            return this.allTagsArray;
        }
        if (this.cache.getTagCount() != 0) {
            this.cache.clear();
        }
        boolean bl = this.useAllTypesCache;
        try {
            this.useAllTypesCache = false;
            this.useSpecialTypesCache = false;
            Tag[] tagArray = Tag.parseAll(this, false);
            return tagArray;
        }
        finally {
            this.useAllTypesCache = bl;
            this.useSpecialTypesCache = true;
        }
    }

    public List getChildElements() {
        if (this.childElements == null) {
            if (this.length() == 0) {
                this.childElements = Collections.EMPTY_LIST;
            } else {
                StartTag startTag;
                if (this.allTags == null) {
                    this.fullSequentialParse();
                }
                this.childElements = new ArrayList();
                int n = 0;
                while ((startTag = this.source.findNextStartTag(n)) != null) {
                    if (startTag.getTagType().isServerTag()) {
                        n = startTag.end;
                        continue;
                    }
                    Element element = startTag.getElement();
                    element.getChildElements(0);
                    if (element.parentElement == Element.NOT_CACHED) {
                        element.parentElement = null;
                        this.childElements.add(element);
                    }
                    n = element.end;
                }
            }
        }
        return this.childElements;
    }

    public SourceFormatter getSourceFormatter() {
        return new SourceFormatter(this);
    }

    public List findAllTags() {
        if (this.allTags == null) {
            this.fullSequentialParse();
        }
        return this.allTags;
    }

    public List findAllStartTags() {
        if (this.allStartTags == null) {
            List list = this.findAllTags();
            this.allStartTags = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof StartTag)) continue;
                this.allStartTags.add(e);
            }
        }
        return this.allStartTags;
    }

    public List findAllElements() {
        if (this.allElements == null) {
            List list = this.findAllStartTags();
            if (list.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            this.allElements = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                StartTag startTag = (StartTag)iterator.next();
                this.allElements.add(startTag.getElement());
            }
        }
        return this.allElements;
    }

    public Element getElementById(String string) {
        StartTag startTag = this.findNextStartTag(0, "id", string, true);
        return startTag == null ? null : startTag.getElement();
    }

    public final Tag getTagAt(int n) {
        return Tag.getTagAt(this, n);
    }

    public Tag findPreviousTag(int n) {
        return Tag.findPreviousOrNextTag(this, n, true);
    }

    public Tag findPreviousTag(int n, TagType tagType) {
        return Tag.findPreviousOrNextTag(this, n, tagType, true);
    }

    public Tag findNextTag(int n) {
        return Tag.findPreviousOrNextTag(this, n, false);
    }

    public Tag findNextTag(int n, TagType tagType) {
        return Tag.findPreviousOrNextTag(this, n, tagType, false);
    }

    public Tag findEnclosingTag(int n) {
        return this.findEnclosingTag(n, null);
    }

    public Tag findEnclosingTag(int n, TagType tagType) {
        Tag tag = this.findPreviousTag(n, tagType);
        if (tag == null || tag.end <= n) {
            return null;
        }
        return tag;
    }

    public Element findNextElement(int n) {
        StartTag startTag = this.findNextStartTag(n);
        return startTag == null ? null : startTag.getElement();
    }

    public Element findNextElement(int n, String string) {
        StartTag startTag = this.findNextStartTag(n, string);
        return startTag == null ? null : startTag.getElement();
    }

    public Element findNextElement(int n, String string, String string2, boolean bl) {
        StartTag startTag = this.findNextStartTag(n, string, string2, bl);
        return startTag == null ? null : startTag.getElement();
    }

    public StartTag findPreviousStartTag(int n) {
        return StartTag.findPreviousOrNext(this, n, true);
    }

    public StartTag findPreviousStartTag(int n, String string) {
        if (string != null) {
            string = string.toLowerCase();
        }
        boolean bl = Tag.isXMLName(string);
        return StartTag.findPreviousOrNext(this, n, string, bl, true);
    }

    public StartTag findNextStartTag(int n) {
        return StartTag.findPreviousOrNext(this, n, false);
    }

    public StartTag findNextStartTag(int n, String string) {
        if (string != null) {
            string = string.toLowerCase();
        }
        boolean bl = Tag.isXMLName(string);
        return StartTag.findPreviousOrNext(this, n, string, bl, false);
    }

    public StartTag findNextStartTag(int n, String string, String string2, boolean bl) {
        return StartTag.findNext(this, n, string, string2, bl);
    }

    public EndTag findPreviousEndTag(int n) {
        return EndTag.findPreviousOrNext(this, n, true);
    }

    public EndTag findPreviousEndTag(int n, String string) {
        if (string == null) {
            throw new IllegalArgumentException("name argument must not be null");
        }
        return EndTag.findPreviousOrNext(this, n, string.toLowerCase(), EndTagType.NORMAL, true);
    }

    public EndTag findNextEndTag(int n) {
        return EndTag.findPreviousOrNext(this, n, false);
    }

    public EndTag findNextEndTag(int n, String string) {
        return this.findNextEndTag(n, string, EndTagType.NORMAL);
    }

    public EndTag findNextEndTag(int n, String string, EndTagType endTagType) {
        if (string == null) {
            throw new IllegalArgumentException("name argument must not be null");
        }
        return EndTag.findPreviousOrNext(this, n, string.toLowerCase(), endTagType, false);
    }

    public Element findEnclosingElement(int n) {
        return this.findEnclosingElement(n, null);
    }

    public Element findEnclosingElement(int n, String string) {
        int n2 = n;
        if (string != null) {
            string = string.toLowerCase();
        }
        boolean bl = Tag.isXMLName(string);
        StartTag startTag;
        while ((startTag = StartTag.findPreviousOrNext(this, n2, string, bl, true)) != null) {
            Element element = startTag.getElement();
            if (n < element.end) {
                return element;
            }
            n2 = startTag.begin - 1;
        }
        return null;
    }

    public CharacterReference findPreviousCharacterReference(int n) {
        return CharacterReference.findPreviousOrNext(this, n, true);
    }

    public CharacterReference findNextCharacterReference(int n) {
        return CharacterReference.findPreviousOrNext(this, n, false);
    }

    public int findNameEnd(int n) {
        if (!Tag.isXMLNameStartChar(this.string.charAt(n++))) {
            return -1;
        }
        while (n < this.string.length() && Tag.isXMLNameChar(this.string.charAt(n))) {
            ++n;
        }
        return n;
    }

    public Attributes parseAttributes(int n, int n2) {
        return this.parseAttributes(n, n2, Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int n, int n2, int n3) {
        return Attributes.construct(this, n, n2, n3);
    }

    public void ignoreWhenParsing(int n, int n2) {
        if (this.wasFullSequentialParseCalled()) {
            throw new IllegalStateException("ignoreWhenParsing can not be used after fullSequentialParse() has been called");
        }
        if (this.parseTextOutputDocument == null) {
            this.parseTextOutputDocument = new OutputDocument(this.getParseText());
            this.parseText = null;
        }
        this.parseTextOutputDocument.replaceWithSpaces(n, n2);
    }

    public void ignoreWhenParsing(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((Segment)iterator.next()).ignoreWhenParsing();
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger != null ? logger : LoggerDisabled.INSTANCE;
    }

    public Logger getLogger() {
        return this.logger != LoggerDisabled.INSTANCE ? this.logger : null;
    }

    public void clearCache() {
        this.cache.clear();
        this.allTagsArray = null;
        this.allTags = null;
        this.allStartTags = null;
        this.allElements = null;
    }

    public String getCacheDebugInfo() {
        return this.cache.toString();
    }

    List getParsedTags() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.cache.getTagIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public final ParseText getParseText() {
        if (this.parseText == null) {
            if (this.parseTextOutputDocument != null) {
                this.parseText = new ParseText(this.parseTextOutputDocument);
                this.parseTextOutputDocument = null;
            } else {
                this.parseText = new ParseText(this);
            }
        }
        return this.parseText;
    }

    public CharStreamSource indent(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.getSourceFormatter().setIndentString(string).setTidyTags(bl).setCollapseWhiteSpace(bl2).setIndentAllElements(bl3);
    }

    public void setLogWriter(Writer writer) {
        this.setLogger(new WriterLogger(writer));
    }

    public Writer getLogWriter() {
        if (!(this.logger instanceof WriterLogger)) {
            return null;
        }
        return ((WriterLogger)this.getLogger()).getWriter();
    }

    public void log(String string) {
        this.logger.info(string);
    }

    public boolean isLoggingEnabled() {
        return this.logger.isInfoEnabled();
    }

    static String getCharsetParameterFromHttpHeaderValue(String string) {
        int n = string.toLowerCase().indexOf("charset=");
        if (n == -1) {
            return null;
        }
        int n2 = n + 8;
        int n3 = string.indexOf(59, n2);
        String string2 = n3 == -1 ? string.substring(n2) : string.substring(n2, n3);
        return string2.trim();
    }

    static Logger newLogger() {
        return LoggerFactory.getLogger(PACKAGE_NAME);
    }

    private static String getString(EncodingDetector encodingDetector) throws IOException {
        try {
            return Util.getString(encodingDetector.openReader());
        }
        catch (IOException iOException) {
            try {
                Logger logger = Source.newLogger();
                if (logger.isInfoEnabled()) {
                    logger.info("IOException constructing encoded source. Encoding: " + encodingDetector.getEncoding() + " - " + encodingDetector.getEncodingSpecificationInfo() + ". PreliminaryEncoding: " + encodingDetector.getPreliminaryEncoding() + " - " + encodingDetector.getPreliminaryEncodingSpecificationInfo());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    private boolean wasFullSequentialParseCalled() {
        return this.allTagsArray != null;
    }
}

