/*
 * File    : BoxBaseEditor.java
 * Created : 02-oct-2002 13:45
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.boxes;

import edu.xtec.jclic.beans.ColorButton;
import edu.xtec.jclic.beans.GradientButton;
import edu.xtec.jclic.beans.SmallIntEditor;
import edu.xtec.util.FontCheck;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.cat)
 * @version 13.09.17
 */
public class BoxBaseEditor extends javax.swing.JPanel {
    
    Options options;
    BoxBase bb;
    
    /** Creates new form BoxBaseEditor */
    public BoxBaseEditor(Options options, BoxBase bb) {
        this.options=options;
        initComponents();
        setBoxBase(bb);
    }
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    javax.swing.JLabel bgColorLb = new javax.swing.JLabel();
    bgColorBtn = new edu.xtec.jclic.beans.ColorButton();
    bgColorBtn.setOptions(options);
    javax.swing.JLabel gradientLb = new javax.swing.JLabel();
    gradientButton = new edu.xtec.jclic.beans.GradientButton();
    gradientButton.setOptions(options);
    transparentChk = new javax.swing.JCheckBox();
    javax.swing.JSeparator sep1 = new javax.swing.JSeparator();
    javax.swing.JLabel fontLb = new javax.swing.JLabel();
    typefacePanel = new javax.swing.JPanel();
    fontFaceCombo = new JComboBox<Object>(FontCheck.getFontList(false));
    javax.swing.JLabel sizeLb = new javax.swing.JLabel();
    fontSizeCombo = new JComboBox<Object>(FontCheck.fontSizes);
    boldBtn = new javax.swing.JToggleButton();
    italicBtn = new javax.swing.JToggleButton();
    javax.swing.JSeparator sep2 = new javax.swing.JSeparator();
    javax.swing.JLabel textColorLb = new javax.swing.JLabel();
    textColorBtn = new edu.xtec.jclic.beans.ColorButton();
    textColorBtn.setOptions(options);
    javax.swing.JLabel altColorLb = new javax.swing.JLabel();
    altColorBtn = new edu.xtec.jclic.beans.ColorButton();
    altColorBtn.setOptions(options);
    javax.swing.JLabel textMarginLb = new javax.swing.JLabel();
    textMarginInt = new edu.xtec.jclic.beans.SmallIntEditor();
    shadowChk = new javax.swing.JCheckBox();
    javax.swing.JLabel shadowColorLb = new javax.swing.JLabel();
    shadowColorBtn = new edu.xtec.jclic.beans.ColorButton();
    shadowColorBtn.setOptions(options);
    javax.swing.JLabel borderColorLb = new javax.swing.JLabel();
    borderColorBtn = new edu.xtec.jclic.beans.ColorButton();
    borderColorBtn.setOptions(options);
    javax.swing.JLabel borderWidthLb = new javax.swing.JLabel();
    borderWidthSlider = new javax.swing.JSlider();
    javax.swing.JLabel inactiveColorLb = new javax.swing.JLabel();
    inactiveColorBtn = new edu.xtec.jclic.beans.ColorButton();
    inactiveColorBtn.setOptions(options);
    javax.swing.JLabel markerWidthLb = new javax.swing.JLabel();
    markerWidthSlider = new javax.swing.JSlider();

    setBorder(javax.swing.BorderFactory.createEtchedBorder());
    setLayout(new java.awt.GridBagLayout());

    bgColorLb.setLabelFor(bgColorBtn);
    bgColorLb.setText(options.getMsg("edit_act_bgColor"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(bgColorLb, gridBagConstraints);

    bgColorBtn.setToolTipText(options.getMsg("edit_act_bgColor_tooltip"));
    bgColorBtn.addPropertyChangeListener(ColorButton.PROP_COLOR, propListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(bgColorBtn, gridBagConstraints);

    gradientLb.setText(options.getMsg("edit_act_gradient"));
    gradientLb.setLabelFor(gradientButton);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(gradientLb, gridBagConstraints);

    gradientButton.setToolTipText(options.getMsg("edit_act_gradient_tooltip"));
    gradientButton.addPropertyChangeListener(GradientButton.PROP_GRADIENT, propListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(gradientButton, gridBagConstraints);

    transparentChk.setToolTipText(options.getMsg("edit_act_transparent_tooltip"));
    transparentChk.setText(options.getMsg("edit_act_transparent"));
    transparentChk.addActionListener(actionListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(transparentChk, gridBagConstraints);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.weightx = 1.0;
    add(sep1, gridBagConstraints);

    fontLb.setLabelFor(fontFaceCombo);
    fontLb.setText(options.getMsg("edit_font_face"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(fontLb, gridBagConstraints);

    typefacePanel.setLayout(new java.awt.GridBagLayout());

    fontFaceCombo.setEditable(true);
    fontFaceCombo.setPreferredSize(new Dimension(125, fontFaceCombo.getPreferredSize().height));
    fontFaceCombo.addActionListener(cfListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    typefacePanel.add(fontFaceCombo, gridBagConstraints);

    sizeLb.setText(options.getMsg("edit_font_size"));
    sizeLb.setLabelFor(fontSizeCombo);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    typefacePanel.add(sizeLb, gridBagConstraints);

    fontSizeCombo.setEditable(true);
    fontSizeCombo.setPreferredSize(new Dimension(50, fontSizeCombo.getPreferredSize().height));
    fontSizeCombo.addActionListener(cfListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    typefacePanel.add(fontSizeCombo, gridBagConstraints);

    boldBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/font_bold.gif"))); // NOI18N
    boldBtn.setToolTipText(options.getMsg("edit_font_bold"));
    boldBtn.setPreferredSize(new java.awt.Dimension(27, 27));
    boldBtn.addActionListener(cfListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    typefacePanel.add(boldBtn, gridBagConstraints);

    italicBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/font_italic.gif"))); // NOI18N
    italicBtn.setToolTipText(options.getMsg("edit_font_italic"));
    italicBtn.setPreferredSize(new java.awt.Dimension(27, 27));
    italicBtn.addActionListener(cfListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    typefacePanel.add(italicBtn, gridBagConstraints);

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    add(typefacePanel, gridBagConstraints);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.weightx = 1.0;
    add(sep2, gridBagConstraints);

    textColorLb.setText(options.getMsg("edit_act_textColor"));
    textColorLb.setLabelFor(textColorBtn);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(textColorLb, gridBagConstraints);

    textColorBtn.setToolTipText(options.getMsg("edit_act_textColor_tooltip"));
    textColorBtn.addPropertyChangeListener(ColorButton.PROP_COLOR, propListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(textColorBtn, gridBagConstraints);

    altColorLb.setText(options.getMsg("edit_act_altColor"));
    altColorLb.setLabelFor(altColorBtn);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    add(altColorLb, gridBagConstraints);

    altColorBtn.setToolTipText(options.getMsg("edit_act_altColor_tooltip"));
    altColorBtn.addPropertyChangeListener(ColorButton.PROP_COLOR, propListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(altColorBtn, gridBagConstraints);

    textMarginLb.setLabelFor(textMarginInt);
    textMarginLb.setText(options.getMsg("edit_cell_textMargin"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    add(textMarginLb, gridBagConstraints);

    textMarginInt.setToolTipText(options.getMsg("edit_cell_textMargin_tooltip"));
    textMarginInt.setMax(50);
    textMarginInt.addPropertyChangeListener(SmallIntEditor.PROP_VALUE, propListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    add(textMarginInt, gridBagConstraints);

    shadowChk.setToolTipText(options.getMsg("edit_act_shadow_tooltip"));
    shadowChk.setText(options.getMsg("edit_act_shadow"));
    shadowChk.addActionListener(actionListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = 2;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(shadowChk, gridBagConstraints);

    shadowColorLb.setText(options.getMsg("edit_act_shadowColor"));
    shadowColorLb.setLabelFor(shadowColorBtn);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(shadowColorLb, gridBagConstraints);

    shadowColorBtn.setToolTipText(options.getMsg("edit_act_shadowColor_tooltip"));
    shadowColorBtn.addPropertyChangeListener(ColorButton.PROP_COLOR, propListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(shadowColorBtn, gridBagConstraints);

    borderColorLb.setText(options.getMsg("edit_act_borderColor"));
    borderColorLb.setLabelFor(borderColorBtn);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(borderColorLb, gridBagConstraints);

    borderColorBtn.setToolTipText(options.getMsg("edit_act_borderColor_tooltip"));
    borderColorBtn.addPropertyChangeListener(ColorButton.PROP_COLOR, propListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(borderColorBtn, gridBagConstraints);

    borderWidthLb.setText(options.getMsg("edit_cell_borderWidth"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(borderWidthLb, gridBagConstraints);

    borderWidthSlider.setMinorTickSpacing(10);
    borderWidthSlider.setPaintTicks(true);
    borderWidthSlider.setMajorTickSpacing(50);
    borderWidthSlider.setToolTipText(options.getMsg("edit_cell_borderWidth_tooltip"));
    borderWidthSlider.setPreferredSize(new java.awt.Dimension(100, 27));
    borderWidthSlider.addChangeListener(borderListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(borderWidthSlider, gridBagConstraints);

    inactiveColorLb.setText(options.getMsg("edit_act_inactiveColor"));
    inactiveColorLb.setLabelFor(inactiveColorBtn);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    add(inactiveColorLb, gridBagConstraints);

    inactiveColorBtn.setToolTipText(options.getMsg("edit_act_inactiveColor_tooltip"));
    inactiveColorBtn.addPropertyChangeListener(ColorButton.PROP_COLOR, propListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
    add(inactiveColorBtn, gridBagConstraints);

    markerWidthLb.setText(options.getMsg("edit_cell_markerWidth"));
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    add(markerWidthLb, gridBagConstraints);

    markerWidthSlider.setMinorTickSpacing(10);
    markerWidthSlider.setPaintTicks(true);
    markerWidthSlider.setMajorTickSpacing(50);
    markerWidthSlider.setToolTipText(options.getMsg("edit_cell_markerWidth_tooltip"));
    markerWidthSlider.setPreferredSize(new java.awt.Dimension(100, 27));
    borderWidthSlider.addChangeListener(borderListener);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
    gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
    add(markerWidthSlider, gridBagConstraints);
  }// </editor-fold>//GEN-END:initComponents
    
    
    public void setBoxBase(BoxBase b){
        if(b==null)
            b=new BoxBase();
        bb=(BoxBase)b.clone();
        Font f=bb.getOriginalFont();
        fontFaceCombo.setSelectedItem(f.getFamily());
        fontSizeCombo.setSelectedItem(Integer.toString(f.getSize()));
        boldBtn.setSelected(f.isBold());
        italicBtn.setSelected(f.isItalic());
        bgColorBtn.setColor(b.backColor);
        gradientButton.setGradient(b.bgGradient);
        textColorBtn.setColor(b.textColor);
        shadowColorBtn.setColor(b.shadowColor);
        shadowChk.setSelected(b.shadow);
        transparentChk.setSelected(b.transparent);
        borderColorBtn.setColor(b.borderColor);
        inactiveColorBtn.setColor(b.inactiveColor);
        altColorBtn.setColor(b.alternativeColor);
        textMarginInt.setValue(b.textMargin);
        borderWidthSlider.setValue((int)(b.borderStroke.getLineWidth()*10));
        markerWidthSlider.setValue((int)(b.markerStroke.getLineWidth()*10));
    }
    
    protected void createFont(){
        Font f=bb.getFont();
        int s;
        try{
            s=Integer.parseInt((String)fontSizeCombo.getSelectedItem());
        } catch(Exception ex){
            s=f.getSize();
        }
        s=Math.min(Math.max(s, 6), 140);
        
        int style=Font.PLAIN;
        if(boldBtn.isSelected())
            style|=Font.BOLD;
        if(italicBtn.isSelected())
            style|=Font.ITALIC;
        bb.setFont(new Font((String)fontFaceCombo.getSelectedItem(), style, s)); 
    }
    
    public static final String PROP_BOX_BASE="boxBase";
    
    private void checkAndFirePropertyChange(BoxBase oldBb){
        BoxBase currentBb=getBoxBase();
        boolean eq=((oldBb==null && currentBb==null) || (oldBb!=null && oldBb.equals(currentBb)));
        if(!eq)
            firePropertyChange(PROP_BOX_BASE, oldBb, currentBb);
    }
    
    ActionListener cfListener=new ActionListener(){
        public void actionPerformed(ActionEvent ev){
            BoxBase oldBb=getBoxBaseClone();
            createFont();
            checkAndFirePropertyChange(oldBb);
            //fireActionPerformed(ev);
        }
    };

    PropertyChangeListener propListener=new PropertyChangeListener(){
        public void propertyChange(PropertyChangeEvent evt){
            BoxBase oldBb=getBoxBaseClone();
            bb.backColor=bgColorBtn.getColor();
            bb.bgGradient=gradientButton.getGradient();
            bb.textColor=textColorBtn.getColor();
            bb.shadowColor=shadowColorBtn.getColor();
            bb.shadow=shadowChk.isSelected();
            bb.transparent=transparentChk.isSelected();
            bb.borderColor=borderColorBtn.getColor();
            bb.inactiveColor=inactiveColorBtn.getColor();
            bb.alternativeColor=altColorBtn.getColor();
            bb.textMargin=textMarginInt.getValue();
            checkAndFirePropertyChange(oldBb);
        }
    };
    
    ActionListener actionListener=new ActionListener(){
        public void actionPerformed(ActionEvent ev){
            BoxBase oldBb=getBoxBaseClone();
            bb.shadow=shadowChk.isSelected();
            bb.transparent=transparentChk.isSelected();
            checkAndFirePropertyChange(oldBb);
        }
    }; 
    
    ChangeListener borderListener=new ChangeListener(){
        public void stateChanged(ChangeEvent e){
            BoxBase oldBb=getBoxBaseClone();
            bb.borderStroke=new java.awt.BasicStroke(((float)borderWidthSlider.getValue())/10f);
            bb.markerStroke=new java.awt.BasicStroke(((float)markerWidthSlider.getValue())/10f);
            //fireActionPerformed(null);
            checkAndFirePropertyChange(oldBb);
        }
    };
    
    public BoxBase getBoxBase(){
        return bb;
    }
    
    public BoxBase getBoxBaseClone(){
        if(bb!=null)
            return (BoxBase)bb.clone();
        return null;
    }    
    
    private static Map<Options, BoxBaseEditor> panels=new HashMap<Options, BoxBaseEditor>(1);
    public static BoxBase getBoxBase(BoxBase initialBoxBase, Component parent, Options options, final AbstractBox preview){
        Messages msg=options.getMessages();
        BoxBaseEditor bbe=panels.get(options);
        if(bbe==null){
            bbe=new BoxBaseEditor(options, initialBoxBase);
            panels.put(options, bbe);
        } else{
            bbe.setBoxBase(initialBoxBase);
        }
        PropertyChangeListener lst=null;
        final BoxBaseEditor bb_ed=bbe;
        if(preview!=null){
            lst=new PropertyChangeListener(){
                public void propertyChange(PropertyChangeEvent ev){
                    if(preview!=null)
                        preview.setBoxBase(bb_ed.getBoxBase());
                }
            };
            bbe.addPropertyChangeListener(PROP_BOX_BASE, lst);
        }
        BoxBase bbBackup = preview!=null ? bbe.getBoxBaseClone() : null;
        boolean b=msg.showInputDlg(parent, bbe, "edit_style_title");
        if(lst!=null)
            bbe.removePropertyChangeListener(PROP_BOX_BASE, lst);
        if(!b && preview!=null)
            preview.setBoxBase(bbBackup);
        return b ? bbe.bb : null;
    }
    
    
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private edu.xtec.jclic.beans.ColorButton altColorBtn;
  private edu.xtec.jclic.beans.ColorButton bgColorBtn;
  private javax.swing.JToggleButton boldBtn;
  private edu.xtec.jclic.beans.ColorButton borderColorBtn;
  private javax.swing.JSlider borderWidthSlider;
  private javax.swing.JComboBox<Object> fontFaceCombo;
  private javax.swing.JComboBox<Object> fontSizeCombo;
  private edu.xtec.jclic.beans.GradientButton gradientButton;
  private edu.xtec.jclic.beans.ColorButton inactiveColorBtn;
  private javax.swing.JToggleButton italicBtn;
  private javax.swing.JSlider markerWidthSlider;
  private javax.swing.JCheckBox shadowChk;
  private edu.xtec.jclic.beans.ColorButton shadowColorBtn;
  private edu.xtec.jclic.beans.ColorButton textColorBtn;
  private edu.xtec.jclic.beans.SmallIntEditor textMarginInt;
  private javax.swing.JCheckBox transparentChk;
  private javax.swing.JPanel typefacePanel;
  // End of variables declaration//GEN-END:variables
    
}
