/*
 *   Jackbeat - JACK sequencer
 *    
 *   Copyright (c) 2004-2005 Olivier Guilyardi <olivier@samalyse.com>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef JACKBEAT_JAB_H
#define JACKBEAT_JAB_H


#define JAB_WRITE 1
#define JAB_READ 2

typedef struct jab_t jab_t;
typedef void(* jab_progress_callback_t)(char * status, double fraction, void * data);

jab_t * jab_open (char *path, int mode, jab_progress_callback_t progress_callback, 
                  void *progress_data);
void jab_add_sequence (jab_t *jab, sequence_t *sequence);
sequence_t * jab_retrieve_sequence (jab_t *jab, char *sequence_name, int *error);
int jab_close (jab_t *jab);

#endif
