/****************************************************************************
 *                         GhdlRemoteSimPlugin.h
 *
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "IviRemoteSimPlugin.h"
#include "GhdlRemoteIviSim.h"

typedef struct {
	int magic;
	void (*vpi_register_systf)(const struct t_vpi_systf_data*ss);
	void (*vpi_vprintf)(const char*fmt, va_list ap);
	unsigned int (*vpi_mcd_close)(unsigned int mcd);
	char *(*vpi_mcd_name)(unsigned int mcd);
	unsigned int (*vpi_mcd_open)(char *name);
	unsigned int (*vpi_mcd_open_x)(char *name, char *mode);
	int (*vpi_mcd_vprintf)(unsigned int mcd, const char*fmt, va_list ap);
	int (*vpi_mcd_fputc)(unsigned int mcd, unsigned char x);
	int (*vpi_mcd_fgetc)(unsigned int mcd);
	vpiHandle (*vpi_register_cb)(p_cb_data data);
	int (*vpi_remove_cb)(vpiHandle ref);
	void (*vpi_sim_vcontrol)(int operation, va_list ap);
	vpiHandle (*vpi_handle)(int type, vpiHandle ref);
	vpiHandle (*vpi_iterate)(int type, vpiHandle ref);
	vpiHandle (*vpi_scan)(vpiHandle iter);
	vpiHandle (*vpi_handle_by_index)(vpiHandle ref, int index);
	void (*vpi_get_time)(vpiHandle obj, s_vpi_time*t);
	int (*vpi_get)(int property, vpiHandle ref);
	char* (*vpi_get_str)(int property, vpiHandle ref);
	void (*vpi_get_value)(vpiHandle expr, p_vpi_value value);
	vpiHandle (*vpi_put_value)(vpiHandle obj, p_vpi_value value,
			p_vpi_time when, int flags);
	int (*vpi_free_object)(vpiHandle ref);
	int (*vpi_get_vlog_info)(p_vpi_vlog_info vlog_info_p);
	int (*vpi_chk_error)(p_vpi_error_info info);
	vpiHandle (*vpi_handle_by_name)(char *name, vpiHandle scope);
} vpi_thunk, *p_vpi_thunk;

/****************************************************************************/
/** \class GhdlRemoteSimPlugin
 *  \brief Implements the remote component of the GHDL simulator integration
 ****************************************************************************/
class GhdlRemoteSimPlugin : public IviRemoteSimPlugin {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * GhdlRemoteSimPlugin()
         */
        /**
         ************************************************************/
        GhdlRemoteSimPlugin(Tcl_Interp *interp);

        /************************************************************
         * ~GhdlRemoteSimPlugin()
         */
        /**
         ************************************************************/
        virtual ~GhdlRemoteSimPlugin();

        /************************************************************
         * BeginRun()
         */
        /**
         ************************************************************/
        virtual int BeginRun(Uint32 runLen);

    /****************************************************************
     * Protected Methods
     ****************************************************************/
    protected:

        /************************************************************
         * ConstructSim()
         */
        /**
         * Constructs an IviSim object for the GHDL simulator
         ************************************************************/
        virtual IviSim *ConstructSim();

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

        /************************************************************
         * TimeCB()
         */
        /**
         ************************************************************/
        static int TimeCB(p_cb_data cb_data) {
            ((GhdlRemoteSimPlugin *)cb_data->user_data)->TimeCB();
            return 0;
        }
        void TimeCB();

        /************************************************************
         * EndOfSimCB()
         ************************************************************/
        static int EndOfSimCB(p_cb_data cb_data) {
            ((GhdlRemoteSimPlugin *)cb_data->user_data)->EndOfSimCB();
            return 0;
        }
        void EndOfSimCB();

        /************************************************************
         * EndOfCompileCB
         ************************************************************/
        static int EndOfCompileCB(p_cb_data cb_data) {
            ((GhdlRemoteSimPlugin *)cb_data->user_data)->EndOfCompileCB();
            return 0;
        }
        void EndOfCompileCB();

        /************************************************************
         * SetupVpiCBs()
         ************************************************************/
        void SetupVpiCBs();

    /****************************************************************    
     * Private Data
     ****************************************************************/
    private:
        GhdlRemoteIviSim             *d_sim;
};
