#****************************************************************************
#*                              IviEntry.tcl
#*
#* Author: Matthew Ballance
#* Desc:   TCL file to create labled frames.
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************

namespace eval Entry {
    namespace export Entry

    variable text ""
}


proc Entry::Entry {path args} {
    variable text

    set   auto_focus 1

    entry $path -selectbackground "#000080"

    while {[llength $args] > 0} {
        set shift 1
        set arg [lindex $args 0]
        if {$arg == "-text"} {
            set shift 2
            set text [lindex $args 1]
        } elseif {$arg == "-width"} {
            set shift 2
            $path config -width [lindex $args 1]
	} elseif {$arg == "-auto_focus"} {
            set auto_focus [lindex $args 1]
            set shift 2
        } else {
            error "unknown option \"$arg\""
        }
        set args [lrange $args $shift end]
    }

    array set $path {_dummy _dummy}
    upvar #0 $path data


    if {$text != ""} {
        $path delete 0 end
        $path insert 0 $text
    }

    if {$auto_focus} {
        bind $path <Enter> "Entry::enter $path"
        bind $path <Leave> [list focus $path ; $path selection clear ]
    }

    rename $path ::$path:cmd
    proc ::$path { cmd args } "return \[eval Entry::cmd $path \$cmd \$args\]"

    return $path
}

proc Entry::enter {path args} {
    upvar #0 $path data

    focus $path
    ::$path:cmd icursor 0
    ::$path:cmd selection clear
    ::$path:cmd selection range 0 end
}

proc Entry::cmd { path cmd args } {
    if {$cmd == "set_text"} {
        ::$path:cmd delete 0 end
        ::$path:cmd insert 0 [lindex $args 0]
    } elseif {$cmd == "get_text"} {
        return [::$path:cmd get]
    } elseif {$cmd == "clear"} {
        ::$path:cmd delete 0 end
    } elseif {$cmd == "configure" || $cmd == "config"} {
        eval ::$path:cmd configure $args
    } else {
        return [eval ::$path:cmd $cmd $args]
    }
}


