/****************************************************************************
 *                            StrAccObj.cc
 *
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "StrAccObj.h"
#include <stdlib.h>
#include <string.h>

/********************************************************************
 * StrAccObj()
 ********************************************************************/
StrAccObj::StrAccObj()
{
    d_store = 0;
    d_idx   = 0;
    d_len   = 0;
}

/********************************************************************
 * operator ()
 ********************************************************************/
void StrAccObj::operator () (const char *string)
{
    d_store = (char *)string;
    d_idx = 0;

    if (d_store) {
        d_len = strlen(string);
    } else {
        d_len = 0;
    }
}

/********************************************************************
 * read_bytes()
 ********************************************************************/
int StrAccObj::read_bytes(Uint8 *buf, Uint32 len)
{
    if (d_idx >= d_len) {
        return -1;
    } else if ((d_idx+len) >= d_len) {
        int ret = d_len-d_idx;
        memcpy(buf, &d_store[d_idx], d_len-d_idx);
        d_idx += ret;
        return ret;
    } else {
        memcpy(buf, &d_store[d_idx], len);
        d_idx += len;
        return len;
    }
}

/********************************************************************
 * eof()
 ********************************************************************/
int StrAccObj::eof()
{
    if (d_idx >= d_len) {
        return 1;
    } else {
        return 0;
    }
}
