/****************************************************************************
 *                           StimulusSeq.h
 *
 * Author: Matthew Ballance
 * Desc:   The StimulusSeq class is the template for sequences of values. 
 *         A StimSeqInst object uses a StimulusSeq to generate a waveform
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_STIMULUS_SEQ_H
#define INCLUDED_STIMULUS_SEQ_H
#include "types.h"
#include "vector.h"
#include "ivi_String.h"

class StimulusItem;
class StimulusMgr;
class StimulusSeq {
    public:
        StimulusSeq(const char *inst_name, StimulusMgr *mgr);

        void Start();

        inline void addItem(StimulusItem *item) { values->append(item); }

        inline StimulusItem *idx(Uint32 x) { return values->idx(x); }
        inline Uint32        length()      { return values->length(); }

        inline StimulusMgr *get_parent() { return parent; }
        inline void set_parent(StimulusMgr *mgr) { parent = mgr; }

        inline void   setInitDelay(Uint32 delay)   { initDelay = delay;   }
        inline Uint32 getInitDelay()   { return initDelay; }

        inline void    setRepeatDelay(Uint32 delay) { repeatDelay = delay; }
        inline Uint32  getRepeatDelay() { return repeatDelay; }

        inline void enableRepeat()      { repeat = 1; numRepeat = 0xFFFFFFFF; }
        inline Uint32 getRepeat() const { return repeat; }

        inline void setNumRepeat(Uint32 num) { numRepeat = num; }
        inline Uint32 getNumRepeat() const { return numRepeat;}
        inline Vector<StimulusItem> *get_values() { return values; }

        inline char *get_instName() { return instName.value(); }
        inline Uint32 getBitWidth() const { return d_bitWidth; }
        void setMaxBitWidth(Uint32 width);

    private:
        /**** Sequence of values or sequences... ****/
        Vector<StimulusItem> *values;
        StimulusMgr          *parent;
        Uint32                repeatDelay;
        Uint32                initDelay;
        Uint32                repeat;
        /**** Number of times to repeat ****/
        Uint32                numRepeat;
        String                instName;

        Uint32                d_bitWidth;
};

#endif /* INCLUDED_STIMULUS_SEQ_H */

