/****************************************************************************
 *                              StimulusMgr.h
 *
 * Author: Matthew Ballance
 * Desc:   Data structures to manage stimulus to the design
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_STIMULUS_MGR_H
#define INCLUDED_STIMULUS_MGR_H
#include "vpi_user.h"
#include "IviSim.h"
#include "vector.h"
#include "BitVector.h"
#include <memory.h>
#include "LogInstance.h"
#include <tcl.h>

class StimulusSeq;
class StimSeqInst;
class LogMgr;
class LogInstance;
class LogInstLevel;
class StimTraceRdr;
class StimulusMgr {
    public:
        StimulusMgr(Tcl_Interp *interp, int, Tcl_Obj *const objv[]);
       ~StimulusMgr();

        void   addSeq(StimulusSeq *seq);
        StimulusSeq *lookupSeq(const char *seq_name);

        void   addSeqInst(StimSeqInst *inst);
        void   delSeqInst(StimSeqInst *inst);

        void   addTraceInst(StimTraceRdr *rdr);
        void   delTraceInst(StimTraceRdr *rdr);

        inline IviSim      *getSim()             { return sim;      }
        inline void         setSim(IviSim *sim)  { this->sim = sim; }

        Tcl_Obj                *SimString;


    private:
        int ParseStimSeq(StimulusSeq *seq, Uint32 objc, Tcl_Obj *const objv[]);
        int StimulusPut(Uint32 objc, Tcl_Obj *const objv[]);
        int putTrace(Uint32 objc, Tcl_Obj *const objv[]);
        int StimulusCreate(Uint32 objc, Tcl_Obj *const objv[]);
        int Get(Uint32 objc, Tcl_Obj *const objv[]);
        int GetDelay(Tcl_Obj *obj, Uint32 *delay);
        int GetRadix(Char *, BitVector::RadixType *);
        static int InstCmd(
                ClientData        clientData,
                Tcl_Interp       *interp,
                int               objc, 
                Tcl_Obj          *const objv[]);
        int Configure(int objc, Tcl_Obj *const objv[]);
        int LookupVpiHndl(DesignDB *ddb, Char *sigSpec, vpiHandle *vpiHndl);

        LogInstance            *log;
        LogInstLevel            log_low;
        LogInstLevel            log_med;
        LogInstLevel            log_high;

        Tcl_HashTable           hashTab;
        Vector<StimulusSeq>     d_seqList;
        Tcl_Command             cmd;
        IviSim                 *sim;
        Vector<StimSeqInst>    *seq_insts;
        Vector<StimTraceRdr>   *trace_insts;
        Tcl_Interp             *interp;
        String                  instName;
};

#endif /* INCLUDED_STIMULUS_MGR_H */

