/****************************************************************************
 *                             PsTextLayout.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a quick-and-dirty text layout for the Postscript
 *         pixmap
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_PS_TEXT_LAYOUT_H
#define INCLUDED_PS_TEXT_LAYOUT_H
#include "types.h"
#include <tk.h>
#include <stdarg.h>

class FileAccObj;
class PsTextLayout {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * PsTextLayout()
         ************************************************************/
        PsTextLayout(
                Tk_Font font, const char *str, Int32 len, Int32 wraplen,
                Tk_Justify justify, Int32 flags, Int32 *width, Int32 *height);

        /************************************************************
         * ~PsTextLayout()
         ************************************************************/
        ~PsTextLayout();

        /************************************************************
         * DrawLayout()
         ************************************************************/
        void DrawLayout(FileAccObj *f, 
                Uint32 x, Uint32 y, Int32 start, Int32 end);

        /************************************************************
         * getHeight()
         ************************************************************/
        inline Int32 getHeight() const { return d_height; }

        /************************************************************
         * getWidth()
         ************************************************************/
        inline Int32 getWidth() const { return d_width; }

        /************************************************************
         * getString()
         ************************************************************/
        inline char *getString() { return d_string; }

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        Tk_TextLayout        d_tkLayout;
        char                *d_string;
        Int32                d_width;
        Int32                d_height;

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:

};


#endif /* INCLUDED_PS_TEXT_LAYOUT_H */
