/****************************************************************************
 *                          IviUintHashTabEntry.h
 *
 * Author: Matthew Ballance
 * Desc: 
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_IVI_UINT_HASH_TAB_ENTRY_H
#define INCLUDED_IVI_UINT_HASH_TAB_ENTRY_H
#include "types.h"
#include "IviUintHashTabLevel.h"

/********************************************************************
 * IviUintHasTabEntryBase
 ********************************************************************/
class IviUintHashTabBase;
class IviUintHashTabEntryBase : public IviUintHashTabLevelBase {

    friend class IviUintHashTabBase;

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * IviUintHashTabEntryBase()
         ************************************************************/ 
        IviUintHashTabEntryBase(Uint32 key) : d_key(key) { ; }

        /************************************************************
         * ~IviUintHashTabEntryBase()
         ************************************************************/
        virtual ~IviUintHashTabEntryBase() { ; }

        /************************************************************
         * getKey()
         ************************************************************/
        Uint32 getKey() { return d_key; }

    /****************************************************************
     * Protected Data
     ****************************************************************/
    protected:
        Uint32                 d_key;
};

/********************************************************************
 * IviUintHashTabEntry
 ********************************************************************/
template <class eType> class IviUintHashTabEntry : 
    public IviUintHashTabEntryBase {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * IviUintHashTabEntry()
         ************************************************************/
        IviUintHashTabEntry(Uint32 key) : 
            IviUintHashTabEntryBase(key), d_value(0) { ; }

        /************************************************************
         * IviUintHashTabEntry()
         ************************************************************/
        IviUintHashTabEntry(Uint32 key, eType &value) : 
            IviUintHashTabEntryBase(key), d_value(value) { ; }

        /************************************************************
         * ~IviUintHashTabEntry()
         ************************************************************/
        virtual ~IviUintHashTabEntry() { ; }

        /************************************************************
         * getValue()
         ************************************************************/
        eType getValue() { return d_value; }

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
            eType                 d_value;
};

#endif /* INCLUDED_IVI_UINT_HASH_TAB_ENTRY_H */
