/****************************************************************************
 *                              DFIOMgr.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a manager for multiple DFIO's and DFIOFilters.
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_DFIO_MGR_H
#define INCLUDED_DFIO_MGR_H
#include "DFIOInfo.h"
#include "DFIOFilter.h"


/**********************************************************
 * DFIOMgr_RegisterDFIO()
 **********************************************************/
int DFIOMgr_RegisterDFIO(DFIOInfo *dfioType);

/**********************************************************
 * DFIOMgr_NewDFIO()
 **********************************************************/
DFIO *DFIOMgr_NewDFIO(const char *dfioTypeName, Tcl_Interp *interp,
        int argc, char **argv);


/**********************************************************
 * DFIOMgr_RegisterDFIOFilter()
 **********************************************************/
Int32 DFIOMgr_RegisterDFIOFilter(
        DFIOFilter     *dfioFilter
        );


#endif /* INCLUDED_DFIO_MGR_H */
