/*****************************************************************************
 *                            CallbackList.cc
 *
 * Author: Matthew Ballance
 * Desc:   A callback list is associated with each instance of a 
 *         callback-type.
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *****************************************************************************/
#include "CallbackList.h"
#include "CallbackType.h"
#include "Callback.h"

/********************************************************************
 * CallbackList
 ********************************************************************/
CallbackList::CallbackList(const char *instName, CallbackType *type) :
        d_instName(instName), d_cbList()
{
    enabled = 1;
}

/********************************************************************
 * AddCb()
 ********************************************************************/
void CallbackList::AddCb(Callback *cb)
{
    d_cbList.append(cb);
    cb->setList(this);
}

/********************************************************************
 * RemoveCb()
 ********************************************************************/
void CallbackList::RemoveCb(Callback *cb)
{
    d_cbList.remove(cb);

    /**** Set the owner of this cb to NULL ****/
    cb->setList(0);
}

/********************************************************************
 * Invoke()
 ********************************************************************/
int CallbackList::Invoke(Uint32 argc, Tcl_Obj *const objv[]) 
{
    Uint32 i;

    if (enabled) {
        for (i=0; i<d_cbList.length(); i++) {
            d_cbList.idx(i)->Invoke(argc, objv);
        }
    }

    return TCL_OK;
}

/************************************************************************
 * Enable()
 ************************************************************************/
void CallbackList::Enable()
{
    enabled = 1;
}

/************************************************************************
 * Disable()
 ************************************************************************/
void CallbackList::Disable()
{
    enabled = 0;
}


