#-------------------------------------------------------------------------------
# Project:     memory controller
# File:        TBmemcon_runtest.do
# Description: IVI script to run simulation
#-------------------------------------------------------------------------------

# create working directories
file mkdir _work
file mkdir _run
cd _run

# build libraries
eval exec ghdl -a --work=unisim         --workdir=../_work ../lib/fb-unisim_VCOMP.vhd
eval exec ghdl -a --work=unisim         --workdir=../_work ../lib/fb-unisim_VITAL.vhd
eval exec ghdl -a --work=common_v1_00_a --workdir=../_work ../lib/hp-pselect.vhd

# import sources to library, make simulator
eval ghdl -i --workdir=../_work [glob ../rtl/*.vhd]
eval ghdl -i --workdir=../_work [glob ../bench/*.vhd]
eval ghdl -m --workdir=../_work -P../_work tbmemcon
file rename -force tbmemcon tbmemcon.ghdl

# load design, setup wave window, run simulation
load_design tbmemcon.ghdl
do ../memcon_ghdl_wave.do
run forever

#-------------------------------------------------------------------------------
# end of file
