-------------------------------------------------------------------------------
-- Filename:        pselect.vhd
--
-- Description:     Parameterizeable peripheral select (address decode).
--                  AValid qualifier comes in on Carry In at bottom 
--                  of carry chain. For version with AValid at top of
--                  carry chain, see pselect_top.vhd.
--                  
-- VHDL-Standard:   VHDL'93
-------------------------------------------------------------------------------
-- Structure:   
--                  pselect.vhd
--

library IEEE;
use IEEE.std_logic_1164.all;
--use IEEE.std_logic_arith.all;
--use IEEE.std_logic_unsigned.all;
use IEEE.numeric_std.all;

--library unisim;
--use unisim.all;

-----------------------------------------------------------------------------
-- Entity section
-----------------------------------------------------------------------------
-------------------------------------------------------------------------------
-- Definition of Generics:
-- C_AB                                 -- number of address bits to decode
--          C_AW                        -- width of address bus
--          C_BAR                       -- base address of peripheral (peripheral select
--                             is asserted when the C_AB most significant
--                             address bits match the C_AB most significant
--                             C_BAR bits
-- Definition of Ports:
--          A                           -- address input
--          AValid                      -- address qualifier
--          PS                          -- peripheral select
-------------------------------------------------------------------------------

entity pselect is

  generic (
    C_AB  : integer := 9;
    C_AW  : integer := 32;
    C_BAR : std_logic_vector
    );
  port (
    A      : in  std_logic_vector(0 to C_AW-1);
    AValid : in  std_logic;
    ps     : out std_logic
    );

end entity pselect;

-----------------------------------------------------------------------------
-- Architecture section
-----------------------------------------------------------------------------

architecture bhv of pselect is
	constant BAR : std_logic_vector(0 to C_BAR'length-1) := C_BAR;
begin

	ps<= AValid when A(0 to C_AB-1) = BAR(0 to C_AB-1) else '0';
		
end bhv;

