/*
  Copyright (c) 2024, Intel Corporation

  SPDX-License-Identifier: BSD-3-Clause
*/

#include "builtins-decl.h"

#define DECL_BUILTIN_NAME(NAME) const char *const NAME = #NAME

namespace ispc {

namespace builtin {

DECL_BUILTIN_NAME(__acos_uniform_double);
DECL_BUILTIN_NAME(__acos_uniform_float);
DECL_BUILTIN_NAME(__acos_uniform_half);
DECL_BUILTIN_NAME(__acos_varying_double);
DECL_BUILTIN_NAME(__acos_varying_float);
DECL_BUILTIN_NAME(__acos_varying_half);
DECL_BUILTIN_NAME(__add_float);
DECL_BUILTIN_NAME(__add_int32);
DECL_BUILTIN_NAME(__add_uniform_double);
DECL_BUILTIN_NAME(__add_uniform_int32);
DECL_BUILTIN_NAME(__add_uniform_int64);
DECL_BUILTIN_NAME(__add_varying_double);
DECL_BUILTIN_NAME(__add_varying_int32);
DECL_BUILTIN_NAME(__add_varying_int64);
DECL_BUILTIN_NAME(__all);
DECL_BUILTIN_NAME(__any);
DECL_BUILTIN_NAME(__aos_to_soa2_double);
DECL_BUILTIN_NAME(__aos_to_soa2_double1);
DECL_BUILTIN_NAME(__aos_to_soa2_double16);
DECL_BUILTIN_NAME(__aos_to_soa2_double32);
DECL_BUILTIN_NAME(__aos_to_soa2_double4);
DECL_BUILTIN_NAME(__aos_to_soa2_double64);
DECL_BUILTIN_NAME(__aos_to_soa2_double8);
DECL_BUILTIN_NAME(__aos_to_soa2_float);
DECL_BUILTIN_NAME(__aos_to_soa2_float1);
DECL_BUILTIN_NAME(__aos_to_soa2_float16);
DECL_BUILTIN_NAME(__aos_to_soa2_float32);
DECL_BUILTIN_NAME(__aos_to_soa2_float4);
DECL_BUILTIN_NAME(__aos_to_soa2_float64);
DECL_BUILTIN_NAME(__aos_to_soa2_float8);
DECL_BUILTIN_NAME(__aos_to_soa3_double);
DECL_BUILTIN_NAME(__aos_to_soa3_double1);
DECL_BUILTIN_NAME(__aos_to_soa3_double16);
DECL_BUILTIN_NAME(__aos_to_soa3_double32);
DECL_BUILTIN_NAME(__aos_to_soa3_double4);
DECL_BUILTIN_NAME(__aos_to_soa3_double64);
DECL_BUILTIN_NAME(__aos_to_soa3_double8);
DECL_BUILTIN_NAME(__aos_to_soa3_float);
DECL_BUILTIN_NAME(__aos_to_soa3_float1);
DECL_BUILTIN_NAME(__aos_to_soa3_float16);
DECL_BUILTIN_NAME(__aos_to_soa3_float32);
DECL_BUILTIN_NAME(__aos_to_soa3_float4);
DECL_BUILTIN_NAME(__aos_to_soa3_float64);
DECL_BUILTIN_NAME(__aos_to_soa3_float8);
DECL_BUILTIN_NAME(__aos_to_soa4_double);
DECL_BUILTIN_NAME(__aos_to_soa4_double1);
DECL_BUILTIN_NAME(__aos_to_soa4_double16);
DECL_BUILTIN_NAME(__aos_to_soa4_double32);
DECL_BUILTIN_NAME(__aos_to_soa4_double4);
DECL_BUILTIN_NAME(__aos_to_soa4_double64);
DECL_BUILTIN_NAME(__aos_to_soa4_double8);
DECL_BUILTIN_NAME(__aos_to_soa4_float);
DECL_BUILTIN_NAME(__aos_to_soa4_float1);
DECL_BUILTIN_NAME(__aos_to_soa4_float16);
DECL_BUILTIN_NAME(__aos_to_soa4_float32);
DECL_BUILTIN_NAME(__aos_to_soa4_float4);
DECL_BUILTIN_NAME(__aos_to_soa4_float64);
DECL_BUILTIN_NAME(__aos_to_soa4_float8);
DECL_BUILTIN_NAME(__asin_uniform_double);
DECL_BUILTIN_NAME(__asin_uniform_float);
DECL_BUILTIN_NAME(__asin_uniform_half);
DECL_BUILTIN_NAME(__asin_varying_double);
DECL_BUILTIN_NAME(__asin_varying_float);
DECL_BUILTIN_NAME(__asin_varying_half);
DECL_BUILTIN_NAME(__atan2_uniform_double);
DECL_BUILTIN_NAME(__atan2_uniform_float);
DECL_BUILTIN_NAME(__atan2_uniform_half);
DECL_BUILTIN_NAME(__atan2_varying_double);
DECL_BUILTIN_NAME(__atan2_varying_float);
DECL_BUILTIN_NAME(__atan2_varying_half);
DECL_BUILTIN_NAME(__atan_uniform_double);
DECL_BUILTIN_NAME(__atan_uniform_float);
DECL_BUILTIN_NAME(__atan_uniform_half);
DECL_BUILTIN_NAME(__atan_varying_double);
DECL_BUILTIN_NAME(__atan_varying_float);
DECL_BUILTIN_NAME(__atan_varying_half);
DECL_BUILTIN_NAME(__atomic_add_int32_global);
DECL_BUILTIN_NAME(__atomic_add_int64_global);
DECL_BUILTIN_NAME(__atomic_add_uniform_int32_global);
DECL_BUILTIN_NAME(__atomic_add_uniform_int64_global);
DECL_BUILTIN_NAME(__atomic_and_int32_global);
DECL_BUILTIN_NAME(__atomic_and_int64_global);
DECL_BUILTIN_NAME(__atomic_and_uniform_int32_global);
DECL_BUILTIN_NAME(__atomic_and_uniform_int64_global);
DECL_BUILTIN_NAME(__atomic_compare_exchange_double_global);
DECL_BUILTIN_NAME(__atomic_compare_exchange_float_global);
DECL_BUILTIN_NAME(__atomic_compare_exchange_int32_global);
DECL_BUILTIN_NAME(__atomic_compare_exchange_int64_global);
DECL_BUILTIN_NAME(__atomic_compare_exchange_uniform_double_global);
DECL_BUILTIN_NAME(__atomic_compare_exchange_uniform_float_global);
DECL_BUILTIN_NAME(__atomic_compare_exchange_uniform_int32_global);
DECL_BUILTIN_NAME(__atomic_compare_exchange_uniform_int64_global);
DECL_BUILTIN_NAME(__atomic_max_uniform_int32_global);
DECL_BUILTIN_NAME(__atomic_max_uniform_int64_global);
DECL_BUILTIN_NAME(__atomic_min_uniform_int32_global);
DECL_BUILTIN_NAME(__atomic_min_uniform_int64_global);
DECL_BUILTIN_NAME(__atomic_or_int32_global);
DECL_BUILTIN_NAME(__atomic_or_int64_global);
DECL_BUILTIN_NAME(__atomic_or_uniform_int32_global);
DECL_BUILTIN_NAME(__atomic_or_uniform_int64_global);
DECL_BUILTIN_NAME(__atomic_sub_int32_global);
DECL_BUILTIN_NAME(__atomic_sub_int64_global);
DECL_BUILTIN_NAME(__atomic_sub_uniform_int32_global);
DECL_BUILTIN_NAME(__atomic_sub_uniform_int64_global);
DECL_BUILTIN_NAME(__atomic_swap_double_global);
DECL_BUILTIN_NAME(__atomic_swap_float_global);
DECL_BUILTIN_NAME(__atomic_swap_int32_global);
DECL_BUILTIN_NAME(__atomic_swap_int64_global);
DECL_BUILTIN_NAME(__atomic_swap_uniform_double_global);
DECL_BUILTIN_NAME(__atomic_swap_uniform_float_global);
DECL_BUILTIN_NAME(__atomic_swap_uniform_int32_global);
DECL_BUILTIN_NAME(__atomic_swap_uniform_int64_global);
DECL_BUILTIN_NAME(__atomic_umax_uniform_uint32_global);
DECL_BUILTIN_NAME(__atomic_umax_uniform_uint64_global);
DECL_BUILTIN_NAME(__atomic_umin_uniform_uint32_global);
DECL_BUILTIN_NAME(__atomic_umin_uniform_uint64_global);
DECL_BUILTIN_NAME(__atomic_xor_int32_global);
DECL_BUILTIN_NAME(__atomic_xor_int64_global);
DECL_BUILTIN_NAME(__atomic_xor_uniform_int32_global);
DECL_BUILTIN_NAME(__atomic_xor_uniform_int64_global);
DECL_BUILTIN_NAME(__avg_down_int16);
DECL_BUILTIN_NAME(__avg_down_int8);
DECL_BUILTIN_NAME(__avg_down_uint16);
DECL_BUILTIN_NAME(__avg_down_uint8);
DECL_BUILTIN_NAME(__avg_up_int16);
DECL_BUILTIN_NAME(__avg_up_int8);
DECL_BUILTIN_NAME(__avg_up_uint16);
DECL_BUILTIN_NAME(__avg_up_uint8);
DECL_BUILTIN_NAME(__broadcast_double);
DECL_BUILTIN_NAME(__broadcast_float);
DECL_BUILTIN_NAME(__broadcast_half);
DECL_BUILTIN_NAME(__broadcast_i16);
DECL_BUILTIN_NAME(__broadcast_i32);
DECL_BUILTIN_NAME(__broadcast_i64);
DECL_BUILTIN_NAME(__broadcast_i8);
DECL_BUILTIN_NAME(__cast_mask_to_i1);
DECL_BUILTIN_NAME(__cast_mask_to_i16);
DECL_BUILTIN_NAME(__cast_mask_to_i32);
DECL_BUILTIN_NAME(__cast_mask_to_i64);
DECL_BUILTIN_NAME(__cast_mask_to_i8);
DECL_BUILTIN_NAME(__ceil_uniform_double);
DECL_BUILTIN_NAME(__ceil_uniform_float);
DECL_BUILTIN_NAME(__ceil_uniform_half);
DECL_BUILTIN_NAME(__ceil_varying_double);
DECL_BUILTIN_NAME(__ceil_varying_float);
DECL_BUILTIN_NAME(__ceil_varying_half);
DECL_BUILTIN_NAME(__clock);
DECL_BUILTIN_NAME(__cos_uniform_double);
DECL_BUILTIN_NAME(__cos_uniform_float);
DECL_BUILTIN_NAME(__cos_uniform_half);
DECL_BUILTIN_NAME(__cos_varying_double);
DECL_BUILTIN_NAME(__cos_varying_float);
DECL_BUILTIN_NAME(__cos_varying_half);
DECL_BUILTIN_NAME(__count_leading_zeros_i32);
DECL_BUILTIN_NAME(__count_leading_zeros_i64);
DECL_BUILTIN_NAME(__count_trailing_zeros_i32);
DECL_BUILTIN_NAME(__count_trailing_zeros_i64);
DECL_BUILTIN_NAME(__delete_uniform_32rt);
DECL_BUILTIN_NAME(__delete_uniform_64rt);
DECL_BUILTIN_NAME(__delete_varying_32rt);
DECL_BUILTIN_NAME(__delete_varying_64rt);
DECL_BUILTIN_NAME(__do_assert_uniform);
DECL_BUILTIN_NAME(__do_assert_varying);
DECL_BUILTIN_NAME(__do_assume_uniform);
DECL_BUILTIN_NAME(__dot2add_i16packed);
DECL_BUILTIN_NAME(__dot2add_i16packed_sat);
DECL_BUILTIN_NAME(__do_print);
DECL_BUILTIN_NAME(__dot4add_u8i8packed);
DECL_BUILTIN_NAME(__dot4add_u8i8packed_sat);
DECL_BUILTIN_NAME(__doublebits_uniform_int64);
DECL_BUILTIN_NAME(__doublebits_varying_int64);
DECL_BUILTIN_NAME(__exclusive_scan_add_double);
DECL_BUILTIN_NAME(__exclusive_scan_add_float);
DECL_BUILTIN_NAME(__exclusive_scan_add_half);
DECL_BUILTIN_NAME(__exclusive_scan_add_i32);
DECL_BUILTIN_NAME(__exclusive_scan_add_i64);
DECL_BUILTIN_NAME(__exclusive_scan_and_i32);
DECL_BUILTIN_NAME(__exclusive_scan_and_i64);
DECL_BUILTIN_NAME(__exclusive_scan_or_i32);
DECL_BUILTIN_NAME(__exclusive_scan_or_i64);
DECL_BUILTIN_NAME(__exp_uniform_double);
DECL_BUILTIN_NAME(__exp_uniform_float);
DECL_BUILTIN_NAME(__exp_uniform_half);
DECL_BUILTIN_NAME(__exp_varying_double);
DECL_BUILTIN_NAME(__exp_varying_float);
DECL_BUILTIN_NAME(__exp_varying_half);
DECL_BUILTIN_NAME(__extract_bool);
DECL_BUILTIN_NAME(__extract_int16);
DECL_BUILTIN_NAME(__extract_int32);
DECL_BUILTIN_NAME(__extract_int64);
DECL_BUILTIN_NAME(__extract_int8);
DECL_BUILTIN_NAME(__extract_mask_hi);
DECL_BUILTIN_NAME(__extract_mask_low);
DECL_BUILTIN_NAME(__fast_masked_vload);
DECL_BUILTIN_NAME(__fastmath);
DECL_BUILTIN_NAME(__floatbits_uniform_int32);
DECL_BUILTIN_NAME(__floatbits_varying_int32);
DECL_BUILTIN_NAME(__float_to_half_uniform);
DECL_BUILTIN_NAME(__float_to_half_varying);
DECL_BUILTIN_NAME(__floor_uniform_double);
DECL_BUILTIN_NAME(__floor_uniform_float);
DECL_BUILTIN_NAME(__floor_uniform_half);
DECL_BUILTIN_NAME(__floor_varying_double);
DECL_BUILTIN_NAME(__floor_varying_float);
DECL_BUILTIN_NAME(__floor_varying_half);
DECL_BUILTIN_NAME(__gather32_double);
DECL_BUILTIN_NAME(__gather32_float);
DECL_BUILTIN_NAME(__gather32_generic_double);
DECL_BUILTIN_NAME(__gather32_generic_float);
DECL_BUILTIN_NAME(__gather32_generic_half);
DECL_BUILTIN_NAME(__gather32_generic_i16);
DECL_BUILTIN_NAME(__gather32_generic_i32);
DECL_BUILTIN_NAME(__gather32_generic_i64);
DECL_BUILTIN_NAME(__gather32_generic_i8);
DECL_BUILTIN_NAME(__gather32_half);
DECL_BUILTIN_NAME(__gather32_i16);
DECL_BUILTIN_NAME(__gather32_i32);
DECL_BUILTIN_NAME(__gather32_i64);
DECL_BUILTIN_NAME(__gather32_i8);
DECL_BUILTIN_NAME(__gather64_double);
DECL_BUILTIN_NAME(__gather64_float);
DECL_BUILTIN_NAME(__gather64_generic_double);
DECL_BUILTIN_NAME(__gather64_generic_float);
DECL_BUILTIN_NAME(__gather64_generic_half);
DECL_BUILTIN_NAME(__gather64_generic_i16);
DECL_BUILTIN_NAME(__gather64_generic_i32);
DECL_BUILTIN_NAME(__gather64_generic_i64);
DECL_BUILTIN_NAME(__gather64_generic_i8);
DECL_BUILTIN_NAME(__gather64_half);
DECL_BUILTIN_NAME(__gather64_i16);
DECL_BUILTIN_NAME(__gather64_i32);
DECL_BUILTIN_NAME(__gather64_i64);
DECL_BUILTIN_NAME(__gather64_i8);
DECL_BUILTIN_NAME(__gather_base_offsets32_double);
DECL_BUILTIN_NAME(__gather_base_offsets32_float);
DECL_BUILTIN_NAME(__gather_base_offsets32_half);
DECL_BUILTIN_NAME(__gather_base_offsets32_i16);
DECL_BUILTIN_NAME(__gather_base_offsets32_i32);
DECL_BUILTIN_NAME(__gather_base_offsets32_i64);
DECL_BUILTIN_NAME(__gather_base_offsets32_i8);
DECL_BUILTIN_NAME(__gather_base_offsets64_double);
DECL_BUILTIN_NAME(__gather_base_offsets64_float);
DECL_BUILTIN_NAME(__gather_base_offsets64_half);
DECL_BUILTIN_NAME(__gather_base_offsets64_i16);
DECL_BUILTIN_NAME(__gather_base_offsets64_i32);
DECL_BUILTIN_NAME(__gather_base_offsets64_i64);
DECL_BUILTIN_NAME(__gather_base_offsets64_i8);
DECL_BUILTIN_NAME(__gather_elt32_double);
DECL_BUILTIN_NAME(__gather_elt32_float);
DECL_BUILTIN_NAME(__gather_elt32_half);
DECL_BUILTIN_NAME(__gather_elt32_i16);
DECL_BUILTIN_NAME(__gather_elt32_i32);
DECL_BUILTIN_NAME(__gather_elt32_i64);
DECL_BUILTIN_NAME(__gather_elt32_i8);
DECL_BUILTIN_NAME(__gather_elt64_double);
DECL_BUILTIN_NAME(__gather_elt64_float);
DECL_BUILTIN_NAME(__gather_elt64_half);
DECL_BUILTIN_NAME(__gather_elt64_i16);
DECL_BUILTIN_NAME(__gather_elt64_i32);
DECL_BUILTIN_NAME(__gather_elt64_i64);
DECL_BUILTIN_NAME(__gather_elt64_i8);
DECL_BUILTIN_NAME(__gather_factored_base_offsets32_double);
DECL_BUILTIN_NAME(__gather_factored_base_offsets32_float);
DECL_BUILTIN_NAME(__gather_factored_base_offsets32_half);
DECL_BUILTIN_NAME(__gather_factored_base_offsets32_i16);
DECL_BUILTIN_NAME(__gather_factored_base_offsets32_i32);
DECL_BUILTIN_NAME(__gather_factored_base_offsets32_i64);
DECL_BUILTIN_NAME(__gather_factored_base_offsets32_i8);
DECL_BUILTIN_NAME(__gather_factored_base_offsets64_double);
DECL_BUILTIN_NAME(__gather_factored_base_offsets64_float);
DECL_BUILTIN_NAME(__gather_factored_base_offsets64_half);
DECL_BUILTIN_NAME(__gather_factored_base_offsets64_i16);
DECL_BUILTIN_NAME(__gather_factored_base_offsets64_i32);
DECL_BUILTIN_NAME(__gather_factored_base_offsets64_i64);
DECL_BUILTIN_NAME(__gather_factored_base_offsets64_i8);
DECL_BUILTIN_NAME(__get_system_isa);
DECL_BUILTIN_NAME(__halfbits_uniform_int16);
DECL_BUILTIN_NAME(__halfbits_varying_int16);
DECL_BUILTIN_NAME(__half_to_float_uniform);
DECL_BUILTIN_NAME(__half_to_float_varying);
DECL_BUILTIN_NAME(__idiv_int16);
DECL_BUILTIN_NAME(__idiv_int32);
DECL_BUILTIN_NAME(__idiv_int8);
DECL_BUILTIN_NAME(__idiv_uint16);
DECL_BUILTIN_NAME(__idiv_uint32);
DECL_BUILTIN_NAME(__idiv_uint8);
DECL_BUILTIN_NAME(__insert_bool);
DECL_BUILTIN_NAME(__insert_int16);
DECL_BUILTIN_NAME(__insert_int32);
DECL_BUILTIN_NAME(__insert_int64);
DECL_BUILTIN_NAME(__insert_int8);
DECL_BUILTIN_NAME(__intbits_uniform_double);
DECL_BUILTIN_NAME(__intbits_uniform_float);
DECL_BUILTIN_NAME(__intbits_uniform_half);
DECL_BUILTIN_NAME(__intbits_varying_double);
DECL_BUILTIN_NAME(__intbits_varying_float);
DECL_BUILTIN_NAME(__intbits_varying_half);
DECL_BUILTIN_NAME(__is_compile_time_constant_mask);
DECL_BUILTIN_NAME(__is_compile_time_constant_uniform_int32);
DECL_BUILTIN_NAME(__is_compile_time_constant_varying_int32);
DECL_BUILTIN_NAME(ISPCAlloc);
DECL_BUILTIN_NAME(ISPCLaunch);
DECL_BUILTIN_NAME(ISPCSync);
DECL_BUILTIN_NAME(__keep_funcs_live);
DECL_BUILTIN_NAME(__log_uniform_double);
DECL_BUILTIN_NAME(__log_uniform_float);
DECL_BUILTIN_NAME(__log_uniform_half);
DECL_BUILTIN_NAME(__log_varying_double);
DECL_BUILTIN_NAME(__log_varying_float);
DECL_BUILTIN_NAME(__log_varying_half);
DECL_BUILTIN_NAME(__masked_load_blend_double);
DECL_BUILTIN_NAME(__masked_load_blend_float);
DECL_BUILTIN_NAME(__masked_load_blend_half);
DECL_BUILTIN_NAME(__masked_load_blend_i16);
DECL_BUILTIN_NAME(__masked_load_blend_i32);
DECL_BUILTIN_NAME(__masked_load_blend_i64);
DECL_BUILTIN_NAME(__masked_load_blend_i8);
DECL_BUILTIN_NAME(__masked_load_double);
DECL_BUILTIN_NAME(__masked_load_float);
DECL_BUILTIN_NAME(__masked_load_half);
DECL_BUILTIN_NAME(__masked_load_i16);
DECL_BUILTIN_NAME(__masked_load_i32);
DECL_BUILTIN_NAME(__masked_load_i64);
DECL_BUILTIN_NAME(__masked_load_i8);
DECL_BUILTIN_NAME(__masked_store_blend_double);
DECL_BUILTIN_NAME(__masked_store_blend_float);
DECL_BUILTIN_NAME(__masked_store_blend_half);
DECL_BUILTIN_NAME(__masked_store_blend_i16);
DECL_BUILTIN_NAME(__masked_store_blend_i32);
DECL_BUILTIN_NAME(__masked_store_blend_i64);
DECL_BUILTIN_NAME(__masked_store_blend_i8);
DECL_BUILTIN_NAME(__masked_store_double);
DECL_BUILTIN_NAME(__masked_store_float);
DECL_BUILTIN_NAME(__masked_store_half);
DECL_BUILTIN_NAME(__masked_store_i16);
DECL_BUILTIN_NAME(__masked_store_i32);
DECL_BUILTIN_NAME(__masked_store_i64);
DECL_BUILTIN_NAME(__masked_store_i8);
DECL_BUILTIN_NAME(__max_uniform_double);
DECL_BUILTIN_NAME(__max_uniform_float);
DECL_BUILTIN_NAME(__max_uniform_half);
DECL_BUILTIN_NAME(__max_uniform_int32);
DECL_BUILTIN_NAME(__max_uniform_int64);
DECL_BUILTIN_NAME(__max_uniform_uint32);
DECL_BUILTIN_NAME(__max_uniform_uint64);
DECL_BUILTIN_NAME(__max_varying_double);
DECL_BUILTIN_NAME(__max_varying_float);
DECL_BUILTIN_NAME(__max_varying_half);
DECL_BUILTIN_NAME(__max_varying_int32);
DECL_BUILTIN_NAME(__max_varying_int64);
DECL_BUILTIN_NAME(__max_varying_uint32);
DECL_BUILTIN_NAME(__max_varying_uint64);
DECL_BUILTIN_NAME(__memcpy32);
DECL_BUILTIN_NAME(__memcpy64);
DECL_BUILTIN_NAME(__memmove32);
DECL_BUILTIN_NAME(__memmove64);
DECL_BUILTIN_NAME(__memory_barrier);
DECL_BUILTIN_NAME(__memset32);
DECL_BUILTIN_NAME(__memset64);
DECL_BUILTIN_NAME(__min_uniform_double);
DECL_BUILTIN_NAME(__min_uniform_float);
DECL_BUILTIN_NAME(__min_uniform_half);
DECL_BUILTIN_NAME(__min_uniform_int32);
DECL_BUILTIN_NAME(__min_uniform_int64);
DECL_BUILTIN_NAME(__min_uniform_uint32);
DECL_BUILTIN_NAME(__min_uniform_uint64);
DECL_BUILTIN_NAME(__min_varying_double);
DECL_BUILTIN_NAME(__min_varying_float);
DECL_BUILTIN_NAME(__min_varying_half);
DECL_BUILTIN_NAME(__min_varying_int32);
DECL_BUILTIN_NAME(__min_varying_int64);
DECL_BUILTIN_NAME(__min_varying_uint32);
DECL_BUILTIN_NAME(__min_varying_uint64);
DECL_BUILTIN_NAME(__movmsk);
DECL_BUILTIN_NAME(__new_uniform_32rt);
DECL_BUILTIN_NAME(__new_uniform_64rt);
DECL_BUILTIN_NAME(__new_varying32_32rt);
DECL_BUILTIN_NAME(__new_varying32_64rt);
DECL_BUILTIN_NAME(__new_varying64_64rt);
DECL_BUILTIN_NAME(__none);
DECL_BUILTIN_NAME(__num_cores);
DECL_BUILTIN_NAME(__packed_load_activei32);
DECL_BUILTIN_NAME(__packed_load_activei64);
DECL_BUILTIN_NAME(__packed_store_active2i32);
DECL_BUILTIN_NAME(__packed_store_active2i64);
DECL_BUILTIN_NAME(__packed_store_activei32);
DECL_BUILTIN_NAME(__packed_store_activei64);
DECL_BUILTIN_NAME(__padds_ui16);
DECL_BUILTIN_NAME(__padds_ui32);
DECL_BUILTIN_NAME(__padds_ui64);
DECL_BUILTIN_NAME(__padds_ui8);
DECL_BUILTIN_NAME(__padds_vi16);
DECL_BUILTIN_NAME(__padds_vi32);
DECL_BUILTIN_NAME(__padds_vi64);
DECL_BUILTIN_NAME(__padds_vi8);
DECL_BUILTIN_NAME(__paddus_ui16);
DECL_BUILTIN_NAME(__paddus_ui32);
DECL_BUILTIN_NAME(__paddus_ui64);
DECL_BUILTIN_NAME(__paddus_ui8);
DECL_BUILTIN_NAME(__paddus_vi16);
DECL_BUILTIN_NAME(__paddus_vi32);
DECL_BUILTIN_NAME(__paddus_vi64);
DECL_BUILTIN_NAME(__paddus_vi8);
DECL_BUILTIN_NAME(__pmuls_ui16);
DECL_BUILTIN_NAME(__pmuls_ui32);
DECL_BUILTIN_NAME(__pmuls_ui8);
DECL_BUILTIN_NAME(__pmuls_vi16);
DECL_BUILTIN_NAME(__pmuls_vi32);
DECL_BUILTIN_NAME(__pmuls_vi8);
DECL_BUILTIN_NAME(__pmulus_ui16);
DECL_BUILTIN_NAME(__pmulus_ui32);
DECL_BUILTIN_NAME(__pmulus_ui8);
DECL_BUILTIN_NAME(__pmulus_vi16);
DECL_BUILTIN_NAME(__pmulus_vi32);
DECL_BUILTIN_NAME(__pmulus_vi8);
DECL_BUILTIN_NAME(__popcnt_int32);
DECL_BUILTIN_NAME(__popcnt_int64);
DECL_BUILTIN_NAME(__pow_uniform_double);
DECL_BUILTIN_NAME(__pow_uniform_float);
DECL_BUILTIN_NAME(__pow_uniform_half);
DECL_BUILTIN_NAME(__pow_varying_double);
DECL_BUILTIN_NAME(__pow_varying_float);
DECL_BUILTIN_NAME(__pow_varying_half);
DECL_BUILTIN_NAME(__prefetch_read_sized_uniform_1);
DECL_BUILTIN_NAME(__prefetch_read_sized_uniform_2);
DECL_BUILTIN_NAME(__prefetch_read_sized_uniform_3);
DECL_BUILTIN_NAME(__prefetch_read_sized_uniform_nt);
DECL_BUILTIN_NAME(__prefetch_read_sized_varying_1);
DECL_BUILTIN_NAME(__prefetch_read_sized_varying_2);
DECL_BUILTIN_NAME(__prefetch_read_sized_varying_3);
DECL_BUILTIN_NAME(__prefetch_read_sized_varying_nt);
DECL_BUILTIN_NAME(__prefetch_read_uniform_1);
DECL_BUILTIN_NAME(__prefetch_read_uniform_2);
DECL_BUILTIN_NAME(__prefetch_read_uniform_3);
DECL_BUILTIN_NAME(__prefetch_read_uniform_nt);
DECL_BUILTIN_NAME(__prefetch_read_varying_1);
DECL_BUILTIN_NAME(__prefetch_read_varying_1_native);
DECL_BUILTIN_NAME(__prefetch_read_varying_2);
DECL_BUILTIN_NAME(__prefetch_read_varying_2_native);
DECL_BUILTIN_NAME(__prefetch_read_varying_3);
DECL_BUILTIN_NAME(__prefetch_read_varying_3_native);
DECL_BUILTIN_NAME(__prefetch_read_varying_nt);
DECL_BUILTIN_NAME(__prefetch_read_varying_nt_native);
DECL_BUILTIN_NAME(__prefetch_write_uniform_1);
DECL_BUILTIN_NAME(__prefetch_write_uniform_2);
DECL_BUILTIN_NAME(__prefetch_write_uniform_3);
DECL_BUILTIN_NAME(__prefetch_write_varying_1);
DECL_BUILTIN_NAME(__prefetch_write_varying_1_native);
DECL_BUILTIN_NAME(__prefetch_write_varying_2);
DECL_BUILTIN_NAME(__prefetch_write_varying_2_native);
DECL_BUILTIN_NAME(__prefetch_write_varying_3);
DECL_BUILTIN_NAME(__prefetch_write_varying_3_native);
DECL_BUILTIN_NAME(__pseudo_gather32_double);
DECL_BUILTIN_NAME(__pseudo_gather32_float);
DECL_BUILTIN_NAME(__pseudo_gather32_half);
DECL_BUILTIN_NAME(__pseudo_gather32_i16);
DECL_BUILTIN_NAME(__pseudo_gather32_i32);
DECL_BUILTIN_NAME(__pseudo_gather32_i64);
DECL_BUILTIN_NAME(__pseudo_gather32_i8);
DECL_BUILTIN_NAME(__pseudo_gather64_double);
DECL_BUILTIN_NAME(__pseudo_gather64_float);
DECL_BUILTIN_NAME(__pseudo_gather64_half);
DECL_BUILTIN_NAME(__pseudo_gather64_i16);
DECL_BUILTIN_NAME(__pseudo_gather64_i32);
DECL_BUILTIN_NAME(__pseudo_gather64_i64);
DECL_BUILTIN_NAME(__pseudo_gather64_i8);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets32_double);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets32_float);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets32_half);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets32_i16);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets32_i32);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets32_i64);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets32_i8);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets64_double);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets64_float);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets64_half);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets64_i16);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets64_i32);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets64_i64);
DECL_BUILTIN_NAME(__pseudo_gather_base_offsets64_i8);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets32_double);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets32_float);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets32_half);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets32_i16);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets32_i32);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets32_i64);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets32_i8);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets64_double);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets64_float);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets64_half);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets64_i16);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets64_i32);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets64_i64);
DECL_BUILTIN_NAME(__pseudo_gather_factored_base_offsets64_i8);
DECL_BUILTIN_NAME(__pseudo_masked_store_double);
DECL_BUILTIN_NAME(__pseudo_masked_store_float);
DECL_BUILTIN_NAME(__pseudo_masked_store_half);
DECL_BUILTIN_NAME(__pseudo_masked_store_i16);
DECL_BUILTIN_NAME(__pseudo_masked_store_i32);
DECL_BUILTIN_NAME(__pseudo_masked_store_i64);
DECL_BUILTIN_NAME(__pseudo_masked_store_i8);
DECL_BUILTIN_NAME(__pseudo_prefetch_read_varying_1);
DECL_BUILTIN_NAME(__pseudo_prefetch_read_varying_1_native);
DECL_BUILTIN_NAME(__pseudo_prefetch_read_varying_2);
DECL_BUILTIN_NAME(__pseudo_prefetch_read_varying_2_native);
DECL_BUILTIN_NAME(__pseudo_prefetch_read_varying_3);
DECL_BUILTIN_NAME(__pseudo_prefetch_read_varying_3_native);
DECL_BUILTIN_NAME(__pseudo_prefetch_read_varying_nt);
DECL_BUILTIN_NAME(__pseudo_prefetch_read_varying_nt_native);
DECL_BUILTIN_NAME(__pseudo_prefetch_write_varying_1);
DECL_BUILTIN_NAME(__pseudo_prefetch_write_varying_1_native);
DECL_BUILTIN_NAME(__pseudo_prefetch_write_varying_2);
DECL_BUILTIN_NAME(__pseudo_prefetch_write_varying_2_native);
DECL_BUILTIN_NAME(__pseudo_prefetch_write_varying_3);
DECL_BUILTIN_NAME(__pseudo_prefetch_write_varying_3_native);
DECL_BUILTIN_NAME(__pseudo_scatter32_double);
DECL_BUILTIN_NAME(__pseudo_scatter32_float);
DECL_BUILTIN_NAME(__pseudo_scatter32_half);
DECL_BUILTIN_NAME(__pseudo_scatter32_i16);
DECL_BUILTIN_NAME(__pseudo_scatter32_i32);
DECL_BUILTIN_NAME(__pseudo_scatter32_i64);
DECL_BUILTIN_NAME(__pseudo_scatter32_i8);
DECL_BUILTIN_NAME(__pseudo_scatter64_double);
DECL_BUILTIN_NAME(__pseudo_scatter64_float);
DECL_BUILTIN_NAME(__pseudo_scatter64_half);
DECL_BUILTIN_NAME(__pseudo_scatter64_i16);
DECL_BUILTIN_NAME(__pseudo_scatter64_i32);
DECL_BUILTIN_NAME(__pseudo_scatter64_i64);
DECL_BUILTIN_NAME(__pseudo_scatter64_i8);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets32_double);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets32_float);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets32_half);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets32_i16);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets32_i32);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets32_i64);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets32_i8);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets64_double);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets64_float);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets64_half);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets64_i16);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets64_i32);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets64_i64);
DECL_BUILTIN_NAME(__pseudo_scatter_base_offsets64_i8);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets32_double);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets32_float);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets32_half);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets32_i16);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets32_i32);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets32_i64);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets32_i8);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets64_double);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets64_float);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets64_half);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets64_i16);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets64_i32);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets64_i64);
DECL_BUILTIN_NAME(__pseudo_scatter_factored_base_offsets64_i8);
DECL_BUILTIN_NAME(__psubs_ui16);
DECL_BUILTIN_NAME(__psubs_ui32);
DECL_BUILTIN_NAME(__psubs_ui64);
DECL_BUILTIN_NAME(__psubs_ui8);
DECL_BUILTIN_NAME(__psubs_vi16);
DECL_BUILTIN_NAME(__psubs_vi32);
DECL_BUILTIN_NAME(__psubs_vi64);
DECL_BUILTIN_NAME(__psubs_vi8);
DECL_BUILTIN_NAME(__psubus_ui16);
DECL_BUILTIN_NAME(__psubus_ui32);
DECL_BUILTIN_NAME(__psubus_ui64);
DECL_BUILTIN_NAME(__psubus_ui8);
DECL_BUILTIN_NAME(__psubus_vi16);
DECL_BUILTIN_NAME(__psubus_vi32);
DECL_BUILTIN_NAME(__psubus_vi64);
DECL_BUILTIN_NAME(__psubus_vi8);
DECL_BUILTIN_NAME(__rcp_fast_uniform_double);
DECL_BUILTIN_NAME(__rcp_fast_uniform_float);
DECL_BUILTIN_NAME(__rcp_fast_uniform_half);
DECL_BUILTIN_NAME(__rcp_fast_varying_double);
DECL_BUILTIN_NAME(__rcp_fast_varying_float);
DECL_BUILTIN_NAME(__rcp_fast_varying_half);
DECL_BUILTIN_NAME(__rcp_uniform_double);
DECL_BUILTIN_NAME(__rcp_uniform_float);
DECL_BUILTIN_NAME(__rcp_uniform_half);
DECL_BUILTIN_NAME(__rcp_varying_double);
DECL_BUILTIN_NAME(__rcp_varying_float);
DECL_BUILTIN_NAME(__rcp_varying_half);
DECL_BUILTIN_NAME(__rdrand_i16);
DECL_BUILTIN_NAME(__rdrand_i32);
DECL_BUILTIN_NAME(__rdrand_i64);
DECL_BUILTIN_NAME(__reduce_add_double);
DECL_BUILTIN_NAME(__reduce_add_float);
DECL_BUILTIN_NAME(__reduce_add_half);
DECL_BUILTIN_NAME(__reduce_add_int16);
DECL_BUILTIN_NAME(__reduce_add_int32);
DECL_BUILTIN_NAME(__reduce_add_int64);
DECL_BUILTIN_NAME(__reduce_add_int8);
DECL_BUILTIN_NAME(__reduce_equal_double);
DECL_BUILTIN_NAME(__reduce_equal_float);
DECL_BUILTIN_NAME(__reduce_equal_half);
DECL_BUILTIN_NAME(__reduce_equal_int32);
DECL_BUILTIN_NAME(__reduce_equal_int64);
DECL_BUILTIN_NAME(__reduce_max_double);
DECL_BUILTIN_NAME(__reduce_max_float);
DECL_BUILTIN_NAME(__reduce_max_half);
DECL_BUILTIN_NAME(__reduce_max_int32);
DECL_BUILTIN_NAME(__reduce_max_int64);
DECL_BUILTIN_NAME(__reduce_max_uint32);
DECL_BUILTIN_NAME(__reduce_max_uint64);
DECL_BUILTIN_NAME(__reduce_min_double);
DECL_BUILTIN_NAME(__reduce_min_float);
DECL_BUILTIN_NAME(__reduce_min_half);
DECL_BUILTIN_NAME(__reduce_min_int32);
DECL_BUILTIN_NAME(__reduce_min_int64);
DECL_BUILTIN_NAME(__reduce_min_uint32);
DECL_BUILTIN_NAME(__reduce_min_uint64);
DECL_BUILTIN_NAME(__restore_ftz_daz_flags);
DECL_BUILTIN_NAME(__rotate_double);
DECL_BUILTIN_NAME(__rotate_float);
DECL_BUILTIN_NAME(__rotate_half);
DECL_BUILTIN_NAME(__rotate_i16);
DECL_BUILTIN_NAME(__rotate_i32);
DECL_BUILTIN_NAME(__rotate_i64);
DECL_BUILTIN_NAME(__rotate_i8);
DECL_BUILTIN_NAME(__round_uniform_double);
DECL_BUILTIN_NAME(__round_uniform_float);
DECL_BUILTIN_NAME(__round_uniform_half);
DECL_BUILTIN_NAME(__round_varying_double);
DECL_BUILTIN_NAME(__round_varying_float);
DECL_BUILTIN_NAME(__round_varying_half);
DECL_BUILTIN_NAME(__rsqrt_fast_uniform_double);
DECL_BUILTIN_NAME(__rsqrt_fast_uniform_float);
DECL_BUILTIN_NAME(__rsqrt_fast_varying_double);
DECL_BUILTIN_NAME(__rsqrt_fast_varying_float);
DECL_BUILTIN_NAME(__rsqrt_uniform_double);
DECL_BUILTIN_NAME(__rsqrt_uniform_float);
DECL_BUILTIN_NAME(__rsqrt_uniform_half);
DECL_BUILTIN_NAME(__rsqrt_varying_double);
DECL_BUILTIN_NAME(__rsqrt_varying_float);
DECL_BUILTIN_NAME(__rsqrt_varying_half);
DECL_BUILTIN_NAME(__saturating_add_i16);
DECL_BUILTIN_NAME(__saturating_add_i32);
DECL_BUILTIN_NAME(__saturating_add_i64);
DECL_BUILTIN_NAME(__saturating_add_i8);
DECL_BUILTIN_NAME(__saturating_add_ui16);
DECL_BUILTIN_NAME(__saturating_add_ui32);
DECL_BUILTIN_NAME(__saturating_add_ui64);
DECL_BUILTIN_NAME(__saturating_add_ui8);
DECL_BUILTIN_NAME(__saturating_mul_i16);
DECL_BUILTIN_NAME(__saturating_mul_i32);
DECL_BUILTIN_NAME(__saturating_mul_i8);
DECL_BUILTIN_NAME(__saturating_mul_ui16);
DECL_BUILTIN_NAME(__saturating_mul_ui32);
DECL_BUILTIN_NAME(__saturating_mul_ui8);
DECL_BUILTIN_NAME(__scatter32_double);
DECL_BUILTIN_NAME(__scatter32_float);
DECL_BUILTIN_NAME(__scatter32_generic_double);
DECL_BUILTIN_NAME(__scatter32_generic_float);
DECL_BUILTIN_NAME(__scatter32_generic_half);
DECL_BUILTIN_NAME(__scatter32_generic_i16);
DECL_BUILTIN_NAME(__scatter32_generic_i32);
DECL_BUILTIN_NAME(__scatter32_generic_i64);
DECL_BUILTIN_NAME(__scatter32_generic_i8);
DECL_BUILTIN_NAME(__scatter32_half);
DECL_BUILTIN_NAME(__scatter32_i16);
DECL_BUILTIN_NAME(__scatter32_i32);
DECL_BUILTIN_NAME(__scatter32_i64);
DECL_BUILTIN_NAME(__scatter32_i8);
DECL_BUILTIN_NAME(__scatter64_double);
DECL_BUILTIN_NAME(__scatter64_float);
DECL_BUILTIN_NAME(__scatter64_generic_double);
DECL_BUILTIN_NAME(__scatter64_generic_float);
DECL_BUILTIN_NAME(__scatter64_generic_half);
DECL_BUILTIN_NAME(__scatter64_generic_i16);
DECL_BUILTIN_NAME(__scatter64_generic_i32);
DECL_BUILTIN_NAME(__scatter64_generic_i64);
DECL_BUILTIN_NAME(__scatter64_generic_i8);
DECL_BUILTIN_NAME(__scatter64_half);
DECL_BUILTIN_NAME(__scatter64_i16);
DECL_BUILTIN_NAME(__scatter64_i32);
DECL_BUILTIN_NAME(__scatter64_i64);
DECL_BUILTIN_NAME(__scatter64_i8);
DECL_BUILTIN_NAME(__scatter_base_offsets32_double);
DECL_BUILTIN_NAME(__scatter_base_offsets32_float);
DECL_BUILTIN_NAME(__scatter_base_offsets32_half);
DECL_BUILTIN_NAME(__scatter_base_offsets32_i16);
DECL_BUILTIN_NAME(__scatter_base_offsets32_i32);
DECL_BUILTIN_NAME(__scatter_base_offsets32_i64);
DECL_BUILTIN_NAME(__scatter_base_offsets32_i8);
DECL_BUILTIN_NAME(__scatter_base_offsets64_double);
DECL_BUILTIN_NAME(__scatter_base_offsets64_float);
DECL_BUILTIN_NAME(__scatter_base_offsets64_half);
DECL_BUILTIN_NAME(__scatter_base_offsets64_i16);
DECL_BUILTIN_NAME(__scatter_base_offsets64_i32);
DECL_BUILTIN_NAME(__scatter_base_offsets64_i64);
DECL_BUILTIN_NAME(__scatter_base_offsets64_i8);
DECL_BUILTIN_NAME(__scatter_elt32_double);
DECL_BUILTIN_NAME(__scatter_elt32_float);
DECL_BUILTIN_NAME(__scatter_elt32_half);
DECL_BUILTIN_NAME(__scatter_elt32_i16);
DECL_BUILTIN_NAME(__scatter_elt32_i32);
DECL_BUILTIN_NAME(__scatter_elt32_i64);
DECL_BUILTIN_NAME(__scatter_elt32_i8);
DECL_BUILTIN_NAME(__scatter_elt64_double);
DECL_BUILTIN_NAME(__scatter_elt64_float);
DECL_BUILTIN_NAME(__scatter_elt64_half);
DECL_BUILTIN_NAME(__scatter_elt64_i16);
DECL_BUILTIN_NAME(__scatter_elt64_i32);
DECL_BUILTIN_NAME(__scatter_elt64_i64);
DECL_BUILTIN_NAME(__scatter_elt64_i8);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets32_double);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets32_float);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets32_half);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets32_i16);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets32_i32);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets32_i64);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets32_i8);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets64_double);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets64_float);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets64_half);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets64_i16);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets64_i32);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets64_i64);
DECL_BUILTIN_NAME(__scatter_factored_base_offsets64_i8);
DECL_BUILTIN_NAME(__send_eot);
DECL_BUILTIN_NAME(__set_ftz_daz_flags);
DECL_BUILTIN_NAME(__set_system_isa);
DECL_BUILTIN_NAME(__sext_uniform_bool);
DECL_BUILTIN_NAME(__sext_varying_bool);
DECL_BUILTIN_NAME(__shift_double);
DECL_BUILTIN_NAME(__shift_float);
DECL_BUILTIN_NAME(__shift_half);
DECL_BUILTIN_NAME(__shift_i16);
DECL_BUILTIN_NAME(__shift_i32);
DECL_BUILTIN_NAME(__shift_i64);
DECL_BUILTIN_NAME(__shift_i8);
DECL_BUILTIN_NAME(__shuffle2_double);
DECL_BUILTIN_NAME(__shuffle2_float);
DECL_BUILTIN_NAME(__shuffle2_half);
DECL_BUILTIN_NAME(__shuffle2_i16);
DECL_BUILTIN_NAME(__shuffle2_i32);
DECL_BUILTIN_NAME(__shuffle2_i64);
DECL_BUILTIN_NAME(__shuffle2_i8);
DECL_BUILTIN_NAME(__shuffle_double);
DECL_BUILTIN_NAME(__shuffle_float);
DECL_BUILTIN_NAME(__shuffle_half);
DECL_BUILTIN_NAME(__shuffle_i16);
DECL_BUILTIN_NAME(__shuffle_i32);
DECL_BUILTIN_NAME(__shuffle_i64);
DECL_BUILTIN_NAME(__shuffle_i8);
DECL_BUILTIN_NAME(__sincos_uniform_double);
DECL_BUILTIN_NAME(__sincos_uniform_float);
DECL_BUILTIN_NAME(__sincos_uniform_half);
DECL_BUILTIN_NAME(__sincos_varying_double);
DECL_BUILTIN_NAME(__sincos_varying_float);
DECL_BUILTIN_NAME(__sincos_varying_half);
DECL_BUILTIN_NAME(__sin_uniform_double);
DECL_BUILTIN_NAME(__sin_uniform_float);
DECL_BUILTIN_NAME(__sin_uniform_half);
DECL_BUILTIN_NAME(__sin_varying_double);
DECL_BUILTIN_NAME(__sin_varying_float);
DECL_BUILTIN_NAME(__sin_varying_half);
DECL_BUILTIN_NAME(__soa_to_aos2_double);
DECL_BUILTIN_NAME(__soa_to_aos2_double1);
DECL_BUILTIN_NAME(__soa_to_aos2_double16);
DECL_BUILTIN_NAME(__soa_to_aos2_double32);
DECL_BUILTIN_NAME(__soa_to_aos2_double4);
DECL_BUILTIN_NAME(__soa_to_aos2_double64);
DECL_BUILTIN_NAME(__soa_to_aos2_double8);
DECL_BUILTIN_NAME(__soa_to_aos2_float);
DECL_BUILTIN_NAME(__soa_to_aos2_float1);
DECL_BUILTIN_NAME(__soa_to_aos2_float16);
DECL_BUILTIN_NAME(__soa_to_aos2_float32);
DECL_BUILTIN_NAME(__soa_to_aos2_float4);
DECL_BUILTIN_NAME(__soa_to_aos2_float64);
DECL_BUILTIN_NAME(__soa_to_aos2_float8);
DECL_BUILTIN_NAME(__soa_to_aos3_double);
DECL_BUILTIN_NAME(__soa_to_aos3_double1);
DECL_BUILTIN_NAME(__soa_to_aos3_double16);
DECL_BUILTIN_NAME(__soa_to_aos3_double32);
DECL_BUILTIN_NAME(__soa_to_aos3_double4);
DECL_BUILTIN_NAME(__soa_to_aos3_double64);
DECL_BUILTIN_NAME(__soa_to_aos3_double8);
DECL_BUILTIN_NAME(__soa_to_aos3_float);
DECL_BUILTIN_NAME(__soa_to_aos3_float1);
DECL_BUILTIN_NAME(__soa_to_aos3_float16);
DECL_BUILTIN_NAME(__soa_to_aos3_float32);
DECL_BUILTIN_NAME(__soa_to_aos3_float4);
DECL_BUILTIN_NAME(__soa_to_aos3_float64);
DECL_BUILTIN_NAME(__soa_to_aos3_float8);
DECL_BUILTIN_NAME(__soa_to_aos4_double);
DECL_BUILTIN_NAME(__soa_to_aos4_double1);
DECL_BUILTIN_NAME(__soa_to_aos4_double16);
DECL_BUILTIN_NAME(__soa_to_aos4_double32);
DECL_BUILTIN_NAME(__soa_to_aos4_double4);
DECL_BUILTIN_NAME(__soa_to_aos4_double64);
DECL_BUILTIN_NAME(__soa_to_aos4_double8);
DECL_BUILTIN_NAME(__soa_to_aos4_float);
DECL_BUILTIN_NAME(__soa_to_aos4_float1);
DECL_BUILTIN_NAME(__soa_to_aos4_float16);
DECL_BUILTIN_NAME(__soa_to_aos4_float32);
DECL_BUILTIN_NAME(__soa_to_aos4_float4);
DECL_BUILTIN_NAME(__soa_to_aos4_float64);
DECL_BUILTIN_NAME(__soa_to_aos4_float8);
DECL_BUILTIN_NAME(__sqrt_uniform_double);
DECL_BUILTIN_NAME(__sqrt_uniform_float);
DECL_BUILTIN_NAME(__sqrt_uniform_half);
DECL_BUILTIN_NAME(__sqrt_varying_double);
DECL_BUILTIN_NAME(__sqrt_varying_float);
DECL_BUILTIN_NAME(__sqrt_varying_half);
DECL_BUILTIN_NAME(__stdlib_acosf);
DECL_BUILTIN_NAME(__stdlib_asin);
DECL_BUILTIN_NAME(__stdlib_asinf);
DECL_BUILTIN_NAME(__stdlib_atan);
DECL_BUILTIN_NAME(__stdlib_atan2);
DECL_BUILTIN_NAME(__stdlib_atan2f);
DECL_BUILTIN_NAME(__stdlib_atanf);
DECL_BUILTIN_NAME(__stdlib_cos);
DECL_BUILTIN_NAME(__stdlib_cosf);
DECL_BUILTIN_NAME(__stdlib_exp);
DECL_BUILTIN_NAME(__stdlib_expf);
DECL_BUILTIN_NAME(__stdlib_log);
DECL_BUILTIN_NAME(__stdlib_logf);
DECL_BUILTIN_NAME(__stdlib_pow);
DECL_BUILTIN_NAME(__stdlib_powf);
DECL_BUILTIN_NAME(__stdlib_sin);
DECL_BUILTIN_NAME(__stdlib_sincos);
DECL_BUILTIN_NAME(__stdlib_sincosf);
DECL_BUILTIN_NAME(__stdlib_sinf);
DECL_BUILTIN_NAME(__stdlib_tan);
DECL_BUILTIN_NAME(__stdlib_tanf);
DECL_BUILTIN_NAME(__streaming_load_uniform_double);
DECL_BUILTIN_NAME(__streaming_load_uniform_float);
DECL_BUILTIN_NAME(__streaming_load_uniform_half);
DECL_BUILTIN_NAME(__streaming_load_uniform_i16);
DECL_BUILTIN_NAME(__streaming_load_uniform_i32);
DECL_BUILTIN_NAME(__streaming_load_uniform_i64);
DECL_BUILTIN_NAME(__streaming_load_uniform_i8);
DECL_BUILTIN_NAME(__streaming_load_varying_double);
DECL_BUILTIN_NAME(__streaming_load_varying_float);
DECL_BUILTIN_NAME(__streaming_load_varying_half);
DECL_BUILTIN_NAME(__streaming_load_varying_i16);
DECL_BUILTIN_NAME(__streaming_load_varying_i32);
DECL_BUILTIN_NAME(__streaming_load_varying_i64);
DECL_BUILTIN_NAME(__streaming_load_varying_i8);
DECL_BUILTIN_NAME(__streaming_store_uniform_double);
DECL_BUILTIN_NAME(__streaming_store_uniform_float);
DECL_BUILTIN_NAME(__streaming_store_uniform_half);
DECL_BUILTIN_NAME(__streaming_store_uniform_i16);
DECL_BUILTIN_NAME(__streaming_store_uniform_i32);
DECL_BUILTIN_NAME(__streaming_store_uniform_i64);
DECL_BUILTIN_NAME(__streaming_store_uniform_i8);
DECL_BUILTIN_NAME(__streaming_store_varying_double);
DECL_BUILTIN_NAME(__streaming_store_varying_float);
DECL_BUILTIN_NAME(__streaming_store_varying_half);
DECL_BUILTIN_NAME(__streaming_store_varying_i16);
DECL_BUILTIN_NAME(__streaming_store_varying_i32);
DECL_BUILTIN_NAME(__streaming_store_varying_i64);
DECL_BUILTIN_NAME(__streaming_store_varying_i8);
DECL_BUILTIN_NAME(__svml_acosd);
DECL_BUILTIN_NAME(__svml_acosf);
DECL_BUILTIN_NAME(__svml_asind);
DECL_BUILTIN_NAME(__svml_asinf);
DECL_BUILTIN_NAME(__svml_atan2d);
DECL_BUILTIN_NAME(__svml_atan2f);
DECL_BUILTIN_NAME(__svml_atand);
DECL_BUILTIN_NAME(__svml_atanf);
DECL_BUILTIN_NAME(__svml_cosd);
DECL_BUILTIN_NAME(__svml_cosf);
DECL_BUILTIN_NAME(__svml_expd);
DECL_BUILTIN_NAME(__svml_expf);
DECL_BUILTIN_NAME(__svml_invsqrtd);
DECL_BUILTIN_NAME(__svml_invsqrtf);
DECL_BUILTIN_NAME(__svml_logd);
DECL_BUILTIN_NAME(__svml_logf);
DECL_BUILTIN_NAME(__svml_powd);
DECL_BUILTIN_NAME(__svml_powf);
DECL_BUILTIN_NAME(__svml_sincosd);
DECL_BUILTIN_NAME(__svml_sincosf);
DECL_BUILTIN_NAME(__svml_sind);
DECL_BUILTIN_NAME(__svml_sinf);
DECL_BUILTIN_NAME(__svml_sqrtd);
DECL_BUILTIN_NAME(__svml_sqrtf);
DECL_BUILTIN_NAME(__svml_tand);
DECL_BUILTIN_NAME(__svml_tanf);
DECL_BUILTIN_NAME(__tan_uniform_double);
DECL_BUILTIN_NAME(__tan_uniform_float);
DECL_BUILTIN_NAME(__tan_uniform_half);
DECL_BUILTIN_NAME(__tan_varying_double);
DECL_BUILTIN_NAME(__tan_varying_float);
DECL_BUILTIN_NAME(__tan_varying_half);
DECL_BUILTIN_NAME(__task_count);
DECL_BUILTIN_NAME(__task_count0);
DECL_BUILTIN_NAME(__task_count1);
DECL_BUILTIN_NAME(__task_count2);
DECL_BUILTIN_NAME(__task_index);
DECL_BUILTIN_NAME(__task_index0);
DECL_BUILTIN_NAME(__task_index1);
DECL_BUILTIN_NAME(__task_index2);
DECL_BUILTIN_NAME(__trunc_uniform_double);
DECL_BUILTIN_NAME(__trunc_uniform_float);
DECL_BUILTIN_NAME(__trunc_uniform_half);
DECL_BUILTIN_NAME(__trunc_varying_double);
DECL_BUILTIN_NAME(__trunc_varying_float);
DECL_BUILTIN_NAME(__trunc_varying_half);
DECL_BUILTIN_NAME(__undef_uniform);
DECL_BUILTIN_NAME(__undef_varying);
DECL_BUILTIN_NAME(__vec4_add_float);
DECL_BUILTIN_NAME(__vec4_add_int32);
DECL_BUILTIN_NAME(__vselect_float);
DECL_BUILTIN_NAME(__vselect_i32);

} // namespace builtin

} // namespace ispc