/*      
 * iroffer by PMG
 * Copyright (C) 1998-2003 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer_globals.h 1.59@(#)
 * pmg@wellington.i202.centerclick.org|src/iroffer_globals.h|20030912220347|19336
 * 
 */

#if !defined _IROFFER_GLOBALS
#define _IROFFER_GLOBALS

#if !defined GEX
#define GEX extern
#endif


typedef struct
{
/* config */
connectionmethod_t connectionmethod;
char* configfile[MAXCONFIG];
char* osstring;
int hideos;
int lognotices;
long startuptime;
int virthost;
char *vhost_ip;
int lowbdwth;
int logstats;
char *logfile;
int logrotate;
char *headline;
char *creditline;
int background;
unsigned long ourip;
int usenatip;
int autosend;
int autopack;
char *autoword, *automsg;
char *xdccfile;
char *pidfile;
char *proxyinfo, *proxyinfo2;
int firewall, dccrangestart;
float overallminspeed, transfermaxspeed;
int overallmaxspeed, overallmaxspeeddayspeed;
int maxb;
int overallmaxspeeddaytimestart, overallmaxspeeddaytimeend;
char overallmaxspeeddaydays;
int maxtransfersperperson, maxqueueditemsperperson;
char *adminpass;
regex_t *adminhost[MAXAHOST];
char *filedir, *messagefile, *ignorefile;
char *periodicmsg_nick, *periodicmsg_msg;
int  periodicmsg_time;
int uploadallowed;
char *uploaddir;
off_t uploadmaxsize;
char *config_nick;
char *user_nick, *caps_nick;
char *user_realname, *user_modes, *loginname;
int restrictlist, restrictsend, restrictprivlist;
char *nickserv_pass;
int notifytime;
int respondtochannelxdcc;
int respondtochannellist;
int smallfilebypass;

/* raw on join patch */
char *server_join_raw;
char *channel_join_raw1, *channel_join_raw2, *channel_join_raw3;

/* rehash temp variables */
channel_t *r_channel[MAXCHNLS];
channel_t *t_channel[MAXCHNLS];
char *r_vhost_ip;
char *r_pidfile;
char *r_config_nick;
char *r_xdccfile;
int r_virthost;
float r_overallminspeed, r_transfermaxspeed;

/* server */
char *server[MAXSRVS], *curserverip, *curserverport, *curserveractualname;
int nocon;
int servertime;
enum
{
  SERVERSTATUS_NEED_TO_CONNECT,
  SERVERSTATUS_TRYING,
  SERVERSTATUS_CONNECTED,
  SERVERSTATUS_NEED_TO_SWITCH
} serverstatus;
long lastservercontact;
char *serverq[MAXSENDQ];
int serversent[30];
int ircserver;
int serverconnectbackoff;
int xdccautosavetime;

/* screen */
int attop, needsclear, termcols, termlines, nocolor, noscreen;

int stdout_buffer_init;
unsigned int stdout_buffer_in_cnt;
unsigned int stdout_buffer_out_cnt;
char *stdout_buffer;

/* channel */
channel_t *channels[MAXCHNLS];

/* dcc chat */
int dccchat, dccchatin, dccchatlisten;
struct sockaddr_in dccchatlistenaddr;

time_t curtime;

fd_set readset, writeset;
int highests;


float record;
float sentrecord;
unsigned long long totalsent;
long totaluptime;
int debug;
int exiting;

unsigned long xdccsent[120];

int inamnt[10];
int ignore;

int numpacks, slotsfull, slotsmax;
int recentsent;
int slotsmaxpack, slotsmaxslots, slotsmaxqueue, inslotsmaxqueue;
int queuesize, inqueue;


int noautosave;
long nonewcons;
long nolisting;
int needsrehash;
int needsshutdown;
int needsswitch;
int delayedshutdown;
int cursendptr;

off_t max_file_size;

rlim_t max_fds_from_rlimit;
int nick_number;

int logfd;

char *sendbuff;

context_t context_log[MAXCONTEXTS];
int context_cur_ptr;

char *xlistqueue[MAXXLQUE];

igninfo *ignorelist[MAXIGNL];

xdcc *xdccs[MAXXDCCS+1];
pqueue *mainqueue[MAXQUEUE];
pqueue *packqueue[MAXQUEUE];
transfer *trans[MAXTRANS];
upload *uploads[MAXUPLDS];

meminfo_t *meminfo;
int meminfo_count;
int meminfo_depth;

#if !defined(NO_CHROOT)
char chrootdir[MAXCHROOTDIR];
int dochroot;
#endif
#if !defined(NO_SETUID)
char runasuser[MAXRUNASUSER];
int dosetuid;
#endif

} gdata_t;


GEX gdata_t gdata;


#endif

/* End of File */
