/*      
 * iroffer by PMG
 * Copyright (C) 1998-2003 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer_display.c 1.36@(#)
 * pmg@wellington.i202.centerclick.org|src/iroffer_display.c|20030914020553|17203
 * 
 */

/* include the headers */
#include "iroffer_config.h"
#include "iroffer_defines.h"
#include "iroffer_headers.h"
#include "iroffer_globals.h"


void initscreen(void) {
   struct winsize win;
   char *tempstr,*tempstr2;
   
   updatecontext();
   
   if (gdata.background == 2) return;
   
   /* clear */
   gdata.attop = 0;

   if ( gdata.noscreen )
      return;
   
   tostdout("\x1b[H\x1b[J\x1b[r");

   gdata.termlines = 80;
   gdata.termcols = 24;
   
   if ((ioctl(0, TIOCGWINSZ, &win) == 0) && win.ws_col && win.ws_row) {
      gdata.termcols = win.ws_col;
      gdata.termlines = win.ws_row;
      }
   
   
   /* last 2 lines */
   tempstr = mycalloc(maxtextlength);
   tempstr2 = mycalloc(maxtextlengthshort);
   getstatusline(tempstr);
   tempstr[between(0,gdata.termcols-4,maxtextlength-2)] = '\0';
   snprintf(tempstr2,maxtextlengthshort-2,"\x1b[%d;1H[ %%-%ds ]",gdata.termlines-1,gdata.termcols-4);
   tostdout(tempstr2,tempstr);
   mydelete(tempstr);
   mydelete(tempstr2);

   tostdout("\x1b[%d;1H[ iroffer (%s) >",gdata.termlines,(gdata.user_nick ? gdata.user_nick : ""));
   tostdout("\x1b[%d;%dH]",gdata.termlines,gdata.termcols);
   
   /* scrolling */
   tostdout("\x1b[1;%dr",gdata.termlines-2);
   
   /* set bottom */
   tostdout("\x1b[%d;%dH",gdata.termlines,(int)(gdata.user_nick ? 16+strlen(gdata.user_nick) : 16));
   
   }

void checktermsize(void) {
   int notok;
   struct winsize win;
   
   updatecontext();
   
   notok = 0;
   if (gdata.background == 2) return;
   
   if ((ioctl(0, TIOCGWINSZ, &win) == 0) && win.ws_col && win.ws_row) {
      if (gdata.termcols != win.ws_col) notok++;
      if (gdata.termlines != win.ws_row) notok++;
      if (notok) {
         gdata.termcols = win.ws_col;
         gdata.termlines = win.ws_row;
         initscreen();
         if (!gdata.attop) gototop();
         tostdout("*** Window Size Changed To: %dx%d\n",gdata.termcols,gdata.termlines);
         gotobot();
         }
      }
   }

void gototop (void) {
   if (gdata.background == 2) return;
   gdata.attop = 1;
   if ( gdata.noscreen )
      return;
   
   tostdout("\x1b[s\x1b[%d;1H",gdata.termlines-2);
   }

void clearbot (void)
{
  if ((gdata.background == 2) || gdata.noscreen)
    {
      return;
    }
  
  /* save cursor */
  tostdout("\x1b[%d;%dH\x1b[s",
           gdata.termlines,
           (int)(gdata.user_nick ? 16+strlen(gdata.user_nick) : 16));
  
  /* clean bottom line */
  tostdout("\x1b[%d;1H[ iroffer (%s) > %*s]",
           gdata.termlines,
           (gdata.user_nick ? gdata.user_nick : ""),
           gdata.termcols - (int)(gdata.user_nick ? 16+strlen(gdata.user_nick) : 16),"");
  
  return;
}

void gotobot (void) {
   if (gdata.background == 2) return;
   gdata.attop = 0;
   if ( gdata.noscreen )
      return;
   
   tostdout("\x1b[u");
   }


void tostdout_disable_buffering(int flush)
{
  if (!gdata.stdout_buffer_init)
    {
      return;
    }
  
  set_socket_nonblocking(fileno(stdout),0);
  
  tostdout_write();
  
  gdata.stdout_buffer_init = 0;
  
  return;
}

void tostdout_write(void)
{
  ssize_t retval;
  
  if (!gdata.stdout_buffer_init)
    {
      fflush(stdout);
      return;
    }
  
  while (gdata.stdout_buffer_in_cnt != gdata.stdout_buffer_out_cnt)
    {
      /* if data wraps around end of buffer, just send twice instead of once */
      size_t length = min2( min2(gdata.stdout_buffer_in_cnt, ceiling(gdata.stdout_buffer_out_cnt, STDOUT_BUFFER_SIZE)) - gdata.stdout_buffer_out_cnt, STDOUT_WRITE_MAX_SIZE);
      
      retval = write(fileno(stdout), &gdata.stdout_buffer[gdata.stdout_buffer_out_cnt % STDOUT_BUFFER_SIZE], length);
      
      if ((retval < 0) && (errno == EAGAIN))
        {
          /* cant write */
          break;
        }
      else if (retval < 0)
        {
          outerror(OUTERROR_TYPE_CRASH,"can't write to stdout: %s",strerror(errno));
        }
      else if (retval > 0)
        {
          /* wrote some or all of data */
          length = retval;
          memset(&gdata.stdout_buffer[gdata.stdout_buffer_out_cnt % STDOUT_BUFFER_SIZE], 0, length);
          gdata.stdout_buffer_out_cnt += length;
        }
    }
  
  return;
}

void tostdout(const char *format, ...)
{
  va_list args;
  va_start(args, format);
  vtostdout(format, args);
  va_end(args);
}

void vtostdout(const char *format, va_list ap)
{
  int ii, len;
  char tempstr[maxtextlength];
  
  if (!gdata.stdout_buffer_init)
    {
      vprintf(format,ap);
      fflush(stdout);
    }
  else
    {
      vsnprintf(tempstr,maxtextlength-2,format,ap);
      
      len = strlen(tempstr);
      
      for (ii=0; ii<len; ii++)
        {
          if (gdata.stdout_buffer_in_cnt < (gdata.stdout_buffer_out_cnt + STDOUT_BUFFER_SIZE - 1))
            {
              gdata.stdout_buffer[gdata.stdout_buffer_in_cnt % STDOUT_BUFFER_SIZE] = tempstr[ii];
              gdata.stdout_buffer_in_cnt++;
            }
          /* else out of space, drop char */
        }
      
      /* tostdout_write(); */
    }
  
  return;
}



/* End of File */

