/*      
 * iroffer by PMG
 * Copyright (C) 1998-2003 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer_dccchat.c 1.53@(#)
 * pmg@wellington.i202.centerclick.org|src/iroffer_dccchat.c|20030914020543|18497
 * 
 */

/* include the headers */
#include "iroffer_config.h"
#include "iroffer_defines.h"
#include "iroffer_headers.h"
#include "iroffer_globals.h"


int setupdccchatout(const char *nick)
{
  SIGNEDSOCK int addrlen;
  int max;
  int retry;
  int tempc;
  int listenport;
  
  updatecontext();
  
  addrlen = sizeof (struct sockaddr_in);
  
  if (gdata.dccchat != FD_UNUSED)
    {
      writedccchat("Another DCC Chat Request Received");
      writedccchat("Bye.");
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"DCC CHAT Switch");
      FD_CLR(gdata.dccchat, &gdata.readset);
      usleep(100*1000);
      /*
       * cygwin close() is broke, if outstanding data is present
       * it will block until the TCP connection is dead, sometimes
       * upto 10-20 minutes, calling shutdown() first seems to help
       */
      shutdown(gdata.dccchat, SHUT_RDWR);
      close(gdata.dccchat);
      gdata.dccchat = FD_UNUSED;
      highestsock();
    }
   
   if ((gdata.dccchatlisten = socket (AF_INET, SOCK_STREAM, 0)) < 0)
     {
       outerror(OUTERROR_TYPE_WARN_LOUD,
                "Could Not Create Socket, Aborting: %s", strerror(errno));
       gdata.dccchatlisten = FD_UNUSED;
       return 1;
     }

  if (gdata.firewall)
    {
      tempc = 1;
      setsockopt(gdata.dccchatlisten, SOL_SOCKET, SO_REUSEADDR, &tempc, sizeof(int));
    }
  
  bzero ((char *) &gdata.dccchatlistenaddr, sizeof (struct sockaddr_in));
  
  gdata.dccchatlistenaddr.sin_family = AF_INET;
  gdata.dccchatlistenaddr.sin_addr.s_addr = INADDR_ANY;
  
  max = (ACTUAL_MAXTRANS+MAXUPLDS+2);
  
  for (retry = 0; retry < max; retry++)
    {
      if (gdata.firewall)
        {
          gdata.dccchatlistenaddr.sin_port = htons(gdata.dccrangestart + retry);
        }
      else
        {
          gdata.dccchatlistenaddr.sin_port = htons(0);
        }
      
      if (gdata.debug > 0)
        {
          ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,
                  "trying bind to port = %d",
                  ntohs(gdata.dccchatlistenaddr.sin_port));
        }
      
      if (bind(gdata.dccchatlisten,
               (struct sockaddr *)&gdata.dccchatlistenaddr,
               sizeof(struct sockaddr_in)) < 0)
        {
          if (!gdata.firewall)
            {
              /* give up */
              retry = max;
              break;
            }
        }
      else
        {
          break;
        }
    }
  
  if (retry == max)
    {
      outerror(OUTERROR_TYPE_WARN_LOUD,
               "Couldn't Bind to Socket, Aborting: %s", strerror(errno));
      gdata.dccchatlisten = FD_UNUSED;
      return 1;
    }
  
  if ((getsockname (gdata.dccchatlisten, (struct sockaddr *)&gdata.dccchatlistenaddr, &addrlen)) < 0)
    {
      outerror(OUTERROR_TYPE_WARN_LOUD,
               "Couldn't get Port Number, Aborting: %s", strerror(errno));
      gdata.dccchatlisten = FD_UNUSED;
      return 1;
    }
  
  listenport = ntohs (gdata.dccchatlistenaddr.sin_port);
  
  if (listen (gdata.dccchatlisten, 1) < 0)
    {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Couldn't Listen, Aborting: %s", strerror(errno));
      gdata.dccchatlisten = FD_UNUSED;
      return 1;
    }
  
  highestsock();
  
  privmsg(nick,"\1DCC CHAT CHAT %lu %d\1",gdata.ourip,listenport);
  
  return 0;
}

void setupdccchataccept(void) {
   SIGNEDSOCK int addrlen;
   char *tempstr, *tempstr2;
   
   updatecontext();
   
   if (gdata.dccchat != FD_UNUSED) {
      writedccchat("Another DCC Chat Request Received");
      writedccchat("Bye.");
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"DCC CHAT Switch");
      FD_CLR(gdata.dccchat, &gdata.readset);
      usleep(100*1000);
      /*
       * cygwin close() is broke, if outstanding data is present
       * it will block until the TCP connection is dead, sometimes
       * upto 10-20 minutes, calling shutdown() first seems to help
       */
      shutdown(gdata.dccchat, SHUT_RDWR);
      close(gdata.dccchat);
      gdata.dccchat = FD_UNUSED;
      highestsock();
      }
   
   addrlen = sizeof (struct sockaddr_in);
   if ((gdata.dccchat = accept(gdata.dccchatlisten, (struct sockaddr *) &gdata.dccchatlistenaddr, &addrlen)) < 0) {
      outerror(OUTERROR_TYPE_WARN,"Accept Error, Aborting: %s",strerror(errno));
      FD_CLR(gdata.dccchatlisten, &gdata.readset);
      close(gdata.dccchatlisten);
      gdata.dccchatlisten = FD_UNUSED;
      gdata.dccchat = FD_UNUSED;
      highestsock();
      return;
      }
   
   FD_CLR(gdata.dccchatlisten, &gdata.readset);
   close(gdata.dccchatlisten);
   gdata.dccchatlisten = FD_UNUSED;
   
   tempstr = mycalloc(maxtextlength);
   tempstr2 = mycalloc(maxtextlength);
   getuptime(tempstr2,0,gdata.startuptime);
   snprintf(tempstr,maxtextlength-2,
            "Welcome to %s\niroffer v" VERSIONLONG "%s%s\n"
            "    running %s\n"
            " \nEnter Your Password:\n",
            gdata.user_nick,
            gdata.hideos ? "" : " - ",
            gdata.hideos ? "" : gdata.osstring,
            tempstr2);
   write(gdata.dccchat,tempstr,strlen(tempstr));
   mydelete(tempstr);
   mydelete(tempstr2);
   
   gdata.dccchatin = 0;

   highestsock();
   }

int setupdccchat(const char *line) {
   struct sockaddr_in remoteip;
   struct sockaddr_in localaddr;
   struct hostent *localhost;
   char *ip, *port;
   SIGNEDSOCK int addrlen;
   char *tempstr, *tempstr2;
   
   updatecontext();
   
   if (gdata.dccchat != FD_UNUSED) {
      writedccchat("Another DCC Chat Request Received");
      writedccchat("Bye.");
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_NO_COLOR,"DCC CHAT Switch");
      FD_CLR(gdata.dccchat, &gdata.readset);
      usleep(100*1000);
      /*
       * cygwin close() is broke, if outstanding data is present
       * it will block until the TCP connection is dead, sometimes
       * upto 10-20 minutes, calling shutdown() first seems to help
       */
      shutdown(gdata.dccchat, SHUT_RDWR);
      close(gdata.dccchat);
      gdata.dccchat = FD_UNUSED;
      highestsock();
      }
   
   ip = getpart(line,7);
   port = getpart(line,8);
   
   if ( !ip || !port ) {
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   
   ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L,COLOR_MAGENTA,"DCC Chat Requested");
   
   bzero ((char *) &remoteip, sizeof (remoteip));
   
   gdata.dccchat = socket( AF_INET, SOCK_STREAM, 0);
   if (gdata.dccchat < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Socket Error: %s", strerror(errno));
      gdata.dccchat = FD_UNUSED;
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   
   port[strlen(port)-1] = '\0';
   
   remoteip.sin_family = AF_INET;
   remoteip.sin_port = htons(atoi(port));
   
/*   if (( remotehost = gethostbyname(hostname)) == NULL) { */
/*      outerror(OUTERROR_TYPE_WARN_LOUD,"Can't Resolve Server Host"); */
/*      return 1; */
/*      } */
   
   remoteip.sin_addr.s_addr = htonl(atoul(ip));

/*   memcpy(&remoteip.sin_addr, *((struct in_addr **)remotehost->h_addr_list), sizeof(struct in_addr)); */
   
   if (gdata.virthost) {
      if (!gdata.vhost_ip) outerror(OUTERROR_TYPE_CRASH,"virthost = yes, but no vhost_ip set");
      bzero((char*)&localaddr, sizeof(struct sockaddr_in));
      localaddr.sin_family = AF_INET;
      localaddr.sin_port = 0;
      if (( localhost = gethostbyname(gdata.vhost_ip)) == NULL) {
         outerror(OUTERROR_TYPE_WARN_LOUD,"Can't Resolve Virtual Host");
         gdata.dccchat = FD_UNUSED;
         mydelete(ip);
         mydelete(port);
         return 1;
         }
      memcpy(&localaddr.sin_addr, *((struct in_addr **)localhost->h_addr_list), sizeof(struct in_addr));
      if (bind(gdata.dccchat, (struct sockaddr *) &localaddr, sizeof(localaddr)) < 0) {
         outerror(OUTERROR_TYPE_WARN_LOUD,"Couldn't Bind To Virtual Host: %s", strerror(errno));
         gdata.dccchat = FD_UNUSED;
         mydelete(ip);
         mydelete(port);
         return 1;
         }
      }

   alarm(CTIMEOUT);
   if (connect(gdata.dccchat, (struct sockaddr *) &remoteip, sizeof(remoteip)) < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Connection to DCC Chat Failed: %s", strerror(errno));
      gdata.dccchat = FD_UNUSED;
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   alarm(0);
   
   addrlen = sizeof (remoteip);
   if (getsockname(gdata.dccchat,(struct sockaddr *) &remoteip, &addrlen) < 0) {
      outerror(OUTERROR_TYPE_WARN_LOUD,"Couldn't get sock name: %s", strerror(errno));
      gdata.dccchat = FD_UNUSED;
      mydelete(ip);
      mydelete(port);
      return 1;
      }
   
   if (gdata.debug > 0) {
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_YELLOW,"dccchat socket = %d",gdata.dccchat);
      }

   highestsock();
   
   tempstr = mycalloc(maxtextlength);
   tempstr2 = mycalloc(maxtextlength);
   getuptime(tempstr2,0,gdata.startuptime);
   snprintf(tempstr,maxtextlength-2,
            "Welcome to %s\niroffer v" VERSIONLONG "%s%s\n"
            "    running %s\n"
            " \nEnter Your Password:\n",
            gdata.user_nick,
            gdata.hideos ? "" : " - ",
            gdata.hideos ? "" : gdata.osstring,
            tempstr2);
   write(gdata.dccchat,tempstr,strlen(tempstr));
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(ip);
   mydelete(port);
   gdata.dccchatin = 0;
   
   return 0;
   }

void parsedccchat(char* line) {
   char *linec = mycalloc(maxtextlength);
   userinput ui;
   char *tempstr;

   updatecontext();
   
   strncpy(linec,line,maxtextlength-1);
   caps(linec);
   
   if (!gdata.dccchatin) {
      if ( verifypass(line) ) {
         gdata.dccchatin = 1;
         writedccchat(" \n*** Entering DCC Chat Admin Interface\n"
                      "*** For Help type \"help\"\n");
         if (gdata.messagefile) {
            tempstr = mycalloc(maxtextlength);
            msglog_howmany(tempstr);
            writedccchat(tempstr);
            mydelete(tempstr);
            }
         writedccchat(" \n");

         }
      else {
         ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L|OUT_D,COLOR_MAGENTA,"DCC CHAT: Incorrect password");
         FD_CLR(gdata.dccchat, &gdata.readset);
         usleep(100*1000);
         /*
          * cygwin close() is broke, if outstanding data is present
          * it will block until the TCP connection is dead, sometimes
          * upto 10-20 minutes, calling shutdown() first seems to help
          */
         shutdown(gdata.dccchat, SHUT_RDWR);
         close(gdata.dccchat);
         gdata.dccchat = FD_UNUSED;
         highestsock();
         }
      }
   else if (!strcmp(linec,"QUIT")) {
      ioutput(CALLTYPE_NORMAL,OUT_S|OUT_L,COLOR_MAGENTA,"DCC CHAT: QUIT");
      writedccchat("Bye.");
      FD_CLR(gdata.dccchat, &gdata.readset);
      usleep(100*1000);
      /*
       * cygwin close() is broke, if outstanding data is present
       * it will block until the TCP connection is dead, sometimes
       * upto 10-20 minutes, calling shutdown() first seems to help
       */
      shutdown(gdata.dccchat, SHUT_RDWR);
      close(gdata.dccchat);
      gdata.dccchat = FD_UNUSED;
      highestsock();
      }
   else {
      if (!gdata.attop) gototop();
      if (gdata.debug > 0)
         ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_CYAN,">DCC>: %s",line);
      /*remoteadmin(NULL,msg3,msg4,line); */
      u_fillwith_dcc(&ui,line);
      u_parseit(&ui);

      }
   
   mydelete(linec);
   }

void writedccchat(const char *str) {
   updatecontext();
   
   if (!str) return;
   
   write(gdata.dccchat,str,strlen(str));
   
   if ( str[strlen(str)-1] != '\n')
      write (gdata.dccchat,"\n",1);
   
   if (gdata.debug > 0)
      ioutput(CALLTYPE_NORMAL,OUT_S,COLOR_CYAN,"<DCC<: %s",str);

   }

void writestatus(void) {
   char *tempstr,*tempstr2;
   
   updatecontext();
   
   tempstr = mycalloc(maxtextlength);
   tempstr2 = mycalloc(maxtextlengthshort);
   
   getstatusline(tempstr);
   writedccchat(tempstr);
   
   mydelete(tempstr);
   mydelete(tempstr2);
   
   }

/* End of File */
