#ifndef AUTOSOCKET_H_
#define AUTOSOCKET_H_

#if HAVE_CONFIG_H
#  include <config.h>
#endif

#if USE_WINSOCK >= 2
#  include <winsock2.h>
#  include <ws2tcpip.h>
#elif defined(USE_WINSOCK)
#  include <winsock.h>
#else
#  if HAVE_UNISTD_H
#    include <unistd.h>
#  endif
#  if HAVE_SYS_TIME_H
#    include <sys/time.h>
#  endif
#  if HAVE_SYS_TYPES_H
#    include <sys/types.h>
#  endif
#  if HAVE_SYS_SOCKET_H
#    include <sys/socket.h>
#  endif
#  if HAVE_SYS_SELECT_H
#    include <sys/select.h>
#  endif
#  if HAVE_NETINET_IN_H
#    include <netinet/in.h>
#  endif
#  if HAVE_ARPA_INET_H
#    include <arpa/inet.h>
#  endif
#  if HAVE_NETDB_H
#    include <netdb.h>
#  endif
#endif /* USE_WINSOCK */

#ifdef USE_WINSOCK
#  define sock_errno WSAGetLastError()
#include <stdio.h>
static inline const char *sock_strerror(int err) {
    static char msg[1024];

    if(0 == FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, NULL, err, 0,
			  (LPTSTR)&msg, sizeof msg, NULL))
	snprintf(msg, sizeof msg, "Unknown network error %d", err);
    return msg;
}
#  define sock_perror(msg) (msg ? fprintf(stderr, "%s: %s\n", msg,      \
					  sock_strerror(sock_errno))    \
			    : fprintf(stderr, "%s\n",                   \
				      sock_strerror(sock_errno)))
#  define SOCK_EINTR WSAEINTR
#else
#  define sock_errno errno
#  define sock_strerror(err) strerror(err)
#  define sock_perror(err) perror(err)
#  define SOCK_EINTR EINTR
#endif

#endif		/* AUTOSOCKET_H_ */
