/*
 * modelmixture.cpp
 *
 *  Created on: Nov 29, 2014
 *      Author: minh
 */

#include "modelgtr.h"
#include "modelnonrev.h"
#include "modeldna.h"
#include "modelprotein.h"
#include "modelbin.h"
#include "modelcodon.h"
#include "modelmorphology.h"
#include "modelset.h"
#include "modelmixture.h"
#include "phylokernelmixture.h"

const string builtin_mixmodels_definition =
"#nexus\n\
\n\
begin models;\n\
\n\
[ ---------------------------------------------------------\n\
    EX2 mixture model of Le, Lartillot & Gascuel (2008) \n\
 --------------------------------------------------------- ]\n\
\n\
[ Exposed component ]\n\
model ExpEX2 =\n\
0.526738 \n\
0.483150 0.505837 \n\
0.658902 0.051052 3.902456 \n\
2.051872 2.214326 0.961103 0.129989 \n\
1.280002 2.039552 1.301786 0.399061 0.456521 \n\
1.306565 0.137928 0.285806 3.100403 0.033946 2.514377 \n\
1.370782 0.363365 1.820100 0.885317 0.886564 0.320746 0.303966 \n\
0.540809 2.288922 4.949307 0.700890 2.172284 3.755421 0.270957 0.401311 \n\
0.171986 0.237023 0.337226 0.018315 1.037046 0.212032 0.084442 0.012279 0.317239 \n\
0.430511 0.670514 0.158937 0.021949 1.702066 1.261113 0.110508 0.052946 0.869247 8.675343 \n\
0.697731 3.881079 1.677194 0.105450 0.146263 2.570254 0.730337 0.279865 0.598289 0.338782 0.313102 \n\
1.043937 0.656943 0.539827 0.066925 1.846562 1.973592 0.188160 0.158136 0.519993 9.483497 14.176858 1.013268 \n\
0.265209 0.097443 0.182522 0.026918 3.002586 0.080193 0.023999 0.084663 2.047163 2.193062 4.802817 0.044792 3.261401 \n\
1.270693 0.166534 0.068692 0.228829 0.156216 0.362501 0.214847 0.148900 0.323141 0.071992 0.343919 0.195470 0.099252 0.087020 \n\
4.826665 0.751947 4.412265 0.975564 5.294149 1.033459 0.382235 1.970857 0.993310 0.190509 0.389101 0.592156 0.557254 0.668834 1.223981 \n\
2.131819 0.584329 2.133604 0.368887 2.067387 1.013613 0.511390 0.174527 0.580960 2.563630 0.522334 1.147459 2.960091 0.244420 0.413148 7.384701 \n\
0.143081 0.475590 0.061094 0.042618 1.603125 0.210329 0.048276 0.186382 0.961546 0.208313 1.130724 0.052858 1.328785 5.210001 0.045945 0.316078 0.144393 \n\
0.208643 0.196271 0.599369 0.121313 3.842632 0.158470 0.064648 0.039280 8.230282 0.517123 0.713426 0.084962 0.812142 23.228875 0.043249 0.405310 0.234217 4.903887 \n\
2.544463 0.313443 0.172264 0.073705 4.207648 0.497398 0.484620 0.132496 0.329895 23.711178 3.466991 0.348362 4.136445 1.199764 0.368231 0.266531 3.184874 0.252132 0.459187 \n\
\n\
0.088367 0.078147 0.047163 0.087976 0.004517 0.058526 0.128039 0.056993 0.024856 0.025277 0.045202 0.094639 0.012338 0.016158 0.060124 0.055346 0.051290 0.006771 0.021554 0.036718;\n\
\n\
[ Buried component ]\n\
model BurEX2 =\n\
0.338649 \n\
0.201335 0.981635 \n\
0.283859 0.247537 6.505182 \n\
2.640244 0.904730 1.353325 0.312005 \n\
0.543136 4.570308 2.439639 0.682052 0.216787 \n\
0.748479 0.917979 0.804756 10.030310 0.024055 8.670112 \n\
2.700465 0.539246 0.810739 0.810727 0.701320 0.330139 0.636675 \n\
0.237686 3.175221 6.308043 1.540002 0.469875 8.675492 0.750683 0.183743 \n\
0.044209 0.099241 0.162644 0.020816 0.166986 0.082745 0.030581 0.005017 0.075820 \n\
0.124047 0.314159 0.088243 0.017526 0.449241 0.641784 0.073392 0.017752 0.277023 2.383760 \n\
0.433721 17.781822 2.851914 0.459939 0.117548 6.815411 3.482941 0.484653 1.247888 0.161658 0.219757 \n\
0.497479 0.448773 0.380964 0.057176 0.815999 2.089412 0.291379 0.054491 0.307450 2.817174 4.759683 1.082403 \n\
0.093991 0.055530 0.098936 0.026160 0.662517 0.091948 0.022760 0.034431 0.675645 0.521416 1.672365 0.077917 1.296869 \n\
0.986621 0.356417 0.214521 0.246129 0.164228 0.654039 0.295079 0.179095 0.428213 0.037671 0.170780 0.347219 0.074086 0.057233 \n\
5.925588 0.979993 4.725421 1.158990 5.111992 1.120931 0.737456 2.279470 0.886126 0.051057 0.089611 0.925355 0.275366 0.274582 1.151114 \n\
1.958501 0.630713 2.007592 0.289641 2.284140 0.787821 0.539892 0.097432 0.467489 0.644041 0.202812 1.401676 1.340732 0.103118 0.601281 8.190534 \n\
0.068357 0.784449 0.109073 0.085810 0.457880 0.297731 0.155877 0.157418 0.708743 0.054134 0.374568 0.115777 0.477495 2.362999 0.047127 0.209085 0.097054 \n\
0.084768 0.312038 0.615093 0.202611 0.788164 0.293543 0.137306 0.035497 4.938330 0.101803 0.180086 0.280737 0.264540 8.142914 0.059308 0.264401 0.133054 2.905674 \n\
1.387752 0.140091 0.112176 0.058637 1.575057 0.203946 0.239406 0.044011 0.085226 6.427279 1.035942 0.244336 1.033583 0.278010 0.213475 0.079878 1.592560 0.081135 0.108383 \n\
\n\
0.123119 0.019475 0.019852 0.018583 0.018711 0.017275 0.018723 0.050388 0.016402 0.119697 0.161399 0.012776 0.035838 0.057019 0.030913 0.043472 0.049935 0.012600 0.039929 0.133894;\n\
\n\
[ main definition of EX2 with fixed component rates ]\n\
model EX2 =MIX{BurEX2:0.672020808818762,ExpEX2:1.6413466609931};\n\
\n\
\n\
[ ---------------------------------------------------------\n\
    EX3 mixture model of Le, Lartillot & Gascuel (2008) \n\
 --------------------------------------------------------- ]\n\
\n\
[ Buried component ]\n\
model BurEX3 =\n\
0.352598 \n\
0.216996 1.087422 \n\
0.292440 0.323465 7.797086 \n\
2.610812 0.913640 1.460331 0.344397 \n\
0.510610 5.128748 2.811070 0.773241 0.220223 \n\
0.753729 1.090823 0.956820 12.012282 0.021022 10.123412 \n\
2.838061 0.595013 0.884971 0.922298 0.707214 0.351856 0.713974 \n\
0.239679 3.625577 7.108377 1.826237 0.481109 10.246488 0.839852 0.219310 \n\
0.051496 0.102940 0.168735 0.024207 0.162795 0.087881 0.036973 0.004515 0.079975 \n\
0.119849 0.316151 0.091984 0.018800 0.422679 0.648064 0.075035 0.016317 0.282195 2.225363 \n\
0.443183 20.766910 3.194817 0.568138 0.132784 7.478955 4.176123 0.551523 1.415394 0.163276 0.207613 \n\
0.460570 0.458210 0.398615 0.059146 0.765112 2.134261 0.313124 0.053192 0.340474 2.609469 4.476961 1.014674 \n\
0.089411 0.056698 0.104720 0.027913 0.630095 0.094857 0.023275 0.034031 0.691151 0.491179 1.606618 0.077868 1.226530 \n\
0.993370 0.419898 0.217106 0.273526 0.181230 0.729534 0.311152 0.192454 0.483200 0.040002 0.170402 0.376998 0.075002 0.057218 \n\
6.108406 1.066008 5.182562 1.216396 5.236005 1.159086 0.763810 2.404073 0.924395 0.048875 0.084247 0.923997 0.260340 0.260617 1.208454 \n\
1.992855 0.687262 2.181095 0.312299 2.276505 0.829879 0.551397 0.101409 0.480998 0.610331 0.198919 1.407257 1.292634 0.096955 0.648250 8.527249 \n\
0.063159 0.855332 0.134012 0.099769 0.468450 0.329372 0.136731 0.169991 0.745868 0.056715 0.377293 0.137955 0.463394 2.343596 0.058650 0.211406 0.085948 \n\
0.078057 0.341493 0.655744 0.241264 0.762740 0.302096 0.142491 0.040257 5.226086 0.092084 0.180292 0.311130 0.249838 8.141649 0.062812 0.267992 0.128044 3.047417 \n\
1.339724 0.144916 0.125078 0.062854 1.481083 0.194081 0.225389 0.043663 0.090575 5.973306 0.993888 0.222252 0.964622 0.262045 0.207448 0.083450 1.544911 0.078358 0.105286 \n\
\n\
0.123992 0.016529 0.017595 0.015784 0.019325 0.015552 0.015939 0.049573 0.014540 0.126555 0.167605 0.011083 0.037438 0.058363 0.028849 0.042324 0.049207 0.011962 0.037833 0.139953;\n\
\n\
[ Intermediate component ]\n\
model IntEX3 =\n\
0.489239 \n\
0.466919 0.536794 \n\
0.601908 0.069474 4.603441 \n\
2.430552 1.807414 0.997223 0.166431 \n\
1.101971 2.081359 1.299123 0.508086 0.393348 \n\
1.227777 0.215899 0.345545 3.579383 0.046861 3.113235 \n\
1.873072 0.390054 1.528288 0.941969 0.867139 0.349219 0.406414 \n\
0.519003 1.930915 5.003737 0.781887 1.630085 3.567804 0.324903 0.315383 \n\
0.158722 0.180317 0.295816 0.013254 0.642786 0.179498 0.090830 0.013181 0.209208 \n\
0.345026 0.503290 0.138767 0.024393 1.107569 1.027755 0.123806 0.048549 0.592981 5.439892 \n\
0.610178 4.322929 1.524318 0.121994 0.181609 2.674484 0.792405 0.276766 0.591509 0.301836 0.294950 \n\
0.949957 0.472702 0.502710 0.091008 1.283305 1.905885 0.242081 0.140301 0.378459 6.259505 9.391081 1.074513 \n\
0.247271 0.069820 0.161809 0.028611 2.065479 0.077874 0.025753 0.065388 1.541097 1.306479 3.015722 0.048689 2.243101 \n\
1.334722 0.170174 0.099375 0.211869 0.163190 0.349495 0.155436 0.186099 0.300496 0.065625 0.265961 0.162529 0.088677 0.083754 \n\
5.316955 0.699036 4.526191 1.143652 5.249370 0.970695 0.438792 2.366185 0.939629 0.138819 0.275119 0.532771 0.521510 0.547761 1.187779 \n\
1.963809 0.535034 2.034583 0.383040 2.012437 0.891145 0.531018 0.180104 0.467342 1.861944 0.395319 1.071879 2.340268 0.183984 0.400373 7.243848 \n\
0.145693 0.378596 0.046601 0.048388 1.074147 0.174525 0.063777 0.168836 0.822524 0.110645 0.677913 0.062047 0.796395 3.502387 0.046950 0.290501 0.107097 \n\
0.195764 0.149382 0.534652 0.105996 2.446201 0.150150 0.071967 0.031908 6.198893 0.299207 0.413150 0.090874 0.492692 15.039152 0.044765 0.328289 0.175204 3.125850 \n\
2.227504 0.220361 0.150316 0.066496 3.112801 0.393451 0.444469 0.108811 0.224352 15.532696 2.152640 0.302279 2.658339 0.738053 0.322254 0.197018 2.507055 0.175763 0.276642 \n\
\n\
0.086346 0.080808 0.041727 0.064440 0.006654 0.052795 0.092110 0.048527 0.028831 0.040497 0.071679 0.079687 0.018007 0.025901 0.052632 0.052778 0.056138 0.010733 0.034744 0.054964;\n\
\n\
[ Highly exposed component ]\n\
model HExEX3 =\n\
0.557500 \n\
0.467024 0.508965 \n\
0.660464 0.044039 3.386724 \n\
1.332582 3.667491 1.440486 0.185886 \n\
1.402485 2.156104 1.297398 0.333117 0.789370 \n\
1.259192 0.111162 0.245837 2.707953 0.058650 2.098300 \n\
0.934526 0.393780 2.196372 0.868249 1.336358 0.322363 0.252359 \n\
0.518929 3.157422 5.392488 0.748008 3.827563 4.517669 0.284167 0.634601 \n\
0.279723 0.407537 0.535113 0.054030 3.345087 0.427624 0.148200 0.015686 0.658979 \n\
0.715094 1.182387 0.270883 0.035162 3.520931 2.366650 0.172395 0.100089 1.779380 18.830270 \n\
0.694526 3.728628 1.747648 0.083685 0.100399 2.477205 0.623294 0.280977 0.694965 0.569776 0.493141 \n\
1.338414 1.261833 0.818216 0.054313 3.918703 2.383718 0.219943 0.228757 0.867786 19.605444 31.431195 1.089056 \n\
0.295523 0.190129 0.263800 0.044853 5.266468 0.120909 0.042178 0.194665 3.494314 5.825792 11.527190 0.044361 6.237844 \n\
1.085021 0.168461 0.041147 0.203765 0.185173 0.353420 0.218194 0.120292 0.375260 0.116875 0.705493 0.190747 0.139085 0.108823 \n\
4.090024 0.852803 4.335615 0.829194 6.499129 1.095446 0.336922 1.733724 1.144100 0.413986 0.878828 0.631498 0.730416 1.167593 1.195720 \n\
2.318400 0.650016 2.351068 0.385247 1.883085 1.167877 0.532167 0.187062 0.796107 4.825759 0.838744 1.268311 4.445757 0.381760 0.419944 7.677284 \n\
0.134371 1.021826 0.151293 0.065183 3.716538 0.530580 0.077516 0.396559 1.324147 0.443432 3.290145 0.064651 4.411035 13.056874 0.056705 0.534908 0.408415 \n\
0.212989 0.424870 1.115762 0.268883 8.874037 0.255572 0.125866 0.107717 14.436023 1.292209 1.491799 0.104026 2.063744 49.760746 0.057618 0.756357 0.396791 12.032322 \n\
3.112666 0.544010 0.214411 0.125541 5.301703 0.868794 0.839508 0.215758 0.533676 46.074660 7.301056 0.557248 9.151909 2.634769 0.523205 0.564572 4.519860 0.456880 0.670812 \n\
\n\
0.094155 0.070537 0.052200 0.112406 0.002213 0.062733 0.165272 0.062302 0.019853 0.011154 0.019829 0.108860 0.006503 0.006873 0.070091 0.057931 0.046183 0.002449 0.008629 0.019827;\n\
\n\
[ main definition of EX3 with fixed component rates ]\n\
model EX3 = MIX{BurEX3:0.427672756793791,IntEX3:0.837595938019774,HExEX3:1.51863631431518};\n\
\n\
[ ---------------------------------------------------------\n\
    EHO mixture model of Le, Lartillot & Gascuel (2008)\n\
 --------------------------------------------------------- ]\n\
\n\
[ extended component ]\n\
model ExtEHO = \n\
0.221750 \n\
0.256487 0.595368 \n\
0.447755 0.112310 7.769815 \n\
4.893140 0.929131 1.061884 0.164472 \n\
0.542660 2.886791 1.927072 0.497273 0.133291 \n\
0.549459 0.290798 0.518264 5.393249 0.003776 4.326528 \n\
5.411319 0.302948 0.907713 0.961651 1.249183 0.173873 0.316780 \n\
0.283752 2.760038 5.159285 0.978418 0.737799 5.086066 0.421812 0.209276 \n\
0.026683 0.053027 0.166715 0.016491 0.151942 0.055934 0.026726 0.001780 0.098605 \n\
0.226816 0.251641 0.062256 0.015837 0.763554 0.537705 0.042909 0.032938 0.321607 3.217159 \n\
0.235513 6.017300 2.543177 0.223507 0.023575 3.432847 1.211039 0.160545 0.671045 0.082221 0.106179 \n\
0.992834 0.351969 0.415447 0.041511 1.271632 1.700679 0.111984 0.117596 0.326393 3.329162 7.496635 0.519821 \n\
0.191967 0.041219 0.090517 0.014810 1.004694 0.042779 0.011177 0.040989 0.641267 0.813011 2.233318 0.023173 1.863238 \n\
1.876507 0.395175 0.362650 0.550534 0.174031 0.731229 0.412907 0.205341 0.381717 0.011597 0.315127 0.393303 0.135360 0.043846 \n\
6.066032 1.083228 5.612711 1.035540 4.263932 1.429211 0.766802 2.266299 1.074108 0.047896 0.147065 0.683291 0.352118 0.382422 1.462674 \n\
1.827471 0.645132 1.883173 0.287521 1.395928 1.013709 0.781080 0.055140 0.512000 0.588357 0.142327 1.256445 1.435179 0.079647 0.417388 6.092548 \n\
0.101419 0.452274 0.065206 0.034173 0.592031 0.164037 0.049674 0.183473 0.741383 0.069289 0.429275 0.050856 0.545447 2.178510 0.022770 0.304839 0.111242 \n\
0.091914 0.112094 0.451176 0.108762 1.183567 0.132194 0.042952 0.030418 4.373360 0.122828 0.186938 0.096667 0.344096 8.276255 0.053251 0.325231 0.135310 2.597897 \n\
1.970427 0.119016 0.091863 0.041044 1.750822 0.222903 0.225961 0.053387 0.123318 6.815243 1.427658 0.124284 1.427074 0.341263 0.127045 0.076658 1.052442 0.073165 0.101733 \n\
\n\
0.062087 0.053435 0.023743 0.032063 0.013132 0.034151 0.061042 0.030664 0.022696 0.104732 0.099541 0.054991 0.022312 0.045996 0.025392 0.045673 0.072789 0.012691 0.043790 0.139079;\n\
\n\
[ Helix component ]\n\
model HelEHO = \n\
0.346476 \n\
0.374362 0.664870 \n\
0.557349 0.079157 3.710526 \n\
3.192474 1.027228 0.891196 0.006722 \n\
0.776545 1.902860 1.561002 0.517360 0.112028 \n\
0.841893 0.158406 0.443065 3.792847 0.000006 2.320685 \n\
4.037113 0.661209 1.866962 1.144918 1.465540 0.511489 0.573208 \n\
0.394225 2.123760 5.845902 0.737868 1.084909 3.960964 0.270146 0.380762 \n\
0.111350 0.099645 0.233216 0.005627 0.839533 0.089484 0.019520 0.021251 0.132153 \n\
0.193017 0.307622 0.115495 0.009651 1.136538 0.584189 0.039838 0.048105 0.485901 4.915707 \n\
0.481682 3.827872 1.926308 0.163314 0.021755 2.487895 0.768919 0.327002 0.534206 0.147053 0.136159 \n\
0.610432 0.344033 0.452639 0.035659 1.624032 1.146169 0.103241 0.171164 0.364836 6.260678 7.738615 0.549401 \n\
0.147278 0.035167 0.106276 0.018468 1.864906 0.047207 0.010268 0.086543 1.244539 0.927331 3.243633 0.016265 2.326533 \n\
1.090575 0.181605 0.093658 0.386490 0.097655 0.462559 0.290152 0.568098 0.458437 0.043237 0.207460 0.198291 0.061027 0.067592 \n\
6.243684 0.836138 5.633664 0.952131 6.398291 1.267404 0.430602 5.463144 1.088326 0.102127 0.193860 0.707365 0.438507 0.470620 1.534272 \n\
2.847158 0.566364 2.984732 0.347047 3.711971 1.083181 0.495700 0.500029 0.642773 1.698955 0.402699 1.111399 2.483456 0.231119 0.685164 8.832473 \n\
0.090983 0.369015 0.085583 0.046821 0.950521 0.183299 0.040785 0.391093 0.950288 0.075780 0.624335 0.041505 0.980672 3.915972 0.053806 0.299723 0.100663 \n\
0.152848 0.170981 0.594708 0.106099 2.051641 0.121416 0.047614 0.064377 8.167042 0.195540 0.352598 0.069186 0.465779 15.178886 0.058255 0.405459 0.201603 4.035822 \n\
2.140511 0.136453 0.145376 0.046174 4.011687 0.191618 0.192292 0.202844 0.174981 14.460840 2.175028 0.136317 2.393838 0.659302 0.418505 0.180248 3.585329 0.175143 0.281722 \n\
\n\
0.121953 0.076798 0.032215 0.066765 0.006842 0.061304 0.131841 0.026596 0.020392 0.047287 0.087919 0.084679 0.020970 0.024145 0.025871 0.042103 0.038715 0.008346 0.023841 0.051421;\n\
\n\
[ Other component ]\n\
model OthEHO =\n\
0.529263 \n\
0.379476 0.612335 \n\
0.516691 0.067732 4.012914 \n\
3.774890 1.615176 0.888663 0.165810 \n\
1.312262 2.913667 1.533683 0.442262 0.337571 \n\
1.403437 0.154460 0.333334 3.815893 0.015567 3.743866 \n\
1.272402 0.389317 1.243222 0.661976 0.554904 0.332656 0.319770 \n\
0.558733 2.816641 4.803000 0.761339 1.223662 4.889028 0.323617 0.300981 \n\
0.124057 0.155080 0.219635 0.019097 0.560959 0.100743 0.038076 0.005599 0.184752 \n\
0.340362 0.580087 0.119838 0.015948 1.192857 1.156516 0.083154 0.031031 0.646292 7.873544 \n\
0.706732 5.734632 1.847806 0.128114 0.050896 3.616626 1.131071 0.283950 0.643558 0.179831 0.224320 \n\
1.056749 0.665355 0.399943 0.053900 1.893946 2.299714 0.168079 0.085094 0.556024 8.136055 14.213193 0.931689 \n\
0.233961 0.079465 0.130295 0.016768 1.902244 0.077611 0.012655 0.048906 1.403178 1.581816 4.275863 0.036062 2.888633 \n\
1.518830 0.252482 0.049484 0.171011 0.108909 0.501196 0.346600 0.058913 0.299924 0.073007 0.297573 0.249478 0.091619 0.068920 \n\
5.595735 0.861017 3.749627 0.987083 4.952776 1.045071 0.463265 1.190738 0.897478 0.131753 0.265701 0.607097 0.399537 0.408758 0.993614 \n\
2.157458 0.613623 1.733380 0.361861 2.145775 1.011592 0.523086 0.091023 0.450662 1.492403 0.408418 1.143233 2.378569 0.131777 0.381007 7.574340 \n\
0.151895 0.544292 0.060182 0.043433 1.259614 0.228038 0.045082 0.134804 0.748147 0.134416 0.979277 0.038787 0.908253 4.850762 0.052415 0.249753 0.114232 \n\
0.219509 0.243507 0.580103 0.130214 2.325021 0.196580 0.079660 0.037482 6.907609 0.299245 0.552917 0.067894 0.685250 19.404995 0.047839 0.323207 0.183044 4.704884 \n\
3.049976 0.278740 0.134120 0.055382 4.149385 0.500946 0.435957 0.067170 0.214393 22.435652 2.883298 0.323886 3.369448 0.722571 0.315978 0.152899 2.423398 0.186495 0.303833 \n\
\n\
0.076458 0.052393 0.055429 0.088634 0.007473 0.040671 0.080952 0.100192 0.025439 0.031730 0.053100 0.070835 0.014039 0.023159 0.087111 0.063636 0.055346 0.007033 0.023779 0.042590;\n\
\n\
[ main definition of EHO with fixed component rates ]\n\
model EHO = MIX{ExtEHO:0.720274356,HelEHO:0.976798797,OthEHO:0.783109376};\n\
\n\
\n\
[ ---------------------------------------------------------\n\
    UL2 mixture model of Le, Lartillot & Gascuel (2008)\n\
 --------------------------------------------------------- ]\n\
\n\
model M1_UL2 =\n\
0.267149 \n\
0.211944 0.816250 \n\
0.156648 0.336150 3.110967 \n\
2.402535 1.001114 1.287205 0.467161 \n\
0.301870 3.168646 1.844180 0.571540 0.394361 \n\
0.503678 1.529332 0.788530 3.920399 0.234553 8.502278 \n\
3.124853 0.171548 0.220006 0.250690 0.766651 0.174653 0.399019 \n\
0.139279 1.597241 5.622886 2.146897 0.349557 8.097306 1.211287 0.044878 \n\
0.037158 0.139068 0.189483 0.049336 0.147864 0.122799 0.153664 0.006928 0.085276 \n\
0.108752 0.387538 0.092568 0.035815 0.399254 0.617370 0.225586 0.018972 0.202328 2.343778 \n\
0.255267 15.176345 1.030178 0.196011 0.396427 3.731061 2.642525 0.142626 0.878376 0.319044 0.422741 \n\
0.430988 0.522887 0.351960 0.102916 0.683070 2.247889 0.621957 0.070803 0.228871 2.780325 4.767336 1.450453 \n\
0.088392 0.116382 0.114044 0.066251 0.668683 0.133418 0.075116 0.039034 0.780377 0.488538 1.586897 0.143427 1.211385 \n\
1.303487 0.178064 0.192016 0.065259 0.315140 0.406966 0.144065 0.135536 0.273070 0.087171 0.298010 0.087701 0.165232 0.104423 \n\
7.472990 0.579607 3.004054 0.854304 5.789930 0.930019 0.709540 2.018826 0.527351 0.051443 0.070322 0.432286 0.281917 0.286341 0.473611 \n\
2.276542 0.392852 1.332166 0.193248 2.577504 0.541748 0.690939 0.052900 0.272814 0.634227 0.224553 0.795413 1.360016 0.120449 0.745729 6.088861 \n\
0.048841 0.673695 0.076107 0.073261 0.377566 0.284556 0.284138 0.130136 0.649073 0.047797 0.324911 0.148403 0.390301 2.189403 0.122493 0.131225 0.080727 \n\
0.073190 0.425791 0.503951 0.250485 0.577049 0.306036 0.198368 0.024991 3.987606 0.083215 0.127898 0.372637 0.179514 7.784255 0.089874 0.175724 0.117177 2.629196 \n\
1.351002 0.175990 0.120675 0.105544 1.491339 0.203270 0.463186 0.055506 0.065132 6.411609 1.020423 0.337618 1.047308 0.272790 0.407545 0.079844 1.634833 0.077263 0.083195 \n\
\n\
0.122413 0.017757 0.020209 0.012086 0.018894 0.014525 0.009897 0.045663 0.020120 0.124002 0.168915 0.011684 0.037631 0.063612 0.023347 0.039268 0.046707 0.015603 0.050968 0.136701;\n\
\n\
\n\
model M2_UL2 =\n\
0.557363 \n\
0.539068 0.465628 \n\
0.696831 0.032997 3.879799 \n\
1.480953 4.566841 1.777582 0.310752 \n\
1.402193 1.920868 1.276554 0.327085 0.972350 \n\
1.335667 0.096752 0.255510 2.685052 0.088385 2.281328 \n\
1.056193 0.423348 2.171283 0.933450 1.398738 0.369406 0.334900 \n\
0.729300 2.712485 5.461073 0.679965 5.202985 4.012284 0.282038 0.585359 \n\
0.267035 0.493033 0.523699 0.023230 2.563394 0.459103 0.176281 0.010013 0.551901 \n\
0.700687 0.932999 0.206875 0.025161 3.939537 1.918986 0.154733 0.085684 1.446302 8.189198 \n\
0.736759 3.603558 1.676442 0.070721 0.292188 2.403019 0.611829 0.307607 0.675279 0.627044 0.410941 \n\
1.505101 0.819561 0.736222 0.089302 4.462071 2.539203 0.250970 0.204790 0.654198 11.105816 15.171688 1.258549 \n\
0.541573 0.185468 0.343735 0.042217 5.958046 0.156533 0.064557 0.188906 3.891682 3.152154 5.098336 0.088022 4.518197 \n\
1.155460 0.142408 0.044854 0.175385 0.123605 0.316005 0.157783 0.157894 0.347393 0.047328 0.344717 0.153954 0.054635 0.108793 \n\
3.823040 0.733964 4.846938 0.890611 7.416660 0.987912 0.343107 2.296896 1.193558 0.368432 0.667347 0.535051 0.754875 1.469714 1.242760 \n\
1.897039 0.590040 2.371940 0.347041 1.619173 1.025240 0.479587 0.210934 0.728868 5.106169 0.726618 1.152768 3.985684 0.433442 0.358997 9.007029 \n\
0.296375 0.833840 0.091310 0.080326 5.217767 0.363445 0.078944 0.378088 1.571919 0.351013 2.139511 0.098671 2.796573 6.102504 0.023698 0.665667 0.292919 \n\
0.297444 0.206563 0.871576 0.173621 11.803422 0.181973 0.110832 0.073892 12.757344 1.161331 1.646025 0.101481 1.732368 29.335598 0.037045 0.706902 0.346859 5.666524 \n\
2.765737 0.415803 0.194725 0.093474 5.264577 0.734884 0.683342 0.156374 0.517626 26.038986 3.741256 0.457775 5.253478 1.999427 0.297563 0.344932 4.012753 0.385172 0.870088 \n\
\n\
0.087622 0.083588 0.048847 0.098882 0.002815 0.062809 0.143166 0.055391 0.023310 0.015495 0.032465 0.102135 0.009511 0.008409 0.069323 0.057733 0.051876 0.003945 0.014462 0.028216;\n\
\n\
model UL2 = MIX{M1_UL2:0.581348617,M2_UL2:1.465482789};\n\
\n\
\n\
[ ---------------------------------------------------------\n\
    UL3 mixture model of Le, Lartillot & Gascuel (2008)\n\
 --------------------------------------------------------- ]\n\
\n\
model Q1_UL3 =\n\
0.514865 \n\
0.774348 0.583403 \n\
0.854291 0.046141 2.011233 \n\
1.019817 5.652322 2.260587 0.057603 \n\
1.095968 1.696154 1.296536 0.417322 0.967032 \n\
1.054599 0.084924 0.368384 3.592374 0.063073 1.885301 \n\
3.510012 0.797055 1.759631 1.421695 2.627911 0.743770 0.772359 \n\
0.694799 2.596186 4.214186 0.654590 6.673533 3.664595 0.294967 0.608220 \n\
0.344837 0.543739 0.965435 0.062495 2.500862 0.452448 0.155720 0.083334 0.905291 \n\
0.593987 0.857922 0.351903 0.045358 3.290242 1.421539 0.109100 0.230693 1.595696 5.042430 \n\
0.708843 2.012940 1.662582 0.106190 0.329149 2.268825 0.579185 0.365374 0.696286 0.701896 0.398546 \n\
0.990080 0.754111 0.910436 0.143464 3.570847 1.708803 0.181804 0.706982 0.789517 8.138995 13.390024 1.137779 \n\
0.085639 0.012721 0.098898 0.018361 2.148695 0.012425 0.009316 0.135782 0.921964 1.006572 2.479349 0.014715 1.418875 \n\
0.655013 0.150052 0.120388 0.698261 0.254951 0.353826 0.250818 0.715043 0.329691 0.170251 0.827093 0.187804 0.178490 0.048299 \n\
2.863328 0.657706 3.761619 0.619692 9.817007 0.810603 0.344050 6.758412 0.997214 0.414623 0.625678 0.555290 0.647617 0.392859 0.929152 \n\
1.373936 0.392433 2.711122 0.237865 2.460302 0.701472 0.319136 0.607889 0.728133 3.705396 0.412346 0.953939 2.446017 0.054119 0.279699 9.934970 \n\
0.247598 0.514750 0.144529 0.157484 5.383077 0.199950 0.045688 0.790171 1.116595 0.243053 1.738186 0.070214 3.427855 3.275850 0.007577 0.583988 0.205721 \n\
0.090644 0.046952 0.326197 0.089450 7.475195 0.018555 0.020706 0.016617 3.728614 0.404819 0.617948 0.029889 0.956437 47.933104 0.050416 0.181180 0.070113 5.242459 \n\
2.093798 0.323334 0.307076 0.101486 8.553531 0.473023 0.410909 0.459941 0.568017 13.906640 1.778101 0.426825 2.763369 0.570421 0.311278 0.389524 2.915452 0.252168 0.268516 \n\
\n\
0.104307 0.092553 0.043722 0.085643 0.003218 0.074342 0.163928 0.024243 0.022216 0.016012 0.038591 0.105577 0.011434 0.016126 0.018057 0.061232 0.061373 0.004086 0.020876 0.032465;\n\
\n\
model Q2_UL3 =\n\
1.709484 \n\
0.184309 0.860448 \n\
0.660851 0.182073 4.471383 \n\
4.554487 2.843438 1.801073 1.068728 \n\
3.425703 6.092362 2.868388 0.790473 0.794773 \n\
4.278840 0.359055 0.585031 4.176143 0.121031 6.860012 \n\
0.625715 1.054231 1.222442 0.492366 1.418419 0.796035 0.643251 \n\
1.089116 6.396197 8.965630 1.915247 2.033352 11.058341 0.768162 0.523196 \n\
0.024545 0.023433 0.014686 0.002204 0.628823 0.008720 0.008363 0.002485 0.046726 \n\
0.150945 0.140520 0.002514 0.000212 1.903535 0.384413 0.015127 0.010251 0.210723 5.066207 \n\
1.751314 12.981698 3.641808 0.278298 0.036599 7.677610 2.744099 0.612733 1.686490 0.042380 0.023858 \n\
0.475876 0.364580 0.063143 0.001486 3.890832 0.754732 0.041044 0.024222 0.236955 5.752463 12.019762 0.229898 \n\
0.142125 0.051255 0.006503 0.000593 5.397699 0.064190 0.006871 0.015588 0.424840 1.005341 5.458275 0.021422 1.779060 \n\
5.433246 1.051312 0.012611 0.027267 0.635181 1.765792 0.849429 0.023324 0.610884 0.000184 0.037705 0.604166 0.001415 0.003197 \n\
6.267113 1.750009 5.986041 1.411952 5.482009 1.923966 0.595886 0.943724 1.786620 0.043381 0.066093 0.813893 0.053557 0.199095 1.723045 \n\
6.389458 1.828974 2.044599 1.561907 2.083626 2.070125 1.210529 0.217976 1.192222 0.515450 0.199809 2.020941 1.238100 0.150760 1.727569 9.882473 \n\
0.281689 1.180712 0.000006 0.017218 3.696424 0.146508 0.068518 0.222418 0.497727 0.199828 1.849405 0.001429 1.394852 2.473491 0.016401 0.288550 0.190290 \n\
0.302638 0.475135 0.196905 0.067615 6.355457 0.576342 0.232832 0.059485 4.525509 0.571811 1.194578 0.006674 0.467694 8.107893 0.024556 0.394389 0.441794 4.067825 \n\
11.333027 0.298555 0.053673 0.009846 5.743238 0.296166 0.413471 0.120393 0.105418 9.130937 2.674960 0.165290 4.417978 1.811161 0.492985 0.042803 3.284174 0.844277 2.327679 \n\
\n\
0.044015 0.021591 0.056258 0.102405 0.003260 0.018409 0.041364 0.168549 0.015843 0.064277 0.118096 0.036061 0.027358 0.036695 0.124914 0.047807 0.022696 0.005866 0.018644 0.025892;\n\
\n\
\n\
model Q3_UL3 =\n\
0.063622 \n\
0.118948 0.528684 \n\
0.065502 0.142677 12.092355 \n\
2.010382 0.302352 1.127688 0.014546 \n\
0.169022 2.026184 1.256016 0.417582 0.170493 \n\
0.172876 0.453837 0.454428 1.882165 0.045799 4.705997 \n\
5.254550 0.174422 0.364886 0.192790 0.891120 0.148450 0.195211 \n\
0.090586 1.258840 5.523808 0.313487 0.211550 4.734918 0.466811 0.096529 \n\
0.034911 0.065167 0.222440 0.023060 0.132230 0.122571 0.075521 0.003942 0.065261 \n\
0.146425 0.219004 0.136129 0.028165 0.448432 0.795591 0.146014 0.016718 0.240024 2.387089 \n\
0.041117 11.082325 0.783756 0.049843 0.039616 1.828161 0.649991 0.069199 0.271006 0.094864 0.140698 \n\
0.599734 0.230551 0.595641 0.059404 0.699534 2.765355 0.391569 0.089210 0.206188 3.020110 2.806927 0.516762 \n\
0.148889 0.145244 0.408811 0.089283 0.724422 0.260910 0.101509 0.101882 1.508086 0.693424 0.709933 0.061880 1.887041 \n\
0.378131 0.225548 0.181924 0.038283 0.146379 0.511097 0.151769 0.166424 0.386101 0.186116 0.753595 0.182723 0.420131 0.341199 \n\
8.340091 0.495564 3.010756 0.463573 5.601734 0.985082 0.415256 2.532014 0.720035 0.067860 0.121784 0.279698 0.626080 0.788724 0.890779 \n\
1.932342 0.358779 1.069003 0.093122 2.028674 0.637861 0.597230 0.019551 0.211054 0.870341 0.381670 0.461083 2.131453 0.255120 0.604567 3.450887 \n\
0.031419 0.378744 0.085588 0.008303 0.277628 0.277906 0.122038 0.055246 0.420382 0.021973 0.127345 0.027776 0.139098 3.077241 0.163299 0.177114 0.062650 \n\
0.106283 0.366786 1.453278 0.404793 0.753053 0.475024 0.273992 0.055936 7.367304 0.094629 0.126746 0.148716 0.369726 5.251757 0.232549 0.676796 0.247828 2.910495 \n\
1.104848 0.069287 0.110149 0.084224 1.280832 0.175361 0.342585 0.047507 0.038768 8.415916 1.577573 0.054532 1.537983 0.409619 0.309028 0.094413 1.483411 0.060147 0.076595 \n\
\n\
0.134055 0.044392 0.020730 0.020801 0.021008 0.024509 0.028587 0.029069 0.028138 0.105826 0.117458 0.049732 0.026120 0.038984 0.016306 0.038369 0.055334 0.017276 0.039905 0.143398;\n\
\n\
model UL3 = MIX{Q1_UL3:0.484340397,Q2_UL3:0.492780514,Q3_UL3:1.15597274};\n\
\n\
\n\
[ ---------------------------------------------------------\n\
    EX_EHO mixture model of Le & Gascuel (2010)\n\
 --------------------------------------------------------- ]\n\
\n\
\n\
model BUR_EXT =\n\
0.228492 \n\
0.165543 0.916344 \n\
0.238509 0.258514 8.498064 \n\
3.374029 1.037434 1.667702 0.332072 \n\
0.344742 4.971495 2.471912 0.654950 0.130301 \n\
0.417921 1.039226 0.875808 13.073209 0.040759 9.834742 \n\
4.248714 0.411876 0.585570 0.748848 0.908311 0.221633 0.593504 \n\
0.182762 3.872065 6.999812 1.719470 0.493863 8.695395 0.749303 0.137367 \n\
0.011705 0.090751 0.149898 0.021996 0.077693 0.043664 0.013820 0.001527 0.073342 \n\
0.133793 0.286232 0.065118 0.015540 0.456304 0.546974 0.052641 0.024196 0.226460 2.160734 \n\
0.249141 17.756919 3.385483 0.343780 0.093875 6.677050 2.745017 0.295602 1.481997 0.100576 0.167406 \n\
0.641194 0.342577 0.427146 0.059345 0.867233 2.306480 0.218260 0.058613 0.358032 2.187901 5.151337 0.750049 \n\
0.118366 0.068606 0.102572 0.009357 0.633943 0.033356 0.012944 0.024474 0.497973 0.534407 1.581972 0.063281 1.329239 \n\
1.561052 0.483968 0.385170 0.261437 0.310131 0.913924 0.355871 0.175520 0.512823 0.019789 0.295416 0.348527 0.104569 0.059641 \n\
5.891807 1.320618 5.737159 1.074011 4.702782 1.389531 0.878480 2.178078 1.111068 0.033343 0.094349 1.035903 0.327901 0.292022 1.344678 \n\
2.059884 0.976165 2.166428 0.369522 1.951862 0.815145 0.575774 0.060834 0.558388 0.422299 0.153549 1.793263 1.268126 0.085468 0.780914 9.031309 \n\
0.081683 0.814216 0.057557 0.055146 0.450959 0.191881 0.109420 0.144367 0.651978 0.068649 0.345622 0.169527 0.387902 1.883741 0.023466 0.309129 0.111568 \n\
0.052650 0.248907 0.570101 0.180267 0.701260 0.253975 0.061388 0.025465 4.206114 0.083799 0.147600 0.226848 0.254720 6.549427 0.027521 0.283138 0.141408 2.561108 \n\
1.355342 0.137437 0.104597 0.051387 1.203830 0.218892 0.194527 0.031054 0.088935 4.577473 1.003647 0.153722 0.883283 0.242657 0.191295 0.068785 0.990922 0.056276 0.078264 \n\
\n\
0.087158 0.015906 0.012970 0.012566 0.020325 0.013301 0.013777 0.039603 0.014597 0.161107 0.147775 0.011033 0.031334 0.064281 0.013322 0.035417 0.048583 0.012672 0.045210 0.199064;\n\
\n\
\n\
model BUR_HEL =\n\
0.317211 \n\
0.209784 1.120865 \n\
0.315205 0.301050 7.439896 \n\
2.214446 0.884449 1.356293 0.110768 \n\
0.465495 4.319791 2.843187 1.082540 0.215988 \n\
0.668735 0.901135 0.986572 11.245156 0.009874 7.561773 \n\
3.614157 0.568883 0.972660 1.036117 0.894733 0.409083 0.780808 \n\
0.249929 3.138701 7.344935 1.747672 0.379845 9.559763 0.842239 0.146008 \n\
0.059633 0.103290 0.206475 0.017492 0.286194 0.123433 0.037593 0.010910 0.071273 \n\
0.096230 0.285199 0.113728 0.015874 0.439724 0.547078 0.063675 0.021607 0.303531 2.097349 \n\
0.380075 15.783354 2.780107 0.569108 0.093004 6.179905 3.209588 0.413960 1.002075 0.185911 0.185249 \n\
0.371379 0.411553 0.398602 0.076761 0.727245 1.665645 0.249045 0.068128 0.256194 2.940308 3.649539 0.972247 \n\
0.075616 0.043519 0.096446 0.041118 0.636688 0.102460 0.039991 0.041269 0.839126 0.376556 1.551814 0.064774 1.173962 \n\
1.100574 0.385197 0.319458 0.353000 0.112549 0.805706 0.369483 0.482895 0.520098 0.058167 0.144341 0.361488 0.074069 0.057968 \n\
6.832958 0.955160 5.296628 1.265211 6.144756 1.315182 0.902504 3.903795 0.862633 0.072343 0.080478 0.979654 0.330305 0.328917 1.924898 \n\
2.223205 0.445571 2.461831 0.299635 2.943208 0.830637 0.621903 0.184055 0.468356 0.911139 0.208091 1.343261 1.515339 0.158763 0.915879 9.298787 \n\
0.062541 0.806724 0.110928 0.132125 0.414525 0.388313 0.191952 0.271274 0.909529 0.025790 0.343842 0.099137 0.543577 2.467147 0.044938 0.215329 0.087955 \n\
0.082948 0.329591 0.693402 0.286594 0.866329 0.259566 0.167425 0.049038 6.332054 0.093136 0.177755 0.275998 0.261754 8.344684 0.088981 0.335859 0.137177 3.125017 \n\
1.390479 0.142986 0.175068 0.106294 1.687293 0.159520 0.297915 0.080925 0.085103 6.414688 0.953785 0.240157 1.097345 0.264988 0.373870 0.144230 2.572837 0.089110 0.115941 \n\
\n\
0.158060 0.021566 0.016487 0.014079 0.016937 0.020232 0.023096 0.032822 0.014618 0.114447 0.198900 0.014668 0.042840 0.053434 0.015640 0.037275 0.043095 0.012211 0.036330 0.113263;\n\
\n\
model BUR_OTH =\n\
0.406682 \n\
0.246649 0.848592 \n\
0.364260 0.198690 4.535840 \n\
3.292044 0.837291 1.295138 0.420726 \n\
0.735862 4.205085 2.062501 0.427451 0.259335 \n\
0.954795 0.673046 0.671062 8.395674 0.048284 8.922739 \n\
1.958847 0.573207 0.632317 0.572264 0.486274 0.345345 0.650009 \n\
0.312042 2.699661 4.969855 1.181781 0.551188 7.620453 0.701108 0.195346 \n\
0.071000 0.127041 0.184028 0.030240 0.180591 0.065984 0.039235 0.005033 0.098525 \n\
0.142298 0.338853 0.086876 0.026095 0.484427 0.867777 0.087780 0.017129 0.309774 3.477136 \n\
0.624622 18.390649 2.748646 0.442886 0.238266 6.993941 3.906971 0.652336 1.365814 0.219252 0.288480 \n\
0.610604 0.581287 0.382156 0.048508 0.963147 2.672887 0.384585 0.051334 0.386066 3.752286 6.858529 1.524446 \n\
0.124670 0.047666 0.102656 0.031532 0.699124 0.129867 0.004923 0.039185 0.701690 0.643782 2.019473 0.104308 1.568249 \n\
1.126387 0.321347 0.107738 0.137858 0.150346 0.601413 0.310374 0.073794 0.332910 0.056230 0.208204 0.368816 0.078902 0.062410 \n\
5.908551 0.834735 3.611589 0.969189 4.765870 0.881934 0.528944 1.439305 0.746876 0.060111 0.114374 0.784754 0.235963 0.219009 0.710100 \n\
1.856381 0.574277 1.573584 0.223054 2.038789 0.763848 0.461329 0.076195 0.396095 0.701247 0.249302 1.091322 1.282643 0.070553 0.419070 6.616977 \n\
0.069294 0.654056 0.127255 0.078896 0.517561 0.188732 0.125541 0.104279 0.547504 0.066927 0.454998 0.056498 0.425274 2.668838 0.050943 0.151483 0.062698 \n\
0.128158 0.354167 0.640140 0.182565 0.793990 0.368725 0.157796 0.037084 4.307140 0.140691 0.241076 0.323966 0.293629 9.711414 0.060323 0.207489 0.111492 2.857446 \n\
1.982761 0.158227 0.115545 0.051117 2.065903 0.338262 0.258245 0.045770 0.089942 10.113118 1.382024 0.431385 1.456614 0.295718 0.273919 0.066465 1.668063 0.113899 0.144981 \n\
\n\
0.102123 0.021199 0.032404 0.032350 0.018985 0.017469 0.017625 0.089270 0.021090 0.083642 0.123866 0.012720 0.029789 0.055399 0.072705 0.061298 0.061705 0.013496 0.039682 0.093184;\n\
\n\
model EXP_EXT=\n\
0.464716 \n\
0.597009 0.420578 \n\
1.010693 0.048553 5.944290 \n\
3.915828 2.088244 0.878468 0.236108 \n\
1.156023 1.882317 1.435926 0.338823 0.482742 \n\
1.131098 0.127150 0.346338 3.317186 0.061060 2.724696 \n\
4.638659 0.351041 1.379174 1.216518 1.396050 0.199361 0.353970 \n\
0.657615 2.215990 4.150252 0.717363 1.853969 3.768864 0.347165 0.313421 \n\
0.078558 0.127092 0.347281 0.032361 0.605448 0.171553 0.104678 0.010608 0.309418 \n\
0.516672 0.510585 0.105529 0.039188 1.808273 1.017577 0.112010 0.044661 0.772131 5.693102 \n\
0.519389 3.571104 1.844049 0.109305 0.103105 2.232749 0.653339 0.195325 0.547017 0.219311 0.253086 \n\
1.658261 0.640712 0.558751 0.063591 1.694880 2.088441 0.194697 0.291701 0.321392 6.220456 12.392618 0.862547 \n\
0.426071 0.064894 0.132019 0.034872 2.076573 0.085745 0.026972 0.099963 1.388250 1.765294 3.859637 0.032198 3.134107 \n\
3.082729 0.250470 0.232578 0.376163 0.290522 0.502379 0.240501 0.302007 0.283950 0.013574 0.606936 0.248475 0.226716 0.058246 \n\
7.012884 0.866957 5.008997 0.814153 4.758346 1.192080 0.595351 2.514269 0.993487 0.135167 0.349525 0.542021 0.512591 0.744682 1.258172 \n\
2.037755 0.446367 1.618299 0.203392 1.177421 0.840646 0.583757 0.071515 0.466886 1.503883 0.260405 0.934230 2.245607 0.123552 0.258896 4.504833 \n\
0.171334 0.385971 0.087717 0.019596 1.015512 0.127027 0.037725 0.217844 0.822780 0.095756 0.777332 0.039952 0.977419 3.217291 0.015240 0.301259 0.102153 \n\
0.194998 0.091803 0.433021 0.086495 3.074882 0.111578 0.041481 0.048438 4.904785 0.336528 0.411742 0.087476 0.640594 14.126821 0.061656 0.338111 0.129249 2.902137 \n\
2.811391 0.216605 0.127240 0.061503 2.320268 0.390874 0.450783 0.132513 0.234279 12.181354 2.539512 0.233848 3.363159 0.717467 0.138035 0.159602 1.615372 0.132268 0.186175 \n\
\n\
0.043140 0.090761 0.034408 0.052848 0.006370 0.053817 0.107749 0.024812 0.029498 0.049134 0.050167 0.098127 0.013722 0.025841 0.037395 0.056505 0.094326 0.012045 0.039238 0.080099;\n\
\n\
model EXP_HEL =\n\
0.434227 \n\
0.551823 0.569806 \n\
0.698268 0.056291 3.064314 \n\
2.026002 2.379205 1.077282 0.016649 \n\
0.986617 1.606282 1.331570 0.426399 0.409724 \n\
1.005936 0.120122 0.390888 2.999742 0.021217 1.881156 \n\
3.221202 0.736168 2.269617 1.272893 1.771711 0.622430 0.656603 \n\
0.515574 2.032567 5.484997 0.666491 2.985549 3.380526 0.265244 0.557878 \n\
0.200810 0.241566 0.441585 0.009830 1.541200 0.198621 0.069562 0.043838 0.339616 \n\
0.328669 0.583849 0.178015 0.022077 2.045404 1.046125 0.089148 0.104708 0.875298 8.628242 \n\
0.598864 3.090263 1.682415 0.113637 0.207957 2.085253 0.582536 0.376534 0.554395 0.371883 0.290692 \n\
0.799278 0.528354 0.704087 0.062290 2.303849 1.507620 0.173293 0.356580 0.492228 10.028453 12.162732 0.867109 \n\
0.256227 0.083117 0.192262 0.030759 4.328951 0.078062 0.022890 0.181917 2.406824 2.014776 4.856941 0.041675 3.521229 \n\
1.118844 0.147481 0.061969 0.323498 0.171678 0.387521 0.237715 0.641036 0.433529 0.069102 0.359935 0.164055 0.063832 0.126592 \n\
5.069051 0.749554 5.245486 0.840686 7.114530 1.177802 0.382956 6.139836 1.086779 0.194824 0.424579 0.655759 0.682174 0.753148 1.355810 \n\
2.949741 0.623328 3.248881 0.406219 3.345739 1.214278 0.538553 0.867954 0.747654 3.316346 0.754081 1.193593 3.516479 0.366653 0.622665 7.975653 \n\
0.115446 0.394156 0.090971 0.055309 1.947845 0.185912 0.046886 0.451084 1.173014 0.277029 1.078778 0.054622 1.516237 5.813526 0.071865 0.359167 0.106921 \n\
0.205680 0.197878 0.678775 0.118188 4.183184 0.139485 0.059999 0.051336 10.200670 0.507328 0.721921 0.086974 0.741023 24.191458 0.046460 0.489820 0.247367 4.904042 \n\
2.494211 0.280293 0.235248 0.083648 5.509932 0.429196 0.409105 0.447130 0.351675 23.404006 3.840750 0.300727 4.126659 1.483049 0.675560 0.336101 4.426709 0.309940 0.588217 \n\
\n\
0.115826 0.094038 0.037357 0.085821 0.003363 0.073078 0.167709 0.025416 0.021634 0.024147 0.050238 0.106612 0.013318 0.013330 0.029895 0.044902 0.037901 0.006460 0.018548 0.030407;\n\
\n\
model EXP_OTH =\n\
0.603175 \n\
0.478745 0.562615 \n\
0.608325 0.056553 3.755571 \n\
2.371839 2.480665 0.889513 0.170707 \n\
1.551117 2.685995 1.462350 0.424139 0.669728 \n\
1.624084 0.129505 0.314826 3.404205 0.049823 3.375473 \n\
0.987777 0.356744 1.294077 0.640234 0.583980 0.331879 0.304731 \n\
0.667236 2.788429 4.719171 0.731257 1.872668 4.612209 0.316233 0.320454 \n\
0.186911 0.269245 0.318538 0.028464 0.987958 0.242926 0.090427 0.007312 0.327205 \n\
0.527992 0.844027 0.167295 0.021423 1.623589 1.636879 0.135662 0.044560 0.939347 10.338048 \n\
0.842575 5.076266 1.736167 0.106076 0.132985 3.365869 0.969736 0.270931 0.669196 0.356829 0.352830 \n\
1.296147 0.863599 0.469732 0.075018 1.832599 2.642602 0.217378 0.107935 0.624941 10.670411 17.593544 1.247987 \n\
0.325034 0.135328 0.192352 0.021631 2.731423 0.103263 0.027708 0.060740 2.148472 2.344767 5.497995 0.057563 3.278627 \n\
1.670091 0.235642 0.042844 0.164518 0.112539 0.479958 0.326780 0.057540 0.291899 0.110067 0.380466 0.240061 0.109541 0.083760 \n\
5.098150 0.831455 3.661924 0.978777 4.500240 1.064732 0.455496 1.095629 0.915898 0.226713 0.405000 0.608323 0.525496 0.593321 1.035726 \n\
2.174502 0.630453 1.791747 0.396219 1.681712 1.083797 0.556968 0.100584 0.457070 2.361119 0.543612 1.211816 2.987220 0.198957 0.368383 7.505908 \n\
0.203719 0.615713 0.044203 0.046952 1.745090 0.303876 0.050920 0.155176 0.920001 0.165182 1.385828 0.055323 1.274920 5.896599 0.059081 0.303111 0.156402 \n\
0.271220 0.253084 0.643377 0.142691 3.763228 0.209729 0.093004 0.035856 8.167503 0.490579 0.894778 0.077103 1.029700 26.210400 0.045876 0.373529 0.218567 5.726440 \n\
3.470639 0.410713 0.180011 0.081584 4.323431 0.751254 0.686467 0.086874 0.318032 29.800262 3.856040 0.482930 4.862267 1.182403 0.390522 0.268937 2.836818 0.229423 0.453335 \n\
\n\
0.071716 0.058979 0.060316 0.101089 0.005039 0.044673 0.093349 0.105394 0.026228 0.020220 0.037831 0.081647 0.010677 0.015875 0.090566 0.065046 0.054453 0.005546 0.019924 0.031432;\n\
\n\
\n\
model EX_EHO = MIX{BUR_EXT:0.761816796788931,BUR_HEL:0.744425646802117,BUR_OTH:0.532457759429489,EXP_EXT:1.5639387472863,EXP_HEL:2.06403411829438,EXP_OTH:1.43336795177594};\n\
\n\
\n\
[ ---------------------------------------------------------\n\
    LG4M mixture model of Le, Dang & Gascuel (2012)\n\
 --------------------------------------------------------- ]\n\
\n\
model LG4M1 =\n\
 0.269343\n\
 0.254612 0.150988\n\
 0.236821 0.031863 0.659648\n\
 2.506547 0.938594 0.975736 0.175533\n\
 0.359080 0.348288 0.697708 0.086573 0.095967\n\
 0.304674 0.156000 0.377704 0.449140 0.064706 4.342595\n\
 1.692015 0.286638 0.565095 0.380358 0.617945 0.202058 0.264342\n\
 0.251974 0.921633 1.267609 0.309692 0.390429 2.344059 0.217750 0.104842\n\
 1.085220 0.325624 0.818658 0.037814 1.144150 0.534567 0.222793 0.062682 0.567431\n\
 0.676353 0.602366 0.217027 0.007533 1.595775 0.671143 0.158424 0.070463 0.764255 8.226528\n\
 0.179155 0.971338 1.343718 0.133744 0.122468 0.983857 0.994128 0.220916 0.410581 0.387487 0.181110\n\
 1.636817 0.515217 0.670461 0.071252 1.534848 5.288642 0.255628 0.094198 0.257229 25.667158 6.819689 1.591212\n\
 0.235498 0.123932 0.099793 0.030425 0.897279 0.112229 0.022529 0.047488 0.762914 1.344259 0.865691 0.038921 2.030833\n\
 1.265605 0.040163 0.173354 0.027579 0.259961 0.580374 0.088041 0.145595 0.143676 0.298859 1.020117 0.000714 0.190019 0.093964\n\
 5.368405 0.470952 5.267140 0.780505 4.986071 0.890554 0.377949 1.755515 0.786352 0.527246 0.667783 0.659948 0.731921 0.837669 1.355630\n\
 1.539394 0.326789 1.688169 0.283738 1.389282 0.329821 0.231770 0.117017 0.449977 3.531600 0.721586 0.497588 2.691697 0.152088 0.698040 16.321298\n\
 0.140944 0.375611 0.025163 0.002757 0.801456 0.257253 0.103678 0.132995 0.345834 0.377156 0.839647 0.176970 0.505682 1.670170 0.091298 0.210096 0.013165\n\
 0.199836 0.146857 0.806275 0.234246 1.436970 0.319669 0.010076 0.036859 3.503317 0.598632 0.738969 0.154436 0.579000 4.245524 0.074524 0.454195 0.232913 1.178490\n\
 9.435529 0.285934 0.395670 0.130890 6.097263 0.516259 0.503665 0.222960 0.149143 13.666175 2.988174 0.162725 5.973826 0.843416 0.597394 0.701149 4.680002 0.300085 0.416262\n\
\n\
0.082276 0.055172 0.043853 0.053484 0.018957 0.028152 0.046679 0.157817 0.033297 0.028284 0.054284 0.025275 0.023665 0.041874 0.063071 0.066501 0.065424 0.023837 0.038633 0.049465;\n\
\n\
model LG4M2 =\n\
0.133720\n\
 0.337212 0.749052\n\
 0.110918 0.105087 4.773487\n\
 3.993460 0.188305 1.590332 0.304942\n\
 0.412075 2.585774 1.906884 0.438367 0.242076\n\
 0.435295 0.198278 0.296366 7.470333 0.008443 3.295515\n\
 7.837540 0.164607 0.431724 0.153850 1.799716 0.269744 0.242866\n\
 0.203872 2.130334 9.374479 1.080878 0.152458 12.299133 0.279589 0.089714\n\
 0.039718 0.024553 0.135254 0.014979 0.147498 0.033964 0.005585 0.007248 0.022746\n\
 0.075784 0.080091 0.084971 0.014128 0.308347 0.500836 0.022833 0.022999 0.161270 1.511682\n\
 0.177662 10.373708 1.036721 0.038303 0.043030 2.181033 0.321165 0.103050 0.459502 0.021215 0.078395\n\
 0.420784 0.192765 0.329545 0.008331 0.883142 1.403324 0.168673 0.160728 0.612573 1.520889 7.763266 0.307903\n\
 0.071268 0.019652 0.088753 0.013547 0.566609 0.071878 0.020050 0.041022 0.625361 0.382806 1.763059 0.044644 1.551911\n\
 0.959127 1.496585 0.377794 0.332010 0.318192 1.386970 0.915904 0.224255 2.611479 0.029351 0.068250 1.542356 0.047525 0.182715\n\
 11.721512 0.359408 2.399158 0.219464 9.104192 0.767563 0.235229 3.621219 0.971955 0.033780 0.043035 0.236929 0.319964 0.124977 0.840651\n\
 2.847068 0.218463 1.855386 0.109808 4.347048 0.765848 0.164569 0.312024 0.231569 0.356327 0.159597 0.403210 1.135162 0.106903 0.269190 9.816481\n\
 0.030203 0.387292 0.118878 0.067287 0.190240 0.122113 0.007023 0.137411 0.585141 0.020634 0.228824 0.000122 0.474862 3.135128 0.030313 0.093830 0.119152\n\
 0.067183 0.130101 0.348730 0.061798 0.301198 0.095382 0.095764 0.044628 2.107384 0.046105 0.100117 0.017073 0.192383 8.367641 0.000937 0.137416 0.044722 4.179782\n\
 0.679398 0.041567 0.092408 0.023701 1.271187 0.115566 0.055277 0.086988 0.060779 8.235167 0.609420 0.061764 0.581962 0.184187 0.080246 0.098033 1.438350 0.023439 0.039124\n\
\n\
0.120900 0.036460 0.026510 0.040410 0.015980 0.021132 0.025191 0.036369 0.015884 0.111029 0.162852 0.024820 0.028023 0.074058 0.012065 0.041963 0.039072 0.012666 0.040478 0.114137;\n\
\n\
model LG4M3 =\n\
0.421017\n\
 0.316236 0.693340\n\
 0.285984 0.059926 6.158219\n\
 4.034031 1.357707 0.708088 0.063669\n\
 0.886972 2.791622 1.701830 0.484347 0.414286\n\
 0.760525 0.233051 0.378723 4.032667 0.081977 4.940411\n\
 0.754103 0.402894 2.227443 1.102689 0.416576 0.459376 0.508409\n\
 0.571422 2.319453 5.579973 0.885376 1.439275 4.101979 0.576745 0.428799\n\
 0.162152 0.085229 0.095692 0.006129 0.490937 0.104843 0.045514 0.004705 0.098934\n\
 0.308006 0.287051 0.056994 0.007102 0.958988 0.578990 0.067119 0.024403 0.342983 3.805528\n\
 0.390161 7.663209 1.663641 0.105129 0.135029 3.364474 0.652618 0.457702 0.823674 0.129858 0.145630\n\
 1.042298 0.364551 0.293222 0.037983 1.486520 1.681752 0.192414 0.070498 0.222626 4.529623 4.781730 0.665308\n\
 0.362476 0.073439 0.129245 0.020078 1.992483 0.114549 0.023272 0.064490 1.491794 1.113437 2.132006 0.041677 1.928654\n\
 1.755491 0.087050 0.099325 0.163817 0.242851 0.322939 0.062943 0.198698 0.192904 0.062948 0.180283 0.059655 0.129323 0.065778\n\
 3.975060 0.893398 5.496314 1.397313 3.575120 1.385297 0.576191 1.733288 1.021255 0.065131 0.129115 0.600308 0.387276 0.446001 1.298493\n\
 2.565079 0.534056 2.143993 0.411388 2.279084 0.893006 0.528209 0.135731 0.518741 0.972662 0.280700 0.890086 1.828755 0.189028 0.563778 7.788147\n\
 0.283631 0.497926 0.075454 0.043794 1.335322 0.308605 0.140137 0.150797 1.409726 0.119868 0.818331 0.080591 1.066017 3.754687 0.073415 0.435046 0.197272\n\
 0.242513 0.199157 0.472207 0.085937 2.039787 0.262751 0.084578 0.032247 7.762326 0.153966 0.299828 0.117255 0.438215 14.506235 0.089180 0.352766 0.215417 5.054245\n\
 2.795818 0.107130 0.060909 0.029724 2.986426 0.197267 0.196977 0.044327 0.116751 7.144311 1.848622 0.118020 1.999696 0.705747 0.272763 0.096935 1.820982 0.217007 0.172975\n\
\n\
0.072639 0.051691 0.038642 0.055580 0.009829 0.031374 0.048731 0.065283 0.023791 0.086640 0.120847 0.052177 0.026728 0.032589 0.039238 0.046748 0.053361 0.008024 0.037426 0.098662;\n\
\n\
model LG4M4 =\n\
0.576160\n\
 0.567606 0.498643\n\
 0.824359 0.050698 3.301401\n\
 0.822724 4.529235 1.291808 0.101930\n\
 1.254238 2.169809 1.427980 0.449474 0.868679\n\
 1.218615 0.154502 0.411471 3.172277 0.050239 2.138661\n\
 1.803443 0.604673 2.125496 1.276384 1.598679 0.502653 0.479490\n\
 0.516862 2.874265 4.845769 0.719673 3.825677 4.040275 0.292773 0.596643\n\
 0.180898 0.444586 0.550969 0.023542 2.349573 0.370160 0.142187 0.016618 0.500788\n\
 0.452099 0.866322 0.201033 0.026731 2.813990 1.645178 0.135556 0.072152 1.168817 5.696116\n\
 0.664186 2.902886 2.101971 0.127988 0.200218 2.505933 0.759509 0.333569 0.623100 0.547454 0.363656\n\
 0.864415 0.835049 0.632649 0.079201 2.105931 1.633544 0.216462 0.252419 0.665406 7.994105 11.751178 1.096842\n\
 0.324478 0.208947 0.280339 0.041683 4.788477 0.107022 0.067711 0.171320 3.324779 2.965328 5.133843 0.084856 4.042591\n\
 1.073043 0.173826 0.041985 0.270336 0.121299 0.351384 0.228565 0.225318 0.376089 0.058027 0.390354 0.214230 0.058954 0.126299\n\
 3.837562 0.884342 4.571911 0.942751 6.592827 1.080063 0.465397 3.137614 1.119667 0.362516 0.602355 0.716940 0.506796 1.444484 1.432558\n\
 2.106026 0.750016 2.323325 0.335915 1.654673 1.194017 0.617231 0.318671 0.801030 4.455842 0.580191 1.384210 3.522468 0.473128 0.432718 5.716300\n\
 0.163720 0.818102 0.072322 0.068275 3.305436 0.373790 0.054323 0.476587 1.100360 0.392946 1.703323 0.085720 1.725516 5.436253 0.053108 0.498594 0.231832\n\
 0.241167 0.302440 1.055095 0.246940 9.741942 0.249895 0.129973 0.052363 11.542498 1.047449 1.319667 0.139770 1.330225 26.562270 0.046986 0.737653 0.313460 5.165098\n\
 1.824586 0.435795 0.179086 0.091739 3.609570 0.649507 0.656681 0.225234 0.473437 19.897252 3.001995 0.452926 3.929598 1.692159 0.370204 0.373501 3.329822 0.326593 0.860743\n\
\n\
0.104843 0.078835 0.043513 0.090498 0.002924 0.066163 0.151640 0.038843 0.022556 0.018383 0.038687 0.104462 0.010166 0.009089 0.066950 0.053667 0.049486 0.004409 0.012924 0.031963;\n\
\n\
model LG4M = MIX{LG4M1,LG4M2,LG4M3,LG4M4}*G4;\n\
model LG4  = MIX{LG4M1,LG4M2,LG4M3,LG4M4}*G4;\n\
\n\
\n\
[ ---------------------------------------------------------\n\
    LG4X mixture model of Le, Dang & Gascuel (2012)\n\
 --------------------------------------------------------- ]\n\
\n\
model LG4X1 =\n\
0.295719\n\
0.067388 0.448317\n\
0.253712 0.457483 2.358429\n\
1.029289 0.576016 0.251987 0.189008\n\
0.107964 1.741924 0.216561 0.599450 0.029955\n\
0.514644 0.736017 0.503084 109.901504 0.084794 4.117654\n\
10.868848 0.704334 0.435271 1.070052 1.862626 0.246260 1.202023\n\
0.380498 5.658311 4.873453 5.229858 0.553477 6.508329 1.634845 0.404968\n\
0.084223 0.123387 0.090748 0.052764 0.151733 0.054187 0.060194 0.048984 0.204296\n\
0.086976 0.221777 0.033310 0.021407 0.230320 0.195703 0.069359 0.069963 0.504221 1.495537\n\
0.188789 93.433377 0.746537 0.621146 0.096955 1.669092 2.448827 0.256662 1.991533 0.091940 0.122332\n\
0.286389 0.382175 0.128905 0.081091 0.352526 0.810168 0.232297 0.228519 0.655465 1.994320 3.256485 0.457430\n\
0.155567 0.235965 0.127321 0.205164 0.590018 0.066081 0.064822 0.241077 6.799829 0.754940 2.261319 0.163849 1.559944\n\
1.671061 6.535048 0.904011 5.164456 0.386853 2.437439 3.537387 4.320442 11.291065 0.170343 0.848067 5.260446 0.426508 0.438856\n\
2.132922 0.525521 0.939733 0.747330 1.559564 0.165666 0.435384 3.656545 0.961142 0.050315 0.064441 0.360946 0.132547 0.306683 4.586081\n\
0.529591 0.303537 0.435450 0.308078 0.606648 0.106333 0.290413 0.290216 0.448965 0.372166 0.102493 0.389413 0.498634 0.109129 2.099355 3.634276\n\
0.115551 0.641259 0.046646 0.260889 0.587531 0.093417 0.280695 0.307466 6.227274 0.206332 0.459041 0.033291 0.559069 18.392863 0.411347 0.101797 0.034710\n\
0.102453 0.289466 0.262076 0.185083 0.592318 0.035149 0.105999 0.096556 20.304886 0.097050 0.133091 0.115301 0.264728 66.647302 0.476350 0.148995 0.063603 20.561407\n\
0.916683 0.102065 0.043986 0.080708 0.885230 0.072549 0.206603 0.306067 0.205944 5.381403 0.561215 0.112593 0.693307 0.400021 0.584622 0.089177 0.755865 0.133790 0.154902\n\
\n\
0.147383 0.017579 0.058208 0.017707 0.026331 0.041582 0.017494 0.027859 0.011849 0.076971 0.147823 0.019535 0.037132 0.029940 0.008059 0.088179 0.089653 0.006477 0.032308 0.097931;\n\
\n\
model LG4X2 =\n\
 0.066142\n\
 0.590377 0.468325\n\
 0.069930 0.013688 2.851667\n\
 9.850951 0.302287 3.932151 0.146882\n\
 1.101363 1.353957 8.159169 0.249672 0.582670\n\
 0.150375 0.028386 0.219934 0.560142 0.005035 3.054085\n\
 0.568586 0.037750 0.421974 0.046719 0.275844 0.129551 0.037250\n\
 0.051668 0.262130 2.468752 0.106259 0.098208 4.210126 0.029788 0.013513\n\
 0.127170 0.016923 0.344765 0.003656 0.445038 0.165753 0.008541 0.002533 0.031779\n\
 0.292429 0.064289 0.210724 0.004200 1.217010 1.088704 0.014768 0.005848 0.064558 7.278994\n\
 0.071458 0.855973 1.172204 0.014189 0.033969 1.889645 0.125869 0.031390 0.065585 0.029917 0.042762\n\
 1.218562 0.079621 0.763553 0.009876 1.988516 3.344809 0.056702 0.021612 0.079927 7.918203 14.799537 0.259400\n\
 0.075144 0.011169 0.082464 0.002656 0.681161 0.111063 0.004186 0.004854 0.095591 0.450964 1.506485 0.009457 1.375871\n\
 7.169085 0.161937 0.726566 0.040244 0.825960 2.067758 0.110993 0.129497 0.196886 0.169797 0.637893 0.090576 0.457399 0.143327\n\
 30.139501 0.276530 11.149790 0.267322 18.762977 3.547017 0.201148 0.976631 0.408834 0.104288 0.123793 0.292108 0.598048 0.328689 3.478333\n\
 13.461692 0.161053 4.782635 0.053740 11.949233 2.466507 0.139705 0.053397 0.126088 1.578530 0.641351 0.297913 4.418398 0.125011 2.984862 13.974326\n\
 0.021372 0.081472 0.058046 0.006597 0.286794 0.188236 0.009201 0.019475 0.037226 0.015909 0.154810 0.017172 0.239749 0.562720 0.061299 0.154326 0.060703\n\
 0.045779 0.036742 0.498072 0.027639 0.534219 0.203493 0.012095 0.004964 0.452302 0.094365 0.140750 0.021976 0.168432 1.414883 0.077470 0.224675 0.123480 0.447011\n\
 4.270235 0.030342 0.258487 0.012745 4.336817 0.281953 0.043812 0.015539 0.016212 16.179952 3.416059 0.032578 2.950318 0.227807 1.050562 0.112000 5.294490 0.033381 0.045528\n\
\n\
0.063139 0.066357 0.011586 0.066571 0.010800 0.009276 0.053984 0.146986 0.034214 0.088822 0.098196 0.032390 0.021263 0.072697 0.016761 0.020711 0.020797 0.025463 0.045615 0.094372;\n\
\n\
model LG4X3 =\n\
 0.733336\n\
 0.558955 0.597671\n\
 0.503360 0.058964 5.581680\n\
 4.149599 2.863355 1.279881 0.225860\n\
 1.415369 2.872594 1.335650 0.434096 1.043232\n\
 1.367574 0.258365 0.397108 2.292917 0.209978 4.534772\n\
 1.263002 0.366868 1.840061 1.024707 0.823594 0.377181 0.496780\n\
 0.994098 2.578946 5.739035 0.821921 3.039380 4.877840 0.532488 0.398817\n\
 0.517204 0.358350 0.284730 0.027824 1.463390 0.370939 0.232460 0.008940 0.349195\n\
 0.775054 0.672023 0.109781 0.021443 1.983693 1.298542 0.169219 0.043707 0.838324 5.102837\n\
 0.763094 5.349861 1.612642 0.088850 0.397640 3.509873 0.755219 0.436013 0.888693 0.561690 0.401070\n\
 1.890137 0.691594 0.466979 0.060820 2.831098 2.646440 0.379926 0.087640 0.488389 7.010411 8.929538 1.357738\n\
 0.540460 0.063347 0.141582 0.018288 4.102068 0.087872 0.020447 0.064863 1.385133 3.054968 5.525874 0.043394 3.135353\n\
 0.200122 0.032875 0.019509 0.042687 0.059723 0.072299 0.023282 0.036426 0.050226 0.039318 0.067505 0.023126 0.012695 0.015631\n\
 4.972745 0.821562 4.670980 1.199607 5.901348 1.139018 0.503875 1.673207 0.962470 0.204155 0.273372 0.567639 0.570771 0.458799 0.233109\n\
 1.825593 0.580847 1.967383 0.420710 2.034980 0.864479 0.577513 0.124068 0.502294 2.653232 0.437116 1.048288 2.319555 0.151684 0.077004 8.113282\n\
 0.450842 0.661866 0.088064 0.037642 2.600668 0.390688 0.109318 0.218118 1.065585 0.564368 1.927515 0.120994 1.856122 4.154750 0.011074 0.377578 0.222293\n\
 0.526135 0.265730 0.581928 0.141233 5.413080 0.322761 0.153776 0.039217 8.351808 0.854294 0.940458 0.180650 0.975427 11.429924 0.026268 0.429221 0.273138 4.731579\n\
 3.839269 0.395134 0.145401 0.090101 4.193725 0.625409 0.696533 0.104335 0.377304 15.559906 2.508169 0.449074 3.404087 1.457957 0.052132 0.260296 2.903836 0.564762 0.681215\n\
\n\
 0.062457 0.066826 0.049332 0.065270 0.006513 0.041231 0.058965 0.080852 0.028024 0.037024 0.075925 0.064131 0.019620 0.028710 0.104579 0.056388 0.062027 0.008241 0.033124 0.050760;\n\
\n\
model LG4X4 =\n\
 0.658412\n\
 0.566269 0.540749\n\
 0.854111 0.058015 3.060574\n\
 0.884454 5.851132 1.279257 0.160296\n\
 1.309554 2.294145 1.438430 0.482619 0.992259\n\
 1.272639 0.182966 0.431464 2.992763 0.086318 2.130054\n\
 1.874713 0.684164 2.075952 1.296206 2.149634 0.571406 0.507160\n\
 0.552007 3.192521 4.840271 0.841829 5.103188 4.137385 0.351381 0.679853\n\
 0.227683 0.528161 0.644656 0.031467 3.775817 0.437589 0.189152 0.025780 0.665865\n\
 0.581512 1.128882 0.266076 0.048542 3.954021 2.071689 0.217780 0.082005 1.266791 8.904999\n\
 0.695190 3.010922 2.084975 0.132774 0.190734 2.498630 0.767361 0.326441 0.680174 0.652629 0.440178\n\
 0.967985 1.012866 0.720060 0.133055 1.776095 1.763546 0.278392 0.343977 0.717301 10.091413 14.013035 1.082703\n\
 0.344015 0.227296 0.291854 0.056045 4.495841 0.116381 0.092075 0.195877 4.001286 2.671718 5.069337 0.091278 4.643214\n\
 0.978992 0.156635 0.028961 0.209188 0.264277 0.296578 0.177263 0.217424 0.362942 0.086367 0.539010 0.172734 0.121821 0.161015\n\
 3.427163 0.878405 4.071574 0.925172 7.063879 1.033710 0.451893 3.057583 1.189259 0.359932 0.742569 0.693405 0.584083 1.531223 1.287474\n\
 2.333253 0.802754 2.258357 0.360522 2.221150 1.283423 0.653836 0.377558 0.964545 4.797423 0.780580 1.422571 4.216178 0.599244 0.444362 5.231362\n\
 0.154701 0.830884 0.073037 0.094591 3.017954 0.312579 0.074620 0.401252 1.350568 0.336801 1.331875 0.068958 1.677263 5.832025 0.076328 0.548763 0.208791\n\
 0.221089 0.431617 1.238426 0.313945 8.558815 0.305772 0.181992 0.072258 12.869737 1.021885 1.531589 0.163829 1.575754 33.873091 0.079916 0.831890 0.307846 5.910440\n\
 2.088785 0.456530 0.199728 0.118104 4.310199 0.681277 0.752277 0.241015 0.531100 23.029406 4.414850 0.481711 5.046403 1.914768 0.466823 0.382271 3.717971 0.282540 0.964421\n\
\n\
0.106471 0.074171 0.044513 0.096390 0.002148 0.066733 0.158908 0.037625 0.020691 0.014608 0.028797 0.105352 0.007864 0.007477 0.083595 0.055726 0.047711 0.003975 0.010088 0.027159;\n\
\n\
model LG4X = MIX{LG4X1,LG4X2,LG4X3,LG4X4}*R4;\n\
\n\
[ ---------------------------------------------------------\n\
    +cF class frequency mixture model of Wang et al. (2008)\n\
 --------------------------------------------------------- ]\n\
\n\
frequency Fclass1 = 0.02549352 0.01296012 0.005545202 0.006005566 0.01002193 0.01112289 0.008811948 0.001796161 0.004312188 0.2108274 0.2730413 0.01335451 0.07862202 0.03859909 0.005058205 0.008209453 0.03210019 0.002668138 0.01379098 0.2376598;\n\
frequency Fclass2 = 0.09596966 0.008786096 0.02805857 0.01880183 0.005026264 0.006454635 0.01582725 0.7215719 0.003379354 0.002257725 0.003013483 0.01343441 0.001511657 0.002107865 0.006751404 0.04798539 0.01141559 0.000523736 0.002188483 0.004934972;\n\
frequency Fclass3 = 0.01726065 0.005467988 0.01092937 0.3627871 0.001046402 0.01984758 0.5149206 0.004145081 0.002563289 0.002955213 0.005286931 0.01558693 0.002693098 0.002075771 0.003006167 0.01263069 0.01082144 0.000253451 0.001144787 0.004573568;\n\
frequency Fclass4 = 0.1263139 0.09564027 0.07050061 0.03316681 0.02095119 0.05473468 0.02790523 0.009007538 0.03441334 0.005855319 0.008061884 0.1078084 0.009019514 0.05018693 0.07948 0.09447839 0.09258897 0.01390669 0.05367769 0.01230413;\n\
model CF4 = POISSON+FMIX{empirical,Fclass1,Fclass2,Fclass3,Fclass4}+G;\n\
model JTTCF4G = JTT+FMIX{empirical,Fclass1,Fclass2,Fclass3,Fclass4}+G;\n\
\n\
[ ---------------------------------------------------------\n\
    CAT-C10 profile mixture model of Le, Gascuel & Lartillot (2008)\n\
 --------------------------------------------------------- ]\n\
\n\
frequency C10pi1 = 0.4082573125 0.0081783015 0.0096285438 0.0069870889 0.0349388179 0.0075279735 0.0097846653 0.1221613215 0.0039151830 0.0125784287 0.0158338663 0.0059670150 0.0081313216 0.0061604332 0.0394155867 0.1682450664 0.0658132542 0.0018751587 0.0041579747 0.0604426865;\n\
frequency C10pi2 = 0.1027763487 0.0418664491 0.0213272051 0.0155943616 0.0149663448 0.0440685478 0.0419667447 0.0138805792 0.0158864807 0.1066076641 0.1131944125 0.0436343681 0.0437800327 0.0180729309 0.0223250701 0.0529608087 0.1081741005 0.0045147205 0.0137373857 0.1606654446;\n\
frequency C10pi3 = 0.0351766018 0.0019678632 0.0016591476 0.0006768741 0.0078706538 0.0016559557 0.0019686768 0.0022420602 0.0012878339 0.3515819591 0.1278183107 0.0018856550 0.0242631753 0.0126221329 0.0029771559 0.0049998099 0.0255378034 0.0011907778 0.0037539283 0.3888636245;\n\
frequency C10pi4 = 0.0408513927 0.0269887074 0.2185648186 0.2333814790 0.0037602852 0.0380451418 0.0901238869 0.1158332065 0.0373197176 0.0025523644 0.0052164616 0.0485017266 0.0022571778 0.0025108218 0.0108333610 0.0804527209 0.0302879995 0.0010815260 0.0069890931 0.0044481118;\n\
frequency C10pi5 = 0.0185492661 0.0062362395 0.0024895723 0.0009775062 0.0070416514 0.0083539447 0.0024891617 0.0028952913 0.0040103982 0.1632422345 0.4443079409 0.0043570878 0.1202815687 0.0733329781 0.0048827648 0.0051642443 0.0131806647 0.0068759784 0.0144734420 0.0968580644;\n\
frequency C10pi6 = 0.1106750119 0.0352190043 0.0405186210 0.1636437899 0.0014834855 0.0877962201 0.2638456592 0.0325228293 0.0163803600 0.0068334902 0.0140679579 0.0677158208 0.0048988133 0.0023256777 0.0298982139 0.0562887953 0.0426922497 0.0010338979 0.0040522304 0.0181078719;\n\
frequency C10pi7 = 0.0522657662 0.0668294648 0.0714836849 0.0297745257 0.0143324928 0.0736540298 0.0388386669 0.0228101108 0.1551638111 0.0187406149 0.0653779932 0.0439469345 0.0207189121 0.0624033021 0.0145475497 0.0549017631 0.0370140058 0.0193756900 0.1110694548 0.0267512268;\n\
frequency C10pi8 = 0.0116587342 0.0050990142 0.0064011054 0.0021742457 0.0105340743 0.0040203734 0.0024251112 0.0034709143 0.0366787049 0.0187185330 0.0676489746 0.0026694717 0.0143534813 0.3650985596 0.0031159927 0.0094848536 0.0073713920 0.0509564551 0.3574858593 0.0206341497;\n\
frequency C10pi9 = 0.0627195947 0.2038782162 0.0428629162 0.0236193294 0.0052662886 0.1098111767 0.0686284994 0.0256174957 0.0332612124 0.0128968249 0.0305627740 0.2270839355 0.0124036991 0.0039181841 0.0140440613 0.0483152469 0.0463378087 0.0025143473 0.0065521118 0.0197062770;\n\
frequency C10pi10 = 0.1145518598 0.0324008908 0.0750614981 0.0416192189 0.0098549497 0.0339624663 0.0364907910 0.0503817581 0.0165233329 0.0092949460 0.0139153707 0.0423026886 0.0082240805 0.0046605982 0.0379221548 0.2610647896 0.1845829279 0.0017548981 0.0058538316 0.0195769483;\n\
model C10 = POISSON+G+FMIX{C10pi1:1:0.1191344178,C10pi2:1:0.0874372456,C10pi3:1:0.1037105070,C10pi4:1:0.0922584809,C10pi5:1:0.1070492801,C10pi6:1:0.1329945166,C10pi7:1:0.0538028458,C10pi8:1:0.0691986212,C10pi9:1:0.1319937434,C10pi10:1:0.1024203429};\n\
model C10Opt = POISSON+G+FMIX{C10pi1,C10pi2,C10pi3,C10pi4,C10pi5,C10pi6,C10pi7,C10pi8,C10pi9,C10pi10};\n\
\n\
[ ---------------------------------------------------------\n\
    CAT-C20 profile mixture model of Le, Gascuel & Lartillot (2008)\n\
 --------------------------------------------------------- ]\n\
frequency C20pi1 = 0.0862412505 0.0171943793 0.0791293376 0.0329908619 0.0130504558 0.0169046938 0.0184526503 0.0366905299 0.0108013340 0.0097907148 0.0112826424 0.0220195221 0.0087821483 0.0044155335 0.0189273201 0.3178152357 0.2711700523 0.0015317305 0.0048342853 0.0179753220 ;\n\
frequency C20pi2 = 0.2035582865 0.0050980810 0.0077052407 0.0031656079 0.0348667285 0.0064044073 0.0070859400 0.0195235515 0.0024392035 0.1152573291 0.0789777393 0.0042380850 0.0309187017 0.0112429356 0.0164189221 0.0496777139 0.1118946615 0.0017762569 0.0048448213 0.2849057867 ;\n\
frequency C20pi3 = 0.0211547413 0.0014946177 0.0012755030 0.0005492865 0.0048188557 0.0012328812 0.0014539632 0.0011430874 0.0011346394 0.3928460626 0.1250644210 0.0013579946 0.0209788805 0.0128251737 0.0020247248 0.0026240726 0.0171914121 0.0011591071 0.0036027969 0.3860677787 ;\n\
frequency C20pi4 = 0.0376903543 0.2885196153 0.0365411474 0.0109469400 0.0064073829 0.0893564381 0.0358365464 0.0191106776 0.0329513951 0.0101711878 0.0237495504 0.2897626974 0.0096528870 0.0036349802 0.0105337370 0.0356313768 0.0355926500 0.0027925238 0.0066557222 0.0144621902 ;\n\
frequency C20pi5 = 0.0084597802 0.0053589922 0.0072525884 0.0024487852 0.0084909000 0.0042781483 0.0025055486 0.0024277107 0.0433214027 0.0097713028 0.0380507037 0.0026741007 0.0080724771 0.3420463838 0.0021418673 0.0080418935 0.0055322116 0.0494840193 0.4375001561 0.0121410277 ;\n\
frequency C20pi6 = 0.1759898886 0.0290429175 0.0332845569 0.1301263816 0.0017558693 0.0707183953 0.2182166681 0.0409535143 0.0130708195 0.0085622087 0.0159530702 0.0542946169 0.0054045759 0.0025276980 0.0371020404 0.0793480500 0.0540083424 0.0010592104 0.0036259116 0.0249552645 ;\n\
frequency C20pi7 = 0.1634397322 0.0195541184 0.0438701833 0.0374272612 0.0088659891 0.0137554758 0.0220611924 0.5296717726 0.0090006141 0.0017569353 0.0061156267 0.0167117975 0.0029390787 0.0030641349 0.0126457766 0.0829342776 0.0142835614 0.0028640685 0.0032398299 0.0057985736 ;\n\
frequency C20pi8 = 0.0917468761 0.0265853306 0.0290699087 0.0133818895 0.0284015012 0.0255084506 0.0196875685 0.0249898794 0.0449766405 0.0583555688 0.1155009222 0.0164915955 0.0395994595 0.0998479096 0.0209916159 0.0736482742 0.0661518462 0.0246463919 0.0972327226 0.0831856483 ;\n\
frequency C20pi9 = 0.0646700714 0.0988015996 0.0228907308 0.0168733856 0.0077117603 0.0996414875 0.0544977962 0.0148893975 0.0313851988 0.0505983315 0.1844282999 0.0907931290 0.0774839960 0.0219148172 0.0105004469 0.0321196170 0.0411766062 0.0084303030 0.0206106035 0.0505824221 ;\n\
frequency C20pi10 = 0.0135993865 0.0043408375 0.0018469375 0.0007951703 0.0100090240 0.0046420778 0.0018011758 0.0026794645 0.0072401918 0.0814026713 0.3661422246 0.0025158135 0.0734965132 0.2640965246 0.0038994134 0.0043668760 0.0075248451 0.0261564898 0.0660970801 0.0573472826 ;\n\
frequency C20pi11 = 0.1478036236 0.0842845089 0.0726630217 0.0534743238 0.0048825808 0.0757166156 0.0727246460 0.0907725939 0.0262288856 0.0035781075 0.0126777221 0.1051660098 0.0059621792 0.0029903868 0.0156558198 0.1459903343 0.0634877444 0.0015928454 0.0050760739 0.0092719768 ;\n\
frequency C20pi12 = 0.0186377412 0.0042055165 0.0019865236 0.0008329696 0.0054968852 0.0065890091 0.0020248504 0.0021713483 0.0023665991 0.2020809776 0.4370381920 0.0029120653 0.1241860384 0.0385383157 0.0040672279 0.0046177381 0.0149904396 0.0026871667 0.0056324117 0.1189379840 ;\n\
frequency C20pi13 = 0.0477624336 0.0505742667 0.0209574273 0.0141349161 0.0075791708 0.0429296799 0.0462688073 0.0052327914 0.0165351815 0.1741496627 0.1121253570 0.0577575020 0.0330288046 0.0130691347 0.0124374733 0.0264988925 0.0951754678 0.0031660482 0.0112465746 0.2093704079 ;\n\
frequency C20pi14 = 0.4164189845 0.0056100821 0.0091701381 0.0045131748 0.0406937949 0.0061320495 0.0063229801 0.0946185184 0.0031057404 0.0076443223 0.0099885414 0.0038941773 0.0069323155 0.0048438356 0.0187840756 0.2360774301 0.0746274607 0.0012172579 0.0034825786 0.0459225422 ;\n\
frequency C20pi15 = 0.0402295888 0.0735203003 0.1036647193 0.0365523994 0.0124782975 0.0826558132 0.0372197283 0.0233618081 0.2108307125 0.0093478727 0.0360561493 0.0482410586 0.0100289536 0.0459094917 0.0098503973 0.0533383445 0.0310209005 0.0140076639 0.1064377821 0.0152480184 ;\n\
frequency C20pi16 = 0.0323453034 0.0236282995 0.2520448083 0.2431495959 0.0035976296 0.0330831153 0.0710274499 0.1016074562 0.0366225082 0.0031410809 0.0051980542 0.0470129351 0.0024028744 0.0024429276 0.0094837826 0.0848355278 0.0359083275 0.0008730928 0.0067247672 0.0048704638 ;\n\
frequency C20pi17 = 0.1476256642 0.0334506604 0.0211972524 0.0403051550 0.0032327194 0.0371554480 0.0576893391 0.0330850942 0.0146392559 0.0108267008 0.0256200793 0.0451350877 0.0058651400 0.0047177179 0.3473710507 0.0892065279 0.0485899446 0.0016358749 0.0044177191 0.0282335685 ;\n\
frequency C20pi18 = 0.1031448143 0.0717747663 0.0435172139 0.0386401502 0.0061762467 0.0786603123 0.0923369140 0.0202338419 0.0246761899 0.0376904275 0.0376283678 0.0921698920 0.0161883318 0.0067666433 0.0128302120 0.0951450188 0.1378566702 0.0022144738 0.0083041573 0.0740453560 ;\n\
frequency C20pi19 = 0.0837542823 0.0899383244 0.0518811417 0.0804870571 0.0020735078 0.1456497470 0.1947759184 0.0229030361 0.0268458796 0.0074079756 0.0190249576 0.1459287407 0.0067395241 0.0023063393 0.0085616014 0.0455739585 0.0451080843 0.0010771349 0.0049325333 0.0150302559 ;\n\
frequency C20pi20 = 0.0578735570 0.0138313604 0.0491421636 0.2946738942 0.0011130839 0.0598250358 0.3402102668 0.0293911435 0.0139817004 0.0030525663 0.0062611922 0.0363365043 0.0027295976 0.0017034884 0.0156106390 0.0358044639 0.0249941878 0.0008664342 0.0038312977 0.0087674229 ;\n\
\n\
[ C20 with fixed weights ]\n\
model C20 = POISSON+G+FMIX{C20pi1:1:0.0559910600,C20pi2:1:0.0514824870,C20pi3:1:0.0812922124,C20pi4:1:0.0721976867,C20pi5:1:0.0556718858,C20pi6:1:0.0331003080,C20pi7:1:0.0589501763,C20pi8:1:0.0263756889,C20pi9:1:0.0307584220,C20pi10:1:0.0376701125,C20pi11:1:0.0303058290,C20pi12:1:0.0808775576,C20pi13:1:0.0263349134,C20pi14:1:0.0579101455,C20pi15:1:0.0371248064,C20pi16:1:0.0586867766,C20pi17:1:0.0561479138,C20pi18:1:0.0349810886,C20pi19:1:0.0544937394,C20pi20:1:0.0596471901};\n\
[ C20 to weights to be optimized ]\n\
model C20Opt = POISSON+G+FMIX{C20pi1,C20pi2,C20pi3,C20pi4,C20pi5,C20pi6,C20pi7,C20pi8,C20pi9,C20pi10,C20pi11,C20pi12,C20pi13,C20pi14,C20pi15,C20pi16,C20pi17,C20pi18,C20pi19,C20pi20};\n\
\n\
model C20Test = POISSON+G+FMIX{C20pi1:1:0.089485,C20pi2:1:0.021281,C20pi3:1:0.119676,C20pi4:1:0.080933,C20pi5:1:0.064054,C20pi6:1:0.021848,C20pi7:1:0.063392,C20pi8:1:0.003629,C20pi9:1:0.007174,C20pi10:1:0.006256,C20pi11:1:0.023424,C20pi12:1:0.086825,C20pi13:1:0.038495,C20pi14:1:0.090028,C20pi15:1:0.020025,C20pi16:1:0.043484,C20pi17:1:0.076864,C20pi18:1:0.031347,C20pi19:1:0.047749,C20pi20:1:0.064031};\n\
\n\
[ ---------------------------------------------------------\n\
    CAT-C30 profile mixture model of Le, Gascuel & Lartillot (2008)\n\
 --------------------------------------------------------- ]\n\
frequency C30pi1 = 0.1100453954 0.0171294861 0.0640338464 0.1595411459 0.0019047235 0.0310187088 0.1098958823 0.0684301540 0.0137950707 0.0026283074 0.0073396531 0.0358553674 0.0024706414 0.0016629473 0.1669356820 0.1381790473 0.0568342547 0.0004661120 0.0035970152 0.0082365591;\n\
frequency C30pi2 = 0.0874125465 0.0806320385 0.0382152368 0.0326119879 0.0049826376 0.0798168854 0.0951700809 0.0144042708 0.0210626652 0.0399884450 0.0301585074 0.1147200015 0.0126488911 0.0048996596 0.0137397028 0.0873769666 0.1558616621 0.0015122843 0.0053974463 0.0793880836;\n\
frequency C30pi3 = 0.0225477414 0.0014900535 0.0013034594 0.0005959279 0.0050018158 0.0011436556 0.0015030529 0.0011570953 0.0009374322 0.3944689167 0.0889573138 0.0013600872 0.0189102669 0.0089216031 0.0018312028 0.0028336408 0.0189813395 0.0006693746 0.0023303726 0.4250556480;\n\
frequency C30pi4 = 0.0602158209 0.0136833299 0.0414987935 0.2900084105 0.0009525462 0.0621611083 0.3610869026 0.0281925621 0.0130500799 0.0030516237 0.0060401889 0.0352704692 0.0027460635 0.0014625624 0.0127175499 0.0318109377 0.0225279521 0.0007948027 0.0034024563 0.0093258397;\n\
frequency C30pi5 = 0.0101223637 0.0028344920 0.0012928910 0.0006379191 0.0085989355 0.0035028551 0.0011249625 0.0024085229 0.0047753376 0.0701153131 0.4135913903 0.0016748492 0.0744862631 0.2785384406 0.0040466582 0.0037087155 0.0052379329 0.0200222636 0.0523938808 0.0408860135;\n\
frequency C30pi6 = 0.1335831781 0.0284789590 0.0213891629 0.1125775537 0.0010514541 0.0565844323 0.2099572968 0.0207551870 0.0121330488 0.0073526522 0.0133278240 0.0771772013 0.0030571689 0.0016793592 0.1890195131 0.0484054108 0.0373318180 0.0009266995 0.0026946425 0.0225174379;\n\
frequency C30pi7 = 0.0408277374 0.0124491768 0.0080464869 0.0030634898 0.0153918410 0.0102922098 0.0066010880 0.0058113137 0.0245211764 0.1487514547 0.1637802160 0.0075923232 0.0385527359 0.1575049888 0.0058352224 0.0151578617 0.0332220362 0.0264937109 0.1213342989 0.1547706314;\n\
frequency C30pi8 = 0.2469059247 0.0106278945 0.0168929681 0.0027418266 0.1039406309 0.0103988197 0.0054944756 0.0373263209 0.0085752319 0.0292403793 0.0535091180 0.0056123053 0.0302246485 0.0251775640 0.0078098946 0.1642352274 0.1239889705 0.0053155877 0.0163953993 0.0955868125;\n\
frequency C30pi9 = 0.0549428629 0.1305426495 0.0202957532 0.0092915274 0.0099280995 0.0906036344 0.0417085054 0.0105563869 0.0363512470 0.0569584863 0.1681833183 0.1152521806 0.0592328363 0.0243860149 0.0083055411 0.0283778833 0.0412594019 0.0096355359 0.0249780472 0.0592100878;\n\
frequency C30pi10 = 0.0462773303 0.0362984274 0.0412365193 0.0182504174 0.0172727117 0.0348990852 0.0224266258 0.0160971397 0.1357852215 0.0164966886 0.0598936127 0.0239396241 0.0164507129 0.1336320854 0.0117413009 0.0454156401 0.0304387749 0.0330338410 0.2350163763 0.0253978649;\n\
frequency C30pi11 = 0.0474379955 0.0410179935 0.0222453982 0.0112116958 0.0082332447 0.0374051414 0.0388100853 0.0055998598 0.0149156570 0.1832173840 0.1100691114 0.0467850545 0.0356443791 0.0116643783 0.0100244663 0.0317171100 0.1114352326 0.0026685586 0.0099660086 0.2199312452;\n\
frequency C30pi12 = 0.0213607696 0.0069976154 0.0039878996 0.0012941246 0.0061024858 0.0139566033 0.0036297282 0.0030017014 0.0038425894 0.1309465785 0.4566988203 0.0054567760 0.1947837355 0.0371808169 0.0040747282 0.0076991487 0.0198018718 0.0034086391 0.0064545692 0.0693207986;\n\
frequency C30pi13 = 0.0919632044 0.0160004872 0.0764682386 0.0306717360 0.0117031014 0.0160060006 0.0171907654 0.0370684649 0.0100792697 0.0093123713 0.0097240970 0.0205385908 0.0075767282 0.0041589440 0.0179686194 0.3254471625 0.2744377258 0.0013887442 0.0044739725 0.0178217761;\n\
frequency C30pi14 = 0.4649246103 0.0043013249 0.0075304815 0.0050731691 0.0233328752 0.0043571322 0.0057994247 0.1495242047 0.0023298425 0.0043361190 0.0055995530 0.0028525398 0.0039313170 0.0025588185 0.0186467246 0.2150194771 0.0477030158 0.0009038096 0.0020087184 0.0292668421;\n\
frequency C30pi15 = 0.2051329382 0.0439661329 0.0339418395 0.1070980865 0.0020915940 0.0822742346 0.1989733497 0.0487574293 0.0127143076 0.0058124693 0.0133471767 0.0667787412 0.0043783406 0.0018235059 0.0110997761 0.0873961609 0.0519781961 0.0007361603 0.0023821404 0.0193174204;\n\
frequency C30pi16 = 0.0263689890 0.0133613622 0.2727158135 0.3117715371 0.0039462429 0.0218978778 0.0694354212 0.0799842408 0.0309615130 0.0027521242 0.0038579661 0.0288630708 0.0018363656 0.0023351927 0.0062457560 0.0798729385 0.0324143174 0.0007229656 0.0063857732 0.0042705326;\n\
frequency C30pi17 = 0.1526502637 0.0332784464 0.0168229991 0.0237392180 0.0040215287 0.0341733672 0.0377949108 0.0306214335 0.0141929803 0.0123317972 0.0290062362 0.0375543022 0.0064473224 0.0058584416 0.3864504800 0.0880336410 0.0489543188 0.0018252558 0.0048877798 0.0313552773;\n\
frequency C30pi18 = 0.0080247558 0.0017408595 0.0006327403 0.0003385965 0.0023412143 0.0015507896 0.0007818945 0.0005403825 0.0010026402 0.3177056649 0.3737894172 0.0012598254 0.0488212345 0.0311968471 0.0020687549 0.0012095129 0.0065696791 0.0016309208 0.0043343553 0.1944599147;\n\
frequency C30pi19 = 0.0599950319 0.1000540567 0.1334918892 0.0889730776 0.0016884984 0.0864856169 0.0962700957 0.0588796388 0.0327277145 0.0021467269 0.0070876372 0.1825860579 0.0033979446 0.0011800742 0.0141408084 0.0779002375 0.0448817374 0.0006249028 0.0032641120 0.0042241415;\n\
frequency C30pi20 = 0.0393520657 0.0838170642 0.1425481600 0.0431197671 0.0099071945 0.1019786610 0.0394639510 0.0282866471 0.2095718357 0.0076101442 0.0258339558 0.0596434088 0.0084586675 0.0188680789 0.0096840517 0.0624998643 0.0347087967 0.0054645779 0.0564145251 0.0127685828;\n\
frequency C30pi21 = 0.0072715487 0.0140998918 0.0019756795 0.0027603830 0.0067852535 0.0043339290 0.0025069369 0.0080834718 0.0113217919 0.0056609640 0.0394199644 0.0017735096 0.0079866080 0.1271475634 0.0041098092 0.0052244365 0.0043022271 0.6273570153 0.1084563767 0.0094226397;\n\
frequency C30pi22 = 0.0907070068 0.0290062335 0.0860677696 0.0745872716 0.0063699858 0.0259377035 0.0386802115 0.4750046194 0.0168090013 0.0014721054 0.0055149849 0.0343855535 0.0024692074 0.0028859215 0.0112150781 0.0731110371 0.0153705714 0.0022914775 0.0041860660 0.0039281943;\n\
frequency C30pi23 = 0.0055291882 0.0024626303 0.0046086594 0.0011413426 0.0072105915 0.0022692184 0.0009683043 0.0016070950 0.0325831191 0.0082918400 0.0353677882 0.0013849437 0.0074486804 0.3744093753 0.0013374573 0.0057402692 0.0037279636 0.0330334445 0.4609978298 0.0098802591;\n\
frequency C30pi24 = 0.2443263138 0.0045386562 0.0062422652 0.0031590902 0.0273880205 0.0053593950 0.0076715636 0.0196089609 0.0020189401 0.1017435067 0.0468424225 0.0045492259 0.0201286022 0.0060619450 0.0185219126 0.0497753825 0.1170795523 0.0009577255 0.0035333687 0.3104931504;\n\
frequency C30pi25 = 0.0863111274 0.0984811895 0.0313963115 0.0600902926 0.0024419845 0.1672351286 0.2036096150 0.0175221435 0.0245245046 0.0105994220 0.0271209781 0.1485789590 0.0095824358 0.0029393105 0.0068276769 0.0347800318 0.0408210979 0.0014001253 0.0055105388 0.0202271268;\n\
frequency C30pi26 = 0.0643926114 0.0369048739 0.1031213278 0.1628208462 0.0023165895 0.0752534859 0.1762701353 0.0297139006 0.0303503732 0.0088163033 0.0148016812 0.0727140107 0.0056748403 0.0043066715 0.0099270322 0.0926433867 0.0833129915 0.0011237109 0.0093801464 0.0161550816;\n\
frequency C30pi27 = 0.1736682858 0.0943628709 0.0520404980 0.0285984935 0.0083596568 0.0722446698 0.0483894060 0.0781901497 0.0266134684 0.0068641911 0.0219499324 0.0964011794 0.0112303313 0.0058273974 0.0169661076 0.1547802460 0.0751701930 0.0028774511 0.0082130397 0.0172524320;\n\
frequency C30pi28 = 0.0347856579 0.3075984538 0.0314157384 0.0092355245 0.0062754891 0.0861073155 0.0323568406 0.0170288127 0.0306438905 0.0091932292 0.0224428556 0.3020845818 0.0093720833 0.0034303536 0.0104447169 0.0326882932 0.0328713449 0.0025244855 0.0064171317 0.0130832013;\n\
frequency C30pi29 = 0.1087737102 0.0051781020 0.0032679768 0.0015823203 0.0247877480 0.0057932006 0.0041769888 0.0134703172 0.0024765788 0.1643462917 0.2337152707 0.0027000391 0.0539213396 0.0316523420 0.0154886946 0.0188187787 0.0474912345 0.0037656478 0.0073106362 0.2512827825;\n\
frequency C30pi30 = 0.1101008748 0.0324324597 0.0435098681 0.0579268520 0.0072699765 0.0615196630 0.0828181488 0.0314463068 0.0308557019 0.0530865813 0.1096787834 0.0293860426 0.0458728977 0.0269153699 0.0296430687 0.0715887866 0.0685882454 0.0062324120 0.0257237601 0.0754042006;\n\
model C30 = POISSON+G+FMIX{C30pi1:1:0.0095783264,C30pi2:1:0.0248476365,C30pi3:1:0.0636309366,C30pi4:1:0.0537939225,C30pi5:1:0.0295885587,C30pi6:1:0.0117587936,C30pi7:1:0.0132013428,C30pi8:1:0.0236868805,C30pi9:1:0.0261687659,C30pi10:1:0.0239821974,C30pi11:1:0.0257100906,C30pi12:1:0.0465072425,C30pi13:1:0.0546794546,C30pi14:1:0.0536085131,C30pi15:1:0.0270622670,C30pi16:1:0.0403913593,C30pi17:1:0.0474212700,C30pi18:1:0.0458816478,C30pi19:1:0.0214036510,C30pi20:1:0.0290385981,C30pi21:1:0.0123391793,C30pi22:1:0.0569350229,C30pi23:1:0.0419687568,C30pi24:1:0.0339027062,C30pi25:1:0.0388777376,C30pi26:1:0.0196343766,C30pi27:1:0.0233086174,C30pi28:1:0.0622722654,C30pi29:1:0.0184803385,C30pi30:1:0.0203395454};\n\
\n\
[ ---------------------------------------------------------\n\
    CAT-C40 profile mixture model of Le, Gascuel & Lartillot (2008)\n\
 --------------------------------------------------------- ]\n\
frequency C40pi1 = 0.0660259814 0.0231861755 0.1599815873 0.1054473175 0.0056586745 0.0273928499 0.0440360794 0.0711238664 0.0168194755 0.0039088727 0.0055316013 0.0366689617 0.0037412416 0.0013104807 0.0176359169 0.2497687201 0.1507079582 0.0006723214 0.0038290224 0.0065528958;\n\
frequency C40pi2 = 0.0232377444 0.0122683027 0.2759650991 0.3532087982 0.0037987468 0.0197339134 0.0739378219 0.0576668030 0.0315866952 0.0031092806 0.0038711609 0.0259363304 0.0017355634 0.0024032103 0.0063116881 0.0657067704 0.0270483653 0.0007602894 0.0069602476 0.0047531689;\n\
frequency C40pi3 = 0.0166486809 0.0012594763 0.0012622242 0.0005651446 0.0036665719 0.0010669784 0.0013356251 0.0008894749 0.0008231853 0.4129367561 0.0884689295 0.0011904105 0.0186054583 0.0082775676 0.0014029981 0.0021339439 0.0162167380 0.0006082049 0.0019553200 0.4206863114;\n\
frequency C40pi4 = 0.2394741986 0.0072901253 0.0120536943 0.0044741726 0.0283811727 0.0086558850 0.0105529632 0.0135109628 0.0038929844 0.0765957115 0.0358494908 0.0071093014 0.0199496319 0.0055991131 0.0114265585 0.0847798773 0.1797284519 0.0009838000 0.0042240671 0.2454678377;\n\
frequency C40pi5 = 0.1194613086 0.0233255669 0.0294552140 0.0134272792 0.0150526644 0.0301537796 0.0192173037 0.0337675998 0.0214746045 0.0579001821 0.1446308373 0.0147261337 0.0561242940 0.0550467421 0.0631355418 0.0925266727 0.0831230185 0.0131636136 0.0331118002 0.0811758434;\n\
frequency C40pi6 = 0.0567043710 0.0117359330 0.0364734454 0.2955500969 0.0008924801 0.0609516515 0.3795154126 0.0230469606 0.0118360971 0.0031182036 0.0060137466 0.0314205689 0.0028584065 0.0012972333 0.0124745819 0.0300334889 0.0227051137 0.0007738758 0.0031343761 0.0094639563;\n\
frequency C40pi7 = 0.0179027412 0.0040967133 0.0035697688 0.0008870412 0.0160760340 0.0045395474 0.0023182113 0.0039829808 0.0127292680 0.0404650518 0.1676143477 0.0027994718 0.0424172255 0.3344862590 0.0020115128 0.0075841581 0.0068227293 0.0518381385 0.2452542553 0.0326045442;\n\
frequency C40pi8 = 0.2712170094 0.0056480837 0.0141045260 0.0021017036 0.2003830179 0.0048264059 0.0023229984 0.0502501222 0.0053727960 0.0150684657 0.0330003443 0.0020646283 0.0154811217 0.0202990358 0.0045351023 0.1764198412 0.0839578061 0.0046265242 0.0141271048 0.0741933626;\n\
frequency C40pi9 = 0.0894736584 0.1040026384 0.0190192153 0.0272183085 0.0045538316 0.1168091917 0.1275076663 0.0115685734 0.0215746293 0.0469424171 0.0512035100 0.1382047308 0.0147656854 0.0056590176 0.0095546504 0.0383953611 0.0836652641 0.0017079427 0.0062181292 0.0819555787;\n\
frequency C40pi10 = 0.0495441385 0.0375345822 0.0315863530 0.0143641284 0.0182505609 0.0316504100 0.0215379122 0.0140199913 0.1108543799 0.0247065801 0.0700287927 0.0258142032 0.0188271760 0.1418048822 0.0112101202 0.0456094427 0.0361427973 0.0371985427 0.2223972375 0.0369177689;\n\
frequency C40pi11 = 0.1704314254 0.0415784004 0.0271109259 0.1098556600 0.0009747331 0.0917299929 0.2536458944 0.0249846466 0.0101389736 0.0058749399 0.0116526350 0.0903324267 0.0036512738 0.0013321301 0.0293613681 0.0561765645 0.0479045729 0.0006696817 0.0022637316 0.0203300232;\n\
frequency C40pi12 = 0.0162725399 0.0054826071 0.0021876158 0.0010182101 0.0050614097 0.0104414465 0.0025141347 0.0021935389 0.0029914328 0.1328173512 0.4904441779 0.0040120394 0.1929931280 0.0376245580 0.0034333187 0.0040122105 0.0127074428 0.0032107554 0.0058100621 0.0647720205;\n\
frequency C40pi13 = 0.0823765743 0.0734226431 0.0598389731 0.0311745159 0.0065694304 0.0686451074 0.0675530778 0.0178961594 0.0251143622 0.0291161743 0.0287904106 0.0982301674 0.0168022878 0.0064717899 0.0114044922 0.1302995288 0.1820374273 0.0022724618 0.0079573279 0.0540270885;\n\
frequency C40pi14 = 0.3594965940 0.0072407229 0.0033421456 0.0031484357 0.0251417178 0.0049014279 0.0064962700 0.1194682267 0.0022970448 0.0458766662 0.0468053893 0.0050168849 0.0215568816 0.0092020461 0.0443915884 0.0465270945 0.0477755293 0.0024540215 0.0046450361 0.1942162766;\n\
frequency C40pi15 = 0.2015583874 0.0430161610 0.0425386444 0.0954149893 0.0032365302 0.0772010857 0.1534908791 0.0667291678 0.0155218808 0.0067740832 0.0165114429 0.0547322644 0.0060162992 0.0025643300 0.0091970560 0.1185981804 0.0625472744 0.0009565508 0.0031150007 0.0202797924;\n\
frequency C40pi16 = 0.1042731047 0.0147062345 0.0621645800 0.2424069523 0.0022450116 0.0356498946 0.1774821588 0.1697819523 0.0132648834 0.0018929517 0.0042542620 0.0220651981 0.0016441234 0.0012570256 0.0317041583 0.0778636230 0.0288515782 0.0006930898 0.0017741945 0.0060250231;\n\
frequency C40pi17 = 0.0781183281 0.0111498472 0.0159270309 0.0041541669 0.0194448667 0.0240151620 0.0116633921 0.0111524105 0.0063589385 0.1354530457 0.2457574952 0.0093729846 0.1087781166 0.0262793949 0.0055294038 0.0408518858 0.0860514305 0.0031547586 0.0085108496 0.1482764918;\n\
frequency C40pi18 = 0.0856592432 0.0101233167 0.0441923073 0.0135061568 0.0136072878 0.0092590642 0.0078602552 0.0245400880 0.0055379075 0.0100591561 0.0103343559 0.0127318506 0.0080675803 0.0047153035 0.0175273997 0.3406479487 0.3573294650 0.0014243098 0.0035099810 0.0193670227;\n\
frequency C40pi19 = 0.0674594695 0.1161734658 0.1163107783 0.0662588409 0.0021634231 0.0939360452 0.0865501280 0.0368556575 0.0381149118 0.0033238825 0.0093839985 0.1899736999 0.0039487389 0.0018212730 0.0151207830 0.0842204423 0.0565953680 0.0007187305 0.0046189437 0.0064514195;\n\
frequency C40pi20 = 0.0572262322 0.0494723554 0.1083882793 0.1793932771 0.0015301521 0.0903668522 0.1992261265 0.0316472274 0.0291392067 0.0045804559 0.0100739563 0.1015624916 0.0040204606 0.0013701849 0.0063674130 0.0621142922 0.0496102162 0.0006669285 0.0046497641 0.0085941279;\n\
frequency C40pi21 = 0.0036020163 0.0102712927 0.0013455508 0.0020871647 0.0045484804 0.0032718114 0.0017857730 0.0056391633 0.0064968790 0.0029292916 0.0232635081 0.0010419846 0.0044592278 0.0855714596 0.0024991984 0.0030671803 0.0025900250 0.7617821954 0.0678809532 0.0058668443;\n\
frequency C40pi22 = 0.2032018418 0.0083895722 0.0143743754 0.0135011707 0.0098131618 0.0044514580 0.0083818173 0.6184886075 0.0027747899 0.0011828492 0.0039826789 0.0044598895 0.0020631785 0.0019619615 0.0085870399 0.0739919851 0.0108922273 0.0018606145 0.0015638674 0.0060769136;\n\
frequency C40pi23 = 0.0050898779 0.0028740788 0.0057092962 0.0016126151 0.0061776450 0.0024693148 0.0012040415 0.0016334183 0.0393460780 0.0059088776 0.0249343597 0.0013713662 0.0049795162 0.3563126947 0.0014136424 0.0059527667 0.0036536770 0.0357987380 0.4853645852 0.0081934106;\n\
frequency C40pi24 = 0.0403335679 0.0540186397 0.0216052457 0.0098218598 0.0081549541 0.0383639077 0.0375406578 0.0047934404 0.0176735565 0.1893424159 0.1051859862 0.0607377395 0.0305599836 0.0119140782 0.0077550551 0.0257110173 0.1009913165 0.0028780020 0.0115276935 0.2210908828;\n\
frequency C40pi25 = 0.0790086293 0.1065441152 0.0309384274 0.0546012394 0.0024947877 0.1843375981 0.1997882784 0.0192655847 0.0270700474 0.0075667489 0.0254542392 0.1553108816 0.0098024439 0.0023773444 0.0056640684 0.0332370813 0.0359574739 0.0011682801 0.0048820809 0.0145306498;\n\
frequency C40pi26 = 0.0722240672 0.0489728405 0.0678929607 0.1194883992 0.0064755348 0.0708969573 0.1345886574 0.0287815397 0.0699011334 0.0173588702 0.0519870084 0.0490341790 0.0154411043 0.0348233029 0.0145597486 0.0589579876 0.0425972780 0.0087913770 0.0554386705 0.0317883834;\n\
frequency C40pi27 = 0.1085842431 0.0206450023 0.0441956285 0.1529666596 0.0012502570 0.0405398136 0.1664851192 0.0336098469 0.0134902179 0.0038821795 0.0089861440 0.0576227094 0.0024339036 0.0014553522 0.1990095021 0.0846749753 0.0454715217 0.0005902831 0.0027650162 0.0113416246;\n\
frequency C40pi28 = 0.0309526387 0.3195887318 0.0301336637 0.0082352132 0.0065593963 0.0832608108 0.0291974083 0.0154206187 0.0310385092 0.0098251607 0.0237900204 0.3062634996 0.0097071728 0.0036891639 0.0095029109 0.0295285439 0.0303052301 0.0028125285 0.0068850639 0.0133037148;\n\
frequency C40pi29 = 0.0098953741 0.0019604525 0.0007307935 0.0003748228 0.0028276741 0.0017337004 0.0009182100 0.0006997068 0.0010419482 0.3115040359 0.3750387796 0.0013960508 0.0474451070 0.0298607430 0.0025296256 0.0014628019 0.0075738968 0.0016799771 0.0040259930 0.1973003069;\n\
frequency C40pi30 = 0.1163213921 0.0273321006 0.0250163656 0.0731917718 0.0034792282 0.0586677248 0.1380880502 0.0193193469 0.0160240740 0.0712243431 0.0771473538 0.0355120487 0.0242841072 0.0094117688 0.0508926833 0.0475560280 0.0726552233 0.0026892716 0.0076166020 0.1235705162;\n\
frequency C40pi31 = 0.1285218235 0.0373073487 0.1179844215 0.0402749992 0.0172928883 0.0439706110 0.0250692272 0.1127033137 0.0606981059 0.0109350265 0.0258415767 0.0288749652 0.0167592956 0.0199118302 0.0180674983 0.1741489481 0.0648967655 0.0063574951 0.0321771650 0.0182066946;\n\
frequency C40pi32 = 0.0372286941 0.0094528028 0.0053377315 0.0023703173 0.0144940088 0.0079097138 0.0048585146 0.0046433943 0.0186795102 0.1820459527 0.1780099317 0.0058198481 0.0371334296 0.1463772419 0.0048538601 0.0103570678 0.0284161577 0.0211293603 0.0958905187 0.1849919442;\n\
frequency C40pi33 = 0.0535643726 0.1159797757 0.0239172676 0.0113537364 0.0096256227 0.0928585070 0.0391699080 0.0120279334 0.0384887950 0.0522748270 0.1892392595 0.0996037748 0.0712219098 0.0264213736 0.0083720574 0.0299114019 0.0389484845 0.0104232046 0.0265030050 0.0500947835;\n\
frequency C40pi34 = 0.1332424803 0.0033147683 0.0022704992 0.0012739239 0.0246514263 0.0030843469 0.0040461524 0.0089139209 0.0015864680 0.1971284995 0.1251288442 0.0023713225 0.0286947200 0.0156995251 0.0118845743 0.0171461828 0.0563298009 0.0017341820 0.0048778410 0.3566205216;\n\
frequency C40pi35 = 0.1498658185 0.0326607222 0.0176452820 0.0280354786 0.0035437399 0.0348151308 0.0435380704 0.0311112643 0.0140625707 0.0101953314 0.0251433928 0.0393124980 0.0051548319 0.0047533945 0.3923800449 0.0874496981 0.0473306717 0.0015215239 0.0043208299 0.0271597054;\n\
frequency C40pi36 = 0.4214366359 0.0061425967 0.0121590498 0.0073305074 0.0187609694 0.0072748556 0.0086837775 0.0902333103 0.0030262044 0.0039362777 0.0047193320 0.0051508681 0.0038306586 0.0027156136 0.0208940236 0.2901188793 0.0651922314 0.0008108235 0.0023622848 0.0252211004;\n\
frequency C40pi37 = 0.1770713890 0.1332782050 0.0311656783 0.0226500225 0.0078348946 0.0752471493 0.0509767242 0.0897389513 0.0220667143 0.0059519850 0.0205369728 0.1257689326 0.0092982479 0.0040514178 0.0264087912 0.1169591448 0.0565566955 0.0029947127 0.0049346701 0.0165087010;\n\
frequency C40pi38 = 0.0293984032 0.0370901720 0.1483622633 0.1099709900 0.0031729093 0.0388688450 0.0464270335 0.4222420155 0.0272494642 0.0007997326 0.0037634298 0.0622314461 0.0016657052 0.0015039626 0.0056481827 0.0472252404 0.0086568982 0.0009176022 0.0027693124 0.0020363920;\n\
frequency C40pi39 = 0.0265779317 0.0791104753 0.1318603134 0.0280314140 0.0101369144 0.0989710810 0.0269057233 0.0173376629 0.2815133703 0.0064646977 0.0268210053 0.0474749135 0.0072375268 0.0276960902 0.0083014995 0.0426276702 0.0259042511 0.0078528946 0.0891598394 0.0100147256;\n\
frequency C40pi40 = 0.0096096503 0.0027136180 0.0013104432 0.0006331856 0.0077301682 0.0033899420 0.0010471898 0.0020227436 0.0039001415 0.0733098005 0.4451691588 0.0014931484 0.0732575295 0.2630171690 0.0042768091 0.0036117358 0.0057928403 0.0181275729 0.0370698053 0.0425173480;\n\
model C40 = POISSON+G+FMIX{C40pi1:1:0.0223853788,C40pi2:1:0.0338891820,C40pi3:1:0.0577169375,C40pi4:1:0.0252416233,C40pi5:1:0.0108607921,C40pi6:1:0.0462373793,C40pi7:1:0.0102293175,C40pi8:1:0.0147523625,C40pi9:1:0.0143161352,C40pi10:1:0.0182302541,C40pi11:1:0.0204025079,C40pi12:1:0.0425505156,C40pi13:1:0.0248627269,C40pi14:1:0.0105892988,C40pi15:1:0.0188238725,C40pi16:1:0.0086663445,C40pi17:1:0.0148496147,C40pi18:1:0.0343037402,C40pi19:1:0.0225335203,C40pi20:1:0.0174068578,C40pi21:1:0.0112207827,C40pi22:1:0.0443532245,C40pi23:1:0.0392573370,C40pi24:1:0.0196756555,C40pi25:1:0.0287690328,C40pi26:1:0.0114441177,C40pi27:1:0.0112338740,C40pi28:1:0.0582694099,C40pi29:1:0.0444272279,C40pi30:1:0.0112010942,C40pi31:1:0.0145176111,C40pi32:1:0.0114629026,C40pi33:1:0.0239628061,C40pi34:1:0.0266266492,C40pi35:1:0.0481201159,C40pi36:1:0.0371147423,C40pi37:1:0.0160476688,C40pi38:1:0.0237249267,C40pi39:1:0.0235226203,C40pi40:1:0.0261998398};\n\
\n\
[ ---------------------------------------------------------\n\
    CAT-C50 profile mixture model of Le, Gascuel & Lartillot (2008)\n\
 --------------------------------------------------------- ]\n\
frequency C50pi1 = 0.1357566757 0.0328511938 0.0937692919 0.0757182069 0.0041887049 0.0448010470 0.0572805366 0.1210866186 0.0167465028 0.0049719235 0.0113823284 0.0458096069 0.0064563157 0.0029292810 0.0228705187 0.2060115780 0.1011347978 0.0012443033 0.0056104605 0.0093801079;\n\
frequency C50pi2 = 0.0530862751 0.1905936010 0.0595772279 0.0320970468 0.0026608079 0.1152605895 0.0840617877 0.0196495178 0.0274729775 0.0064919200 0.0158709120 0.2635539775 0.0078171228 0.0017231166 0.0121639300 0.0449347664 0.0472425608 0.0008407188 0.0037608716 0.0111402722;\n\
frequency C50pi3 = 0.0083279799 0.0007172026 0.0006359642 0.0003134388 0.0020547407 0.0007351595 0.0005373710 0.0005576905 0.0004858721 0.4370910601 0.1208722220 0.0006394909 0.0195499664 0.0090175268 0.0007265254 0.0007876194 0.0057076665 0.0006453449 0.0016797264 0.3889174318;\n\
frequency C50pi4 = 0.2072868350 0.0166858699 0.0129177658 0.0020625574 0.0849982226 0.0151757635 0.0065903656 0.0472047575 0.0130289256 0.0345690755 0.1042722764 0.0075861385 0.0498042308 0.0572909747 0.0064928361 0.1183618036 0.0780339514 0.0128352368 0.0323576924 0.0924447209;\n\
frequency C50pi5 = 0.0364181183 0.0076427099 0.0052725527 0.0020389950 0.0171009943 0.0064088232 0.0042399368 0.0053824238 0.0198596156 0.1361523026 0.1651892915 0.0045481616 0.0387479055 0.2025922657 0.0055053348 0.0121111950 0.0254621828 0.0327580458 0.1368025306 0.1357666147;\n\
frequency C50pi6 = 0.0535489196 0.0099543365 0.0269073208 0.3076150732 0.0007101021 0.0574988641 0.4066173371 0.0204537673 0.0096286483 0.0025879708 0.0049721459 0.0280989086 0.0025143457 0.0010618006 0.0124317994 0.0247246015 0.0191107367 0.0006385967 0.0024132214 0.0085115039;\n\
frequency C50pi7 = 0.0074733729 0.0025226602 0.0033967505 0.0005574007 0.0081158286 0.0037658904 0.0013610444 0.0022017759 0.0115142679 0.0195730439 0.1268878488 0.0018497296 0.0269141680 0.3821985941 0.0019970421 0.0057127939 0.0039692337 0.0553575998 0.3184099394 0.0162210153;\n\
frequency C50pi8 = 0.2615592974 0.0027098854 0.0124908261 0.0020153852 0.2740228527 0.0017043893 0.0007667803 0.0463498030 0.0019474361 0.0082858275 0.0147048711 0.0010787235 0.0063051368 0.0062080862 0.0039442437 0.1940042648 0.0963699489 0.0016185483 0.0048431386 0.0590705550;\n\
frequency C50pi9 = 0.1190557043 0.0956320251 0.0215995297 0.0378323341 0.0041536088 0.1151348174 0.1337084452 0.0179375220 0.0216767047 0.0336228770 0.0557402194 0.1132452331 0.0178407325 0.0063405927 0.0147606946 0.0478666925 0.0712091035 0.0022867238 0.0075728630 0.0627835766;\n\
frequency C50pi10 = 0.0505010344 0.0281381134 0.0341872191 0.0178157543 0.0183140005 0.0271729546 0.0212018661 0.0176052654 0.1190104107 0.0161645217 0.0561232531 0.0203908848 0.0146521042 0.1553484132 0.0135251600 0.0478959652 0.0292963208 0.0376058633 0.2477283800 0.0273225153;\n\
frequency C50pi11 = 0.1239446910 0.0355525870 0.0409769096 0.1479953346 0.0011563976 0.0908869312 0.2700270273 0.0283589709 0.0126760201 0.0064825033 0.0122101302 0.0787433823 0.0042467440 0.0016540857 0.0205717500 0.0552940245 0.0474239965 0.0008596621 0.0027823209 0.0181565313;\n\
frequency C50pi12 = 0.0160542063 0.0027359185 0.0014708079 0.0007004900 0.0034820152 0.0061470051 0.0016359686 0.0022137927 0.0013207229 0.1640035117 0.4616043506 0.0021342205 0.2174099502 0.0143751693 0.0013694259 0.0037614383 0.0172651408 0.0011454338 0.0019438536 0.0792265779;\n\
frequency C50pi13 = 0.1548192401 0.0131324559 0.0280584102 0.0095301620 0.0166267416 0.0175228950 0.0170969133 0.0179616718 0.0078385586 0.0865181208 0.0523369910 0.0132802182 0.0326348210 0.0083511229 0.0145594414 0.1096327081 0.2218108602 0.0015829972 0.0062173360 0.1704883347;\n\
frequency C50pi14 = 0.2950313592 0.0027580697 0.0021616268 0.0015364190 0.0375439186 0.0028808733 0.0042976283 0.0261726702 0.0008294969 0.0834938143 0.0553606311 0.0022642314 0.0181259911 0.0074433078 0.0126794048 0.0382913338 0.0783205173 0.0010015148 0.0034016419 0.3264055498;\n\
frequency C50pi15 = 0.1683177099 0.0820396152 0.0526048706 0.0822517150 0.0023029997 0.0969341246 0.1488943001 0.0535291188 0.0179803231 0.0032503636 0.0114941086 0.1156402642 0.0039439899 0.0015002945 0.0066854154 0.0924511658 0.0480769504 0.0006152103 0.0025022919 0.0089851683;\n\
frequency C50pi16 = 0.0334088176 0.0134485791 0.1590918150 0.3657542471 0.0025127086 0.0327665151 0.1820739351 0.0740807194 0.0202010901 0.0016650025 0.0036700956 0.0295517886 0.0017087810 0.0011422805 0.0073155123 0.0426788071 0.0211162106 0.0005931485 0.0034724580 0.0037474882;\n\
frequency C50pi17 = 0.0777586977 0.0174438357 0.0053423343 0.0043431532 0.0062523949 0.0220851281 0.0161769285 0.0053903202 0.0080675581 0.1052945216 0.1617365895 0.0148319919 0.0288253912 0.0168985297 0.2565426868 0.0202089662 0.0542929694 0.0060146095 0.0078109966 0.1646823969;\n\
frequency C50pi18 = 0.0727013979 0.0048977192 0.0026095383 0.0011420120 0.0198747408 0.0066949336 0.0030401434 0.0079074845 0.0026492900 0.1685788878 0.3185489163 0.0026024909 0.0735597038 0.0490419983 0.0051699104 0.0128630830 0.0305356924 0.0050857840 0.0095279173 0.2029683559;\n\
frequency C50pi19 = 0.0658153836 0.0833432992 0.0224582275 0.0107735824 0.0092974677 0.0745951987 0.0299754097 0.0146336557 0.0148026634 0.0671888719 0.2198675990 0.0868172087 0.1084156835 0.0155812696 0.0071132147 0.0381451947 0.0562948237 0.0056421684 0.0102813038 0.0589577740;\n\
frequency C50pi20 = 0.0525278351 0.0364897390 0.0903013988 0.1854660991 0.0037795400 0.0776857292 0.1789287290 0.0232011648 0.0687702011 0.0135825419 0.0337350646 0.0458143770 0.0108457797 0.0191020037 0.0088729983 0.0495289201 0.0389358438 0.0046292762 0.0354195947 0.0223831639;\n\
frequency C50pi21 = 0.0026515970 0.0080885204 0.0010572021 0.0016052142 0.0036540307 0.0022979498 0.0014681767 0.0046230912 0.0043887616 0.0020669456 0.0172444871 0.0006593575 0.0034691503 0.0658351447 0.0019185467 0.0022498420 0.0021278866 0.8183345006 0.0515918357 0.0046677595;\n\
frequency C50pi22 = 0.0548133174 0.0692044159 0.0211265710 0.0207779125 0.0072646572 0.0567865657 0.0738456579 0.0051797705 0.0168408457 0.1386104888 0.0713795154 0.0896393340 0.0201205491 0.0082150393 0.0104049016 0.0282344422 0.0995597110 0.0019722093 0.0074054035 0.1986186919;\n\
frequency C50pi23 = 0.0047955268 0.0028033787 0.0050506238 0.0014080516 0.0061671241 0.0019350126 0.0009861551 0.0014396818 0.0389623239 0.0048950388 0.0151748150 0.0012306644 0.0032520404 0.3601993060 0.0011266316 0.0054509935 0.0034763921 0.0362899931 0.4980200998 0.0073361467;\n\
frequency C50pi24 = 0.0365462996 0.0280070630 0.0183606115 0.0070525803 0.0093251684 0.0300239431 0.0221812842 0.0047778642 0.0178840316 0.2025947306 0.1973012130 0.0250209750 0.0557862640 0.0258067541 0.0042772210 0.0209374223 0.0731398943 0.0049738166 0.0200601168 0.1959427463;\n\
frequency C50pi25 = 0.0684197684 0.0111619750 0.0544764241 0.0224313301 0.0106958312 0.0091799953 0.0097436799 0.0255871619 0.0055558006 0.0059416697 0.0076746853 0.0144198991 0.0056892166 0.0037356845 0.0172554137 0.3527301149 0.3586913194 0.0012501907 0.0028636710 0.0124961682;\n\
frequency C50pi26 = 0.0495330775 0.1060064564 0.1511923969 0.0483471288 0.0080946362 0.0886108407 0.0449556763 0.0331436148 0.1447288287 0.0061850770 0.0190407203 0.0948075276 0.0063418871 0.0126162987 0.0100869563 0.0799801169 0.0445418973 0.0044765096 0.0363930724 0.0109172804;\n\
frequency C50pi27 = 0.0702411901 0.0642050323 0.0779553908 0.0510328304 0.0042438849 0.0723300485 0.0883747710 0.0177347101 0.0233800891 0.0198779320 0.0183537117 0.1051267065 0.0107865869 0.0037987118 0.0112811107 0.1345081583 0.1805543234 0.0014252764 0.0055089381 0.0392805971;\n\
frequency C50pi28 = 0.1207399152 0.1741788075 0.0385528120 0.0162689581 0.0118494185 0.0760068404 0.0337935391 0.0653431008 0.0342783806 0.0085426053 0.0256788075 0.1434443984 0.0112347894 0.0061270793 0.0294493558 0.1091415488 0.0634181251 0.0046156419 0.0085374279 0.0187984481;\n\
frequency C50pi29 = 0.0064521696 0.0021817337 0.0005939658 0.0003904032 0.0021538307 0.0019099968 0.0008007758 0.0005208471 0.0011374294 0.2850758996 0.4278536740 0.0013920239 0.0561988528 0.0449501501 0.0026289702 0.0011053664 0.0055157148 0.0022753671 0.0059612583 0.1509015707;\n\
frequency C50pi30 = 0.0969092741 0.0359723370 0.0633194168 0.0411020773 0.0145578946 0.0466661704 0.0469223767 0.0374614202 0.0537149580 0.0394603009 0.0856256544 0.0283577862 0.0346435320 0.0507298072 0.0167177549 0.0990945318 0.0806503833 0.0128373826 0.0598972198 0.0553597218;\n\
frequency C50pi31 = 0.0840212010 0.0214242172 0.2240668646 0.0354684798 0.0265031681 0.0235675678 0.0076026464 0.1173325117 0.0516019781 0.0048917455 0.0067211727 0.0173653354 0.0079342101 0.0087501486 0.0093276105 0.2637097946 0.0630157977 0.0022314593 0.0170994247 0.0073646661;\n\
frequency C50pi32 = 0.0055061507 0.0012508737 0.0004824961 0.0004530173 0.0054435931 0.0011315076 0.0004150379 0.0012285001 0.0019884532 0.0617431901 0.4342418135 0.0008161868 0.0554628445 0.3289659386 0.0025814794 0.0021197505 0.0029510440 0.0172981374 0.0412097497 0.0347102358;\n\
frequency C50pi33 = 0.0442014612 0.1295816316 0.0258622052 0.0148900471 0.0076165815 0.1301765579 0.0636708052 0.0105339122 0.0662542863 0.0423977240 0.1434197528 0.1040381429 0.0403363621 0.0260540342 0.0089335090 0.0242573966 0.0317938092 0.0077831996 0.0309973779 0.0472012033;\n\
frequency C50pi34 = 0.0571984155 0.0034929878 0.0031324721 0.0012472712 0.0113230439 0.0025279922 0.0040737817 0.0030647398 0.0020494153 0.3131200932 0.0901750144 0.0034699557 0.0242565205 0.0112345295 0.0048197020 0.0095675953 0.0529842025 0.0010645104 0.0041851135 0.3970126433;\n\
frequency C50pi35 = 0.1141963934 0.0102229903 0.0178644126 0.0172307307 0.0056978908 0.0039055039 0.0085974326 0.7425714921 0.0026414175 0.0005602022 0.0019872568 0.0055400059 0.0004739977 0.0010663175 0.0054302447 0.0508318204 0.0055408544 0.0018890811 0.0012409205 0.0025110348;\n\
frequency C50pi36 = 0.3531758625 0.0043402857 0.0031812423 0.0030024877 0.0165711581 0.0029126214 0.0042077690 0.4520896100 0.0021366362 0.0063692579 0.0120143269 0.0022586970 0.0080260130 0.0043865828 0.0111462027 0.0658344033 0.0182952730 0.0010872878 0.0023330172 0.0266312657;\n\
frequency C50pi37 = 0.0310798708 0.0234519814 0.1273669012 0.1197925100 0.0031216960 0.0295858842 0.0470763446 0.4883046368 0.0193412101 0.0008855622 0.0032808220 0.0408430573 0.0014984226 0.0016298596 0.0063229464 0.0423452622 0.0082797260 0.0007718998 0.0024996877 0.0025217188;\n\
frequency C50pi38 = 0.0370340667 0.0689410214 0.1704407181 0.1041817082 0.0018108784 0.0715495095 0.0659866718 0.2159298358 0.0443591808 0.0008668888 0.0064679416 0.1275300877 0.0027248464 0.0014178323 0.0060253154 0.0534574556 0.0147073432 0.0007999410 0.0037708147 0.0019979426;\n\
frequency C50pi39 = 0.0160398536 0.0526622999 0.1051167149 0.0187352256 0.0085330116 0.0922616498 0.0154450839 0.0076235155 0.3848449137 0.0057129406 0.0277195224 0.0219347380 0.0071078308 0.0376358992 0.0072201969 0.0209969653 0.0142198783 0.0096946226 0.1384243143 0.0080708232;\n\
frequency C50pi40 = 0.0165549167 0.0085856833 0.0049441851 0.0016567380 0.0086529073 0.0184087838 0.0033759867 0.0033844413 0.0084695063 0.0483923758 0.4963073963 0.0056997331 0.1949377866 0.0999527140 0.0060271256 0.0084289585 0.0122619536 0.0114013282 0.0192314834 0.0233259964;\n\
frequency C50pi41 = 0.0227379959 0.0137060298 0.3162561805 0.2932103363 0.0037073869 0.0169119273 0.0380984220 0.0550224760 0.0319886436 0.0039219190 0.0041582288 0.0312539900 0.0019467591 0.0022276545 0.0059660826 0.0998736999 0.0462336456 0.0007310446 0.0069012376 0.0051463400;\n\
frequency C50pi42 = 0.2406936002 0.0197081082 0.0462578641 0.0206379264 0.0186726798 0.0189843646 0.0129785315 0.1749109142 0.0118714342 0.0049349532 0.0126237761 0.0127876711 0.0095642661 0.0083606873 0.0326283314 0.2101300187 0.1130042042 0.0041951500 0.0069210515 0.0201344675;\n\
frequency C50pi43 = 0.0214325714 0.3730744306 0.0220674626 0.0037495290 0.0069038342 0.0670391950 0.0159298773 0.0126211348 0.0284477629 0.0102051798 0.0242954287 0.3272456489 0.0093147452 0.0036403029 0.0070138928 0.0216860624 0.0232259733 0.0030422478 0.0065368590 0.0125278613;\n\
frequency C50pi44 = 0.1567707052 0.0258059606 0.0161658338 0.0223946414 0.0074382689 0.0274455582 0.0410010574 0.0360501033 0.0159972680 0.0640941463 0.0944756654 0.0192586366 0.0312789234 0.0227728534 0.1653169011 0.0640177954 0.0549103568 0.0050980224 0.0138248643 0.1158824381;\n\
frequency C50pi45 = 0.4345912387 0.0061142999 0.0097660767 0.0060102195 0.0197377879 0.0069062805 0.0082800652 0.0829075516 0.0029125126 0.0047747098 0.0054182241 0.0049974525 0.0039676868 0.0029052002 0.0193588692 0.2795854727 0.0677816788 0.0008196092 0.0025196339 0.0306454302;\n\
frequency C50pi46 = 0.0296734965 0.1443250343 0.0128668160 0.0059561454 0.0129805897 0.0492311054 0.0262726056 0.0069437743 0.0676183913 0.0452364160 0.1374511139 0.0907089722 0.0308070846 0.0816441785 0.0060701025 0.0197130339 0.0299715868 0.0461468661 0.1119414237 0.0444412635;\n\
frequency C50pi47 = 0.1089911217 0.0159187676 0.0643054232 0.2086425054 0.0016540963 0.0375565797 0.1791004993 0.0610564917 0.0144660242 0.0038322948 0.0067778708 0.0372270242 0.0022817918 0.0012634818 0.0851792013 0.1065821239 0.0524401536 0.0005901255 0.0027836060 0.0093508169;\n\
frequency C50pi48 = 0.1429463629 0.0304191716 0.0191145368 0.0351867799 0.0031493079 0.0341248336 0.0508492526 0.0305914291 0.0134276644 0.0070227247 0.0197257013 0.0421442438 0.0038904796 0.0040697467 0.4052202085 0.0874406009 0.0445304918 0.0012842531 0.0039485525 0.0209136585;\n\
frequency C50pi49 = 0.0580116857 0.0903213669 0.0369245281 0.0613603988 0.0022829951 0.2073851382 0.2225853236 0.0159476910 0.0311816018 0.0068543753 0.0217092509 0.1504781849 0.0084841006 0.0020581132 0.0046206107 0.0276754451 0.0321477211 0.0011651089 0.0051889637 0.0136173964;\n\
frequency C50pi50 = 0.2153540940 0.0359173007 0.0219927944 0.0735128474 0.0037017294 0.0566408566 0.1350375818 0.0662986417 0.0157121780 0.0138456188 0.0266922211 0.0474338339 0.0088042600 0.0035035311 0.0739583083 0.0921989198 0.0575687235 0.0019306896 0.0044520833 0.0454437865;\n\
model C50 = POISSON+G+FMIX{C50pi1:1:0.0164297003,C50pi2:1:0.0273175755,C50pi3:1:0.0460247610,C50pi4:1:0.0084864734,C50pi5:1:0.0125389252,C50pi6:1:0.0343549036,C50pi7:1:0.0130241102,C50pi8:1:0.0094755681,C50pi9:1:0.0190040551,C50pi10:1:0.0151902354,C50pi11:1:0.0320534760,C50pi12:1:0.0210059850,C50pi13:1:0.0237408547,C50pi14:1:0.0239841203,C50pi15:1:0.0213748021,C50pi16:1:0.0210717705,C50pi17:1:0.0050241805,C50pi18:1:0.0166262276,C50pi19:1:0.0143945956,C50pi20:1:0.0104391130,C50pi21:1:0.0107628277,C50pi22:1:0.0148818171,C50pi23:1:0.0321480239,C50pi24:1:0.0145477978,C50pi25:1:0.0332355807,C50pi26:1:0.0143190281,C50pi27:1:0.0234478734,C50pi28:1:0.0183044983,C50pi29:1:0.0403269452,C50pi30:1:0.0135629530,C50pi31:1:0.0091880799,C50pi32:1:0.0158270022,C50pi33:1:0.0121019379,C50pi34:1:0.0353560982,C50pi35:1:0.0404495617,C50pi36:1:0.0104569232,C50pi37:1:0.0146187792,C50pi38:1:0.0093984095,C50pi39:1:0.0146773809,C50pi40:1:0.0201635562,C50pi41:1:0.0255640273,C50pi42:1:0.0039486842,C50pi43:1:0.0393652608,C50pi44:1:0.0056415419,C50pi45:1:0.0382833580,C50pi46:1:0.0039735086,C50pi47:1:0.0140269355,C50pi48:1:0.0476703673,C50pi49:1:0.0204062788,C50pi50:1:0.0117835304};\n\
\n\
[ ---------------------------------------------------------\n\
    CAT-C60 profile mixture model of Le, Gascuel & Lartillot (2008)\n\
 --------------------------------------------------------- ]\n\
frequency C60pi1 = 0.1534363248 0.0444389067 0.0796726990 0.0546757288 0.0047306596 0.0514333025 0.0529324359 0.1103775749 0.0174480218 0.0050343887 0.0130294160 0.0603928711 0.0075550589 0.0035554315 0.0249523704 0.2029625968 0.0957668473 0.0014444483 0.0059800307 0.0101808864;\n\
frequency C60pi2 = 0.0281984692 0.3031055487 0.0312954609 0.0091549350 0.0019503463 0.0939884393 0.0388530140 0.0084028325 0.0155384715 0.0107872879 0.0217786594 0.3476042929 0.0109904917 0.0015919288 0.0071539896 0.0197479052 0.0328352333 0.0009209994 0.0025714024 0.0135302919;\n\
frequency C60pi3 = 0.0083680740 0.0007319768 0.0006123446 0.0002228366 0.0020433870 0.0009498685 0.0004731544 0.0004825748 0.0005189995 0.3768453098 0.2608334606 0.0006296168 0.0315700586 0.0123984358 0.0009595916 0.0009746383 0.0049990761 0.0008657759 0.0017132332 0.2938075872;\n\
frequency C60pi4 = 0.2227229348 0.0064846074 0.0061206496 0.0007997588 0.1640285908 0.0051051888 0.0027280806 0.0202702520 0.0037183875 0.0455406072 0.0883350071 0.0022832871 0.0348094559 0.0228667054 0.0035471579 0.0850040072 0.1012848285 0.0048424833 0.0096500033 0.1698580069;\n\
frequency C60pi5 = 0.0412139519 0.0067627055 0.0051067690 0.0017434391 0.0204715649 0.0057538477 0.0037263409 0.0069107492 0.0180293946 0.1154281623 0.1693562458 0.0042900270 0.0414066566 0.2239001858 0.0058416410 0.0149106129 0.0239548406 0.0332237129 0.1379349474 0.1200342049;\n\
frequency C60pi6 = 0.0480550249 0.0308438053 0.0940628721 0.2084606133 0.0037801787 0.0747676701 0.1855184661 0.0191402239 0.0872162350 0.0094685435 0.0277340828 0.0375741243 0.0088308358 0.0196000958 0.0081267777 0.0439680761 0.0324588883 0.0034665720 0.0387499964 0.0181769181;\n\
frequency C60pi7 = 0.0062848745 0.0026246919 0.0030342510 0.0005324147 0.0073027627 0.0034409089 0.0009741492 0.0019578159 0.0102225186 0.0180592309 0.1179064681 0.0016205916 0.0234721825 0.3974552519 0.0020165583 0.0056903327 0.0037091821 0.0598639097 0.3185565304 0.0152753744;\n\
frequency C60pi8 = 0.1815005560 0.0026845411 0.0148484537 0.0025145485 0.4205633920 0.0014097001 0.0007088144 0.0461854175 0.0014374605 0.0041745536 0.0098310464 0.0006474254 0.0041611385 0.0068976432 0.0038767247 0.1864537050 0.0687189855 0.0027083549 0.0061033012 0.0345742379;\n\
frequency C60pi9 = 0.0600740822 0.0367642654 0.0134869242 0.0170572285 0.0070719770 0.0142469806 0.0127486975 0.0343564471 0.0305859029 0.0204571345 0.0994551128 0.0212367087 0.0318165939 0.1140907926 0.0297628218 0.0505792699 0.0339368402 0.2312808862 0.1192491702 0.0217421638;\n\
frequency C60pi10 = 0.0708394513 0.0474098489 0.0416822304 0.0324482918 0.0131641265 0.0494874703 0.0508264389 0.0183309196 0.0567272697 0.0650369079 0.1282255556 0.0343618389 0.0390362930 0.0594359563 0.0135608209 0.0551343199 0.0642260358 0.0137118382 0.0673934289 0.0789609573;\n\
frequency C60pi11 = 0.0617689371 0.0076332888 0.0303081645 0.3430234188 0.0007199837 0.0307856241 0.3792509407 0.0284658686 0.0079592120 0.0016999627 0.0039945339 0.0216076877 0.0019734329 0.0009814186 0.0174791407 0.0337831940 0.0203426591 0.0006130268 0.0017102752 0.0058992300;\n\
frequency C60pi12 = 0.0421559537 0.1042068314 0.0286980872 0.0164385240 0.0044450330 0.1393690851 0.0531949072 0.0134711207 0.0177764997 0.0267727728 0.1967237776 0.1323735242 0.1182827521 0.0086728324 0.0051837880 0.0255852718 0.0333292020 0.0045852327 0.0070281498 0.0217066546;\n\
frequency C60pi13 = 0.2814809927 0.0100367066 0.0172867775 0.0064385734 0.0258337508 0.0133101925 0.0115046410 0.0270054934 0.0054629657 0.0188216093 0.0190993462 0.0098712843 0.0158719589 0.0050481705 0.0129510033 0.1886808600 0.2427104979 0.0012274627 0.0036052922 0.0837524211;\n\
frequency C60pi14 = 0.2769188320 0.0017226995 0.0021315271 0.0011672545 0.0318292645 0.0018216251 0.0024752467 0.0199646887 0.0005170863 0.0983109006 0.0489264326 0.0016232163 0.0173414948 0.0070843906 0.0070179705 0.0336348952 0.0814141404 0.0007118144 0.0032942319 0.3620922883;\n\
frequency C60pi15 = 0.1577797792 0.1112140270 0.0570403237 0.0648290471 0.0053318076 0.1065373681 0.0913586945 0.0906209718 0.0533809635 0.0029171632 0.0156225571 0.0782148712 0.0045758969 0.0025047816 0.0067077844 0.0929310045 0.0393122597 0.0028575821 0.0077590269 0.0085040899;\n\
frequency C60pi16 = 0.0593735135 0.0354740772 0.1151175314 0.2189482708 0.0015332173 0.0688752402 0.1819422913 0.0813707101 0.0220478285 0.0020993577 0.0056191259 0.0750172075 0.0021871739 0.0010838321 0.0109737422 0.0726449461 0.0380238271 0.0007346460 0.0026664883 0.0042669729;\n\
frequency C60pi17 = 0.0978066326 0.0265576438 0.0101843505 0.0120781428 0.0064138404 0.0307876446 0.0291282947 0.0128912798 0.0128036716 0.0723904209 0.1279438950 0.0245630658 0.0303267312 0.0198963719 0.2723524069 0.0350549441 0.0484557340 0.0046842467 0.0104773833 0.1152032995;\n\
frequency C60pi18 = 0.0124023388 0.0030680354 0.0009239105 0.0006037316 0.0041885695 0.0032957441 0.0012524000 0.0011306791 0.0013542104 0.2344167852 0.4550557697 0.0016718177 0.0667307666 0.0610615367 0.0037076169 0.0019420934 0.0067612939 0.0038937184 0.0074911765 0.1290478057;\n\
frequency C60pi19 = 0.0794230623 0.1294739355 0.0662792725 0.0587236242 0.0019919499 0.1143880588 0.1246900644 0.0325432311 0.0238605372 0.0036277150 0.0097987961 0.2147597316 0.0041846209 0.0012869951 0.0142410239 0.0615807386 0.0477333594 0.0006525371 0.0029420233 0.0078187231;\n\
frequency C60pi20 = 0.0248148778 0.0083552910 0.1888915388 0.4278832998 0.0027839717 0.0210777725 0.1432386297 0.0643968435 0.0185736870 0.0022506941 0.0034558626 0.0179274104 0.0015714503 0.0014680353 0.0073768035 0.0377003132 0.0187767966 0.0005891859 0.0042602708 0.0046072655;\n\
frequency C60pi21 = 0.0017003427 0.0060674330 0.0004222900 0.0010711490 0.0029059420 0.0016424179 0.0011731741 0.0035579609 0.0027630465 0.0012291190 0.0127420810 0.0004273804 0.0025671348 0.0513377024 0.0013536738 0.0011871674 0.0014033068 0.8640436936 0.0390912582 0.0033137266;\n\
frequency C60pi22 = 0.0468360682 0.0639796924 0.0205603686 0.0185615516 0.0059954138 0.0557030821 0.0705436036 0.0045435329 0.0152062773 0.1550613356 0.0824253382 0.0866248354 0.0245854443 0.0080177192 0.0081485616 0.0237025617 0.0962054496 0.0018368673 0.0067131723 0.2047491243;\n\
frequency C60pi23 = 0.0258764792 0.0201097124 0.0298384107 0.0107037437 0.0142503909 0.0158529432 0.0105649532 0.0073064999 0.1411078834 0.0114777629 0.0407992414 0.0119179202 0.0098798997 0.1876429961 0.0051228805 0.0275699644 0.0170764901 0.0405124999 0.3536390834 0.0187502449;\n\
frequency C60pi24 = 0.0296285022 0.0046400334 0.0034944393 0.0008851024 0.0090046468 0.0055481111 0.0033046518 0.0027969482 0.0050701500 0.2583397750 0.2668085481 0.0046690936 0.0770825277 0.0408798247 0.0026918193 0.0068538089 0.0322265673 0.0035506055 0.0153353414 0.2271895033;\n\
frequency C60pi25 = 0.0555725806 0.0098447861 0.0409064430 0.0140389597 0.0097418602 0.0068727710 0.0069443190 0.0157956555 0.0041631258 0.0069826497 0.0075271247 0.0139224817 0.0058762687 0.0034496730 0.0119733364 0.3482466393 0.4213655981 0.0010061491 0.0026576772 0.0131119012;\n\
frequency C60pi26 = 0.0682671212 0.0615207091 0.0530661192 0.0360278709 0.0141433148 0.0612274332 0.0497415394 0.0268696520 0.1127674983 0.0132646615 0.0544493838 0.0482609047 0.0170033964 0.0803375967 0.0191949850 0.0671839752 0.0443995774 0.0199957919 0.1255070748 0.0267713947;\n\
frequency C60pi27 = 0.0792618808 0.0638377192 0.0635289371 0.0436646174 0.0049503302 0.0666365188 0.0829639117 0.0183428565 0.0233169239 0.0249427251 0.0221483402 0.0932577596 0.0120893380 0.0049131149 0.0126360122 0.1334848656 0.1916745928 0.0018040086 0.0062353115 0.0503102360;\n\
frequency C60pi28 = 0.0731759112 0.2105335985 0.0324200854 0.0110007149 0.0123458504 0.0858951989 0.0349942684 0.0224509173 0.0386903280 0.0246226304 0.0508307349 0.1783344831 0.0185740720 0.0093148787 0.0148722772 0.0603181436 0.0649574934 0.0051046395 0.0130597421 0.0385040321;\n\
frequency C60pi29 = 0.0878402710 0.0110331750 0.0060801213 0.0032803903 0.0171147088 0.0109831614 0.0101465790 0.0087090941 0.0054902234 0.1987761871 0.1756460821 0.0082096925 0.0417232903 0.0191954435 0.0111283542 0.0209862621 0.0697718709 0.0031744014 0.0081905473 0.2825201446;\n\
frequency C60pi30 = 0.0990215820 0.0349351987 0.0211149501 0.0118797946 0.0108995677 0.0557710676 0.0278999992 0.0240250097 0.0123445071 0.0776564721 0.2354511299 0.0322817789 0.1207665429 0.0214442058 0.0075655541 0.0524170141 0.0649785115 0.0047075806 0.0077328724 0.0771066610;\n\
frequency C60pi31 = 0.0601641168 0.0161995226 0.2783522747 0.0337188808 0.0315066987 0.0210645987 0.0059839451 0.0543080710 0.0531523512 0.0070650825 0.0070698142 0.0139598368 0.0088298653 0.0069525877 0.0075834331 0.2829802556 0.0860317092 0.0014966551 0.0134849454 0.0100953553;\n\
frequency C60pi32 = 0.0049781737 0.0018412331 0.0007012207 0.0005315368 0.0052978737 0.0024089907 0.0007630546 0.0015051317 0.0041575221 0.0443828633 0.4417417476 0.0011615060 0.0602807417 0.3351117140 0.0027847686 0.0025795769 0.0030288544 0.0171302592 0.0458455751 0.0237676560;\n\
frequency C60pi33 = 0.0251996593 0.1114468110 0.0142031925 0.0041012288 0.0097099500 0.0620070749 0.0262571641 0.0038067269 0.0431938935 0.0974043253 0.2447197423 0.0824312856 0.0539323021 0.0429091639 0.0052658505 0.0096093107 0.0251183002 0.0146571900 0.0456965140 0.0783303143;\n\
frequency C60pi34 = 0.0230361648 0.0014748749 0.0013534390 0.0006264439 0.0048580122 0.0009870046 0.0015762583 0.0011565336 0.0008899238 0.3952895890 0.0576537208 0.0014663528 0.0140986541 0.0072127040 0.0020177885 0.0028770237 0.0205580852 0.0005477695 0.0019539080 0.4603657493;\n\
frequency C60pi35 = 0.1408776963 0.0297808449 0.0171297613 0.0285076933 0.0032213718 0.0320632225 0.0423838922 0.0299558472 0.0131321477 0.0066914481 0.0195120028 0.0383781635 0.0036276863 0.0041231064 0.4383466229 0.0851400095 0.0422765692 0.0013236871 0.0037087638 0.0198194632;\n\
frequency C60pi36 = 0.4442491220 0.0050216551 0.0102305117 0.0057193038 0.0235405374 0.0055997640 0.0064889886 0.0822687710 0.0025505743 0.0033615104 0.0040990063 0.0038097073 0.0028683069 0.0024413211 0.0162890960 0.2999969708 0.0559664935 0.0007735426 0.0020639824 0.0226608347;\n\
frequency C60pi37 = 0.0898717958 0.0070958305 0.0130067619 0.0129166888 0.0044131479 0.0023806547 0.0058957027 0.8087563021 0.0016517855 0.0004339282 0.0015564455 0.0033939025 0.0004253422 0.0008073572 0.0034128140 0.0362876891 0.0032887534 0.0015223902 0.0008537454 0.0020289624;\n\
frequency C60pi38 = 0.0550840246 0.0472254260 0.1877829604 0.1273796123 0.0035824944 0.0527969268 0.0655884730 0.0637607521 0.0404883483 0.0075574152 0.0136304510 0.0867682792 0.0081684229 0.0040375032 0.0110681809 0.1263380956 0.0752544318 0.0013563681 0.0118590434 0.0102727908;\n\
frequency C60pi39 = 0.0117681394 0.0442558806 0.0844144627 0.0144712108 0.0070388254 0.1038342049 0.0110901161 0.0049626578 0.4337194047 0.0061337038 0.0298794939 0.0137928558 0.0076237551 0.0338266335 0.0081346096 0.0140571089 0.0108276801 0.0080683065 0.1437251732 0.0083757773;\n\
frequency C60pi40 = 0.0159285638 0.0048098656 0.0032692643 0.0010966937 0.0080519916 0.0134552459 0.0021324215 0.0025086365 0.0049192147 0.0501543893 0.5307634291 0.0035599431 0.2160085187 0.0743650717 0.0045247350 0.0066922196 0.0119092283 0.0070928134 0.0106565111 0.0281012433;\n\
frequency C60pi41 = 0.0195973253 0.0105142992 0.3289103336 0.3099848991 0.0034539049 0.0116196758 0.0250777800 0.0627528956 0.0295961112 0.0032650434 0.0028246884 0.0240963907 0.0008425062 0.0019706550 0.0049062781 0.1064984500 0.0438053705 0.0006333959 0.0056197958 0.0040302013;\n\
frequency C60pi42 = 0.0833804360 0.0125871438 0.0969824220 0.0686820704 0.0081981143 0.0121520930 0.0227415415 0.0982291876 0.0073954898 0.0017471177 0.0039653113 0.0129342146 0.0019557975 0.0024132583 0.0355924232 0.3115606483 0.2113368612 0.0016329034 0.0017991083 0.0047138579;\n\
frequency C60pi43 = 0.0181409133 0.4129662563 0.0233205154 0.0033333547 0.0085143598 0.0526694251 0.0096531879 0.0224552642 0.0375238929 0.0035090482 0.0149146621 0.3208065790 0.0046098856 0.0035426859 0.0087197469 0.0262309419 0.0131791136 0.0034766995 0.0079588201 0.0044746474;\n\
frequency C60pi44 = 0.2494227404 0.0185481724 0.0164119567 0.0169234299 0.0122862654 0.0228501981 0.0370491083 0.0347467705 0.0087069587 0.0595718359 0.0451065029 0.0177064733 0.0204556127 0.0077360919 0.0686403544 0.0889295672 0.0986017356 0.0028603862 0.0061938477 0.1672519917;\n\
frequency C60pi45 = 0.1419737638 0.0373945961 0.0576296888 0.0537452477 0.0068856658 0.0286239972 0.0407540287 0.3988107872 0.0152895617 0.0016627616 0.0092348297 0.0314273807 0.0055425500 0.0040286132 0.0180328866 0.1123731997 0.0242478202 0.0025909098 0.0049054208 0.0048462908;\n\
frequency C60pi46 = 0.0178903305 0.1958843646 0.0155853897 0.0031054277 0.0290304227 0.1051819261 0.0040503389 0.0100480293 0.1252696215 0.0016708003 0.0722356645 0.0233340169 0.0116142354 0.0238913260 0.0009938415 0.0181675536 0.0186260222 0.2260554691 0.0859787232 0.0113864962;\n\
frequency C60pi47 = 0.1454758367 0.0420979067 0.0400419720 0.1294249748 0.0014186329 0.0906469055 0.2471353458 0.0319650773 0.0130426183 0.0058525371 0.0123593139 0.0818154090 0.0044178939 0.0017552077 0.0151135525 0.0656688174 0.0511289472 0.0007731441 0.0029258438 0.0169400635;\n\
frequency C60pi48 = 0.0169799462 0.0242346701 0.1318047919 0.1043655101 0.0022087215 0.0269349684 0.0376379591 0.5404470183 0.0181137053 0.0007459679 0.0021146994 0.0508617611 0.0009473769 0.0006780593 0.0038754401 0.0297030159 0.0045836180 0.0006031889 0.0015704090 0.0015891728;\n\
frequency C60pi49 = 0.0402646249 0.1152022601 0.0323829165 0.0293968352 0.0039388655 0.2497008043 0.1603524245 0.0129260411 0.0617967839 0.0098491259 0.0354918823 0.1448804422 0.0124818865 0.0041153375 0.0043374229 0.0243246958 0.0305645368 0.0026676598 0.0097227847 0.0156026694;\n\
frequency C60pi50 = 0.2256914610 0.0523417493 0.0244308734 0.0637125217 0.0043390149 0.0578159236 0.1154830640 0.0867335173 0.0131066949 0.0085086217 0.0193314218 0.0660468804 0.0064877206 0.0027440054 0.0611149102 0.1070877179 0.0507677144 0.0013695913 0.0028982948 0.0299883012;\n\
frequency C60pi51 = 0.0033164209 0.0015310773 0.0030830171 0.0008266472 0.0051890730 0.0011024889 0.0005134130 0.0010432830 0.0278451262 0.0041895268 0.0111212494 0.0007149922 0.0023621780 0.3801761447 0.0008365077 0.0035876698 0.0023608948 0.0333346985 0.5107889643 0.0060766272;\n\
frequency C60pi52 = 0.1995014012 0.0236078675 0.0392254543 0.0094955104 0.0584590451 0.0254265363 0.0125535371 0.0939787338 0.0341857201 0.0140209879 0.0449387571 0.0118723304 0.0246990633 0.0634433944 0.0145385320 0.1663920640 0.0533159207 0.0129802666 0.0606346163 0.0367302614;\n\
frequency C60pi53 = 0.0319448994 0.1011667268 0.2084709220 0.0378074649 0.0066040348 0.0766372935 0.0279488190 0.0365541130 0.2088643258 0.0047542347 0.0156545731 0.0868664783 0.0043253317 0.0108915768 0.0060899575 0.0577656939 0.0302051160 0.0026001883 0.0387897304 0.0060585202;\n\
frequency C60pi54 = 0.0776799515 0.0142518583 0.0403216692 0.0080651725 0.0140092962 0.0179995517 0.0112622427 0.0136868237 0.0133729897 0.1239635380 0.0724670993 0.0129144967 0.0420745442 0.0173584908 0.0117084432 0.0922723571 0.2316899445 0.0028153633 0.0141726542 0.1679135132;\n\
frequency C60pi55 = 0.1183662657 0.0805192606 0.0259524932 0.0495595439 0.0035624835 0.1204924917 0.1537589210 0.0194993426 0.0229373171 0.0302661211 0.0571250629 0.0982304112 0.0171727472 0.0068665705 0.0175153030 0.0486588400 0.0635796210 0.0023008307 0.0083027431 0.0553336300;\n\
frequency C60pi56 = 0.0528559899 0.0193569043 0.0264743774 0.2092761515 0.0008625883 0.1212409715 0.4024189781 0.0155838458 0.0124148798 0.0054864832 0.0090256472 0.0497017031 0.0042357114 0.0012650715 0.0063185636 0.0197262901 0.0235463735 0.0008381610 0.0033948741 0.0159764347;\n\
frequency C60pi57 = 0.0344366215 0.0426221820 0.1636716191 0.1139007491 0.0020985982 0.0605413987 0.0541780220 0.3361639671 0.0461776737 0.0003463416 0.0048355678 0.0667552967 0.0019704509 0.0031557619 0.0040369775 0.0481173332 0.0089148085 0.0006510101 0.0054145649 0.0020110555;\n\
frequency C60pi58 = 0.1153088951 0.0151278638 0.0458476603 0.1755516676 0.0014962362 0.0366731222 0.1749410045 0.0394181311 0.0132401530 0.0056912974 0.0101409559 0.0433118387 0.0030332064 0.0015700232 0.1665802563 0.0871536033 0.0468260603 0.0007515702 0.0031432715 0.0141931831;\n\
frequency C60pi59 = 0.3865149348 0.0037579334 0.0030420497 0.0022366810 0.0218928357 0.0021464743 0.0031387843 0.3694353983 0.0014672902 0.0085376076 0.0127257242 0.0018840458 0.0080581695 0.0039281367 0.0158688291 0.0808877279 0.0305195935 0.0009922880 0.0019020345 0.0410634615;\n\
frequency C60pi60 = 0.0146570745 0.0028841333 0.0012998335 0.0005210575 0.0024317913 0.0049362750 0.0014874369 0.0020953252 0.0010181940 0.1913901476 0.4432797758 0.0022898369 0.2217427062 0.0091637503 0.0007685153 0.0027251487 0.0170997497 0.0008779380 0.0014756028 0.0778557075;\n\
model C60 = POISSON+G+FMIX{C60pi1:1:0.0169698865,C60pi2:1:0.0211683374,C60pi3:1:0.0276589079,C60pi4:1:0.0065675964,C60pi5:1:0.0141221416,C60pi6:1:0.0068774834,C60pi7:1:0.0146909701,C60pi8:1:0.0067225777,C60pi9:1:0.0018396660,C60pi10:1:0.0102547197,C60pi11:1:0.0230896163,C60pi12:1:0.0057941033,C60pi13:1:0.0125394534,C60pi14:1:0.0204526478,C60pi15:1:0.0070629602,C60pi16:1:0.0117982741,C60pi17:1:0.0068334668,C60pi18:1:0.0433775839,C60pi19:1:0.0318278731,C60pi20:1:0.0222546108,C60pi21:1:0.0102264969,C60pi22:1:0.0150545891,C60pi23:1:0.0134159878,C60pi24:1:0.0148552065,C60pi25:1:0.0239111516,C60pi26:1:0.0128776278,C60pi27:1:0.0222318842,C60pi28:1:0.0247444742,C60pi29:1:0.0214274810,C60pi30:1:0.0115001882,C60pi31:1:0.0076017389,C60pi32:1:0.0130258568,C60pi33:1:0.0093701965,C60pi34:1:0.0467194264,C60pi35:1:0.0441940314,C60pi36:1:0.0322263154,C60pi37:1:0.0402999891,C60pi38:1:0.0150234227,C60pi39:1:0.0104589903,C60pi40:1:0.0214742395,C60pi41:1:0.0154957836,C60pi42:1:0.0101789953,C60pi43:1:0.0227980379,C60pi44:1:0.0123204539,C60pi45:1:0.0066777583,C60pi46:1:0.0004150083,C60pi47:1:0.0344385130,C60pi48:1:0.0113663379,C60pi49:1:0.0127143049,C60pi50:1:0.0124323741,C60pi51:1:0.0262124415,C60pi52:1:0.0064994957,C60pi53:1:0.0103203293,C60pi54:1:0.0142463512,C60pi55:1:0.0215600067,C60pi56:1:0.0199150700,C60pi57:1:0.0038964200,C60pi58:1:0.0113448855,C60pi59:1:0.0128595846,C60pi60:1:0.0117656776};\n\
\n\
end;\n";

const double MIN_MIXTURE_PROP = 0.001;
//const double MAX_MIXTURE_PROP = 1000.0;
//const double MIN_MIXTURE_RATE = 0.01;
//const double MAX_MIXTURE_RATE = 100.0;

ModelSubst* createModel(string model_str, ModelsBlock *models_block, StateFreqType freq_type, string freq_params,
		PhyloTree* tree, bool count_rates)
{
	ModelSubst *model = NULL;
	//cout << "Numstates: " << tree->aln->num_states << endl;
	string model_params;
	NxsModel *nxsmodel = models_block->findModel(model_str);
	if (nxsmodel) model_params = nxsmodel->description;
	size_t pos = model_str.find(OPEN_BRACKET);
	if (pos != string::npos) {
		if (model_str.rfind(CLOSE_BRACKET) != model_str.length()-1)
			outError("Close bracket not found at the end of ", model_str);
		model_params = model_str.substr(pos+1, model_str.length()-pos-2);
		model_str = model_str.substr(0, pos);
	}
	/*
	if ((model_str == "JC" && tree->aln->seq_type == SEQ_DNA) ||
		(model_str == "POISSON" && tree->aln->seq_type == SEQ_PROTEIN) ||
		(model_str == "JC2" && tree->aln->seq_type == SEQ_BINARY) ||
		(model_str == "JCC" && tree->aln->seq_type == SEQ_CODON) ||
		(model_str == "MK" && tree->aln->seq_type == SEQ_MORPH))
	{
		model = new ModelSubst(tree->aln->num_states);
	} else */
//	if ((model_str == "GTR" && tree->aln->seq_type == SEQ_DNA) ||
//		(model_str == "GTR2" && tree->aln->seq_type == SEQ_BINARY) ||
//		(model_str == "GTR20" && tree->aln->seq_type == SEQ_PROTEIN)) {
//		model = new ModelGTR(tree, count_rates);
//		if (freq_params != "")
//			((ModelGTR*)model)->readStateFreq(freq_params);
//		if (model_params != "")
//			((ModelGTR*)model)->readRates(model_params);
//		((ModelGTR*)model)->init(freq_type);
//	} else
	if (model_str == "UNREST") {
		freq_type = FREQ_EQUAL;
		//params.optimize_by_newton = false;
		tree->optimize_by_newton = false;
		model = new ModelNonRev(tree, count_rates);
		((ModelNonRev*)model)->init(freq_type);
	} else if (tree->aln->seq_type == SEQ_BINARY) {
		model = new ModelBIN(model_str.c_str(), model_params, freq_type, freq_params, tree, count_rates);
	} else if (tree->aln->seq_type == SEQ_DNA) {
		model = new ModelDNA(model_str.c_str(), model_params, freq_type, freq_params, tree, count_rates);
	} else if (tree->aln->seq_type == SEQ_PROTEIN) {
		model = new ModelProtein(model_str.c_str(), model_params, freq_type, freq_params, tree, count_rates);
	} else if (tree->aln->seq_type == SEQ_CODON) {
		model = new ModelCodon(model_str.c_str(), model_params, freq_type, freq_params, tree, count_rates);
	} else if (tree->aln->seq_type == SEQ_MORPH) {
		model = new ModelMorphology(model_str.c_str(), model_params, freq_type, freq_params, tree);
	} else {
		outError("Unsupported model type");
	}

	return model;
}

/**
	constructor
	@param tree associated tree for the model
*/
ModelMixture::ModelMixture(PhyloTree *tree, bool count_rates) : ModelGTR(tree, count_rates) {
	prop = NULL;
	fix_prop = true;
	optimizing_submodels = false;
}

ModelMixture::ModelMixture(string orig_model_name, string model_name, string model_list, ModelsBlock *models_block,
		StateFreqType freq, string freq_params, PhyloTree *tree, bool optimize_weights, bool count_rates)
	: ModelGTR(tree, count_rates)
{
	prop = NULL;
	fix_prop = true;
	optimizing_submodels = false;
	initMixture(orig_model_name, model_name, model_list, models_block, freq, freq_params, tree, optimize_weights, count_rates);
}

void ModelMixture::initMixture(string orig_model_name, string model_name, string model_list, ModelsBlock *models_block,
		StateFreqType freq, string freq_params, PhyloTree *tree, bool optimize_weights, bool count_rates)
{
//	const int MAX_MODELS = 64;
	size_t cur_pos;
	int m;

	vector<NxsModel*> freq_vec;
	DoubleVector freq_rates;
	DoubleVector freq_weights;
	fix_prop = false;
	optimizing_submodels = false;

	if (freq == FREQ_MIXTURE) {
		for (m = 0, cur_pos = 0; cur_pos < freq_params.length(); m++) {
			size_t pos = freq_params.find(',', cur_pos);
			if (pos == string::npos)
				pos = freq_params.length();
			if (pos <= cur_pos)
				outError("One frequency name in the mixture is empty.");
			string this_name = freq_params.substr(cur_pos, pos-cur_pos);
			double rate = 1.0, weight = 1.0;
			size_t pos_rate = this_name.find(':');
			if (pos_rate != string::npos) {
				size_t pos_weight = this_name.find(':', pos_rate+1);
				if (pos_weight == string::npos) {
					rate = convert_double(this_name.substr(pos_rate+1).c_str());
				} else {
					rate = convert_double(this_name.substr(pos_rate+1, pos_weight-pos_rate-1).c_str());
					weight = convert_double(this_name.substr(pos_weight+1).c_str());
					fix_prop = true;
					if (weight <= 0.0)
						outError("Mixture component weight is negative!");
                    weight = max(weight, MIN_MIXTURE_PROP);
				}
				this_name = this_name.substr(0, pos_rate);
			}
			freq_rates.push_back(rate);
			freq_weights.push_back(weight);
			cur_pos = pos+1;
			if (this_name == "empirical") {
				freq_vec.push_back(NULL);
			} else {
				NxsModel *freq_mod = models_block->findModel(this_name);
				if (!freq_mod)
					outError("Frequency mixture name not found ", this_name);
				if (!(freq_mod->flag & NM_FREQ)) {
					cout << freq_mod->flag << endl;
					outError("Frequency mixture name does not corresponding to frequency model ", this_name);
				}
				freq_vec.push_back(freq_mod);
			}
		}
        double sum_weights = 0.0;
        for (m = 0; m < freq_weights.size(); m++)
            if (freq_vec[m]) 
                sum_weights += freq_weights[m];
        for (m = 0; m < freq_weights.size(); m++)
            if (!freq_vec[m]) 
                freq_weights[m] = sum_weights/freq_weights.size();
		ModelGTR::init(FREQ_USER_DEFINED);
	} else {
		if (freq_params != "")
			readStateFreq(freq_params);
		ModelGTR::init(freq);
	}

	DoubleVector weights;
    name = orig_model_name.substr(0, orig_model_name.find_first_of("+*"));
    if (!models_block->findMixModel(name))
        name = "";
	full_name = (string)"MIX" + OPEN_BRACKET;
	if (model_list == "") model_list = model_name;
	for (m = 0, cur_pos = 0; cur_pos < model_list.length(); m++) {
		size_t pos = model_list.find(',', cur_pos);
		if (pos == string::npos)
			pos = model_list.length();
		if (pos <= cur_pos)
			outError("One model name in the mixture is empty.");
		string this_name = model_list.substr(cur_pos, pos-cur_pos);
		double rate = 1.0, weight = 1.0;
		size_t pos_rate = this_name.find(':');
		if (pos_rate != string::npos) {
			size_t pos_weight = this_name.find(':', pos_rate+1);
			if (pos_weight == string::npos) {
				rate = convert_double(this_name.substr(pos_rate+1).c_str());
			} else {
				rate = convert_double(this_name.substr(pos_rate+1, pos_weight-pos_rate-1).c_str());
				weight = convert_double(this_name.substr(pos_weight+1).c_str());
				fix_prop = true;
				if (weight <= 0.0)
					outError("Mixture component weight is negative!");
			}
			this_name = this_name.substr(0, pos_rate);
		}
		cur_pos = pos+1;
		ModelGTR* model;
		if (freq == FREQ_MIXTURE) {
			for(int f = 0; f != freq_vec.size(); f++) {
				if (freq_vec[f])
					model = (ModelGTR*)createModel(this_name, models_block, FREQ_USER_DEFINED, freq_vec[f]->description, tree, count_rates);
				else
					model = (ModelGTR*)createModel(this_name, models_block, FREQ_EMPIRICAL, "", tree, count_rates);
				model->total_num_subst = rate * freq_rates[f];
				push_back(model);
				weights.push_back(weight * freq_weights[f]);
				if (m+f > 0) {
//					name += ',';
					full_name += ',';
				}
				if (freq_vec[f]) {
					model->name += "+F" +freq_vec[f]->name + "";
					model->full_name += "+F" +freq_vec[f]->name + "";
				} else {
					model->name += "+F";
					model->full_name += "+F";
				}
//				name += model->name;
				full_name += model->name;
			}
		} else {
			model = (ModelGTR*)createModel(this_name, models_block, freq, freq_params, tree, count_rates);
			model->total_num_subst = rate;
			push_back(model);
			weights.push_back(weight);
			if (m > 0) {
//				name += ',';
				full_name += ',';
			}
//			name += model->name;
			full_name += model->name;
		}
	}

//	name += CLOSE_BRACKET;
	full_name += CLOSE_BRACKET;

	int nmixtures = size();
	if (prop)
		aligned_free(prop);
	prop = aligned_alloc<double>(nmixtures);

	double sum = 0.0;
	int i;
	if (fix_prop) {
		for (i = 0, sum = 0.0; i < nmixtures; i++) {
			prop[i] = weights[i];
			sum += prop[i];
		}
	} else {
		// initialize rates as increasing
		for (i = 0, sum = 0.0; i < nmixtures; i++) {
//			prop[i] = random_double();
            prop[i] = 1.0/nmixtures;
			sum += prop[i];
		}
	}
	// normalize weights to 1.0
    if (sum != 1.0) {
        sum = 1.0/sum;
//        cout << "NOTE: Mixture weights do not sum up to 1, rescale weights by " << sum << endl;
        for (i = 0; i < nmixtures; i++)
             prop[i] *= sum;
    }     

	// rescale total_num_subst such that the global rate is 1
	for (i = 0, sum = 0.0; i < nmixtures; i++)
		sum += prop[i]*at(i)->total_num_subst;
	for (i = 0; i < nmixtures; i++)
		at(i)->total_num_subst /= sum;

	if (optimize_weights) fix_prop = false;
	fix_prop |= (nmixtures == 1);
	// use central eigen etc. stufffs

	if (eigenvalues) aligned_free(eigenvalues);
	if (eigenvectors) aligned_free(eigenvectors);
	if (inv_eigenvectors) aligned_free(inv_eigenvectors);
	if (eigen_coeff) aligned_free(eigen_coeff);

	eigenvalues = aligned_alloc<double>(num_states*nmixtures);
	eigenvectors = aligned_alloc<double>(num_states*num_states*nmixtures);
	inv_eigenvectors = aligned_alloc<double>(num_states*num_states*nmixtures);
	int ncoeff = num_states*num_states*num_states;
	eigen_coeff = aligned_alloc<double>(ncoeff*nmixtures);

	// assigning memory for individual models
	m = 0;
	for (iterator it = begin(); it != end(); it++, m++) {
        // first copy memory for eigen stuffs
        memcpy(&eigenvalues[m*num_states], (*it)->eigenvalues, num_states*sizeof(double));
        memcpy(&eigenvectors[m*num_states*num_states], (*it)->eigenvectors, num_states*num_states*sizeof(double));
        memcpy(&inv_eigenvectors[m*num_states*num_states], (*it)->inv_eigenvectors, num_states*num_states*sizeof(double));
        memcpy(&eigen_coeff[m*ncoeff], (*it)->eigen_coeff, ncoeff*sizeof(double));
        // then delete
		if ((*it)->eigenvalues) aligned_free((*it)->eigenvalues);
		if ((*it)->eigenvectors) aligned_free((*it)->eigenvectors);
		if ((*it)->inv_eigenvectors) aligned_free((*it)->inv_eigenvectors);
		if ((*it)->eigen_coeff) aligned_free((*it)->eigen_coeff);

        // and assign new memory
		(*it)->eigenvalues = &eigenvalues[m*num_states];
		(*it)->eigenvectors = &eigenvectors[m*num_states*num_states];
		(*it)->inv_eigenvectors = &inv_eigenvectors[m*num_states*num_states];
		(*it)->eigen_coeff = &eigen_coeff[m*ncoeff];
	}
	decomposeRateMatrix();
}

ModelMixture::~ModelMixture() {
	if (prop)
		aligned_free(prop);
	for (reverse_iterator rit = rbegin(); rit != rend(); rit++) {
		(*rit)->eigen_coeff = NULL;
		(*rit)->eigenvalues = NULL;
		(*rit)->eigenvectors = NULL;
		(*rit)->inv_eigenvectors = NULL;
		delete (*rit);
	}
}

void ModelMixture::setCheckpoint(Checkpoint *checkpoint) {
	CheckpointFactory::setCheckpoint(checkpoint);
	for (iterator it = begin(); it != end(); it++)
		(*it)->setCheckpoint(checkpoint);
}

void ModelMixture::saveCheckpoint() {
    checkpoint->startStruct("ModelMixture");
//    CKP_SAVE(fix_prop);
    int nmix = getNMixtures();
    CKP_ARRAY_SAVE(nmix, prop);
    int part = 1;
    for (iterator it = begin(); it != end(); it++, part++) {
        checkpoint->startStruct("Component" + convertIntToString(part));
        (*it)->saveCheckpoint();
        checkpoint->endStruct();
    }
    checkpoint->endStruct();

    ModelGTR::saveCheckpoint();
}

void ModelMixture::restoreCheckpoint() {
    ModelGTR::restoreCheckpoint();

    checkpoint->startStruct("ModelMixture");
//    CKP_RESTORE(fix_prop);
    int nmix = getNMixtures();
    CKP_ARRAY_RESTORE(nmix, prop);
    int part = 1;
    for (iterator it = begin(); it != end(); it++, part++) {
        checkpoint->startStruct("Component" + convertIntToString(part));
        (*it)->restoreCheckpoint();
        checkpoint->endStruct();
    }
    checkpoint->endStruct();

    decomposeRateMatrix();
    if (phylo_tree)
        phylo_tree->clearAllPartialLH();
}

int ModelMixture::getNDim() {
//	int dim = (fix_prop) ? 0: (size()-1);
    int dim = 0;
    if (!optimizing_submodels && !fix_prop)
    	dim = size()-1;
	for (iterator it = begin(); it != end(); it++)
		dim += (*it)->getNDim();
	return dim;
}

int ModelMixture::getNDimFreq() {
    int dim = 0;
	for (iterator it = begin(); it != end(); it++)
		dim += (*it)->getNDimFreq();
	return dim;
}

double ModelMixture::targetFunk(double x[]) {
	getVariables(x);
//	decomposeRateMatrix();
	int dim = 0;
	for (iterator it = begin(); it != end(); it++) {
		if ((*it)->getNDim() > 0)
			(*it)->decomposeRateMatrix();
		dim += ((*it)->getNDim());
	}
	assert(phylo_tree);
	if (dim > 0) // only clear all partial_lh if changing at least 1 rate matrix
		phylo_tree->clearAllPartialLH();
//	if (prop[size()-1] < 0.0) return 1.0e+12;
	return -phylo_tree->computeLikelihood();
}

double ModelMixture::optimizeWeights() {
    // first compute _pattern_lh_cat
    phylo_tree->computePatternLhCat(WSL_MIXTURE);
    size_t ptn, c;
    size_t nptn = phylo_tree->aln->getNPattern();
    size_t nmix = getNMixtures();
    
    double *new_prop = aligned_alloc<double>(nmix);
    double *ratio_prop = aligned_alloc<double>(nmix);

    // EM algorithm loop described in Wang, Li, Susko, and Roger (2008)
    for (int step = 0; step < nmix; step++) {
        // E-step

        if (step > 0) {
            // convert _pattern_lh_cat taking into account new weights
            for (ptn = 0; ptn < nptn; ptn++) {
                double *this_lk_cat = phylo_tree->_pattern_lh_cat + ptn*nmix;
                for (c = 0; c < nmix; c++) {
                    this_lk_cat[c] *= ratio_prop[c];
                }
            } 
        }
        memset(new_prop, 0, nmix*sizeof(double));
        for (ptn = 0; ptn < nptn; ptn++) {
            double *this_lk_cat = phylo_tree->_pattern_lh_cat + ptn*nmix;
            double lk_ptn = phylo_tree->ptn_invar[ptn];
            for (c = 0; c < nmix; c++) {
                lk_ptn += this_lk_cat[c];
            }
            lk_ptn = phylo_tree->ptn_freq[ptn] / lk_ptn;
            for (c = 0; c < nmix; c++) {
                new_prop[c] += this_lk_cat[c] * lk_ptn;
            }
        } 
        bool converged = true;
        double new_pinvar = 0.0;    
        for (c = 0; c < nmix; c++) {
            new_prop[c] /= phylo_tree->getAlnNSite();
            // check for convergence
            converged = converged && (fabs(prop[c]-new_prop[c]) < 1e-4);
            ratio_prop[c] = new_prop[c] / prop[c];
            prop[c] = new_prop[c];
            new_pinvar += prop[c];
        }
        new_pinvar = 1.0 - new_pinvar;
        if (new_pinvar != 0.0) {
            converged = converged && (fabs(phylo_tree->getRate()->getPInvar()-new_pinvar) < 1e-4);
            phylo_tree->getRate()->setPInvar(new_pinvar);
            phylo_tree->getRate()->setOptimizePInvar(false);
            phylo_tree->computePtnInvar();
            
        }
        if (converged) break;

    }
    
    aligned_free(ratio_prop);
    aligned_free(new_prop);
//    aligned_free(lk_ptn);
    return phylo_tree->computeLikelihood();
}

double ModelMixture::optimizeWithEM(double gradient_epsilon) {
    size_t ptn, c;
    size_t nptn = phylo_tree->aln->getNPattern();
    size_t nmix = size();
    
    double *new_prop = aligned_alloc<double>(nmix);
    PhyloTree *tree = new PhyloTree;
    
    // attach memory to save space
    tree->central_partial_lh = phylo_tree->central_partial_lh;
    tree->central_scale_num = phylo_tree->central_scale_num;
    tree->central_partial_pars = phylo_tree->central_partial_pars;
    
    tree->copyPhyloTree(phylo_tree);
    tree->optimize_by_newton = phylo_tree->optimize_by_newton;
    tree->setLikelihoodKernel(phylo_tree->sse);
    // initialize model
    ModelFactory *model_fac = new ModelFactory();
    model_fac->joint_optimize = phylo_tree->params->optimize_model_rate_joint;
//    model_fac->unobserved_ptns = phylo_tree->getModelFactory()->unobserved_ptns;

    RateHeterogeneity *site_rate = new RateHeterogeneity; 
    tree->setRate(site_rate);
    site_rate->setTree(tree);
            
    model_fac->site_rate = site_rate;
    tree->model_factory = model_fac;
    tree->setParams(phylo_tree->params);
    double score;
        
    int num_steps = (getNDim()+1)*3;
    
    // EM algorithm loop described in Wang, Li, Susko, and Roger (2008)
    for (int step = 0; step < num_steps; step++) {
        // first compute _pattern_lh_cat
        score = phylo_tree->computePatternLhCat(WSL_MIXTURE);
        
        memset(new_prop, 0, nmix*sizeof(double));
                
        // E-step
        // decoupled weights (prop) from _pattern_lh_cat to obtain L_ci and compute pattern likelihood L_i
        for (ptn = 0; ptn < nptn; ptn++) {
            double *this_lk_cat = phylo_tree->_pattern_lh_cat + ptn*nmix;
            double lk_ptn = phylo_tree->ptn_invar[ptn];
            for (c = 0; c < nmix; c++) {
                lk_ptn += this_lk_cat[c];
            }
            lk_ptn = phylo_tree->ptn_freq[ptn] / lk_ptn;
            
            // transform _pattern_lh_cat into posterior probabilities of each category
            for (c = 0; c < nmix; c++) {
                this_lk_cat[c] *= lk_ptn;
                new_prop[c] += this_lk_cat[c];
            }
        } 
        
        // M-step, update weights according to (*)        
        
        bool converged = !fix_prop;
        
        if (!fix_prop) {
            double new_pinvar = 0.0;
            for (c = 0; c < nmix; c++) {
                new_prop[c] = new_prop[c] / phylo_tree->getAlnNSite();
                // check for convergence
                converged = converged && (fabs(prop[c]-new_prop[c]) < 1e-4);
                prop[c] = new_prop[c];
                new_pinvar += prop[c];
            }
            new_pinvar = 1.0 - new_pinvar;
            if (new_pinvar != 0.0) {
                converged = converged && (fabs(phylo_tree->getRate()->getPInvar()-new_pinvar) < 1e-4);
                phylo_tree->getRate()->setPInvar(new_pinvar);
                phylo_tree->getRate()->setOptimizePInvar(false);
                phylo_tree->computePtnInvar();
            }
        }
        
        // now optimize model one by one
        for (c = 0; c < nmix; c++) if (at(c)->getNDim() > 0) {
            tree->copyPhyloTree(phylo_tree);
            ModelGTR *subst_model;
            subst_model = at(c);
            tree->setModel(subst_model);
            subst_model->setTree(tree);
            model_fac->model = subst_model;
                        
            // initialize likelihood
            tree->initializeAllPartialLh();
            // copy posterior probability into ptn_freq
            tree->computePtnFreq();
            double *this_lk_cat = phylo_tree->_pattern_lh_cat+c;
            for (ptn = 0; ptn < nptn; ptn++)
                tree->ptn_freq[ptn] = this_lk_cat[ptn*nmix];
            subst_model->optimizeParameters(gradient_epsilon);
            // reset subst model
            tree->setModel(NULL);
            subst_model->setTree(phylo_tree);
            
        }
        
        phylo_tree->clearAllPartialLH();
        if (converged) break;
    }
    
    // deattach memory
    tree->central_partial_lh = NULL;
    tree->central_scale_num = NULL;
    tree->central_partial_pars = NULL;
    
    delete tree;
    aligned_free(new_prop);
    score = phylo_tree->computeLikelihood();
    phylo_tree->clearAllPartialLH();
    return score;
}

double ModelMixture::optimizeParameters(double gradient_epsilon) {
	optimizing_submodels = true;
    
    int dim = getNDim();
    double score = 0.0;
    
    if (!phylo_tree->getModelFactory()->unobserved_ptns.empty())
        outError("Mixture model +ASC is not supported yet. Contact author if needed.");
    
    if (dim > 0)
        score = optimizeWithEM(gradient_epsilon);
    else if (!fix_prop)
        score = optimizeWeights();
    
//	double score = ModelGTR::optimizeParameters(gradient_epsilon);
	optimizing_submodels = false;
	if (getNDim() == 0) return score;
	// now rescale Q matrices to have proper interpretation of branch lengths
	double sum;
	int i, ncategory = size();
	for (i = 0, sum = 0.0; i < ncategory; i++)
		sum += prop[i]*at(i)->total_num_subst;
//    sum += phylo_tree->getRate()->getPInvar();
    if (fabs(sum-1.0) > 1e-6) {
        for (i = 0; i < ncategory; i++)
            at(i)->total_num_subst /= sum;
        decomposeRateMatrix();
        phylo_tree->clearAllPartialLH();
    }
	return score;
}

void ModelMixture::decomposeRateMatrix() {
	for (iterator it = begin(); it != end(); it++)
		(*it)->decomposeRateMatrix();
}

void ModelMixture::setVariables(double *variables) {
	int dim = 0;
	for (iterator it = begin(); it != end(); it++) {
		(*it)->setVariables(&variables[dim]);
		dim += (*it)->getNDim();
	}
//	if (fix_prop) return;
//	int i, ncategory = size();

//	variables[dim+1] = prop[0]*at(0)->total_num_subst;
//	for (i = 2; i < ncategory; i++)
//		variables[dim+i] = variables[dim+i-1] + prop[i-1]*at(i-1)->total_num_subst;

//	variables[dim+1] = prop[0];
//	for (i = 2; i < ncategory; i++)
//		variables[dim+i] = variables[dim+i-1] + prop[i-1];

    // BQM 2015-05-19: modify using the same strategy for FreeRate model (thanks to Thomas Wong)
//	for (i = 0; i < ncategory-1; i++) {
//		variables[dim+i+1] = prop[i] / prop[ncategory-1];
//        if (variables[dim+i+1] < MIN_MIXTURE_PROP*0.9 || variables[dim+i+1] > MAX_MIXTURE_PROP) {
//            outWarning("For component " + convertIntToString(i+1) + ", mixture weight " + convertDoubleToString(variables[dim+i+1]) + " is out of bound and may cause numerical instability");
//        }
//    }

}

bool ModelMixture::getVariables(double *variables) {
	int dim = 0;
    bool changed = false;
	for (iterator it = begin(); it != end(); it++) {
		changed |= (*it)->getVariables(&variables[dim]);
		dim += (*it)->getNDim();
	}
//	if (fix_prop) return;
//	int i, ncategory = size();

//	double *y = new double[ncategory+1];
//	y[0] = 0; y[ncategory] = 1.0;
//	memcpy(y+1, variables+dim+1, (ncategory-1) * sizeof(double));
//	std::sort(y+1, y+ncategory);
//	double sum = 0.0;
//	for (i = 0; i < ncategory; i++) {
//		prop[i] = (y[i+1]-y[i]);
//	}

    // BQM 2015-05-19: modify using the same strategy for FreeRate model (thanks to Thomas Wong)
//	double sum = 1.0;
//	for (i = 0; i < ncategory-1; i++) {
//		sum += variables[dim+i+1];
//	}
//	for (i = 0; i < ncategory-1; i++) {
//		prop[i] = variables[dim+i+1] / sum;
//	}
//	prop[ncategory-1] = 1.0 / sum;
    
    
//	for (i = 0, sum = 0.0; i < ncategory; i++)
//		sum += prop[i]*at(i)->total_num_subst;
//	for (i = 0; i < ncategory; i++)
//		at(i)->total_num_subst /= sum;

//	if (verbose_mode >= VB_MAX) {
//		for (i = 0; i < ncategory; i++)
//			cout << "Component " << i << " prop=" << prop[i] << endl;
//	}
//	delete [] y;

    return changed;
}

void ModelMixture::setBounds(double *lower_bound, double *upper_bound, bool *bound_check) {
	int dim = 0;
	for (iterator it = begin(); it != end(); it++) {
		(*it)->setBounds(&lower_bound[dim], &upper_bound[dim], &bound_check[dim]);
		dim += (*it)->getNDim();
	}
//	if (fix_prop) return;
//	int i, ncategory = size();
//	for (i = 1; i < ncategory; i++) {
//		lower_bound[dim+i] = MIN_MIXTURE_PROP;
//		upper_bound[dim+i] = MAX_MIXTURE_PROP;
//		bound_check[dim+i] = false;
//	}
}

void ModelMixture::writeInfo(ostream &out) {
	int i;
	for (i = 0; i < size(); i++) {
		at(i)->writeInfo(out);
	}
//	if (fix_prop) return;
	cout << "Mixture weights:";
	for (i = 0; i < size(); i++)
		cout << " " << prop[i];
	cout << endl;
}

void ModelMixture::writeParameters(ostream &out) {
	for (iterator it = begin(); it != end(); it++) {
		(*it)->writeParameters(out);
	}
}

string ModelMixture::getName() {
    if (name != "") return name;
    string retname = "MIX";
    retname += OPEN_BRACKET;
    for (iterator it = begin(); it != end(); it++) {
        if (it != begin()) retname += ",";
        retname += (*it)->getName();
    }
    retname += CLOSE_BRACKET;
    return retname;
}

string ModelMixture::getNameParams() {
    if (full_name != "")
        return full_name;
    string retname = "MIX";
    retname += OPEN_BRACKET;
    for (iterator it = begin(); it != end(); it++) {
        if (it != begin()) retname += ",";
        retname += (*it)->getNameParams();
    }
    retname += CLOSE_BRACKET;
    return retname;
}
