/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "statisticsutility.h"

#include <qtextstream.h>

const QString StatisticsUtility::defaultmimetype= QString( "text/html");
const QString StatisticsUtility::name= QString( "Statistics");

StatisticsUtility::StatisticsUtility(IPod& ipod)
 : IPodUtility(), _ipod_(ipod)
{
}


StatisticsUtility::~StatisticsUtility()
{
}

const QString& StatisticsUtility::getName() {
    return name;
}

const QString& StatisticsUtility::getDefaultMimeType() {
    return defaultmimetype;
}

void StatisticsUtility::handleRequest(const KURL& request, QByteArray& response, QString& mimeType)
{
    QTextOStream stream( response);
    QString title= _ipod_.getName();
    
    mimeType= "text/html";
    stream << "<html><head><title>Statistics for " + title + "</title></head>\n";
    stream << "<body bgcolor=\"white\">\n";
    stream << "<h1 align=\"right\">Statistics for <em>" + title + "</em></h1>\n";
    stream << "<table align=\"center\" frame=\"void\"><tbody>\n";
    stream << "<tr><td><font size=\"+3\">Number of tracks</font></td><td><font size=\"+3\">" << QString::number( _ipod_.getNumTracks()) << "</font></td></tr>\n";
    stream << "<tr><td><font size=\"+3\">Number of playlists</font></td><td><font size=\"+3\">" << QString::number( _ipod_.getNumPlaylists()) << "</font></td></tr>\n";
    stream << "</tbody></table></body></html>\n";
}

