/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PROPERTYUTILITY_H
#define PROPERTYUTILITY_H

#include "ipodutility.h"
#include "itunesdb.h"
/**
@author Michael Schulze
*/
class PropertyUtility : public IPodUtility
{
public:
    PropertyUtility(ITunesDB& trackcontainer);
    virtual ~PropertyUtility();

    const QString& getName();
    const QString& getDefaultMimeType();
    virtual void handleRequest(const KURL& request, QByteArray& response, QString& mimeType);
protected:
    ITunesDB * container;
    static const QString defaultmimetype;
    static const QString name;
};

#endif
