/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DIRECTORYMODEL_H
#define DIRECTORYMODEL_H

#include <qstring.h>
#include <qvaluevector.h>
#include <kurl.h>

#define CATNAME_ARTISTS "Artists"
#define CATNAME_PLAYLISTS "Playlists"
#define CATNAME_UTILS "Utilities"

/**
Represents the directory tree

@author Michael Schulze
*/
class DirectoryModel{
public:

    enum Category {
        Artists,
        Playlists,
        Utilites,
        NumCategories
    };
    
    enum Type {
        ROOT = -1,
        CATEGORY = 0,
        ARTIST = 1,
        ALBUM = 2,
        PLAYLIST = 3,
        UTILITY = 4,
        TRACK = 5,
        UNKNOWN= 255
    } type;
    
    bool isFile;
    const QString& getUtilityName() const;
    const QString& getPlaylist() const;
    Category getCategory() const;
    static const QString& getCategoryName( Category category);
    const QString& getArtist() const;
    const QString& getAlbum() const;
    const QString& getTrack() const;

    
    DirectoryModel();
    DirectoryModel( const KURL& kurl);
    virtual ~DirectoryModel();

    void parseUrl( const KURL& url);

    /**
     * returns the name of the current directory
     */
    const QString& getCurrentDirectory() const;
    
    /**
     * returns the last path element in the url
     */
    const QString& getFilename() const;
        
protected:
    enum Index {
        ROOT_IDX= -1,
        CATEGORY_IDX= 0,
        ARTIST_IDX= 1,
        PLAYLIST_IDX= 1,
        UTILITY_IDX= 1,
        ALBUM_IDX= 2
    };
    
    Category category;
    
    QValueVector<QString> dircomponents;
    static const QString categoryNames[];
};

#endif
