// -*- C++ -*-
// --------------------------------------------------------------------
// Header file for clients of Xpdflib
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef PDFLIB_H
#define PDFLIB_H

#include "ipebase.h"

#include "xpdflib/object.h"
#include "xpdflib/xref.h"
#include "xpdflib/catalog.h"
#include "xpdflib/dict.h"
#include "xpdflib/error.h"
#include "xpdflib/fontfile.h"
#include "xpdflib/gfxfont.h"
#include "xpdflib/gfxstate.h"
#include "xpdflib/link.h"
#include "xpdflib/page.h"
#include "xpdflib/pdfdoc.h"
#include "xpdflib/stream.h"
#include "xpdflib/globalparams.h"
#include "xpdflib/chartypes.h"
#include "xpdflib/ocfile.h"
#include "xpdflib/outputdev.h"
#include "xpdflib/psoutputdev.h"
#include "xpdflib/globalparams.h"
#include "xpdflib/gfx.h"

extern void InitXpdfLib();

class PdfObject {
public:
  PdfObject() { /* nothing */ }
  ~PdfObject() { iObject.free(); }
  //Object& operator*() { return iObject; }
  Object* operator->() { return &iObject; }
  Object* operator&() { return &iObject; }
  IpeString String(); // for writing object to PDF file
private: // no copying or assigning
  PdfObject(const PdfObject &);
  void operator=(const PdfObject &);
public:
  Object iObject;
};

// --------------------------------------------------------------------
#endif
