// --------------------------------------------------------------------
// Conversion to a bitmap
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ipeutils.h"

#include "ipepdfdoc.h"
#include "ipefilter.h"
#include "ipefontpool.h"

#include "ipecanvas.h"

#include <qpixmap.h>
#include <qimage.h>
#include <qpainter.h>

// --------------------------------------------------------------------

class PaintServices : public IpeCanvasPaintServices {
public:
  PaintServices(const IpeFontPool *fp) : iFontPool(fp) { /* nothing */ }
  virtual void CvSvcSetRenderData(IpeBitmap &bitmap);
  virtual void CvSvcRenderCharacter(QPixmap *pixmap, int fontObject,
				    const IpeMatrix &m, const IpeVector &pos,
				    QRgb cRgb, uint charCode, uint uniCode);
private:
  const IpeFontPool *iFontPool;
};

void PaintServices::CvSvcSetRenderData(IpeBitmap &bitmap)
{
  QImage img = IpeImageFilter::Decode(bitmap);
  bitmap.SetRenderData(new QImage(img));
}

void PaintServices::CvSvcRenderCharacter(QPixmap *pixmap, int fontObject,
					 const IpeMatrix &m,
					 const IpeVector &pos,
					 QRgb cRgb,
					 uint charCode, uint uniCode)
{
  if (iFontPool)
    iFontPool->RenderCharacter(pixmap, fontObject, m, pos,
			       cRgb, charCode, uniCode);
}

// --------------------------------------------------------------------

QPixmap toPng(const IpePdfDocument *doc, const IpePage *page,
	      double zoom)
{
  IpeBBoxPainter bboxPainter(doc->StyleSheet());
  for (IpePage::const_iterator it = page->begin(); it != page->end(); ++it) {
    if (page->Layer(it->Layer()).IsVisible())
      it->Object()->Draw(bboxPainter);
  }

  IpeRect bbox = bboxPainter.BBox();
  int wid = int(bbox.Width() * zoom);
  int ht = int(bbox.Height() * zoom);
  QPixmap pixmap(wid, ht);
  pixmap.fill(Qt::white);

  QPainter qPainter;
  qPainter.begin(&pixmap);

  PaintServices services(doc->FontPool());
  IpeCanvasPainter painter(doc->StyleSheet(), &services,
			   &pixmap, &qPainter, zoom, true);
  painter.Transform(IpeLinear(zoom, 0, 0, -zoom));
  painter.Translate(-bbox.TopLeft());
  painter.Push();
  for (IpePage::const_iterator it = page->begin(); it != page->end(); ++it) {
    if (page->Layer(it->Layer()).IsVisible())
      it->Object()->Draw(painter);
  }
  painter.Pop();
  qPainter.end();

  return pixmap;
}

// --------------------------------------------------------------------
