# -*- text -*-
# --------------------------------------------------------------------
#
# Ipe configuration
#
# --------------------------------------------------------------------
#
# Freetype location
#
# Path to "ft2build.h" (if not on standard include path)
INCLUDEPATH += /usr/include/freetype2
# Path to "libfreetype.so" (if not in a standard library directory)
#LIBS       += /usr/lib
# --------------------------------------------------------------------
#
# Zlib location
#
# Path to "zlib.h" (if not on standard include path)
#INCLUDEPATH	 += /usr/include
# Path to "libz.so" (if not in a standard library directory)
#unix:LIBS       += /usr/lib
# --------------------------------------------------------------------
#
# Using threaded Qt library?
#
# Uncomment the next line to use the non-threaded Qt-library
CONFIG      += thread
# --------------------------------------------------------------------
#
# Installing Ipe:
#
IPEVERS = 6.0pre16
#
# IPEPREFIX is the global prefix for the Ipe directory structure, which
# you can override individually for any of the specific directories.
# You could choose "/usr/local" or "/opt/ipe-6.0", or
# even "/usr", or "$(HOME)/ipe-6.0" if you have to install in your home
# directory.
#
# If you are installing Ipe in a networked environment, keep in mind
# that executables, ipelets, and Ipe library are machine-dependent,
# while the documentation and fonts can be shared.
#
#IPEPREFIX  = /usr/local/ipe
#IPEPREFIX  = /usr
IPEPREFIX  = /opt/ipe-6.0
#
# Where Ipe executables will be installed ('ipe', 'ipe5toxml' etc)
IPEBINDIR  = $${IPEPREFIX}/bin
#
# Where the Ipe libraries will be installed (libipe.so.*)
IPELIBDIR  = $${IPEPREFIX}/lib
#
# Where the header files for Ipelib will be installed:
IPEHEADERDIR = $${IPEPREFIX}/include
#
# Where Ipelets will be installed:
IPELETDIR = $${IPEPREFIX}/lib/ipe/$${IPEVERS}/ipelets
#
# List of paths where Ipe will search for Ipelets:
# (Paths are separated by ":" on Windows and ";" on Unix)
IPELETPATH = $${IPELETDIR}
#
# IPEDATADIR will contain two (or three) subdirectories:
#  * IPEDATADIR/doc for documentation (mostly html files)
#  * IPEDATADIR/languages for Ipe localization (but none has been made yet)
#  * IPEDATADIR/fonts for the standard PDF fonts (on systems where these
#                                                 are not already elsewhere)
#
IPEDATADIR = $${IPEPREFIX}/share/ipe/$${IPEVERS}
#
# The full path to the Ipe fontmap:
IPEFONTMAP = $${IPEDATADIR}/fontmap.xml
#
# The HTML browser started to read the on-line Ipe documentation.
#IPEBROWSER = netscape
IPEBROWSER = konqueror
# --------------------------------------------------------------------
# Standard definitions --- don't change
CONFIG      += warn_on release
#linux-g++:QMAKE_CXXFLAGS_WARN_ON += -Werror
# --------------------------------------------------------------------
