-- workspace.lua
--
-- show current workspace name in the statusbar.
-- 
-- simply put the following in your cfg_user.lua:
--  dopath("workspace.lua")
-- and add to the cfg_statusbar.lua's template-line:
--  %workspace
--
-- author: Rico Schiekel <fire at paranetic dot de>
-- version: 1
--


if not _LOADED["mod_statusbar"] then return end

if not workspace then
  workspace = { interval = 150 }
end

local timer = nil
local old_ws = "-"
local ws = "-"

local function update()
    ws = ioncore.find_screen_id(0):current():name()
end

local function notify_statusbar()
    if old_ws ~= ws then
        old_ws = ws
        mod_statusbar.inform('workspace', ws)
        mod_statusbar.update()
    end

    timer:set(workspace.interval, notify_statusbar)
end

-- Init
ioncore.get_hook("screen_managed_changed_hook"):add(update)

timer = ioncore.create_timer()
timer:set(workspace.interval, notify_statusbar)

