-- Toggle (and create) a named scratchpad.
-- Example: This will create a scratchpad named example_sp
--          kpress(MOD4.."space", "toggle_named_scratchpad(_, 'example_sp')")
-- Etan Reisner <deryni@gmail.com>

function toggle_named_scratchpad(reg, name)
	local named_sp

	named_sp = ioncore.lookup_region(name, "WScratchpad")

	if not named_sp then
		named_sp = reg:screen_of():attach_new({type='WScratchpad', layer=2, name=name})
		-- I'm not sure why this is necessary but if I don't have this the first call doesn't show the scratchpad
		mod_sp.set_shown(named_sp, 'unset')
	end

	mod_sp.set_shown(named_sp, 'toggle')
end
