--[[
    lock_frame.lua

    Setup: Add dopath("lock_frame") to cfg_ion.lua
 
    Usage: Tag frames to be locked then press F8 to set lock. These frames
    will now not respond to close functions.
    
    Author: James Gray <j dot gray at ed dot ac dot uk> (yaarg in #ion)
    
    Date: Sat Dec 17 01:34:22 GMT 2005
    
]]

-- This is a slight abuse of the _LOADED variable perhaps, but library-like
-- packages should handle checking if they're loaded instead of confusing
-- the user with require/include differences.
if _LOADED["lock_frame"] then return end

lock_frame = {}  
local locks = {}

function lock_frame.set_locks()
    if not locks then 
        locks = ioncore.tagged_list()
    else
        local t = ioncore.tagged_list()
    for _, another_lock in t do
        table.insert( locks, another_lock )
    end
    end
    ioncore.clear_tags()
end

function lock_frame.check(frame)
    if not locks then return end

    ioncore.defer(function() 
        ioncore.defbindings("WMPlex",{
            kpress_wait(MOD1.."C",
            "WRegion.rqclose_propagate(_, _sub)")
        })
    end)

    for _, f in locks do
        if f == frame then 
            ioncore.defer(function() 
                ioncore.defbindings("WMPlex",{
                    kpress(MOD1.."C", nil)
                })
            end)
            break
        end
    end
end

function lock_frame.init()
    local hook = ioncore.get_hook("region_activated_hook")

    if hook then 
        hook:add(lock_frame.check)
    end 

    ioncore.defbindings("WScreen",{
        kpress("F8", "lock_frame.set_locks()")
    })
end

lock_frame.init()
