-- Creates scratchpads on a per clientwin basis.

-- I realized that sometimes it might be useful to have a scratchpad for
-- notes and things for only one cwin, and not just globally.

-- This script creates a binding for CTRL-MOD1-"space" to create/toggle the
-- per-cwin scratchpads and sets up MOD1-"space" to toggle the default one.

-- It assumes that the default scratchpad will be the only scratchpad that
-- exists other than the ones this script creates.

-- If you create your own scratchpads I would suggest you either name them
-- foo_sp (which will cause this script to grab them, but won't really matter)
-- or that you add logic to find_sps to ignore your scratchpads.

local sps = {}
local loaded = false

-- {{{ find_sps

local function find_sps()
-- Tuomo does this in check_and_create in mod_sp so I can do it here
	local hook

	hook = ioncore.get_hook("ioncore_post_layout_setup_hook")
	if hook then
		hook:remove(find_sps)
	end

-- I'd like to combine this into one line but I'm not sure what that would
-- do to the if test later, I'm not sure if the function returns nil
	local spl = ioncore.region_list("WScratchpad")

	table.foreach(spl, function(k, v)
		                   local s, e
		                   s, e = string.find(v:name(), "_sp$")
		                   if s then
			                   sps[v:name()] = v
		                   else
			                   if v:name() == "WScratchpad" then
				                   default_sp = v
			                   end
		                   end
	                   end)

	loaded = true
end

-- }}}

-- {{{ make_cwin_sp

function make_cwin_sp(frame, cwin)
	local g = {}
	local cg = {}
	local pg = {}
	local sp, key

	if not loaded then
		find_sps()
	end

	if obj_is(frame, "WScratchpad") then
		local s,e

		s,e = string.find(frame:name(), "_sp$")
		if s then
			mod_sp.set_shown(frame, "toggle")
		end

		return
	end

-- These are here so that if the client window changes size the
-- scratchpad for it will also.
	cg = cwin:geom()
	g.w = cg.w
	g.h = cg.h

	pg = cwin:parent():geom()
	g.x = pg.x
	g.y = cg.y - pg.y

	key = cwin:name().."_sp"

	if obj_is(sps[key], "WScratchpad") then
		sp = sps[key]
	else
		sp = cwin:screen_of():attach_new({type='WScratchpad', layer=2, name=key})
		sps[key] = sp
		mod_sp.set_shown(sp, "unset")
	end

	sp:rqgeom(g)
	mod_sp.set_shown(sp, "toggle")
end

-- }}}

function toggle_default_sp()
	if not loaded then
		find_sps()
	end

	mod_sp.set_shown(default_sp, "toggle")
end

local function show_hide_sps(t)
	local reg = t["reg"]

	if obj_is(reg, "WScreen") then
-- Need to figure out how to set things up so that this function can map an sp to the workspace it's clientwin is on to whether it was mapped or not when we switched workspaces.
	end
end

-- {{{ Init

local function setup_hooks()
	local hook

--	hook = ioncore.get_hook("screen_managed_changed_hook")
--	if hook then
--		hook:add(show_hide_sps)
--	end

	hook = ioncore.get_hook("ioncore_post_layout_setup_hook")
	if hook then
		hook:add(find_sps)
	end
end

-- }}}

-- {{{ Bindings

defbindings("WFrame", {
	kpress(MOD2..MOD1.."space", "make_cwin_sp(_, _sub)")
})

defbindings("WScreen", {
	kpress(MOD1.."space", "toggle_default_sp()")
})

-- }}}

setup_hooks()

-- vim:foldmethod=marker
