/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  drawingarea.cc - Open-GL capable drawing area implementation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "drawingarea.h"
#include "../../gdk/gl/config.h"
#include "../../gdk/gl/context.h"
#include "../../gdk/gl/drawable.h"

using namespace Inti;

/*  Gtk::GL::DrawingArea
 */

Gtk::GL::DrawingArea::DrawingArea()
{
}

Gtk::GL::DrawingArea::DrawingArea(const Gdk::GL::Config& glconfig, bool direct)
{
	set_gl_capability(glconfig, direct);
}

Gtk::GL::DrawingArea::DrawingArea(const Gdk::GL::Config& glconfig, int width, int height, bool direct)
: Gtk::DrawingArea(width, height)
{
	set_gl_capability(glconfig, direct);
}

Gtk::GL::DrawingArea::DrawingArea(const Gdk::GL::Config& glconfig, const Gdk::GL::Context& share_list, bool direct)
{
	set_gl_capability(glconfig, share_list, direct);
}

Gtk::GL::DrawingArea::DrawingArea(const Gdk::GL::Config& glconfig, const Gdk::GL::Context& share_list, int width, int height, bool direct)
: Gtk::DrawingArea(width, height)
{
	set_gl_capability(glconfig, share_list, direct);
}

Gtk::GL::DrawingArea::~DrawingArea()
{
}

bool
Gtk::GL::DrawingArea::is_double_buffered() const
{
	return get_gl_drawable()->is_double_buffered();
}

void
Gtk::GL::DrawingArea::swap_buffers()
{
	get_gl_drawable()->swap_buffers();
}

bool
Gtk::GL::DrawingArea::gl_begin()
{
	return get_gl_drawable()->gl_begin(*get_gl_context());
}

void
Gtk::GL::DrawingArea::gl_end()
{
	get_gl_drawable()->gl_end();
}

