/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  pixmap.cc - GdkGLPixmap C++ wrapper inmplementation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "pixmap.h"
#include "private/pixmap_p.h"
#include "private/drawable_p.h"
#include "config.h"
#include <inti/gdk/pixmap.h>

using namespace Inti;

/*  Gdk::GL::Pixmap
 */

Gdk::GL::Pixmap::Pixmap(GdkGLPixmap *pixmap, bool reference)
: Gdk::Drawable((GdkDrawable*)pixmap, reference)
{
}

Gdk::GL::Pixmap::~Pixmap()
{
}

Pointer<Gdk::GL::Pixmap>
Gdk::GL::Pixmap::create(const Config& glconfig, const Gdk::Pixmap& pixmap, const int *attrib_list)
{
	return G::Object::wrap<Gdk::GL::Pixmap>(gdk_gl_pixmap_new(glconfig.gdk_gl_config(), pixmap.gdk_pixmap(), attrib_list));
}

GdkGLPixmapClass*
Gdk::GL::Pixmap::gdk_gl_pixmap_class() const
{
	return get_class<GdkGLPixmapClass>();
}

Gdk::GL::Pixmap::operator GdkGLPixmap* () const
{
	return this ? gdk_gl_pixmap() : 0;
}

Gdk::Pixmap*
Gdk::GL::Pixmap::get_pixmap() const
{
	return G::Object::wrap<Gdk::Pixmap>(gdk_gl_pixmap_get_pixmap(gdk_gl_pixmap()));
}

Gdk::GL::Pixmap*
Gdk::GL::Pixmap::get_gl_pixmap(Gdk::Pixmap& pixmap)
{
	return G::Object::wrap<Pixmap>(gdk_pixmap_get_gl_pixmap(pixmap.gdk_pixmap()));
}

Gdk::GL::Drawable*
Gdk::GL::Pixmap::get_gl_drawable(Gdk::Pixmap& pixmap)
{
	GdkGLDrawable *drawable = gdk_pixmap_get_gl_drawable(pixmap.gdk_pixmap());
	Gdk::GL::Drawable *tmp_drawable = 0;
	if (drawable)
	{
		G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(drawable));
		tmp_drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	}
	return tmp_drawable;
}

bool
Gdk::GL::Pixmap::is_gl_capable(Gdk::Pixmap& pixmap)
{
	return gdk_pixmap_is_gl_capable(pixmap.gdk_pixmap());
}

Pointer<Gdk::GL::Pixmap>
Gdk::GL::Pixmap::set_gl_capability(Gdk::Pixmap& pixmap, const Config& glconfig, const int *attrib_list)
{
	return G::Object::wrap<Pixmap>(gdk_pixmap_set_gl_capability(pixmap.gdk_pixmap(), glconfig.gdk_gl_config(), attrib_list));
}

void
Gdk::GL::Pixmap::unset_gl_capability(Gdk::Pixmap& pixmap)
{
	gdk_pixmap_unset_gl_capability(pixmap.gdk_pixmap());
}

void
Gdk::GL::Pixmap::dispose()
{
	gdk_gl_pixmap_destroy(gdk_gl_pixmap());
}

/*  Gdk::GL::PixmapClass
 */

void
Gdk::GL::PixmapClass::init(GdkGLPixmapClass *g_class)
{
	Gdk::DrawableClass::init((GdkDrawableClass*)g_class);
}

GType
Gdk::GL::PixmapClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GDK_TYPE_GL_PIXMAP, (GClassInitFunc)init);
		G::TypeInstance::add_interface(type, GDK_TYPE_GL_DRAWABLE, (GInterfaceInitFunc)Gdk::GL::DrawableClass::init);
	}
	return type;
}

void*
Gdk::GL::PixmapClass::create()
{
	return g_object_new(get_type(), 0);
}

