/*========================== begin_copyright_notice ============================

Copyright (C) 2017-2021 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

// Template:
// DECLARE_IGC_REGKEY(type, flag, value_of_flag, description, release_mode)
//
// release_mode - The value is responsible for the availability of the flag in the Linux release

DECLARE_IGC_GROUP("VISA optimization")
DECLARE_IGC_REGKEY(bool, DisableSendS,                  false, "Setting this to 1/true adds a compiler switch to not generate sends commands, default is to enable sends ", false)
DECLARE_IGC_REGKEY(bool, EnablePreemption,              true,  "Enable generating preeemptable code (SKL+)", false)
DECLARE_IGC_REGKEY(bool, EnableVISANoSchedule,          false, "Enable VISA No-Schedule", true)
DECLARE_IGC_REGKEY(bool, EnableVISAPreSched,            true,  "Enable VISA Pre-RA Scheduler", true)
DECLARE_IGC_REGKEY(DWORD, VISAPreSchedCtrl,             0,     "Configure Pre-RA Scheduler, default(0), logging(1), latency(2), pressure(4)", false)
DECLARE_IGC_REGKEY(bool, ForceVISAPreSched,             false, "Force enabling of VISA Pre-RA Scheduler", false)
DECLARE_IGC_REGKEY(DWORD, VISAPreSchedRPThreshold,      0,     "Configure how aggressive pre-RA Scheduler is, 0 for the default", false)
DECLARE_IGC_REGKEY(DWORD, SIMD8_SpillThreshold,         2,     "Percentage of instructions allowed for spilling", false)
DECLARE_IGC_REGKEY(DWORD, SIMD16_SpillThreshold,        2,     "Percentage of instructions allowed for spilling", false)
DECLARE_IGC_REGKEY(bool, DisableCSEL,                   false, "disable csel peep-hole", false)
DECLARE_IGC_REGKEY(bool, DisableFlagOpt,                false, "Disable optimization cmp with logic op", false)
DECLARE_IGC_REGKEY(bool, DisableIfCvt,                  false, "Disable ifcvt", false)
DECLARE_IGC_REGKEY(bool, EnableVISANoBXMLEncoder,       false, "Enable VISA No-BXML encoder", false)
DECLARE_IGC_REGKEY(bool, EnableIGAEncoder,              false, "Enable VISA IGA encoder", false)
DECLARE_IGC_REGKEY(bool, EnableVISADumpCommonISA,       false, "Enable VISA Dump Common ISA", true)
DECLARE_IGC_REGKEY(bool, EnableVISABinary,              false, "Enable VISA Binary", true)
DECLARE_IGC_REGKEY(bool, EnableVISAOutput,              false, "Enable VISA GenISA output", true)
DECLARE_IGC_REGKEY(bool, EnableVISASlowpath,            false, "Enable VISA Slowpath. Needed to dump .visaasm", true)
DECLARE_IGC_REGKEY(bool, EnableVISADotAll,              false, "Enable VISA DotAll. Dumps dot files for intermediate stages", false)
DECLARE_IGC_REGKEY(bool, EnableVISADebug,               false, "Runs VISA in debug mode, all optimizations disabled", false)
DECLARE_IGC_REGKEY(DWORD, EnableVISAStructurizer,       1,     "Enable/Disable VISA structurizer. See value defs in igc_flags.hpp.", false)
DECLARE_IGC_REGKEY(bool, EnableVISAJmpi,                true,  "Enable/Disable VISA generating jmpi (scalar jump).", false)
DECLARE_IGC_REGKEY(bool, EnableVISADCE,                 false, "Enable/Disable VISA DCE.", false)
DECLARE_IGC_REGKEY(bool, ForceVISAStructurizer,         false, "Force VISA structurizer for testing. Used on platforms in which we turns off SCF and use UCF by default", false)
DECLARE_IGC_REGKEY(DWORD, NoMaskWA,                     2,     "Add NoMask WA using software-computed emask flag. Valid value: (two groups) \
                                                                   valid value:  bit[1:0] : which BB to insert - 0(off), 1(divergent BB), \
                                                                                            2 (nested divergent BB), 3 (=2). \
                                                                                 bit[2]   : how to add WA - 0 (optim, per-BB) | 1 (simple, ie, per-inst)", false)
DECLARE_IGC_REGKEY(bool, ForceNoMaskWA,                 false, "[tmp, testing] Force NoMaskWA on any platforms", false)
DECLARE_IGC_REGKEY(bool, ForceSubReturn,                true,  "If a subroutine does not have a return, generate a dummy return if this key is set (to meet visa requirement)", false)
DECLARE_IGC_REGKEY(DWORD,UnifiedSendCycle,              0,     "Using unified send cycle.", false)
DECLARE_IGC_REGKEY(DWORD,DisableMixMode,                0,     "Disables mix mode in vISA BE.", false)
DECLARE_IGC_REGKEY(DWORD,DisableHFMath,                 0,     "Disables HF math instructions.", false)
DECLARE_IGC_REGKEY(debugString, VISAOptions,            0,     "Options to vISA. Space-separated options.", true)
DECLARE_IGC_REGKEY(DWORD,disableIGASyntax,              false, "Disables GEN isa text output using IGA and new syntax.", false)
DECLARE_IGC_REGKEY(DWORD,disableCompaction,             false, "Disables compaction.", true)
DECLARE_IGC_REGKEY(DWORD,TotalGRFNum,                   0,     "Total GRF used for register allocation.", false)
DECLARE_IGC_REGKEY(DWORD,ReservedRegisterNum,           0,     "Reserve regsiter number for spill cost testing.", false)
DECLARE_IGC_REGKEY(DWORD, GRFNumToUse,                  0,     "Set the number of general registers to use (64 to totalGRFNum)", false)
DECLARE_IGC_REGKEY(bool, ExpandPlane,                   false, "Enable pln to mad macro expansion.", false)
DECLARE_IGC_REGKEY(bool, EnableBCR,                     false, "Enable bank conflict reduction.", true)
DECLARE_IGC_REGKEY(bool, ForceBCR,                     false, "Force bank conflict reduction, no matter spill or not.", true)
DECLARE_IGC_REGKEY(bool, EnableForceDebugSWSB,          false, "Enable force debugging functionality for software scoreboard generation", true)
DECLARE_IGC_REGKEY(DWORD,EnableSWSBInstStall,           0,     "Enable force stall to specific(start) instruction start for software scoreboard generation", true)
DECLARE_IGC_REGKEY(DWORD,EnableSWSBInstStallEnd,        0,     "Enable force stall to end instruction for software scoreboard generation", true)
DECLARE_IGC_REGKEY(DWORD,EnableSWSBTokenBarrier,        0,     "Enable force specific instruction as a barrier for software scoreboard generation", true)
DECLARE_IGC_REGKEY(DWORD,SWSBTokenNum,                  0,     "Total tokens used for SWSB.", true)
DECLARE_IGC_REGKEY(bool, EnableGroupScheduleForBC,      false,  "Enable bank conflict reduction in scheduling.", true)
DECLARE_IGC_REGKEY(bool, EnableIGASWSB,                 false,  "Use IGA for SWSB", true)
DECLARE_IGC_REGKEY(bool, EnableSWSBStitch,                 false,  "Insert dependence resolve for kernel stitching", true)
DECLARE_IGC_REGKEY(bool, DisableRegDistDep,                 false,  "distable regDist dependence", true)
DECLARE_IGC_REGKEY(bool, EnableQuickTokenAlloc,                 false,  "Insert dependence resolve for kernel stitching", true)
DECLARE_IGC_REGKEY(bool, SetA0toTdrForSendc,            false,  "Set A0 to tdr0 before each sendc/sendsc", true)
DECLARE_IGC_REGKEY(bool, ReplaceIndirectCallWithJmpi,   false,  "Replace indirect call with jmpi instruction (HW WA)", true)
DECLARE_IGC_REGKEY(bool, DPASTokenReduction,            false, "optimization to reduce the tokens used for DPAS instruction.", true)
DECLARE_IGC_REGKEY(bool, EnableAdd3,                    true,  "Enable Add3 (temporary for testing). XeHP only", true)
DECLARE_IGC_REGKEY(bool, EnableBfn,                     true,  "Enable Bfn (temporary for testing). XeHP only", true)
DECLARE_IGC_REGKEY(bool, SeparateSpillPvtScratchSpace,  false,  "Separate scratch spaces for spillfill and privatememory. XeHP and above only. Test only. Remove it once stabalized.", true)
DECLARE_IGC_REGKEY(bool, DisableThreeALUPipes,          false,  "Disable three ALU Pipelines. XeHP only", true)
DECLARE_IGC_REGKEY(bool, Enable16DWURBWrite,            false, "Enable 16 Dword URB Write messages", true)
DECLARE_IGC_REGKEY(bool, Enable16OWSLMBlockRW,          true,  "Enable 16 OWord (8 GRF) SLM block read/write message", true)
DECLARE_IGC_REGKEY(bool, Enable64BMediaBlockRW,         false,  "Enable 64 byte wide media block read/write message", true)
DECLARE_IGC_REGKEY(bool, DisableRegSharingHeuristics,   false,  "Disable compiler heuristics to decide number of threads per EU.", false)
DECLARE_IGC_REGKEY(bool, EnableUntypedSurfRWofSS,       true,   "Enable untyped surface RW to scratch space. XeHP A0 only.", true)

DECLARE_IGC_REGKEY(DWORD, ForceHWThreadNumberPerEU,                   0,     "Total HW thread number per-EU.", false)
DECLARE_IGC_REGKEY(bool, UseMathWithLUT,                false,  "Use the implementations of cos, cospi, log, sin, sincos, and sinpi with Look-Up Tables (LUT).", false)
DECLARE_IGC_REGKEY(bool, GlobalSendVarSplit, false, "Enable global send variable splitting when we are about to spill", false)
DECLARE_IGC_REGKEY(DWORD,EnableSendFusion,              1,     "Enable(!=0)/disable(0)/force(2) send fusion. Valid for simd8 shader/kernel only.", false)
DECLARE_IGC_REGKEY(bool, EnableAtomicFusion,            false, "To enable/disable atomic send fusion (simd8 shaders). Valid if EnableSendFusion is on.", false)
DECLARE_IGC_REGKEY(bool, Use16ByteBindlessSampler,      false, "True if 16-byte aligned bindless sampler state is used", false)
DECLARE_IGC_REGKEY(bool, AvoidDstSrcGRFOverlap,               false,  "avoid GRF overlap for destination and source operands of an SIMD16/SIMD32 instruction ", false)
DECLARE_IGC_REGKEY(bool, UseLinearScanRA,               false,  "use Linear Scan as default register allocation algorithm ", false)
DECLARE_IGC_GROUP("IGC Optimization")
DECLARE_IGC_REGKEY(bool, AllowMem2Reg,                  false, "Setting this to true makes IGC run mem2reg even when optimizations are disabled", true)
DECLARE_IGC_REGKEY(bool, DisableIGCOptimizations,       false, "Setting this to 1/true adds a compiler switch to disables all the above IGC optimizations", false)
DECLARE_IGC_REGKEY(bool, DisableLLVMGenericOptimizations, false, "Disable LLVM generic optimization passes", false)
DECLARE_IGC_REGKEY(bool, DisableCodeSinking,            false, "Setting this to 1/true adds a compiler switch to disable code-sinking", false)
DECLARE_IGC_REGKEY(bool, DisableCodeSinkingInputVec,    false, "Setting this to 1/true disable sinking inputVec inst (test)", false)
DECLARE_IGC_REGKEY(DWORD, LoopSinkMinSave,              5,  "If loop sink can have save more than this Minimum, do it; otherwise, skip", false)
DECLARE_IGC_REGKEY(DWORD, LoopSinkThresholdDelta,       50,  "Do loop sink If the estimated register pressure is higher than this + #avaialble registers", false)
DECLARE_IGC_REGKEY(bool, DisableCodeHoisting,           false, "Setting this to 1/true adds a compiler switch to disable code-hoisting", false)
DECLARE_IGC_REGKEY(bool, DisableDeSSA,                  false, "Setting this to 1/true adds a compiler switch to disable optimized De-SSA", false)
DECLARE_IGC_REGKEY(bool, EnableDeSSAWA,                 true,  "[tmp]Keep some piece of code to avoid perf regression", false)
DECLARE_IGC_REGKEY(DWORD, EnableDeSSAAlias,             3, "[tmp]Enable adding alias feature to DeSSA (3: dessa alias on)", false)
DECLARE_IGC_REGKEY(bool, DisablePayloadCoalescing,      false, "Setting this to 1/true adds a compiler switch to disable payload coalescing optimization for all types", false)
DECLARE_IGC_REGKEY(bool, DisablePayloadCoalescing_RT,   false, "Setting this to 1/true adds a compiler switch to disable payload coalescing optimization for RT only", false)
DECLARE_IGC_REGKEY(bool, DisablePayloadCoalescing_Sample, false, "Setting this to 1/true adds a compiler switch to disable payload coalescing optimization for Samplers only", false)
DECLARE_IGC_REGKEY(bool, DisablePayloadCoalescing_URB,  false, "Setting this to 1/true adds a compiler switch to disable payload coalescing optimization for URB writes only", false)
DECLARE_IGC_REGKEY(bool, DisableUniformAnalysis,        false, "Setting this to 1/true adds a compiler switch to disable uniform_analysis", false)
DECLARE_IGC_REGKEY(bool, EnableWorkGroupUniformGoto,    false, "Setting to 1 enables generating uniform goto for work group uniform [eu fusion only]", false)
DECLARE_IGC_REGKEY(DWORD, DisablePushConstant,           0, "Bit mask to disable push constant per shader stages. bit0 = All, Bit 1 = VS, Bit 2 = HS, Bit 3 = DS, Bit 4 = GS, Bit 5 = PS", false)
DECLARE_IGC_REGKEY(DWORD, DisableAttributePush,          0, "Bit mask to disable push Attribute per shader stages. bit0 = All, Bit 1 = VS, Bit 2 = HS, Bit 3 = DS, Bit 4 = GS", false)
DECLARE_IGC_REGKEY(bool, DisableSimplePushWithDynamicUniformBuffers, false,"Disable Simple Push Constants Optimization for dynamic uniform buffers.", false)
DECLARE_IGC_REGKEY(bool, DisableStaticCheck,            false, "Disable static check to push constants.", false)
DECLARE_IGC_REGKEY(bool, DisableStaticCheckForConstantFolding,  true, "Disable static check to fold constants.", false)
DECLARE_IGC_REGKEY(int, forcePushConstantMode,  0, "set the push constant mode, 0 is default behavior, 1 is simple push, 2 is gather constant, 3 is none/pull constants", false)
DECLARE_IGC_REGKEY(bool, DisableConstantCoalescing,     false, "Setting this to 1/true adds a compiler switch to disable constant coalesing", false)
DECLARE_IGC_REGKEY(bool, DisableConstantCoalescingOutOfBoundsCheck,     false, "Setting this to 1/true adds a compiler switch to disable constant coalesing out of bounds check", false)
DECLARE_IGC_REGKEY(bool, DisableConstantCoalescingOfStatefulNonUniformLoads, true, "Disable merging non-uniform loads from stateful buffers. Note: does not affect merging to sampler loads", false)
DECLARE_IGC_REGKEY(bool, EnableTextureLoadCoalescing, false, "Enable merging non-uniform loads from bindless textures", false)
DECLARE_IGC_REGKEY(bool, UseHDCTypedReadForAllTextures, false, "Setting this to use HDC message rather than sampler ld for texture read", false)
DECLARE_IGC_REGKEY(bool, UseHDCTypedReadForAllTypedBuffers,  false, "Setting this to use HDC message rather than sampler ld for buffer read", false)
DECLARE_IGC_REGKEY(bool, DisableUniformTypedAccess,     false, "Setting this will disable uniform typed access handling", false)
DECLARE_IGC_REGKEY(bool, DisableURBWriteMerge,          false, "Setting this to 1/true adds a compiler switch to disable URB write merge", false)
DECLARE_IGC_REGKEY(bool, DisableMatchFloor,          false, "Setting this to 1/true adds a compiler switch to disable sub-frc = floor optimization", false)
DECLARE_IGC_REGKEY(bool, DisableEmptyBlockRemoval,      false, "Setting this to 1/true adds a compiler switch to disable empty block optimization", false)
DECLARE_IGC_REGKEY(bool, DisableSIMD32Slicing,          false, "Setting this to 1/true adds a compiler switch to disable emitting SIMD32 VISA code in slices", false)
DECLARE_IGC_REGKEY(bool, DisableMatchMad,               false, "Setting this to 1/true adds a compiler switch to disable mul+add = mad optimization", false)
DECLARE_IGC_REGKEY(bool, EnableIntegerMad,              true,  "Setting this to 1/true adds a compiler switch to enable integer mul+add = mad optimization", false)
DECLARE_IGC_REGKEY(bool, DisableMatchPredAdd,           false, "Setting this to 1/true adds a compiler switch to disable pred+add = predAdd optimization", false)
DECLARE_IGC_REGKEY(bool, DisableMatchSimpleAdd,         false, "Setting this to 1/true adds a compiler switch to disable simple cmp+and+add optimization", false)
DECLARE_IGC_REGKEY(bool, DisableMatchPow,               false, "Setting this to 1/true adds a compiler switch to disable log2/mul/exp2 = pow optimization", false)
DECLARE_IGC_REGKEY(bool, DisableIRVerification,         false, "Setting this to 1/true adds a compiler switch to disable IGC IR verification.", false)
DECLARE_IGC_REGKEY(bool, DisableLoopUnroll,             false, "Setting this to 1/true adds a compiler switch to disable loop unrolling.", false)
DECLARE_IGC_REGKEY(bool, DisableRuntimeLoopUnrolling,   false, "Setting this to 1/true adds a compiler switch to disable runtime loop unrolling.", false)
DECLARE_IGC_REGKEY(bool, DisableBranchSwaping,          false, "Setting this to 1/true adds a compiler switch to disable branch swapping.", false)
DECLARE_IGC_REGKEY(DWORD,SetLoopUnrollThreshold,        0,     "Set the loop unroll threshold. Value 0 will use the default threshold.", false)
DECLARE_IGC_REGKEY(DWORD,SetLoopUnrollThresholdForHighRegPressure,        0,     "Set the loop unroll threshold for shaders with high reg pressure. Value 0 will use the default threshold.", false)
DECLARE_IGC_REGKEY(DWORD,SetRegisterPressureThresholdForLoopUnroll,       64,     "Set the register pressure threshold for limiting the loop unroll to smaller loops", false)
DECLARE_IGC_REGKEY(DWORD,SetBranchSwapThreshold,        400,   "Set the branch swaping threshold.", false)
DECLARE_IGC_REGKEY(debugString, LLVMCommandLine,        0,     "applies LLVM command line", false)
DECLARE_IGC_REGKEY(bool, DisableDX9LowPrecision,        true,  "Disables HF in DX9.", false)
DECLARE_IGC_REGKEY(bool, EnablePingPongTextureOpt,      true,  "Enables the Ping Pong texture optimization which is used only for Compute Shaders for back to back dispatches", false)
DECLARE_IGC_REGKEY(bool, EnableSamplerChannelReturn,    true,  "Setting this to 1/true adds a compiler switch to enable using header to return selective channels from sampler", false)
DECLARE_IGC_REGKEY(bool, EnableThreadCombiningOpt,      true,  "Enables the thread combining optimization which is used only for Compute Shaders for combining a number of software threads to dispatch smaller number of hardware threads", false)
DECLARE_IGC_REGKEY(bool, DisablePromotePrivMem,         false, "Setting this to 1/true adds a compiler switch to disable IGC private array promotion", false)
DECLARE_IGC_REGKEY(bool, EnableSimplifyGEP,             true,  "Enable IGC to simplify indices expr of GEP.", false)
DECLARE_IGC_REGKEY(bool, DisableCustomUnsafeOpt,        false, "Disable IGC to run custom unsafe optimizations", false)
DECLARE_IGC_REGKEY(bool, EnableFastMath,                false, "Enable fast math optimizations in IGC", false)
DECLARE_IGC_REGKEY(bool, DisableFlattenSmallSwitch,     false, "Disable the flatten small switch pass", false)
DECLARE_IGC_REGKEY(bool, EnableSplitIndirectEEtoSel,    true,  "Enable the split indirect extractelement to icmp+sel pass", false)
DECLARE_IGC_REGKEY(bool, SplitIndirectEEtoSelThreshold, 8,     "Split indirect extractelement cost threshold", false)
DECLARE_IGC_REGKEY(bool, DisableImmConstantOpt,         false, "Disable IGC IndirectICBPropagaion optimization", false)
DECLARE_IGC_REGKEY(DWORD,MaxImmConstantSizePushed,      256,   "Set the max size of immediate constant buffer pushed", false)
DECLARE_IGC_REGKEY(bool, EnableCustomLoopVersioning,    true,  "Enable IGC to do custom loop versioning", false)
DECLARE_IGC_REGKEY(bool, DisableMCSOpt,                 false,  "Disable IGC to run MCS optimization", false)
DECLARE_IGC_REGKEY(bool, DisableGatingSimilarSamples,   false,  "Disable Gating of similar sample instructions", false)
DECLARE_IGC_REGKEY(bool, EnableSoftwareVertexFetch,     false, "Enable software vertex fetch for VS.", false)
DECLARE_IGC_REGKEY(bool, EnableSoftwareStencil,         false, "Enable software stencil for PS.", false)
DECLARE_IGC_REGKEY(bool, EnableSumFractions,            false, "Enable SumFractions optimization in CustomUnsafeOptPass.", false)
DECLARE_IGC_REGKEY(bool, EnableExtractCommonMultiplier, false, "Enable ExtractCommonMultiplier optimization in CustomUnsafeOptPass.", false)
DECLARE_IGC_REGKEY(bool, EnablePowToLogMulExp,          false, "Enable pow to exp(log(x)*y) optimization in CustomUnsafeOptPass.", false)
DECLARE_IGC_REGKEY(bool, DisablePullConstantHeuristics, true, "Disable the heuristics to determine the no. push constants based on payload size.", false)
DECLARE_IGC_REGKEY(DWORD,PayloadSizeThreshold,          11,    "Set the max payload size threshold for short shades that have PSD bottleneck.", false)
DECLARE_IGC_REGKEY(DWORD, BlockPushConstantGRFThreshold, 0xFFFFFFFF,
                                                               "Set the maximum limit for block push constants i.e. UBO data pushed.\
                                                                Set to 0xFFFFFFFF to use the default threshold for the platform.\
                                                                Note that for small pixel shaders the PayloadSizeThreshold may be the limiting factor.", false)
DECLARE_IGC_REGKEY(bool, PSSIMD32HeuristicFP16, true, "enable PS SIMD32 heuristic based on fp16 characteristic ", false)
DECLARE_IGC_REGKEY(bool, PSSIMD32HeuristicLoopAndDiscard, true, "enable PS SIMD32 heuristic based on loop info and discard", false)
DECLARE_IGC_REGKEY(bool, EnableBlendToDiscard,          true,  "Enable blend to discard based on blend state.", false)
DECLARE_IGC_REGKEY(bool, EnableBlendToFill,             true,  "Enable blend to fill based on blend state.", false)
DECLARE_IGC_REGKEY(bool, UseTiledCSThreadOrder,         true,  "Use 4x4 disaptch for CS order when it seems beneficial", false)
DECLARE_IGC_REGKEY(bool, EnableWaveForce32,             false, "Force Wave to use simd32", false)
DECLARE_IGC_REGKEY(bool, EnableMergeTransposeSLM,       false, "Transpose SLM float3 storage from 3 separate x,y,z buffers to 1 big buffer with xyz consecutively", false)
DECLARE_IGC_REGKEY(bool, EnableSLMConstProp,            true,   "Enable SLM constant propagation (compute shader only).", false)
DECLARE_IGC_REGKEY(bool, EnableStatelessToStatefull,    true,  "Enable Stateless To Statefull transformation for global and constant address space in OpenCL kernels", false)
DECLARE_IGC_REGKEY(bool, EnableStatefulToken,           true,  "Enable generating patch token to indicate a ptr argument is fully converted to stateful (temporary)", false)
DECLARE_IGC_REGKEY(bool, EnableGenUpdateCB,             false, "Enable derived constant optimization.", false)
DECLARE_IGC_REGKEY(bool, EnableGenUpdateCBResInfo,      false, "Enable derived constant optimization with resinfo.", false)
DECLARE_IGC_REGKEY(bool, EnableHighestSIMDForNoSpill,   false,   "When there is no spill choose highest SIMD (compute shader only).", false)

DECLARE_IGC_REGKEY(bool, DisableDynamicTextureFolding,  false,  "Disable Dynamic Texture Folding", false)
DECLARE_IGC_REGKEY(bool, DisableDynamicResInfoFolding,  true,  "Disable Dynamic ResInfo Instruction Folding", false)
DECLARE_IGC_REGKEY(bool, DisableRectListOpt,            false, "Disable Rect List optimization", false)

DECLARE_IGC_REGKEY(bool, DispatchOCLWGInLinearOrder,    false, "If set, dispatch HW threads based on the linearized order of WI in a WG; \
                                                                ie, let localSize=(lx, ly, lz), localId=(ix, iy, iz). And \
                                                                   linearLocalId = ix + lx * (iy + ly * iz); \
                                                                And linear order means that \
                                                                   linearLocalId(lane[x+1])=linearLocalId(lane[x])+1", false)
DECLARE_IGC_REGKEY(DWORD, EnableCodeAssumption,         1, \
    "If set (> 0), generate llvm.assume to help certain optimizations. It is OCL only for now. \
     Only 1 and 2 are valid. 2 will be 1 plus additional assumption. It also does other minor changes.", false)
DECLARE_IGC_REGKEY(bool, EnableHoistMulInLoop, true,
    "Hoist multiply with loop invirant out of loop, FP unsafe", false)
DECLARE_IGC_REGKEY(bool, EnableGVN, true,
    "Enable LLVM global value numbering", false)
DECLARE_IGC_REGKEY(bool, EnableLogicalAndToBranch, true,
    "Enable convert logical AND to conditional branch", false)
DECLARE_IGC_REGKEY(bool, DisableMovingInstanceIDIndexOfVS,  false,   "Disable moving index of InstanceID in VS to last location.", false)
DECLARE_IGC_REGKEY(bool, EnableSplitUnalignedVector,    true,    "Enable Splitting of unaligned vectors for loads and stores", false)
DECLARE_IGC_REGKEY(bool, DisableFDivReassociation,      false,   "Disable reassociation for Fdiv operations to avoid precision difference", false)
DECLARE_IGC_REGKEY(bool, EnableTrigFuncRangeReduction,    false,    "reduce the sin and cosing function domain range", true)
DECLARE_IGC_REGKEY(bool, EnableUnmaskedFunctions,    true,    "Enable unmaksed functions SYCL feature.", true)
DECLARE_IGC_REGKEY(bool, EnableStatefulAtomic,       false,   "Enable promoting stateless atomic to stateful atomic.", false)

DECLARE_IGC_GROUP("Shader debugging")
DECLARE_IGC_REGKEY(bool, ForceDisableShaderDebugHashCodeInKernel,   false,  "Disable hash code addition to the binary after EOT", false)
DECLARE_IGC_REGKEY(bool, ShaderDebugHashCodeInKernel,   false, "Append hash code to the binary", false)
DECLARE_IGC_REGKEY(int,  ShaderDebugHashCode,           0,     "The driver will set a breakpoint in the first instruction of the shader which has the provided hash code.\
                                                                It works only when the value is different then 0 and SystemThreadEnable is set to TRUE.\
                                                                Ex: VS_asm2df26246434553ad_nos0000000000000000 , only the LowPart Need \
                                                                to be Enterd in Registry Ex : 0x434553ad ,i.e Lower 8 Hex Digits of the 16 Digit Hash Code \
                                                                for Compatibilty Reasons", false)
DECLARE_IGC_REGKEY(DWORD, ShaderDisableOptPassesAfter,  0,     "Will only run first N optimization passes, any further passes will be ignored. This flag can be used to bisect optimization passes.", false)
DECLARE_IGC_REGKEY(bool, ShaderOverride,                false, "Will override any LLVM shader with matching name in c:\\Intel\\IGC\\ShaderOverride", false)
DECLARE_IGC_REGKEY(bool, SystemThreadEnable,            false, "This key forces software to create a system thread. The system thread may still be created by software even \
                                                                if this control is set to false.The system thread is invoked if either the software requires \
                                                                exception handling or if kernel debugging is active and a breakpoint is hit.", false)

DECLARE_IGC_REGKEY(bool, EnableSIPOverride,             false, "This key forces load of SIP from a a Local File.", false)
DECLARE_IGC_REGKEY(debugString, SIPOverrideFilePath,    0,     "This key when enabled with EnableSIPOverride load of SIP from a specified path.", false)
DECLARE_IGC_REGKEY(bool, DumpPayloadToScratch,          false, "Setting this to 1/true dumps thread payload to scartch space. Used for  workloads which doesnt use scartch space for other purposes", false)
DECLARE_IGC_REGKEY(DWORD, DebugInternalSwitch,          0,     "Code pass selection, debug only", false)
DECLARE_IGC_REGKEY(bool, SToSProducesPositivePointer,   false, "This key is for StatelessToStatefull optimization if the  user knows the pointer offset is postive to the kernel argument.", false)
DECLARE_IGC_REGKEY(bool, EnableSupportBufferOffset,     false, "[debugging]For StatelessToStatefull optimization [OCL], support implicit buffer offset argument (same as -cl-intel-has-buffer-offset-arg).", false)
DECLARE_IGC_REGKEY(bool, EnableOptionalBufferOffset,    true,  "For StatelessToStatefull optimization [OCL], if true, make buffer offset optional. Valid only if buffer offset is supported.", true)
DECLARE_IGC_REGKEY(bool, UseSubDWAlignedPtrArg,         false, "[OCL]If set, for kernel pointer arg such as ptr to char or short, the arg is not necessarily DW aligned", false)
DECLARE_IGC_REGKEY(bool, EnableTestIGCBuiltin,          false, "Enable testing igc builtin (precompiled kernels) using OCL.", false)
DECLARE_IGC_REGKEY(bool, EnableCSSIMD32,                false, "Enable computer shader SIMD32 mode, and fall back to lower SIMD when spill", false)
DECLARE_IGC_REGKEY(bool, ForceCSSIMD32,                 false, "Force computer shader SIMD32 mode", false)
DECLARE_IGC_REGKEY(bool, ForceCSSIMD16,                 false, "Force computer shader SIMD16 mode if allowed, otherwise it will use SIMD32", false)
DECLARE_IGC_REGKEY(bool, ForceCSLeastSIMD,              false, "Force computer shader to the lowest allowed SIMD mode", false)
DECLARE_IGC_REGKEY(bool, EnableTrivialEmulateSinCos,    false, "Enable Emulation for Sine and Cosine instructions", false)
DECLARE_IGC_REGKEY(DWORD, ld2dmsInstsClubbingThreshold, 3,     "Do not club more than these ld2dms insts into the new BB during MCSOpt", false)
DECLARE_IGC_REGKEY(DWORD, ForcePerThreadPrivateMemorySize, 0,  "Useful for ensuring a certain amount of private memory when doing a shader override.", false)
DECLARE_IGC_REGKEY(DWORD, RetryManagerFirstStateId,     0,     "For debugging purposes, it can be useful to start on a particular id rather than id 0.", false)
DECLARE_IGC_REGKEY(bool, DisableSendSrcDstOverlapWA,    false, "Disable Send Source/destination overlap WA which is enabled for GEN10/GEN11 and whenever Wddm2Svm is set in WATable", false)
DECLARE_IGC_REGKEY(debugString, DisablePassToggles,     0,     "Disable each IGC pass by setting the bit. HEXADECIMAL ONLY!. Ex: C0 is to disable pass 6 and pass 7.", false)
DECLARE_IGC_REGKEY(bool, ForceStatelessForQueueT,       true,  "In OCL, force to use stateless memory to hold queue_t*. This is a legacy feature to be removed.", false)
DECLARE_IGC_REGKEY(bool, ForceMemoryFenceBeforeEOT,     false, "Forces inserting SLM or gloabal memory fence before EOT if shader writes to SLM or goblam memory respectively.", false)
DECLARE_IGC_REGKEY(bool, EnableRTmaskPso,               true,  "Enable render target mask optimization in PSO opt", false)
DECLARE_IGC_REGKEY(DWORD, MSAAClearedKernel,            0,     "Insert the discard code for MSAA_MSC_Cleared kernels. 2/4/8/16", false)
DECLARE_IGC_REGKEY(bool, EnablerReadSuppressionWA,    true, "Enable read suppression WA for the send and indirect access", false)
DECLARE_IGC_REGKEY(bool, DPASReadSuppressionWA,    true, "Enable read suppression WA for the send and indirect access", false)
DECLARE_IGC_REGKEY(DWORD, RSWARegNum,    0, "dummy register used for EnablerReadSuppressionWA", false)
DECLARE_IGC_REGKEY(bool, EnableDivergentBarrierCheck,   false,  "Uses WIAnalysis to find barriers in divergent flow control. May have false positives.", false)

DECLARE_IGC_GROUP("Shader dumping")
DECLARE_IGC_REGKEY(bool, EnableCosDump, false, "Enable cos dump", true)
DECLARE_IGC_REGKEY(bool, EnableCisDump, false, "Enable cis dump", true)
DECLARE_IGC_REGKEY(bool, DumpLLVMIR,                    false, "dump LLVM IR", true)
DECLARE_IGC_REGKEY(bool, QualityMetricsEnable,          false, "Enable Quality Metrics for IGC", true)
DECLARE_IGC_REGKEY(bool, ShaderDumpEnable,              false, "dump LLVM IR, visaasm, and GenISA", true)
DECLARE_IGC_REGKEY(bool, ShaderDumpEnableAll,           false, "dump all LLVM IR passes, visaasm, and GenISA", true)
DECLARE_IGC_REGKEY(DWORD, ShaderDumpEnableG4,           false, "same as ShaderDumpEnable but adds G4 dumps (0 = off, 1 = some, 2 = all)", 0)
DECLARE_IGC_REGKEY(debugString, ShaderDumpFilter,       0,     "Only dump files matching the given regex", true)
DECLARE_IGC_REGKEY(bool, ElfDumpEnable,                 false, "dump ELF file", true)
DECLARE_IGC_REGKEY(bool, ElfTempDumpEnable,             false, "dump temporary ELF files", true)
DECLARE_IGC_REGKEY(bool, ShowFullVectorsInShaderDumps,  false, "print all elements of vectors in ShaderDumps, can dramatically increase ShaderDumps size", true)
DECLARE_IGC_REGKEY(debugString, PrintAfter,             0,     "Take either all or comma/semicolon-separated list of pass names. If set, enable print LLVM IR after the given pass is done (mimic llvm print-after)", true)
DECLARE_IGC_REGKEY(debugString, PrintBefore,            0,     "Take either all or comma/semicolon-separated list of pass names. If set, enable print LLVM IR before the given pass is done (mimic llvm print-before)", true)
DECLARE_IGC_REGKEY(bool, InterleaveSourceShader,        true, "Interleave the source shader in asm dump", true)
DECLARE_IGC_REGKEY(bool, ShaderDumpPidDisable,          false, "disabled adding PID to the name of shader dump directory", true)
DECLARE_IGC_REGKEY(bool, DumpToCurrentDir,              false, "dump shaders to the current directory", true)
DECLARE_IGC_REGKEY(debugString, DumpToCustomDir,        0,     "Dump shaders to custom directory. Parent directory must exist.", true)
DECLARE_IGC_REGKEY(bool, EnableShaderNumbering,         false, "Number shaders in the order they are dumped based on their hashes", true)
DECLARE_IGC_REGKEY(bool, PrintToConsole,                false, "dump to console", true)
DECLARE_IGC_REGKEY(bool, DumpCompilerStats,             false, "dump compiler statistics", true)
DECLARE_IGC_REGKEY(bool, EnableCapsDump,                false, "Enable hardware caps dump", true)
DECLARE_IGC_REGKEY(bool, EnableLivenessDump,            false, "Enable dumping out liveness info on stderr.", true)
DECLARE_IGC_REGKEY(DWORD, ForceRPE,                     0,     "Force RPE (RegisterEstimator) computation if > 0. If 2, force RPE per inst.", true)
DECLARE_IGC_REGKEY(DWORD, RPEDumpLevel,                 0,     "> 0 : dump info of register pressure estimate on stderr. See igc_flags.hpp level defs.", false)
DECLARE_IGC_REGKEY(bool, DumpOCLProgramInfo,            false, "dump OpenCL Patch Tokens, Kernel/Program Binary Header", true)
DECLARE_IGC_REGKEY(bool, DumpPatchTokens,               false, "Enable dumping of patch tokens.", true)
DECLARE_IGC_REGKEY(bool, DumpVariableAlias,             false, "Dump variable alias info, valid if EnableVariableAlias is on)", true)
DECLARE_IGC_REGKEY(bool, DumpDeSSA,                     false, "dump DeSSA info into file.", true)
DECLARE_IGC_REGKEY(bool, DumpWIA,                       false, "dump WI (uniform) infomation into files in dump directory if set to true", false)
DECLARE_IGC_REGKEY(bool, EnableScalarizerDebugLog,      false, "print step by step scalarizer debug info.", true)
DECLARE_IGC_REGKEY(bool, DumpTimeStats,                 false, "Timing of translation, code generation, finalizer, etc", true)
DECLARE_IGC_REGKEY(bool, DumpTimeStatsCoarse,           false, "Only collect/dump coarse level time stats, i.e. skip opt detail timer for now", true)
DECLARE_IGC_REGKEY(bool, DumpTimeStatsPerPass,          false, "Collect Timing of IGC/LLVM passes", true)
DECLARE_IGC_REGKEY(bool, DumpHasNonKernelArgLdSt,       false, "Print if hasNonKernelArg load/store to stderr", true)

DECLARE_IGC_GROUP("Debugging features")
DECLARE_IGC_REGKEY(bool, InitializeUndefValueEnable,    false, "Setting this to 1/true initializes all undefs in URB payload to 0", false)
DECLARE_IGC_REGKEY(bool, InitializeRegistersEnable,     false, "Setting this to 1/true initializes all GRFs, Flag and address registers to 0 at the beginning of the shader", false)
DECLARE_IGC_REGKEY(bool, InitializeAddressRegistersBeforeUse,     false, "Setting this to 1 (true) initializes address register to 0 before each use", false)
DECLARE_IGC_REGKEY(bool, EnableSIMDLaneDebugging,       true,  "Setting this to 1 (true) enables SIMD lane location expression emmitions for GPU debugger", true)
DECLARE_IGC_REGKEY(bool, EnableGTLocationDebugging,     false, "Setting this to 1 (true) enables GT location expression emmitions for GPU debugger", true)
DECLARE_IGC_REGKEY(bool, UseOffsetInLocation,           true,  "Setting this to 1 (true) preserves private base and per thread offset and removes preservation of any other debug variables", true)
DECLARE_IGC_REGKEY(bool, EnableRelocations,             false, "Setting this to 1 (true) makes IGC emit relocatable ELF with debug info", true)
DECLARE_IGC_REGKEY(bool, EnableWriteOldFPToStack,       true,  "Setting this to 1 (true) writes the caller frame's frame-pointer to the start of callee's frame on stack, to support stack walk", false)
DECLARE_IGC_REGKEY(bool, ZeBinCompatibleDebugging,      true,  "Setting this to 1 (true) enables embed debug info in zeBinary", true)
DECLARE_IGC_REGKEY(bool, DebugInfoEnforceAmd64EM,       false, "Enforces elf file with the debug infomation to have eMachine set to AMD64", false)
DECLARE_IGC_REGKEY(debugString, ExtraOCLOptions,        0,     "Extra options for OpenCL", true)
DECLARE_IGC_REGKEY(debugString, ExtraOCLInternalOptions, 0,    "Extra internal options for OpenCL", true)
DECLARE_IGC_REGKEY(bool, UseVISAVarNames,               false, "Make VISA generate names for virtual variables so they match with dbg file", true)
DECLARE_IGC_REGKEY(bool, EmitPrologueEnd,               true,  "Set to true to make IGC emit prologue_end flag", true)

DECLARE_IGC_GROUP("IGC Features")
DECLARE_IGC_REGKEY(bool, EnableOCLSIMD16,               true,  "Enable OCL SIMD16 mode", true)
DECLARE_IGC_REGKEY(bool, EnableOCLSIMD32,               true,  "Enable OCL SIMD32 mode", true)
DECLARE_IGC_REGKEY(DWORD, ForceOCLSIMDWidth,            0,     "Force using SIMD width specified. 0 : no forcing. This overrides driver forced SIMD value(if any) and runtime behaviour could be different if driver expects something fixed", true)
DECLARE_IGC_REGKEY(bool, SendMultipleSIMDModesCS,       true,  "Send multiple SIMD modes for CS", false)
DECLARE_IGC_REGKEY(DWORD, OCLSIMD16SelectionMask,       6,     "Select SIMD 16 heuristics. Valid values are 0, 1, 2 and 3", false)
DECLARE_IGC_REGKEY(bool, EnableHSSinglePatchDispatch,   false, "Setting this to 1/true enables SIMD8 single-patch dispatch in HullShader. Default is either SIMD8 single patch/dual patch dispatch based on control point count", false)
DECLARE_IGC_REGKEY(bool, DisableGPGPUIndirectPayload,   false, "Disable OCL indirect GPGPU payload", false)
DECLARE_IGC_REGKEY(bool, DisableDSDualPatch,            false, "Setting it to true with enable Single and Dual Patch dispatch mode for Domain Shader", false)
DECLARE_IGC_REGKEY(bool, DisableMemOpt,                 false, "Disable MemOpt, merging load/store", false)
DECLARE_IGC_REGKEY(bool, DisableMemOpt2,                false, "Disable MemOpt2", false)
DECLARE_IGC_REGKEY(bool, DisablePreRAScheduler,         false, "Disable Pre RA Scheduling", false)
DECLARE_IGC_REGKEY(DWORD,MaxLiveOutThreshold,           0,     "Max LiveOut Threshold in MemOpt2", false)
DECLARE_IGC_REGKEY(bool, DisableScalarAtomics,          false, "Disable the Scalar Atomics optimization", false)
DECLARE_IGC_REGKEY(bool, EnableSelectiveScalarizer,     false,  "enable selective scalarizer on GPGPU path", true)
DECLARE_IGC_REGKEY(bool, HoistPSConstBufferValues,      true,  "Hoists up down converts for contant buffer accesses, so they an be vectorized more easily.", false)
DECLARE_IGC_REGKEY(bool, EnableSingleVertexDispatch,    false, "Vertex Shader Single Patch Dispatch Regkey", false)
DECLARE_IGC_REGKEY(bool, allowLICM,                     true,  "Enable LICM in IGC.", false)
DECLARE_IGC_REGKEY(DWORD, CSSpillThresholdSLM,          9,    "Spill Threshold for CS SIMD16 with SLM", false)
DECLARE_IGC_REGKEY(DWORD, CSSpillThresholdNoSLM,        5,     "Spill Threshold for CS SIMD16 without SLM", false)
DECLARE_IGC_REGKEY(DWORD, AllowedSpillRegCount,         0,     "Max allowed spill size without recompile", false)
DECLARE_IGC_REGKEY(DWORD, LICMStatThreshold,            70,    "LICM stat threshold to avoid retry SIMD16 for CS", false)
DECLARE_IGC_REGKEY(bool, EnableTypeDemotion,            true,  "Enable Type Demotion", false)
DECLARE_IGC_REGKEY(bool, EnablePreRARematFlag,          true,  "Enable PreRA Rematerialization of Flag", false)
DECLARE_IGC_REGKEY(bool, EnableGASResolver,             true,  "Enable GAS Resolver", false)
DECLARE_IGC_REGKEY(bool, EnableLowerGPCallArg,          true,  "Enable pass to lower generic pointers in function arguments", false)
DECLARE_IGC_REGKEY(bool, DisableRecompilation,          false, "Disable recompilation", false)
DECLARE_IGC_REGKEY(bool, SampleMultiversioning,         false, "Create branches aroung samplers which can be redundant with some values", false)
DECLARE_IGC_REGKEY(bool, EnableSMRescheduling,          false, "Change instruction order to enable extra Sample Multiversioning cases", false)
DECLARE_IGC_REGKEY(bool, DisableEarlyOutPatterns,       false, "Disable optimization trying to create an early out after sampleC messages", false)
DECLARE_IGC_REGKEY(DWORD, EarlyOutPatternSelectPS,      0xff,  "Each bit selects a pattern match to enable/disable.", false)
DECLARE_IGC_REGKEY(DWORD, EarlyOutPatternSelectCS,      0x8,   "Each bit selects a pattern match to enable/disable.", false)
DECLARE_IGC_REGKEY(bool, OCLEnableReassociate,          false, "Enable reassociation", true)
DECLARE_IGC_REGKEY(bool, EnableOCLScratchPrivateMemory, true,  "Enable the use of scratch space for private memory [OCL only]", false)
DECLARE_IGC_REGKEY(bool, EnableMaxWGSizeCalculation,    true,  "Enable max work group size calculation [OCL only]", true)
DECLARE_IGC_REGKEY(bool, Enable64BitEmulation,          false, "Enable 64-bit emulation", false)
DECLARE_IGC_REGKEY(bool, Enable64BitEmulationOnSelectedPlatform, true, "Enable 64-bit emulation on selected platforms", false)
DECLARE_IGC_REGKEY(DWORD, EnableConstIntDivReduction,   0x1,   "Enables strength reduction on integer division/remainder with constant divisors/moduli", true)
DECLARE_IGC_REGKEY(DWORD, EnableIntDivRemCombine,       0x0,   "Given div/rem pairs with same operands merged; replace rem with mul+sub on quotient; 0x3 (set bit[1]) forces this on constant power of two divisors as well", true)
DECLARE_IGC_REGKEY(bool, EnableRecursionOpenCL,         true,  "Enable recursion with OpenCL user functions", false)
DECLARE_IGC_REGKEY(bool, ForceDPEmulation,              false, "Force double emulation for testing purpose", false)
DECLARE_IGC_REGKEY(bool, EnableDPEmulation,             false, "Enforce double precision floating point operations emulation on platforms that do not support it natively", true)
DECLARE_IGC_REGKEY(bool, DPEmuNeedI64Emu,               true,  "Double Emulation needs I64 emulation. Unsetting it to disable I64 Emulation for testing.", false)
DECLARE_IGC_REGKEY(bool, ForceSPDivEmulation,           false, "Force SP Div emulation for testing purpose", false)
DECLARE_IGC_REGKEY(bool, EnableGen11TwoStackTSG,        false, "Enable Two stack TSG gen11 feature", false)
DECLARE_IGC_REGKEY(bool, EnableFallbackToBindless,      true,  "This key enables fallback to bindless mode on all shaders", false)
DECLARE_IGC_REGKEY(bool, EnableFallbackToStateless,     true,  "This key enables fallback to stateless mode on all shaders", false)
DECLARE_IGC_REGKEY(bool, DisablePromoteToDirectAS,      false, "This key disables the PromoteResourceToDirectAS pass", false)
DECLARE_IGC_REGKEY(bool, EnableAdvCodeMotion,           true,  "Enable advanced code motion", false)
DECLARE_IGC_REGKEY(bool, AdvCodeMotionControl,          true,  "Control bits to fine-tune advanced code motion", false)
DECLARE_IGC_REGKEY(bool, EnableAdvRuntimeUnroll,        true,  "Enable advanced runtime unroll", false)
DECLARE_IGC_REGKEY(bool, AdvRuntimeUnrollCount,         false, "Advanced runtime unroll count", false)
DECLARE_IGC_REGKEY(bool, EnableAdvMemOpt,               true,  "Enable advanced memory optimization", false)
DECLARE_IGC_REGKEY(bool, UniformMemOptLimit,            false, "Limit of uniform memory optimization in bits", false)
DECLARE_IGC_REGKEY(bool, EnableFunctionPointer,         true,  "Enables support for function pointers and indirect calls", false)
DECLARE_IGC_REGKEY(bool, EnableIndirectCallOptimization, true, "Enables inlining indirect calls by comparing function addresses", false)
DECLARE_IGC_REGKEY(bool, ForceFFIDOverwrite,            false, "Force overwriting ffid in sr0.0", false)
DECLARE_IGC_REGKEY(bool, EnableReadGTPinInput,          true,  "Enables setting GTPin context flags by reading the input to the compiler adapters", false)
DECLARE_IGC_REGKEY(bool, EnableRuntimeFuncAttributePatching, false,  "Creates a relocation entry to let runtime calculate the max call depth and patch required scratch space usage", true)
DECLARE_IGC_REGKEY(bool, ForceStaticToDynamic,          false,  "Force write of vertex count in GS", false)
DECLARE_IGC_REGKEY(bool, DisableWaSampleLZ,             false,  "Disable The Sample Lz workaround and generate Sample LZ", false)
DECLARE_IGC_REGKEY(DWORD, OverrideRevIdForWA,           0xff,   "Enable this to override the stepping/RevId, default is a0 = 0, b0 = 1, c0 = 2, so on...", false)
DECLARE_IGC_REGKEY(DWORD, OverrideDeviceIdForWA,          0,   "Enable this to override DeviceId ", false)
DECLARE_IGC_REGKEY(DWORD, OverrideProductFamilyForWA,     0,   "Enable this to override the product family, get the correct enum from igfxfmid.h", false)



DECLARE_IGC_REGKEY(bool, EnableGlobalStateBuffer,              false, "This key allows stack calls to read implicit args from side buffer. It also emits a relocatable add in VISA.", true)
DECLARE_IGC_REGKEY(bool, LateInlineUnmaskedFunc,        false, "Postpone inlining of Unmasked functions till end of CG to avoid code movement inside/outside of unmasked region", false)

DECLARE_IGC_GROUP("Performance experiments")
DECLARE_IGC_REGKEY(bool, ForceNonCoherentStatelessBTI,  false, "Enable gneeration of non cache coherent stateless messages", false)
DECLARE_IGC_REGKEY(bool, ForceSendsSupportOnSKLA0,      false, "Allow sends on SKL A0, may be unsafe", false)
DECLARE_IGC_REGKEY(bool, DisableWaSendSEnableIndirectMsgDesc, false, "Disable a C0 WA WaSendSEnableIndirectMsgDesc, may be unsafe", false)
DECLARE_IGC_REGKEY(bool, DisableWaDisableSIMD16On3SrcInstr, false, "Disable C0 WA WaDisableSIMD16On3SrcInstr, may be unsafe", false)
DECLARE_IGC_REGKEY(bool, DiableWaSamplerNoMask,         false, "Disable WA DiableWaSamplerNoMask", false)
DECLARE_IGC_REGKEY(bool, DisableDualBlendSource,        false, "Force the compiler to never use dual blend source messages", false)
DECLARE_IGC_REGKEY(bool, ForceDisableSrc0Alpha,         false, "Force the compiler to skip sending src0 alpha. Only works if we are sure alpha to coverage and alpha test is off", false)
DECLARE_IGC_REGKEY(bool, EnableLTO,                     true,  "Enable link time optimization", false)
DECLARE_IGC_REGKEY(bool, EnableLTODebug,                false, "Enable debug information for LTO", true)
DECLARE_IGC_REGKEY(DWORD, FunctionControl,              0,     "Control function inlining/subroutine/stackcall. See value defs in igc_flags.hpp.", true)
DECLARE_IGC_REGKEY(bool, EnableStackCallFuncCall,       false, "If enabled, the default function call mode will be set to stack call. Otherwise, subroutine call is used.", false)
DECLARE_IGC_REGKEY(bool, EnableByValStructArgPromotion, true, "If enabled, byval/sret struct arguments are promoted to pass-by-value if possible.", true)
DECLARE_IGC_REGKEY(bool, ForceInlineStackCallWithImplArg, true, "If enabled, stack calls that uses implicit args will be force inlined.", true)
DECLARE_IGC_REGKEY(DWORD, FunctionCloningThreshold,    0,
    "Limits how many times functions can be cloned when called from multiple function groups." \
    "If exceeding the cloning threshold, compile the function only once and use address relocation instead." \
    "A value of '0' means no limit on times it can be cloned", true)
DECLARE_IGC_REGKEY(DWORD, OCLInlineThreshold,           512,  "Setting OCL inline thershold", true)
DECLARE_IGC_REGKEY(bool, DisableAddingAlwaysAttribute,  false, "Disable adding always attribute", true)
DECLARE_IGC_REGKEY(bool, EnableForceGroupSize,          false, "Enable forcing thread Group Size ForceGroupSizeX and ForceGroupSizeY", false)
DECLARE_IGC_REGKEY(bool, EnableForceThreadCombining,    false, "Enable forcing Thread Combining with thread Group Size ForceGroupSizeX and ForceGroupSizeY", false)
DECLARE_IGC_REGKEY(DWORD, ForceGroupSizeShaderHash,     0, "Shader hash for forcing thread group size or thread combining (lower 8 hex digits)", false)
DECLARE_IGC_REGKEY(DWORD, ForceGroupSizeX,              8, "force group size along X", false)
DECLARE_IGC_REGKEY(DWORD, ForceGroupSizeY,              8, "force group size along Y", false)
DECLARE_IGC_REGKEY(bool, EnableThreadCombiningWithNoSLM, false, "Enable thread combining opt for shader without SLM", false)
DECLARE_IGC_REGKEY(DWORD, SubroutineThreshold,          110000, "Minimal kernel size to enable subroutines", false)
DECLARE_IGC_REGKEY(DWORD, SubroutineInlinerThreshold,   3000, "Subroutine inliner threshold", false)
DECLARE_IGC_REGKEY(bool, ControlKernelTotalSize,        true, "Control kernel total size", true)
DECLARE_IGC_REGKEY(bool, ControlInlineImplicitArgs,     true, "Avoid trimming functions with implicit args", true)
DECLARE_IGC_REGKEY(DWORD, ControlInlineTinySize,        200, "Tiny function size for controlling kernel total size", true)
DECLARE_IGC_REGKEY(DWORD, PrintControlKernelTotalSize,  0, "Print Control kernel total size", true)
DECLARE_IGC_REGKEY(bool, AddNoInlineToTrimmedFunctions, false, "Tell late passes not to inline trimmed functions", false)
DECLARE_IGC_REGKEY(DWORD, KernelTotalSizeThreshold,     50000, "Trimming target of kernel total size", true)
DECLARE_IGC_REGKEY(bool, EnableConstantPromotion,       true, "Enable global constant data to register promotion", false)
DECLARE_IGC_REGKEY(bool, AllowNonLoopConstantPromotion, false, "Allows promotion for constants not in loop (e.g. used once)", false)
DECLARE_IGC_REGKEY(DWORD, ConstantPromotionSize,        2, "Threshold in number of GRFs", false)
DECLARE_IGC_REGKEY(DWORD, ConstantPromotionCmpSelSize,  4, "Array size threshold for cmp-sel transform", false)
DECLARE_IGC_REGKEY(bool, EnableVariableReuse,           true, "Enable local variable reuse", false)
DECLARE_IGC_REGKEY(bool, EnableVariableAlias,           true, "Enable variable aliases (part of VariableReuse Pass, but separate functionality)", false)
DECLARE_IGC_REGKEY(DWORD, VATemp,                       0, "[temp]New code to replace code under EnableVATemp (removed already). Once stable, remove this.", false)
DECLARE_IGC_REGKEY(bool, EnableExtractMask,             false, "When enabled, it is mostly for reducing response size of send messages.", false)
DECLARE_IGC_REGKEY(DWORD, VariableReuseByteSize,        64, "The byte size threshold for variable reuse", false)
DECLARE_IGC_REGKEY(bool, EnableGather4cpoWA,            true, "Enable WA transforming gather4cpo/gather4po into gather4c/gather4", false)
DECLARE_IGC_REGKEY(bool, EnableIntelFast,               false, "Enable intel fast, experimental flag.", false)
DECLARE_IGC_REGKEY(bool, disableUnormTypedReadWA,       false, "disable software conversion for UNORM surface in Dx10", false)
DECLARE_IGC_REGKEY(bool, forceGlobalRA,                 false, "force global register allocator", false)
DECLARE_IGC_REGKEY(bool, disableVarSplit,               false, "disable variable splitting", false)
DECLARE_IGC_REGKEY(bool, disableRemat,                  false, "disable re-materialization", false)
DECLARE_IGC_REGKEY(bool, EnableDisableMidThreadPreemptionOpt, true, "Disable mid thread preemption", false)
DECLARE_IGC_REGKEY(DWORD, MidThreadPreemptionDisableThreshold, 600, "Threshold to disable mid thread preemption", false)
DECLARE_IGC_REGKEY(DWORD, DispatchGPGPUWalkerAlongYFirst, 1, "0 = No SW Y-walk, 1 = Dispatch GPGPU walker along Y first", false)
DECLARE_IGC_REGKEY(bool, SetMaxPreRASchedulerRegPressureThreshold, false,  "set Max PreRA Scheduler Threshold", false)
DECLARE_IGC_REGKEY(bool, LimitConstantBuffersPushed,    true, "Limit max number of CBs pushed when SupportIndirectConstantBuffer is true", false)
DECLARE_IGC_REGKEY(DWORD, MaxPreRASchedulerRegPressureThreshold, 60,  "Max PreRA Scheduler Threshold", false)
DECLARE_IGC_REGKEY(bool, EnablePreRASampleCluster,      false, "Enabling helps cluster sample instructions with identical texture index which are ready to be scheduled, to be scheduled together", false)
DECLARE_IGC_REGKEY(bool, forceSamplerHeader,            false, "force sampler messages to use header", false)
DECLARE_IGC_REGKEY(bool, VFPackingDisablePartialElements, false, "disable packing for partial vertex element as it causes performance drops", false)
DECLARE_IGC_REGKEY(bool, cl_khr_srgb_image_writes,      false, "Enable cl_khr_srgb_image_writes extension", false)
DECLARE_IGC_REGKEY(bool, MSAA16BitPayloadEnable,        true,  "Enable support for MSAA 16 bit payload , a hardware DCN supporting this from ICL+ to improve perf on MSAA workloads", false)
DECLARE_IGC_REGKEY(bool, EnableInsertElementScalarCoalescing, false,  "Enable coalescing on the scalar operand of insertelement", false)
DECLARE_IGC_REGKEY(bool, EnableMixIntOperands,          true,  "Enable generating mix-sized operands for int ALU", false)
DECLARE_IGC_REGKEY(bool, PixelShaderDoNotAbortOnSpill,  false, "Do not abort on a spill", false)
DECLARE_IGC_REGKEY(DWORD, ForcePixelShaderSIMDMode,     0,     "Setting it to values def in igc.h will force SIMD mode compilation for pixel shaders. Note that only SIMD8 is compiled unless other ForcePixelShaderSIMD* are also selected", false)
DECLARE_IGC_REGKEY(DWORD, StagedCompilationExperiments, 0,     "Experiment with staged compilation when != 0", false)
DECLARE_IGC_REGKEY(bool, StagedCompilation,             true, "Enable staged compilation", false)
DECLARE_IGC_REGKEY(bool, EnableTrackPtr,                false, "Track Staging Context alloc/dealloc", false)
DECLARE_IGC_REGKEY(bool, ExtraRetrySIMD16,              false,  "Enable extra simd16 with retry for STAGE1_BEST_PREF", false)
DECLARE_IGC_REGKEY(bool, SaveRestoreIR,                 true,  "Save/Restore IR for staged compilation to avoid duplicated compilations", false)
DECLARE_IGC_REGKEY(DWORD, CodePatch,                    2,     "Enable Pixel Shader code patching to directly emit code after stitching", false)
DECLARE_IGC_REGKEY(DWORD, CodePatchLimit,               0,     "Debug CodePatch via limiting the number of shader been patched", false)
DECLARE_IGC_REGKEY(DWORD, CodePatchExperiments,         0,      "Experiment with code patching when != 0", false)
DECLARE_IGC_REGKEY(DWORD, CodePatchFilter,            0x17,     "Filter out unsupported patterns", false)
DECLARE_IGC_REGKEY(DWORD, FirstStagedSIMD,              0,      "Force Pixel shader to be 1: FastSIMD (SIMD8), 2: BestSIMD (SIMD16 or SIMD8), 3: FatestSIMD (SIMD8 opt off)", false)
DECLARE_IGC_REGKEY(DWORD, FastestS1Experiments,         0,      "Select configs for fastest compilation by bits.", false)
DECLARE_IGC_REGKEY(bool, ForceFastestSIMD, false,  "Force pixel shader to return SIMD8 as fast as possible.", false)
DECLARE_IGC_REGKEY(bool, ForceBestSIMD, false,  "Force pixel shader to return the best SIMD, either SIMD16 or SIMD8.", false)
DECLARE_IGC_REGKEY(bool, SkipTREarlyExitCheck, false, "Skip SIMD16 early exit check in ShaderCodeGen", false)
DECLARE_IGC_REGKEY(bool, EnableTCSHWBarriers, false,  "Enable TCS pass with HW barriers support. Default TCS pass is TCS pass with multiple continuation functions.", false)
DECLARE_IGC_REGKEY(bool, ForceMCFBarriers, false,  "Force TCS pass with MCF (SW) barriers support. Default TCS pass is TCS pass with multiple continuation functions.", false)
DECLARE_IGC_REGKEY(bool, EnableAccSub, true, "Enable accumulator substitution", false)
DECLARE_IGC_REGKEY(DWORD, NumGeneralAcc, 0, "set the number [1-8] of general acc for accumulator substitution. 0 means using the platform-default value", false)
DECLARE_IGC_REGKEY(bool, ForceSWCoalescingOfAtomicCounter, false, "Force software coalescing of atomic counter", false)
DECLARE_IGC_REGKEY(bool, ForceMixMode, false, "force enable mix mode even on platforms that do not support it", false)
DECLARE_IGC_REGKEY(bool, DisableFDIV, false, "Disable fdiv support", false)
DECLARE_IGC_REGKEY(bool, EmulateFDIV, false, "Emulate fdiv instructions", false)
DECLARE_IGC_REGKEY(bool, UpConvertF16Sampler, true, "up-convert fp16 sampler mesasge to return fp32", false)
DECLARE_IGC_REGKEY(bool, FuseTypedWrite, true, "Enable fusing of simd8 typed write", false)
DECLARE_IGC_REGKEY(bool, EnableUndefAlphaOutputAsRed, true, "Output red for undefined alpha output", false)
DECLARE_IGC_REGKEY(bool, EnableHalfPromotion, true, "Enable pass that replaces instructions using halfs with corresponding float counterparts for pre-SKL", false)
DECLARE_IGC_REGKEY(bool, ForceHalfPromotion, false, "Force enable pass that replaces instructions using halfs with corresponding float counterparts", false)
DECLARE_IGC_REGKEY(bool, DisbleLocalFences, false, "On CNL+ we need to emit local fences. Setting this to true removes those. It may be functionaly not correct.", false)
DECLARE_IGC_REGKEY(bool, FastSpill, false, "fast spill code gen. This may produce worse equality code for the spilling shader", false)
DECLARE_IGC_REGKEY(bool, EnableGSURBEntryPadding, true,  "Enable padding of GS URB Entry by adding extra portions of Control Data Header.", false)
DECLARE_IGC_REGKEY(bool, EnableGSVtxCountMsgHalfCLSize, true,  "Enable the Vertex Count msg of half CL size, instead of 1DW size.", false)
DECLARE_IGC_REGKEY(bool, EnableTEFactorsPadding, true,  "Enable padding of the TE factors.", false)
DECLARE_IGC_REGKEY(bool, EnableTEFactorsClear, true,  "Enable clearing of tessellation factors.", false)
DECLARE_IGC_REGKEY(bool, EnableSubroutineForEmulation,  true,  "Enable subroutine call support when emulation(double) is on. Heuristic decides which use subroutine calls.", false)
DECLARE_IGC_REGKEY(bool, ForceSubroutineForEmulation,   false,  "Force subroutine call for all emulation functions if emulation(double) is on.", false)
DECLARE_IGC_REGKEY(DWORD, InlinedEmulationThreshold,    125000, "Inlined instruction threshold for enabling subroutines", false)
DECLARE_IGC_REGKEY(int, ByPassAllocaSizeHeuristic,   0,  "Force some Alloca to pass the pressure heuristic until the given size", false)
DECLARE_IGC_REGKEY(DWORD, MemOptWindowSize,   150,  "Size of the window in unit of instructions in which load/stores are allowed to be coalesced. Keep it limited in order to avoid creating long liveranges. Default value is 150", false)
DECLARE_IGC_REGKEY(bool, ForceNoFP64bRegioning, false, "force regioning rules for FP and 64b FPU instructions", false)
DECLARE_IGC_REGKEY(bool, EmitDebugRanges, true, "Emit .debug_ranges section when instructions in a block are non-consecutive", false)
DECLARE_IGC_REGKEY(bool, EmitDebugLoc, true, "Enable generation of .debug_loc section", false)
DECLARE_IGC_REGKEY(bool, UseNewRegEncoding, true, "Use new location encoding for register numbers in dwarf", true)
DECLARE_IGC_REGKEY(bool, EmitOffsetInDbgLoc, false, "Emit offset of private memory in DW_AT_location when available", false)
DECLARE_IGC_REGKEY(bool, EnableA64WA, true, "Guarantee A64 load/store addres-hi is uniform", true)
DECLARE_IGC_REGKEY(bool, EnableSamplerSplit, true, "Split SIMD8 Sampler message to 2 subspans and SIMD16 to odd and even", false)
DECLARE_IGC_REGKEY(bool, EnableEvaluateSamplerSplit, true, "Split evaluate messages to sampler into either SIMD8 or SIMD1 messages", false)
DECLARE_IGC_REGKEY(DWORD, AllocaRAPressureThreshold, 500, "The threshold for the register pressure potential", false)
DECLARE_IGC_REGKEY(DWORD, HPCInstNumThreshold, 1000000, "The threshold for the register pressure potential", false)
DECLARE_IGC_REGKEY(DWORD, HPCGlobalInstNumThreshold, 500000, "The threshold for the register pressure potential", false)
DECLARE_IGC_REGKEY(bool, HPCFastCompilation, false, "Force to do fast compilation for HPC kernel", false)
DECLARE_IGC_REGKEY(bool, UseOldSubRoutineAugIntf, false, "Use the old subroutine augmentation code which is slower", false)
DECLARE_IGC_REGKEY(bool, FastCompileRA, false, "Provide the fast compilatoin path for RA, fail safe at first iteration", false)
DECLARE_IGC_REGKEY(bool, HybridRAWithSpill, false, "Did Hybrid RA with Spill", false)
DECLARE_IGC_REGKEY(bool, StripDebugInfo, false, "Strip debug info from llvm IR lowered from input to IGC", false)
DECLARE_IGC_REGKEY(bool, EmitPreDefinedForAllFunctions, false, "When enabled, pre-defined variables for gid, grid, lid are emitted for all functions. This causes those functions to be inlined even when stack calls is enabled.", true)

DECLARE_IGC_REGKEY(bool, EnableZEBinary, false,  "Enable output in ZE binary format", true)
DECLARE_IGC_REGKEY(bool, AllocateZeroInitializedVarsInBss, false,  "Allocate zero initialized global variables in .bss section in ZEBinary", true)
DECLARE_IGC_REGKEY(DWORD, OverrideOCLMaxParamSize, 0,  "Override the value imposed on the kernel by CL_DEVICE_MAX_PARAMETER_SIZE. Value in bytes, if value==0 no override happens.", true)

DECLARE_IGC_REGKEY(bool, EnableOptReportPrivateMemoryToSLM, false, "[POC] Generate opt report file for moving private memory allocations to SLM.", false)
DECLARE_IGC_REGKEY(bool, ForceAllPrivateMemoryToSLM, false, "[POC] Force moving all private memory allocations to SLM.", false)
DECLARE_IGC_REGKEY(debugString, ForcePrivateMemoryToSLMOnBuffers, 0, "[POC] Force moving private memory allocations to SLM, semicolon-separated list of buffers.", false)
DECLARE_IGC_REGKEY(bool, ForcePrivateMemoryToGlobalOnGeneric, false, "Force moving private memory allocations to global buffer when generic pointer is present", true)
DECLARE_IGC_REGKEY(bool, DetectCastToGAS,                     false, "Check if the module contains local/private to GAS (Gerneric Address Space) cast, it also check internal flags", true)

DECLARE_IGC_GROUP("Generating precompiled headers")
DECLARE_IGC_REGKEY(bool, ApplyConservativeRastWAHeader, true, "Apply WaConservativeRasterization for the platforms enabled", false)


DECLARE_IGC_GROUP("OGL Frontend")
    DECLARE_IGC_REGKEY(bool, OGLMinimumDump, false, "Minimum dump for testing - first and last .ll, .cos and compiler output", true)

DECLARE_IGC_GROUP("VectorCompiler Options")
    DECLARE_IGC_REGKEY(bool, VCOptimizeNone, false, "Same as -optimize=none in vector compiler options", true)
    DECLARE_IGC_REGKEY(bool, VCStrictOptionParser, true, "Produce error on unknown API options in vector compiler", true)
    DECLARE_IGC_REGKEY(debugString, VCApiOptions, 0, "Extra API options for VC", true)
    DECLARE_IGC_REGKEY(debugString, VCInternalOptions, 0, "Extra Internal options to pass to VC", true)
    DECLARE_IGC_REGKEY(bool, VCLocalizeAccUsage, false, "Localization of possible accumulator usages for vISA RA", true)
    DECLARE_IGC_REGKEY(bool, VCDisableNonOverlappingRegionOpt, false, "Disable non-overlapping region optimization", true)
    DECLARE_IGC_REGKEY(bool, VCEnableExtraDebugLogging, false, "Turns on extra debug output to trace IGC/VC-specific execution", true)
